/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import java.util.ArrayList;
import java.util.List;

final class SerialNumberCounter {
    private SerialNumberCounter() {
    }

    private static List<String> getValues(String expressions) {
        ArrayList<String> values = new ArrayList<String>();
        int last = 0;
        int index = 0;
        for (char ch : expressions.toCharArray()) {
            switch (ch) {
                case '%': 
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    values.add(expressions.substring(last, index));
                    values.add(String.valueOf(ch));
                    last = index + 1;
                    break;
                }
            }
            ++index;
        }
        if (index != last) {
            values.add(expressions.substring(last, index));
        }
        return values;
    }

    static int getValue(String value, int sn) {
        if ("sn".equals(value)) {
            return sn;
        }
        return Integer.parseInt(value);
    }

    public static int count(int sn, String formula) {
        List<String> values = SerialNumberCounter.getValues(SerialNumberCounter.formatString(formula));
        if (values.size() % 2 == 0) {
            throw new IllegalArgumentException("Invalid serial number formula.");
        }
        int value = SerialNumberCounter.getValue(values.get(0), sn);
        for (int index = 1; index != values.size(); index += 2) {
            String str = values.get(index);
            if ("%".equals(str)) {
                value %= SerialNumberCounter.getValue(values.get(index + 1), sn);
                continue;
            }
            if ("+".equals(str)) {
                value += SerialNumberCounter.getValue(values.get(index + 1), sn);
                continue;
            }
            if ("-".equals(str)) {
                value -= SerialNumberCounter.getValue(values.get(index + 1), sn);
                continue;
            }
            if ("*".equals(str)) {
                value *= SerialNumberCounter.getValue(values.get(index + 1), sn);
                continue;
            }
            if ("/".equals(str)) {
                value /= SerialNumberCounter.getValue(values.get(index + 1), sn);
                continue;
            }
            throw new IllegalArgumentException("Invalid serial number formula.");
        }
        return value;
    }

    private static String formatString(String expression) {
        if (expression == null || expression.length() == 0) {
            throw new RuntimeException("Expression is null or empty");
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : expression.toLowerCase().toCharArray()) {
            if (ch == '(' || ch == ')') {
                throw new RuntimeException("Invalid serial number formula.");
            }
            if (ch == ' ') continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

