/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.ReleaseRequestReason;
import gurux.dlms.ReleaseResponseReason;
import gurux.dlms.Service;
import gurux.dlms.ServiceError;
import gurux.dlms.TranslatorOutputType;
import gurux.dlms.enums.Access;
import gurux.dlms.enums.ApplicationReference;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.Definition;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ExceptionServiceError;
import gurux.dlms.enums.ExceptionStateError;
import gurux.dlms.enums.HardwareResource;
import gurux.dlms.enums.Initiate;
import gurux.dlms.enums.LoadDataSet;
import gurux.dlms.enums.Task;
import gurux.dlms.enums.VdeStateError;
import java.util.HashMap;
import java.util.Map;

final class TranslatorStandardTags {
    private TranslatorStandardTags() {
    }

    static void getGeneralTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 147, "Snrm");
        GXDLMSTranslator.addTag(list, 151, "UnacceptableFrame");
        GXDLMSTranslator.addTag(list, 31, "DisconnectMode");
        GXDLMSTranslator.addTag(list, 115, "Ua");
        GXDLMSTranslator.addTag(list, 96, "aarq");
        GXDLMSTranslator.addTag(list, 97, "aare");
        GXDLMSTranslator.addTag(list, 161, "application-context-name");
        GXDLMSTranslator.addTag(list, 8, "initiateResponse");
        GXDLMSTranslator.addTag(list, 1, "initiateRequest");
        GXDLMSTranslator.addTag(list, 48640, "negotiated-quality-of-service");
        GXDLMSTranslator.addTag(list, 48649, "proposed-quality-of-service");
        GXDLMSTranslator.addTag(list, 48641, "proposed-dlms-version-number");
        GXDLMSTranslator.addTag(list, 48642, "client-max-receive-pdu-size");
        GXDLMSTranslator.addTag(list, 48643, "proposed-conformance");
        GXDLMSTranslator.addTag(list, 48644, "vaa-name");
        GXDLMSTranslator.addTag(list, 48645, "negotiated-conformance");
        GXDLMSTranslator.addTag(list, 48646, "negotiated-dlms-version-number");
        GXDLMSTranslator.addTag(list, 48647, "server-max-receive-pdu-size");
        GXDLMSTranslator.addTag(list, 48648, "ConformanceBit");
        GXDLMSTranslator.addTag(list, 138, "sender-acse-requirements");
        GXDLMSTranslator.addTag(list, 136, "responder-acse-requirements");
        GXDLMSTranslator.addTag(list, 137, "mechanism-name");
        GXDLMSTranslator.addTag(list, 139, "mechanism-name");
        GXDLMSTranslator.addTag(list, 172, "calling-authentication-value");
        GXDLMSTranslator.addTag(list, 128, "responding-authentication-value");
        GXDLMSTranslator.addTag(list, 98, "rlrq");
        GXDLMSTranslator.addTag(list, 99, "rlre");
        GXDLMSTranslator.addTag(list, 83, "Disc");
        GXDLMSTranslator.addTag(list, 162, "result");
        GXDLMSTranslator.addTag(list, 163, "result-source-diagnostic");
        GXDLMSTranslator.addTag(list, 41729, "acse-service-user");
        GXDLMSTranslator.addTag(list, 41730, "acse-service-provider");
        GXDLMSTranslator.addTag(list, 166, "CallingAPTitle");
        GXDLMSTranslator.addTag(list, 164, "RespondingAPTitle");
        GXDLMSTranslator.addTag(list, 170, "charstring");
        GXDLMSTranslator.addTag(list, 168, "dedicated-key");
        GXDLMSTranslator.addTag(list, 65410, "response-allowed");
        GXDLMSTranslator.addTag(list, 171, "user-information");
        GXDLMSTranslator.addTag(list, 14, "confirmedServiceError");
        GXDLMSTranslator.addTag(list, 24, "informationReportRequest");
        GXDLMSTranslator.addTag(list, 194, "event-notification-request");
        GXDLMSTranslator.addTag(list, 169, "calling-AE-invocation-id");
        GXDLMSTranslator.addTag(list, 165, "called-AE-invocation-id");
        GXDLMSTranslator.addTag(list, 173, "responding-AE-invocation-id");
        GXDLMSTranslator.addTag(list, 216, "exception-response");
        GXDLMSTranslator.addTag(list, 65412, "state-error");
        GXDLMSTranslator.addTag(list, 65345, "service-error");
    }

    static void getSnTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        list.put(5, "readRequest");
        list.put(6, "writeRequest");
        list.put(13, "writeResponse");
        list.put(1536, "Data");
        list.put(1282, "variable-name");
        list.put(1284, "parameterized-access");
        list.put(1285, "BlockNumberAccess");
        list.put(1538, "variable-name");
        list.put(12, "readResponse");
        list.put(3074, "DataBlockResult");
        list.put(3072, "data");
        list.put(3328, "data");
        list.put(3073, "data-access-error");
    }

    static void getLnTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 192, "get-request");
        list.put(49153, "get-request-normal");
        list.put(49154, "get-request-next");
        list.put(49155, "get-request-with-list");
        GXDLMSTranslator.addTag(list, 193, "set-request");
        list.put(49409, "set-request-normal");
        list.put(49410, "set-request-first-data-block");
        list.put(49411, "set-request-with-datablock");
        list.put(49412, "set-request-with-list");
        GXDLMSTranslator.addTag(list, 195, "action-request");
        list.put(49921, "action-request-normal");
        list.put(49922, "action-request-next-pblock");
        list.put(49923, "action-request-with-list");
        list.put(49924, "ActionRequestWithFirstBlock");
        list.put(49925, "ActionRequestWithListAndFirstBlock");
        list.put(49926, "ActionRequestWithBlock");
        GXDLMSTranslator.addTag(list, 199, "action-response");
        list.put(50945, "action-response-normal");
        list.put(50946, "action-response-with-pblock");
        list.put(50947, "action-response-with-list");
        list.put(49924, "ActionResponseWithBlock");
        list.put(65337, "single-response");
        list.put(15, "data-notification");
        GXDLMSTranslator.addTag(list, 196, "get-response");
        list.put(50177, "get-response-normal");
        list.put(50178, "get-response-with-data-block");
        list.put(50179, "get-response-with-list");
        GXDLMSTranslator.addTag(list, 197, "set-response");
        list.put(50433, "set-response-normal");
        list.put(50434, "set-response-datablock");
        list.put(50435, "set-response-with-last-data-block");
        list.put(50437, "set-response-with-list");
        GXDLMSTranslator.addTag(list, 217, "access-request");
        list.put(55553, "access-request-get");
        list.put(55554, "access-request-set");
        list.put(55555, "access-request-action");
        GXDLMSTranslator.addTag(list, 218, "access-response");
        list.put(55809, "access-response-get");
        list.put(55810, "access-response-set");
        list.put(55811, "access-response-action");
        list.put(65329, "access-request-body");
        list.put(65330, "access-request-specification");
        list.put(65331, "Access-Request-Specification");
        list.put(65332, "access-request-list-of-data");
        list.put(65333, "access-response-body");
        list.put(65334, "access-response-specification");
        list.put(65335, "Access-Response-Specification");
        list.put(65336, "access-response-list-of-data");
        list.put(65344, "service");
        list.put(65345, "service-error");
        list.put(224, "general-block-transfer");
        GXDLMSTranslator.addTag(list, 230, "gateway-request");
        GXDLMSTranslator.addTag(list, 231, "gateway-response");
    }

    static void getPlcTags(HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 29, "discover-request");
        GXDLMSTranslator.addTag(list, 30, "discover-report");
        GXDLMSTranslator.addTag(list, 28, "register-request");
        GXDLMSTranslator.addTag(list, 25, "ping-request");
        GXDLMSTranslator.addTag(list, 26, "ping-response");
    }

    static void getGloTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 33, "glo-initiate-request");
        GXDLMSTranslator.addTag(list, 40, "glo-initiate-response");
        GXDLMSTranslator.addTag(list, 200, "glo-get-request");
        GXDLMSTranslator.addTag(list, 204, "glo-get-response");
        GXDLMSTranslator.addTag(list, 201, "glo-set-request");
        GXDLMSTranslator.addTag(list, 205, "glo-set-response");
        GXDLMSTranslator.addTag(list, 203, "glo-action-request");
        GXDLMSTranslator.addTag(list, 207, "glo-action-response");
        GXDLMSTranslator.addTag(list, 37, "glo-read-request");
        GXDLMSTranslator.addTag(list, 44, "glo-read-response");
        GXDLMSTranslator.addTag(list, 38, "glo-write-request");
        GXDLMSTranslator.addTag(list, 45, "glo-write-response");
        GXDLMSTranslator.addTag(list, 219, "general-glo-ciphering");
        GXDLMSTranslator.addTag(list, 221, "general-ciphering");
    }

    static void getDedTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 65, "ded-initiate-request");
        GXDLMSTranslator.addTag(list, 72, "ded-initiate-response");
        GXDLMSTranslator.addTag(list, 208, "ded-get-request");
        GXDLMSTranslator.addTag(list, 212, "ded-get-response");
        GXDLMSTranslator.addTag(list, 209, "ded-set-request");
        GXDLMSTranslator.addTag(list, 213, "ded-set-response");
        GXDLMSTranslator.addTag(list, 211, "ded-action-request");
        GXDLMSTranslator.addTag(list, 215, "ded-action-response");
        GXDLMSTranslator.addTag(list, 220, "general-ded-ciphering");
    }

    static void getTranslatorTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 65281, "Wrapper");
        GXDLMSTranslator.addTag(list, 65282, "Hdlc");
        GXDLMSTranslator.addTag(list, 65283, "xDLMS-APDU");
        GXDLMSTranslator.addTag(list, 65318, "aCSE-APDU");
        GXDLMSTranslator.addTag(list, 65284, "TargetAddress");
        GXDLMSTranslator.addTag(list, 65285, "SourceAddress");
        GXDLMSTranslator.addTag(list, 65380, "FrameType");
        GXDLMSTranslator.addTag(list, 65286, "variable-access-specification");
        GXDLMSTranslator.addTag(list, 65287, "list-of-data");
        GXDLMSTranslator.addTag(list, 65288, "Success");
        GXDLMSTranslator.addTag(list, 65289, "data-access-result");
        GXDLMSTranslator.addTag(list, 65290, "cosem-attribute-descriptor");
        GXDLMSTranslator.addTag(list, 65291, "class-id");
        GXDLMSTranslator.addTag(list, 65292, "instance-id");
        GXDLMSTranslator.addTag(list, 65293, "attribute-id");
        GXDLMSTranslator.addTag(list, 65294, "method-invocation-parameters");
        GXDLMSTranslator.addTag(list, 65295, "selector");
        GXDLMSTranslator.addTag(list, 65296, "parameter");
        GXDLMSTranslator.addTag(list, 65297, "last-block");
        GXDLMSTranslator.addTag(list, 65298, "block-number");
        GXDLMSTranslator.addTag(list, 65299, "raw-data");
        GXDLMSTranslator.addTag(list, 65300, "cosem-method-descriptor");
        GXDLMSTranslator.addTag(list, 65301, "method-id");
        GXDLMSTranslator.addTag(list, 65302, "result");
        GXDLMSTranslator.addTag(list, 65413, "pblock");
        GXDLMSTranslator.addTag(list, 65303, "return-parameters");
        GXDLMSTranslator.addTag(list, 65304, "access-selection");
        GXDLMSTranslator.addTag(list, 65305, "value");
        GXDLMSTranslator.addTag(list, 65306, "access-selector");
        GXDLMSTranslator.addTag(list, 65307, "access-parameters");
        GXDLMSTranslator.addTag(list, 65308, "attribute-descriptor-list");
        GXDLMSTranslator.addTag(list, 65309, "Cosem-Attribute-Descriptor-With-Selection");
        GXDLMSTranslator.addTag(list, 65310, "ReadDataBlockAccess");
        GXDLMSTranslator.addTag(list, 65311, "write-data-block-access");
        GXDLMSTranslator.addTag(list, 65312, "data");
        GXDLMSTranslator.addTag(list, 65313, "invoke-id-and-priority");
        GXDLMSTranslator.addTag(list, 65320, "long-invoke-id-and-priority");
        GXDLMSTranslator.addTag(list, 65314, "date-time");
        GXDLMSTranslator.addTag(list, 65366, "current-time");
        GXDLMSTranslator.addTag(list, 65367, "time");
        GXDLMSTranslator.addTag(list, 65315, "reason");
        GXDLMSTranslator.addTag(list, 65316, "Variable-Access-Specification");
        GXDLMSTranslator.addTag(list, 65319, "CHOICE");
        GXDLMSTranslator.addTag(list, 65321, "notification-body");
        GXDLMSTranslator.addTag(list, 65328, "data-value");
        GXDLMSTranslator.addTag(list, 65346, "initiateError");
        GXDLMSTranslator.addTag(list, 65347, "ciphered-content");
        GXDLMSTranslator.addTag(list, 65348, "system-title");
        GXDLMSTranslator.addTag(list, 65349, "datablock");
        GXDLMSTranslator.addTag(list, 65350, "transaction-id");
        GXDLMSTranslator.addTag(list, 65351, "originator-system-title");
        GXDLMSTranslator.addTag(list, 65352, "recipient-system-title");
        GXDLMSTranslator.addTag(list, 65353, "other-information");
        GXDLMSTranslator.addTag(list, 65360, "key-info");
        GXDLMSTranslator.addTag(list, 65364, "ciphered-content");
        GXDLMSTranslator.addTag(list, 65361, "agreed-key");
        GXDLMSTranslator.addTag(list, 65362, "key-parameters");
        GXDLMSTranslator.addTag(list, 65363, "key-ciphered-data");
        GXDLMSTranslator.addTag(list, 65365, "attribute-value");
        GXDLMSTranslator.addTag(list, 65368, "MaxInfoRX");
        GXDLMSTranslator.addTag(list, 65369, "MaxInfoTX");
        GXDLMSTranslator.addTag(list, 65376, "WindowSizeRX");
        GXDLMSTranslator.addTag(list, 65377, "WindowSizeTX");
        GXDLMSTranslator.addTag(list, 65378, "value-list");
        GXDLMSTranslator.addTag(list, 65379, "data-access-result");
        GXDLMSTranslator.addTag(list, 65381, "block-control");
        GXDLMSTranslator.addTag(list, 65382, "block-number-ack");
        GXDLMSTranslator.addTag(list, 65383, "block-data");
        GXDLMSTranslator.addTag(list, 65384, "contents-description");
        GXDLMSTranslator.addTag(list, 65385, "array-contents");
        GXDLMSTranslator.addTag(list, 65402, "network-id");
        GXDLMSTranslator.addTag(list, 65403, "physical-device-address");
        GXDLMSTranslator.addTag(list, 65404, "protocol-version");
        GXDLMSTranslator.addTag(list, 65405, "called-ap-title");
        GXDLMSTranslator.addTag(list, 65406, "called-ap-invocation-id");
        GXDLMSTranslator.addTag(list, 65407, "called-ae-invocation-id");
        GXDLMSTranslator.addTag(list, 65408, "calling-ap-invocation-id");
        GXDLMSTranslator.addTag(list, 65409, "called-ae-qualifier");
    }

    static void getDataTypeTags(HashMap<Integer, String> list) {
        list.put(0xFF0000 + DataType.NONE.getValue(), "null-data");
        list.put(0xFF0000 + DataType.ARRAY.getValue(), "array");
        list.put(0xFF0000 + DataType.BCD.getValue(), "bcd");
        list.put(0xFF0000 + DataType.BITSTRING.getValue(), "bit-string");
        list.put(0xFF0000 + DataType.BOOLEAN.getValue(), "boolean");
        list.put(0xFF0000 + DataType.COMPACT_ARRAY.getValue(), "compact-array");
        list.put(0xFF0000 + DataType.DATE.getValue(), "date");
        list.put(0xFF0000 + DataType.DATETIME.getValue(), "date-time");
        list.put(0xFF0000 + DataType.ENUM.getValue(), "enum");
        list.put(0xFF0000 + DataType.FLOAT32.getValue(), "float32");
        list.put(0xFF0000 + DataType.FLOAT64.getValue(), "float64,");
        list.put(0xFF0000 + DataType.INT16.getValue(), "long");
        list.put(0xFF0000 + DataType.INT32.getValue(), "double-long");
        list.put(0xFF0000 + DataType.INT64.getValue(), "long64");
        list.put(0xFF0000 + DataType.INT8.getValue(), "integer");
        list.put(0xFF0000 + DataType.OCTET_STRING.getValue(), "octet-string");
        list.put(0xFF0000 + DataType.STRING.getValue(), "visible-string");
        list.put(0xFF0000 + DataType.STRING_UTF8.getValue(), "utf8-string");
        list.put(0xFF0000 + DataType.STRUCTURE.getValue(), "structure");
        list.put(0xFF0000 + DataType.TIME.getValue(), "time");
        list.put(0xFF0000 + DataType.UINT16.getValue(), "long-unsigned");
        list.put(0xFF0000 + DataType.UINT32.getValue(), "double-long-unsigned");
        list.put(0xFF0000 + DataType.UINT64.getValue(), "long64-unsigned");
        list.put(0xFF0000 + DataType.UINT8.getValue(), "unsigned");
    }

    static String errorCodeToString(ErrorCode value) {
        String str;
        switch (value) {
            case ACCESS_VIOLATED: {
                str = "scope-of-access-violated";
                break;
            }
            case DATA_BLOCK_NUMBER_INVALID: {
                str = "data-block-number-invalid";
                break;
            }
            case DATA_BLOCK_UNAVAILABLE: {
                str = "data-block-unavailable";
                break;
            }
            case HARDWARE_FAULT: {
                str = "hardware-fault";
                break;
            }
            case INCONSISTENT_CLASS: {
                str = "object-class-inconsistent";
                break;
            }
            case LONG_GET_OR_READ_ABORTED: {
                str = "long-get-aborted";
                break;
            }
            case LONG_SET_OR_WRITE_ABORTED: {
                str = "long-set-aborted";
                break;
            }
            case NO_LONG_GET_OR_READ_IN_PROGRESS: {
                str = "no-long-get-in-progress";
                break;
            }
            case NO_LONG_SET_OR_WRITE_IN_PROGRESS: {
                str = "no-long-set-in-progress";
                break;
            }
            case OK: {
                str = "success";
                break;
            }
            case OTHER_REASON: {
                str = "other-reason";
                break;
            }
            case READ_WRITE_DENIED: {
                str = "read-write-denied";
                break;
            }
            case TEMPORARY_FAILURE: {
                str = "temporary-failure";
                break;
            }
            case UNAVAILABLE_OBJECT: {
                str = "object-unavailable";
                break;
            }
            case UNDEFINED_OBJECT: {
                str = "object-undefined";
                break;
            }
            case UNMATCHED_TYPE: {
                str = "type-unmatched";
                break;
            }
            default: {
                throw new IllegalArgumentException("Error code: " + String.valueOf((Object)value));
            }
        }
        return str;
    }

    static ErrorCode valueOfErrorCode(String value) {
        ErrorCode v;
        if ("scope-of-access-violated".equalsIgnoreCase(value)) {
            v = ErrorCode.ACCESS_VIOLATED;
        } else if ("data-block-number-invalid".equalsIgnoreCase(value)) {
            v = ErrorCode.DATA_BLOCK_NUMBER_INVALID;
        } else if ("data-block-unavailable".equalsIgnoreCase(value)) {
            v = ErrorCode.DATA_BLOCK_UNAVAILABLE;
        } else if ("hardware-fault".equalsIgnoreCase(value)) {
            v = ErrorCode.HARDWARE_FAULT;
        } else if ("object-class-inconsistent".equalsIgnoreCase(value)) {
            v = ErrorCode.INCONSISTENT_CLASS;
        } else if ("long-get-aborted".equalsIgnoreCase(value)) {
            v = ErrorCode.LONG_GET_OR_READ_ABORTED;
        } else if ("long-set-aborted".equalsIgnoreCase(value)) {
            v = ErrorCode.LONG_SET_OR_WRITE_ABORTED;
        } else if ("no-long-get-in-progress".equalsIgnoreCase(value)) {
            v = ErrorCode.NO_LONG_GET_OR_READ_IN_PROGRESS;
        } else if ("no-long-set-in-progress".equalsIgnoreCase(value)) {
            v = ErrorCode.NO_LONG_SET_OR_WRITE_IN_PROGRESS;
        } else if ("success".equalsIgnoreCase(value)) {
            v = ErrorCode.OK;
        } else if ("other-reason".equalsIgnoreCase(value)) {
            v = ErrorCode.OTHER_REASON;
        } else if ("read-write-denied".equalsIgnoreCase(value)) {
            v = ErrorCode.READ_WRITE_DENIED;
        } else if ("temporary-failure".equalsIgnoreCase(value)) {
            v = ErrorCode.TEMPORARY_FAILURE;
        } else if ("object-unavailable".equalsIgnoreCase(value)) {
            v = ErrorCode.UNAVAILABLE_OBJECT;
        } else if ("object-undefined".equalsIgnoreCase(value)) {
            v = ErrorCode.UNDEFINED_OBJECT;
        } else if ("type-unmatched".equalsIgnoreCase(value)) {
            v = ErrorCode.UNMATCHED_TYPE;
        } else {
            throw new IllegalArgumentException("Error code: " + value);
        }
        return v;
    }

    private static Map<ServiceError, String> getServiceErrors() {
        HashMap<ServiceError, String> list = new HashMap<ServiceError, String>();
        list.put(ServiceError.APPLICATION_REFERENCE, "application-reference");
        list.put(ServiceError.HARDWARE_RESOURCE, "hardware-resource");
        list.put(ServiceError.VDE_STATE_ERROR, "vde-state-error");
        list.put(ServiceError.SERVICE, "service");
        list.put(ServiceError.DEFINITION, "definition");
        list.put(ServiceError.ACCESS, "access");
        list.put(ServiceError.INITIATE, "initiate");
        list.put(ServiceError.LOAD_DATASET, "load-data-set");
        list.put(ServiceError.TASK, "task");
        return list;
    }

    static Map<ApplicationReference, String> getApplicationReference() {
        HashMap<ApplicationReference, String> list = new HashMap<ApplicationReference, String>();
        list.put(ApplicationReference.APPLICATION_CONTEXT_UNSUPPORTED, "application-context-unsupported");
        list.put(ApplicationReference.APPLICATION_REFERENCE_INVALID, "application-reference-invalid");
        list.put(ApplicationReference.APPLICATION_UNREACHABLE, "application-unreachable");
        list.put(ApplicationReference.DECIPHERING_ERROR, "deciphering-error");
        list.put(ApplicationReference.OTHER, "other");
        list.put(ApplicationReference.PROVIDER_COMMUNICATION_ERROR, "provider-communication-error");
        list.put(ApplicationReference.TIME_ELAPSED, "time-elapsed");
        return list;
    }

    static Map<HardwareResource, String> getHardwareResource() {
        HashMap<HardwareResource, String> list = new HashMap<HardwareResource, String>();
        list.put(HardwareResource.MASS_STORAGE_UNAVAILABLE, "mass-storage-unavailable");
        list.put(HardwareResource.MEMORY_UNAVAILABLE, "memory-unavailable");
        list.put(HardwareResource.OTHER, "other");
        list.put(HardwareResource.OTHER_RESOURCE_UNAVAILABLE, "other-resource-unavailable");
        list.put(HardwareResource.PROCESSOR_RESOURCE_UNAVAILABLE, "processor-resource-unavailable");
        return list;
    }

    static Map<VdeStateError, String> getVdeStateError() {
        HashMap<VdeStateError, String> list = new HashMap<VdeStateError, String>();
        list.put(VdeStateError.LOADING_DATASET, "loading-data-set");
        list.put(VdeStateError.NO_DLMS_CONTEXT, "no-dlms-context");
        list.put(VdeStateError.OTHER, "other");
        list.put(VdeStateError.STATUS_INOPERABLE, "status-inoperable");
        list.put(VdeStateError.STATUS_NO_CHANGE, "status-nochange");
        return list;
    }

    static Map<Service, String> getService() {
        HashMap<Service, String> list = new HashMap<Service, String>();
        list.put(Service.OTHER, "other");
        list.put(Service.PDU_SIZE, "pdu-size");
        list.put(Service.UNSUPPORTED, "service-unsupported");
        return list;
    }

    static Map<Definition, String> getDefinition() {
        HashMap<Definition, String> list = new HashMap<Definition, String>();
        list.put(Definition.OBJECT_ATTRIBUTE_INCONSISTENT, "object-attribute-inconsistent");
        list.put(Definition.OBJECT_CLASS_INCONSISTENT, "object-class-inconsistent");
        list.put(Definition.OBJECT_UNDEFINED, "object-undefined");
        list.put(Definition.OTHER, "other");
        return list;
    }

    static Map<Access, String> getAccess() {
        HashMap<Access, String> list = new HashMap<Access, String>();
        list.put(Access.HARDWARE_FAULT, "hardware-fault");
        list.put(Access.OBJECT_ACCESS_INVALID, "object-access-violated");
        list.put(Access.OBJECT_UNAVAILABLE, "object-unavailable");
        list.put(Access.OTHER, "other");
        list.put(Access.SCOPE_OF_ACCESS_VIOLATED, "scope-of-access-violated");
        return list;
    }

    static Map<Initiate, String> getInitiate() {
        HashMap<Initiate, String> list = new HashMap<Initiate, String>();
        list.put(Initiate.DLMS_VERSION_TOO_LOW, "dlms-version-too-low");
        list.put(Initiate.INCOMPATIBLE_CONFORMANCE, "incompatible-conformance");
        list.put(Initiate.OTHER, "other");
        list.put(Initiate.PDU_SIZE_TOO_SHORT, "pdu-size-too-short");
        list.put(Initiate.REFUSED_BY_THE_VDE_HANDLER, "refused-by-the-VDE-Handler");
        return list;
    }

    static Map<LoadDataSet, String> getLoadDataSet() {
        HashMap<LoadDataSet, String> list = new HashMap<LoadDataSet, String>();
        list.put(LoadDataSet.DATASET_NOT_READY, "data-set-not-ready");
        list.put(LoadDataSet.DATASET_SIZE_TOO_LARGE, "dataset-size-too-large");
        list.put(LoadDataSet.INTERPRETATION_FAILURE, "interpretation-failure");
        list.put(LoadDataSet.NOT_AWAITED_SEGMENT, "not-awaited-segment");
        list.put(LoadDataSet.NOT_LOADABLE, "not-loadable");
        list.put(LoadDataSet.OTHER, "other");
        list.put(LoadDataSet.PRIMITIVE_OUT_OF_SEQUENCE, "primitive-out-of-sequence");
        list.put(LoadDataSet.STORAGE_FAILURE, "storage-failure");
        return list;
    }

    static Map<Task, String> getTask() {
        HashMap<Task, String> list = new HashMap<Task, String>();
        list.put(Task.NO_REMOTE_CONTROL, "no-remote-control");
        list.put(Task.OTHER, "other");
        list.put(Task.TI_RUNNING, "ti-running");
        list.put(Task.TI_STOPPED, "ti-stopped");
        list.put(Task.TI_UNUSABLE, "ti-unusable");
        return list;
    }

    static String getServiceErrorValue(ServiceError error, byte value) {
        switch (error) {
            case APPLICATION_REFERENCE: {
                return TranslatorStandardTags.getApplicationReference().get((Object)ApplicationReference.forValue(value));
            }
            case HARDWARE_RESOURCE: {
                return TranslatorStandardTags.getHardwareResource().get((Object)HardwareResource.forValue(value));
            }
            case VDE_STATE_ERROR: {
                return TranslatorStandardTags.getVdeStateError().get((Object)VdeStateError.forValue(value));
            }
            case SERVICE: {
                return TranslatorStandardTags.getService().get((Object)Service.forValue(value));
            }
            case DEFINITION: {
                return TranslatorStandardTags.getDefinition().get((Object)Definition.forValue(value));
            }
            case ACCESS: {
                return TranslatorStandardTags.getAccess().get((Object)Access.forValue(value));
            }
            case INITIATE: {
                return TranslatorStandardTags.getInitiate().get((Object)Initiate.forValue(value));
            }
            case LOAD_DATASET: {
                return TranslatorStandardTags.getLoadDataSet().get((Object)LoadDataSet.forValue(value));
            }
            case TASK: {
                return TranslatorStandardTags.getTask().get((Object)Task.forValue(value));
            }
            case OTHER_ERROR: {
                return String.valueOf(value);
            }
        }
        return "";
    }

    static String serviceErrorToString(ServiceError error) {
        return TranslatorStandardTags.getServiceErrors().get((Object)error);
    }

    static ServiceError getServiceError(String value) {
        ServiceError error = null;
        for (Map.Entry<ServiceError, String> it : TranslatorStandardTags.getServiceErrors().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            error = it.getKey();
            break;
        }
        if (error == null) {
            throw new IllegalArgumentException();
        }
        return error;
    }

    private static int getApplicationReference(String value) {
        int ret = -1;
        for (Map.Entry<ApplicationReference, String> it : TranslatorStandardTags.getApplicationReference().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getHardwareResource(String value) {
        int ret = -1;
        for (Map.Entry<HardwareResource, String> it : TranslatorStandardTags.getHardwareResource().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getVdeStateError(String value) {
        int ret = -1;
        for (Map.Entry<VdeStateError, String> it : TranslatorStandardTags.getVdeStateError().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getService(String value) {
        int ret = -1;
        for (Map.Entry<Service, String> it : TranslatorStandardTags.getService().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getDefinition(String value) {
        int ret = -1;
        for (Map.Entry<Definition, String> it : TranslatorStandardTags.getDefinition().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getAccess(String value) {
        int ret = -1;
        for (Map.Entry<Access, String> it : TranslatorStandardTags.getAccess().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getInitiate(String value) {
        int ret = -1;
        for (Map.Entry<Initiate, String> it : TranslatorStandardTags.getInitiate().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getLoadDataSet(String value) {
        int ret = -1;
        for (Map.Entry<LoadDataSet, String> it : TranslatorStandardTags.getLoadDataSet().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getTask(String value) {
        int ret = -1;
        for (Map.Entry<Task, String> it : TranslatorStandardTags.getTask().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    static byte getError(ServiceError serviceError, String value) {
        int ret = 0;
        switch (serviceError) {
            case APPLICATION_REFERENCE: {
                ret = TranslatorStandardTags.getApplicationReference(value);
                break;
            }
            case HARDWARE_RESOURCE: {
                ret = TranslatorStandardTags.getHardwareResource(value);
                break;
            }
            case VDE_STATE_ERROR: {
                ret = TranslatorStandardTags.getVdeStateError(value);
                break;
            }
            case SERVICE: {
                ret = TranslatorStandardTags.getService(value);
                break;
            }
            case DEFINITION: {
                ret = TranslatorStandardTags.getDefinition(value);
                break;
            }
            case ACCESS: {
                ret = TranslatorStandardTags.getAccess(value);
                break;
            }
            case INITIATE: {
                ret = TranslatorStandardTags.getInitiate(value);
                break;
            }
            case LOAD_DATASET: {
                ret = TranslatorStandardTags.getLoadDataSet(value);
                break;
            }
            case TASK: {
                ret = TranslatorStandardTags.getTask(value);
                break;
            }
            case OTHER_ERROR: {
                ret = Integer.parseInt(value);
                break;
            }
        }
        return (byte)ret;
    }

    static String conformancetoString(Conformance value) {
        String str;
        switch (value) {
            case ACCESS: {
                str = "access";
                break;
            }
            case ACTION: {
                str = "action";
                break;
            }
            case ATTRIBUTE_0_SUPPORTED_WITH_GET: {
                str = "attribute0-supported-with-get";
                break;
            }
            case ATTRIBUTE_0_SUPPORTED_WITH_SET: {
                str = "attribute0-supported-with-set";
                break;
            }
            case BLOCK_TRANSFER_WITH_ACTION: {
                str = "block-transfer-with-action";
                break;
            }
            case BLOCK_TRANSFER_WITH_GET_OR_READ: {
                str = "block-transfer-with-get-or-read";
                break;
            }
            case BLOCK_TRANSFER_WITH_SET_OR_WRITE: {
                str = "block-transfer-with-set-or-write";
                break;
            }
            case DATA_NOTIFICATION: {
                str = "data-notification";
                break;
            }
            case EVENT_NOTIFICATION: {
                str = "event-notification";
                break;
            }
            case GENERAL_BLOCK_TRANSFER: {
                str = "general-block-transfer";
                break;
            }
            case GENERAL_PROTECTION: {
                str = "general-protection";
                break;
            }
            case GET: {
                str = "get";
                break;
            }
            case INFORMATION_REPORT: {
                str = "information-report";
                break;
            }
            case MULTIPLE_REFERENCES: {
                str = "multiple-references";
                break;
            }
            case PARAMETERIZED_ACCESS: {
                str = "parameterized-access";
                break;
            }
            case PRIORITY_MGMT_SUPPORTED: {
                str = "priority-mgmt-supported";
                break;
            }
            case READ: {
                str = "read";
                break;
            }
            case RESERVED_SEVEN: {
                str = "reserved-seven";
                break;
            }
            case DELTA_VALUE_ENCODING: {
                str = "delta-value-encoding";
                break;
            }
            case RESERVED_ZERO: {
                str = "reserved-zero";
                break;
            }
            case SELECTIVE_ACCESS: {
                str = "selective-access";
                break;
            }
            case SET: {
                str = "set";
                break;
            }
            case UN_CONFIRMED_WRITE: {
                str = "unconfirmed-write";
                break;
            }
            case WRITE: {
                str = "write";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)value));
            }
        }
        return str;
    }

    static Conformance valueOfConformance(String value) {
        Conformance ret;
        if ("access".equalsIgnoreCase(value)) {
            ret = Conformance.ACCESS;
        } else if ("action".equalsIgnoreCase(value)) {
            ret = Conformance.ACTION;
        } else if ("attribute0-supported-with-get".equalsIgnoreCase(value)) {
            ret = Conformance.ATTRIBUTE_0_SUPPORTED_WITH_GET;
        } else if ("attribute0-supported-with-set".equalsIgnoreCase(value)) {
            ret = Conformance.ATTRIBUTE_0_SUPPORTED_WITH_SET;
        } else if ("block-transfer-with-action".equalsIgnoreCase(value)) {
            ret = Conformance.BLOCK_TRANSFER_WITH_ACTION;
        } else if ("block-transfer-with-get-or-read".equalsIgnoreCase(value)) {
            ret = Conformance.BLOCK_TRANSFER_WITH_GET_OR_READ;
        } else if ("block-transfer-with-set-or-write".equalsIgnoreCase(value)) {
            ret = Conformance.BLOCK_TRANSFER_WITH_SET_OR_WRITE;
        } else if ("data-notification".equalsIgnoreCase(value)) {
            ret = Conformance.DATA_NOTIFICATION;
        } else if ("event-notification".equalsIgnoreCase(value)) {
            ret = Conformance.EVENT_NOTIFICATION;
        } else if ("general-block-transfer".equalsIgnoreCase(value)) {
            ret = Conformance.GENERAL_BLOCK_TRANSFER;
        } else if ("general-protection".equalsIgnoreCase(value)) {
            ret = Conformance.GENERAL_PROTECTION;
        } else if ("get".equalsIgnoreCase(value)) {
            ret = Conformance.GET;
        } else if ("information-report".equalsIgnoreCase(value)) {
            ret = Conformance.INFORMATION_REPORT;
        } else if ("multiple-references".equalsIgnoreCase(value)) {
            ret = Conformance.MULTIPLE_REFERENCES;
        } else if ("parameterized-access".equalsIgnoreCase(value)) {
            ret = Conformance.PARAMETERIZED_ACCESS;
        } else if ("priority-mgmt-supported".equalsIgnoreCase(value)) {
            ret = Conformance.PRIORITY_MGMT_SUPPORTED;
        } else if ("read".equalsIgnoreCase(value)) {
            ret = Conformance.READ;
        } else if ("reserved-seven".equalsIgnoreCase(value)) {
            ret = Conformance.RESERVED_SEVEN;
        } else if ("delta-value-encoding".equalsIgnoreCase(value)) {
            ret = Conformance.DELTA_VALUE_ENCODING;
        } else if ("reserved-zero".equalsIgnoreCase(value)) {
            ret = Conformance.RESERVED_ZERO;
        } else if ("selective-access".equalsIgnoreCase(value)) {
            ret = Conformance.SELECTIVE_ACCESS;
        } else if ("set".equalsIgnoreCase(value)) {
            ret = Conformance.SET;
        } else if ("unconfirmed-write".equalsIgnoreCase(value)) {
            ret = Conformance.UN_CONFIRMED_WRITE;
        } else if ("write".equalsIgnoreCase(value)) {
            ret = Conformance.WRITE;
        } else {
            throw new IllegalArgumentException(value);
        }
        return ret;
    }

    static String releaseResponseReasonToString(ReleaseResponseReason value) {
        String str;
        switch (value) {
            case NORMAL: {
                str = "normal";
                break;
            }
            case NOT_FINISHED: {
                str = "not-finished";
                break;
            }
            case USER_DEFINED: {
                str = "user-defined";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)value));
            }
        }
        return str;
    }

    static ReleaseResponseReason valueOfReleaseResponseReason(String value) {
        ReleaseResponseReason ret;
        if ("normal".equalsIgnoreCase(value)) {
            ret = ReleaseResponseReason.NORMAL;
        } else if ("not-finished".equalsIgnoreCase(value)) {
            ret = ReleaseResponseReason.NOT_FINISHED;
        } else if ("user-defined".equalsIgnoreCase(value)) {
            ret = ReleaseResponseReason.USER_DEFINED;
        } else {
            throw new IllegalArgumentException(value);
        }
        return ret;
    }

    static String releaseRequestReasonToString(ReleaseRequestReason value) {
        String str;
        switch (value) {
            case NORMAL: {
                str = "normal";
                break;
            }
            case URGENT: {
                str = "not-finished";
                break;
            }
            case USER_DEFINED: {
                str = "user-defined";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)value));
            }
        }
        return str;
    }

    static ReleaseRequestReason valueOfReleaseRequestReason(String value) {
        ReleaseRequestReason ret;
        if ("normal".equalsIgnoreCase(value)) {
            ret = ReleaseRequestReason.NORMAL;
        } else if ("not-finished".equalsIgnoreCase(value)) {
            ret = ReleaseRequestReason.URGENT;
        } else if ("user-defined".equalsIgnoreCase(value)) {
            ret = ReleaseRequestReason.USER_DEFINED;
        } else {
            throw new IllegalArgumentException(value);
        }
        return ret;
    }

    static String stateErrorToString(ExceptionStateError error) {
        switch (error) {
            case SERVICE_NOT_ALLOWED: {
                return "service-not-allowed";
            }
            case SERVICE_UNKNOWN: {
                return "service-unknown";
            }
        }
        throw new IllegalArgumentException();
    }

    static String exceptionServiceErrorToString(ExceptionServiceError error) {
        switch (error) {
            case OPERATION_NOT_POSSIBLE: {
                return "operation-not-possible";
            }
            case SERVICE_NOT_SUPPORTED: {
                return "service-not-supported";
            }
            case OTHER_REASON: {
                return "other-reason";
            }
            case PDU_TOO_LONG: {
                return "pdu-too-long";
            }
            case DECIPHERING_ERROR: {
                return "deciphering-error";
            }
            case INVOCATION_COUNTER_ERROR: {
                return "invocation-counter-error";
            }
        }
        throw new IllegalArgumentException();
    }

    static ExceptionStateError valueofStateError(String value) {
        if ("service-not-allowed".equalsIgnoreCase(value)) {
            return ExceptionStateError.SERVICE_NOT_ALLOWED;
        }
        if ("service-unknown".equalsIgnoreCase(value)) {
            return ExceptionStateError.SERVICE_UNKNOWN;
        }
        throw new IllegalArgumentException();
    }

    static ExceptionServiceError valueOfExceptionServiceError(String value) {
        if ("operation-not-possible".equalsIgnoreCase(value)) {
            return ExceptionServiceError.OPERATION_NOT_POSSIBLE;
        }
        if ("service-not-supported".equalsIgnoreCase(value)) {
            return ExceptionServiceError.SERVICE_NOT_SUPPORTED;
        }
        if ("other-reason".equalsIgnoreCase(value)) {
            return ExceptionServiceError.OTHER_REASON;
        }
        if ("pdu-too-long".equalsIgnoreCase(value)) {
            return ExceptionServiceError.PDU_TOO_LONG;
        }
        if ("deciphering-error".equalsIgnoreCase(value)) {
            return ExceptionServiceError.DECIPHERING_ERROR;
        }
        if ("invocation-counter-error".equalsIgnoreCase(value)) {
            return ExceptionServiceError.INVOCATION_COUNTER_ERROR;
        }
        throw new IllegalArgumentException();
    }
}

