/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.asn.GXAsn1BitString;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.internal.GXCommon;

public class GXAsn1PublicKey {
    private byte[] value;

    private void init(byte[] key) {
        if (key == null || key.length != 270) {
            throw new IllegalArgumentException("data");
        }
        this.value = new byte[key.length];
        System.arraycopy(key, 0, this.value, 0, key.length);
    }

    public GXAsn1PublicKey() {
    }

    public GXAsn1PublicKey(GXAsn1BitString data) {
        if (data == null) {
            throw new IllegalArgumentException("key");
        }
        GXAsn1Sequence seq = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(data.getValue());
        this.init(GXAsn1Converter.toByteArray(new Object[]{seq.get(0), seq.get(1)}));
    }

    public GXAsn1PublicKey(byte[] key) {
        this.init(key);
    }

    public final byte[] getValue() {
        return this.value;
    }

    public final String toString() {
        if (this.value == null) {
            return "";
        }
        return GXCommon.toHex(this.value);
    }
}

