/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSCertificateException;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.asn.CertificateVersion;
import gurux.dlms.asn.GXAsn1BitString;
import gurux.dlms.asn.GXAsn1Context;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1ObjectIdentifier;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.asn.GXCertificateRequest;
import gurux.dlms.asn.GXx509Certificate;
import gurux.dlms.asn.enums.ExtendedKeyUsage;
import gurux.dlms.asn.enums.GXOid;
import gurux.dlms.asn.enums.HashAlgorithm;
import gurux.dlms.asn.enums.KeyUsage;
import gurux.dlms.asn.enums.PkcsObjectIdentifier;
import gurux.dlms.asn.enums.PkcsType;
import gurux.dlms.asn.enums.X9ObjectIdentifier;
import gurux.dlms.internal.GXCommon;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GXPkcs10 {
    private byte[] rawData;
    private CertificateVersion version;
    private String subject;
    private List<Map.Entry<PkcsObjectIdentifier, Object[]>> attributes;
    private GXOid algorithm = X9ObjectIdentifier.IdECPublicKey;
    private PublicKey publicKey;
    private GXOid signatureAlgorithm;
    private Object signatureParameters;
    private byte[] signature;

    public GXPkcs10() {
        this.algorithm = X9ObjectIdentifier.IdECPublicKey;
        this.version = CertificateVersion.V1;
        this.attributes = new ArrayList<Map.Entry<PkcsObjectIdentifier, Object[]>>();
    }

    public GXPkcs10(String data) {
        String START = "CERTIFICATE REQUEST-----\n";
        String END = "-----END CERTIFICATE REQUEST";
        String tmp = data.replace("\r\n", "\n");
        int start = tmp.indexOf("CERTIFICATE REQUEST-----\n");
        if (start == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        int end = tmp.indexOf("-----END CERTIFICATE REQUEST");
        if (end == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        this.init(GXCommon.fromBase64(tmp.substring(start + "CERTIFICATE REQUEST-----\n".length(), end)));
    }

    public GXPkcs10(byte[] data) {
        this.init(data);
    }

    public static GXPkcs10 fromPem(String data) {
        String START = "CERTIFICATE REQUEST-----\n";
        String END = "-----END CERTIFICATE REQUEST";
        String tmp = data.replace("\r\n", "\n");
        int start = tmp.indexOf("CERTIFICATE REQUEST-----\n");
        if (start == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        int end = tmp.indexOf("-----END CERTIFICATE REQUEST");
        if (end == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        return GXPkcs10.fromDer(tmp.substring(start + "CERTIFICATE REQUEST-----\n".length(), end));
    }

    public static GXPkcs10 fromDer(String data) {
        GXPkcs10 cert = new GXPkcs10();
        cert.init(GXCommon.fromBase64(data));
        return cert;
    }

    private void init(byte[] data) {
        KeyFactory eckf;
        GXAsn1Sequence subjectPKInfo;
        GXAsn1Sequence seq;
        block20: {
            this.rawData = data;
            this.attributes = new ArrayList<Map.Entry<PkcsObjectIdentifier, Object[]>>();
            seq = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(data);
            if (seq.size() < 3) {
                throw new IllegalArgumentException("Wrong number of elements in sequence.");
            }
            if (!(seq.get(0) instanceof GXAsn1Sequence)) {
                PkcsType type = GXAsn1Converter.getCertificateType(data, seq);
                switch (type) {
                    case PKCS_8: {
                        throw new GXDLMSCertificateException("Invalid Certificate. This is PKCS 8, not PKCS 10.");
                    }
                    case x509_CERTIFICATE: {
                        throw new GXDLMSCertificateException("Invalid Certificate. This is PKCS x509 certificate, not PKCS 10.");
                    }
                }
                throw new GXDLMSCertificateException("Invalid Certificate Version.");
            }
            GXAsn1Sequence reqInfo = (GXAsn1Sequence)seq.get(0);
            this.version = CertificateVersion.forValue(((Number)reqInfo.get(0)).intValue());
            this.subject = GXAsn1Converter.getSubject((GXAsn1Sequence)reqInfo.get(1));
            subjectPKInfo = (GXAsn1Sequence)reqInfo.get(2);
            if (reqInfo.size() > 3) {
                for (Object t : (GXAsn1Context)reqInfo.get(3)) {
                    GXAsn1Sequence it = (GXAsn1Sequence)t;
                    ArrayList values = new ArrayList();
                    for (Object v : (List)((Map.Entry)it.get(1)).getKey()) {
                        values.add(v);
                    }
                    this.attributes.add(new GXSimpleEntry<PkcsObjectIdentifier, Object[]>(PkcsObjectIdentifier.forValue(it.get(0).toString()), values.toArray()));
                }
            }
            GXAsn1Sequence tmp = (GXAsn1Sequence)subjectPKInfo.get(0);
            this.algorithm = X9ObjectIdentifier.forValue(tmp.get(0).toString());
            if (this.algorithm != X9ObjectIdentifier.IdECPublicKey) {
                Object a = this.algorithm;
                if (a == null && (a = PkcsObjectIdentifier.forValue(tmp.get(0).toString())) == null) {
                    a = tmp.get(0).toString();
                }
                throw new IllegalArgumentException("Invalid PKCS #10 certificate algorithm. " + a);
            }
            try {
                String name = this.algorithm.toString().toLowerCase();
                if (name.contains("rsa")) {
                    eckf = KeyFactory.getInstance("RSA");
                    break block20;
                }
                if (name.endsWith("ecdsa")) {
                    eckf = KeyFactory.getInstance("EC");
                    break block20;
                }
                if (name.contains("ec")) {
                    eckf = KeyFactory.getInstance("EC");
                    break block20;
                }
                throw new IllegalStateException("Unknown algorithm:" + this.algorithm.toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(this.algorithm.toString().substring(0, 2) + "key factory not present in runtime");
            }
        }
        try {
            byte[] encodedKey = GXAsn1Converter.toByteArray(subjectPKInfo);
            X509EncodedKeySpec ecpks = new X509EncodedKeySpec(encodedKey);
            this.publicKey = eckf.generatePublic(ecpks);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        GXAsn1Sequence sign = (GXAsn1Sequence)seq.get(1);
        this.signatureAlgorithm = HashAlgorithm.forValue(sign.get(0).toString());
        if (sign.size() != 1) {
            this.signatureParameters = sign.get(1);
        }
        this.signature = ((GXAsn1BitString)seq.get(2)).getValue();
        GXByteBuffer tmp2 = new GXByteBuffer();
        tmp2.set(data);
        GXAsn1Converter.getNext(tmp2);
        tmp2.size(tmp2.position());
        tmp2.position(1);
        GXCommon.getObjectCount(tmp2);
        if (!this.verify(tmp2.subArray(tmp2.position(), tmp2.available()), this.signature)) {
            throw new IllegalArgumentException("Invalid Signature.");
        }
    }

    public final CertificateVersion getVersion() {
        return this.version;
    }

    public final void setVersion(CertificateVersion value) {
        this.version = value;
    }

    public final String getSubject() {
        return this.subject;
    }

    public final void setSubject(String value) {
        this.subject = value;
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final void setPublicKey(PublicKey value) {
        this.publicKey = value;
    }

    public final GXOid getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(GXOid value) {
        this.algorithm = value;
    }

    public final GXOid getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final void setSignatureAlgorithm(GXOid value) {
        this.signatureAlgorithm = value;
    }

    public final Object getSignatureParameters() {
        return this.signatureParameters;
    }

    public final void setSignatureParameters(Object value) {
        this.signatureParameters = value;
    }

    public final byte[] getSignature() {
        return this.signature;
    }

    public final void setSignature(byte[] value) {
        this.signature = value;
    }

    public final String toString() {
        StringBuilder bb = new StringBuilder();
        bb.append("PKCS #10 certificate request:");
        bb.append("\r\n");
        bb.append("Version: ");
        bb.append(this.version.toString());
        bb.append("\r\n");
        bb.append("Subject: ");
        bb.append(this.subject);
        bb.append("\r\n");
        bb.append("Algorithm: ");
        if (this.algorithm != null) {
            bb.append(this.algorithm.toString());
        }
        bb.append("\r\n");
        bb.append("Public Key: ");
        if (this.publicKey != null) {
            bb.append(this.publicKey.toString());
        }
        bb.append("\r\n");
        bb.append("Signature algorithm: ");
        if (this.signatureAlgorithm != null) {
            bb.append(this.signatureAlgorithm.toString());
        }
        bb.append("\r\n");
        bb.append("Signature parameters: ");
        if (this.signatureParameters != null) {
            bb.append(this.signatureParameters.toString());
        }
        bb.append("\r\n");
        bb.append("Signature: ");
        bb.append(GXCommon.toHex(this.signature));
        bb.append("\r\n");
        return bb.toString();
    }

    private boolean verify(byte[] data, byte[] sign) {
        try {
            Signature instance;
            if (this.signatureAlgorithm == HashAlgorithm.SHA256withECDSA) {
                instance = Signature.getInstance("SHA256withECDSA");
            } else if (this.signatureAlgorithm == HashAlgorithm.SHA384withECDSA) {
                instance = Signature.getInstance("SHA384withECDSA");
            } else if (this.signatureAlgorithm == HashAlgorithm.SHA_256_RSA) {
                instance = Signature.getInstance("SHA256withRSA");
            } else {
                throw new IllegalArgumentException("Invalid Signature: " + this.signatureAlgorithm.toString());
            }
            instance.initVerify(this.publicKey);
            instance.update(data);
            return instance.verify(sign);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private Object[] getData() {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(4);
        bb.set(GXAsn1Converter.rawValue(this.publicKey));
        GXAsn1BitString subjectPKInfo = new GXAsn1BitString(bb.array(), 0);
        Object[] tmp = new Object[]{new GXAsn1ObjectIdentifier("1.2.840.10045.2.1"), new GXAsn1ObjectIdentifier("1.2.840.10045.3.1.7")};
        GXAsn1Context list = new GXAsn1Context();
        for (Map.Entry<PkcsObjectIdentifier, Object[]> it : this.attributes) {
            GXAsn1Sequence s = new GXAsn1Sequence();
            s.add(new GXAsn1ObjectIdentifier(it.getKey().getValue()));
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object v : it.getValue()) {
                values.add(v);
            }
            s.add(new GXSimpleEntry(values, null));
            list.add(s);
        }
        return new Object[]{this.version.getValue(), GXAsn1Converter.encodeSubject(this.subject), new Object[]{tmp, subjectPKInfo}, list};
    }

    public final byte[] getEncoded() {
        if (this.rawData != null) {
            return this.rawData;
        }
        if (this.signature == null) {
            throw new IllegalArgumentException("Sign first.");
        }
        GXAsn1ObjectIdentifier sa = new GXAsn1ObjectIdentifier(this.signatureAlgorithm.getValue());
        Object[] list = new Object[]{this.getData(), new Object[]{sa}, new GXAsn1BitString(this.signature, 0)};
        return GXAsn1Converter.toByteArray(list);
    }

    public void sign(KeyPair kp, HashAlgorithm hashAlgorithm) {
        byte[] data = GXAsn1Converter.toByteArray(this.getData());
        try {
            Signature instance = Signature.getInstance(hashAlgorithm.toString());
            instance.initSign(kp.getPrivate());
            instance.update(data);
            this.signatureAlgorithm = hashAlgorithm;
            this.signature = instance.sign();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static GXPkcs10 createCertificateSigningRequest(KeyPair kp, String subject) {
        GXPkcs10 pkc10 = new GXPkcs10();
        pkc10.setAlgorithm(X9ObjectIdentifier.IdECPublicKey);
        pkc10.setPublicKey(kp.getPublic());
        pkc10.setSubject(subject);
        HashAlgorithm algorithm = kp.getPrivate().getEncoded().length < 70 ? HashAlgorithm.SHA256withECDSA : HashAlgorithm.SHA384withECDSA;
        pkc10.sign(kp, algorithm);
        return pkc10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GXx509Certificate getCertificate(String address, GXPkcs10 cert, KeyUsage usage) throws IOException {
        String der = "{\"KeyUsage\":" + usage.getValue() + ",\"CSR\":[\"" + cert.toDer() + "\"]}";
        URL url = new URL(address);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                os.write(der.getBytes());
                os.flush();
            }
            int ret = connection.getResponseCode();
            if (ret == 201 || ret == 200) {
                String str;
                StringBuilder data = new StringBuilder();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    while ((str = in.readLine()) != null) {
                        data.append(str);
                    }
                }
                str = data.toString();
                int pos = str.indexOf("[");
                if (pos == -1) {
                    throw new IllegalArgumentException("Certificates are missing.");
                }
                if ((pos = (str = str.substring(pos + 2)).indexOf("]")) == -1) {
                    throw new IllegalArgumentException("Certificates are missing.");
                }
                str = str.substring(0, pos - 1);
                GXx509Certificate x509 = GXx509Certificate.fromDer(str);
                if (!cert.getPublicKey().equals(x509.getPublicKey())) {
                    throw new IllegalArgumentException("Create certificate signingRequest generated wrong public key.");
                }
                GXx509Certificate gXx509Certificate = x509;
                return gXx509Certificate;
            }
            GXx509Certificate gXx509Certificate = null;
            return gXx509Certificate;
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GXx509Certificate[] getCertificate(String address, List<GXCertificateRequest> certifications) throws IOException {
        StringBuilder usage = new StringBuilder();
        for (GXCertificateRequest it : certifications) {
            if (usage.length() != 0) {
                usage.append(", ");
            }
            usage.append("{\"KeyUsage\":");
            switch (it.getCertificateType()) {
                case DIGITAL_SIGNATURE: {
                    usage.append(String.valueOf(KeyUsage.DIGITAL_SIGNATURE.getValue()));
                    break;
                }
                case KEY_AGREEMENT: {
                    usage.append(String.valueOf(KeyUsage.KEY_AGREEMENT.getValue()));
                    break;
                }
                case TLS: {
                    usage.append(String.valueOf(KeyUsage.DIGITAL_SIGNATURE.getValue() | KeyUsage.KEY_AGREEMENT.getValue()));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type.");
                }
            }
            if (!it.getExtendedKeyUsage().isEmpty()) {
                usage.append(", \"ExtendedKeyUsage\":");
                usage.append(String.valueOf(ExtendedKeyUsage.toInteger(it.getExtendedKeyUsage())));
            }
            usage.append(", \"CSR\":\"");
            usage.append(it.getCertificate().toDer());
            usage.append("\"}");
        }
        String input = "{\"Certificates\":[" + usage.toString() + "]}";
        URL url = new URL(address);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            String output;
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            OutputStream os = conn.getOutputStream();
            os.write(input.getBytes());
            os.flush();
            if (conn.getResponseCode() != 201 && conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            String str = sb.toString();
            int pos = str.indexOf("[");
            if (pos == -1) {
                throw new RuntimeException("Certificates are missing.");
            }
            if ((pos = (str = str.substring(pos + 2)).indexOf("]")) == -1) {
                throw new RuntimeException("Certificates are missing.");
            }
            str = str.substring(0, pos - 1);
            ArrayList<GXx509Certificate> list = new ArrayList<GXx509Certificate>();
            String[] tmp = str.split("['\"]");
            for (String it : tmp) {
                if (it.compareTo(",") == 0) continue;
                GXx509Certificate x509 = GXx509Certificate.fromDer(it);
                list.add(x509);
            }
            Object[] objectArray = list.toArray(new GXx509Certificate[0]);
            return objectArray;
        }
        finally {
            conn.disconnect();
        }
    }

    public static GXPkcs10 load(Path path) throws IOException {
        return GXPkcs10.fromPem(Files.readString(path));
    }

    public void save(Path path) throws IOException {
        Files.write(path, this.toPem().getBytes(), StandardOpenOption.CREATE);
    }

    public String toPem() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE REQUEST-----");
        sb.append(System.lineSeparator());
        sb.append(this.toDer());
        sb.append(System.lineSeparator());
        sb.append("-----END CERTIFICATE REQUEST-----");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public String toDer() {
        return GXCommon.toBase64(this.getEncoded());
    }
}

