/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.enums;

import java.util.HashMap;

public enum DataType {
    ARRAY(1),
    BCD(13),
    BITSTRING(4),
    BOOLEAN(3),
    COMPACT_ARRAY(19),
    DATE(26),
    DATETIME(25),
    ENUM(22),
    FLOAT32(23),
    FLOAT64(24),
    INT16(16),
    INT32(5),
    INT64(20),
    INT8(15),
    NONE(0),
    OCTET_STRING(9),
    STRING(10),
    STRING_UTF8(12),
    STRUCTURE(2),
    TIME(27),
    UINT16(18),
    UINT32(6),
    UINT64(21),
    UINT8(17);

    private int intValue;
    private static HashMap<Integer, DataType> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, DataType> getMappings() {
        Class<DataType> clazz = DataType.class;
        synchronized (DataType.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private DataType(int value) {
        this.intValue = value;
        DataType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static DataType forValue(int value) {
        DataType type = DataType.getMappings().get(value);
        if (type == null) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(value));
        }
        return type;
    }

    public String toString() {
        String str;
        DataType dt = DataType.forValue(this.intValue);
        switch (dt) {
            case ARRAY: {
                str = "Array";
                break;
            }
            case BCD: {
                str = "Bcd";
                break;
            }
            case BITSTRING: {
                str = "BitString";
                break;
            }
            case BOOLEAN: {
                str = "Boolean";
                break;
            }
            case COMPACT_ARRAY: {
                str = "CompactArray";
                break;
            }
            case DATE: {
                str = "Date";
                break;
            }
            case DATETIME: {
                str = "DateTime";
                break;
            }
            case ENUM: {
                str = "Enum";
                break;
            }
            case FLOAT32: {
                str = "Float32";
                break;
            }
            case FLOAT64: {
                str = "Float64";
                break;
            }
            case INT16: {
                str = "Int16";
                break;
            }
            case INT32: {
                str = "Int32";
                break;
            }
            case INT64: {
                str = "Int64";
                break;
            }
            case INT8: {
                str = "Int8";
                break;
            }
            case NONE: {
                str = "None";
                break;
            }
            case OCTET_STRING: {
                str = "OctetString";
                break;
            }
            case STRING: {
                str = "String";
                break;
            }
            case STRING_UTF8: {
                str = "StringUTF8";
                break;
            }
            case STRUCTURE: {
                str = "Structure";
                break;
            }
            case TIME: {
                str = "Time";
                break;
            }
            case UINT16: {
                str = "UInt16";
                break;
            }
            case UINT32: {
                str = "UInt32";
                break;
            }
            case UINT64: {
                str = "UInt64";
                break;
            }
            case UINT8: {
                str = "UInt8";
                break;
            }
            default: {
                throw new IllegalArgumentException("DataType");
            }
        }
        return str;
    }
}

