/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.enums;

import java.util.HashMap;

public enum ErrorCode {
    DISCONNECT_MODE(-4),
    RECEIVE_NOT_READY(-3),
    REJECTED(-2),
    UNACCEPTABLE_FRAME(-1),
    OK(0),
    HARDWARE_FAULT(1),
    TEMPORARY_FAILURE(2),
    READ_WRITE_DENIED(3),
    UNDEFINED_OBJECT(4),
    INCONSISTENT_CLASS(9),
    UNAVAILABLE_OBJECT(11),
    UNMATCHED_TYPE(12),
    ACCESS_VIOLATED(13),
    DATA_BLOCK_UNAVAILABLE(14),
    LONG_GET_OR_READ_ABORTED(15),
    NO_LONG_GET_OR_READ_IN_PROGRESS(16),
    LONG_SET_OR_WRITE_ABORTED(17),
    NO_LONG_SET_OR_WRITE_IN_PROGRESS(18),
    DATA_BLOCK_NUMBER_INVALID(19),
    OTHER_REASON(250);

    private int intValue;
    private static HashMap<Integer, ErrorCode> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, ErrorCode> getMappings() {
        Class<ErrorCode> clazz = ErrorCode.class;
        synchronized (ErrorCode.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorCode(int value) {
        this.intValue = value;
        Class<ErrorCode> clazz = ErrorCode.class;
        synchronized (ErrorCode.class) {
            ErrorCode.getMappings().put(value, this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public int getValue() {
        return this.intValue;
    }

    public static ErrorCode forValue(int value) {
        return ErrorCode.getMappings().get(value);
    }
}

