/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.manufacturersettings;

import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.Security;
import gurux.dlms.manufacturersettings.GXAuthentication;
import gurux.dlms.manufacturersettings.GXObisCodeCollection;
import gurux.dlms.manufacturersettings.GXServerAddress;
import gurux.dlms.manufacturersettings.HDLCAddressType;
import gurux.dlms.manufacturersettings.InactivityMode;
import gurux.dlms.manufacturersettings.StartProtocolType;
import java.util.ArrayList;
import java.util.List;

public class GXManufacturer {
    private InactivityMode inactivityMode = InactivityMode.KEEPALIVE;
    private boolean useIEC47;
    private boolean forceInactivity;
    private boolean useLogicalNameReferencing;
    private String identification;
    private GXObisCodeCollection obisCodes;
    private String name;
    private ArrayList<GXAuthentication> settings;
    private ArrayList<GXServerAddress> serverSettings;
    private int keepAliveInterval;
    private StartProtocolType startProtocol = StartProtocolType.IEC;
    private String webAddress;
    private String info;
    private Security security = Security.NONE;
    private byte[] systemTitle;
    private byte[] serverSystemTitle;
    private byte[] blockCipherKey;
    private byte[] authenticationKey;
    private List<InterfaceType> supporterdInterfaces;

    public GXManufacturer() {
        this.setInactivityMode(InactivityMode.KEEPALIVE);
        this.setStartProtocol(StartProtocolType.IEC);
        this.obisCodes = new GXObisCodeCollection();
        this.setSettings(new ArrayList<GXAuthentication>());
        this.serverSettings = new ArrayList();
        this.setKeepAliveInterval(40000);
        this.supporterdInterfaces = new ArrayList<InterfaceType>();
    }

    public final String getIdentification() {
        return this.identification;
    }

    public final void setIdentification(String value) {
        this.identification = value;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    public final boolean getUseLogicalNameReferencing() {
        return this.useLogicalNameReferencing;
    }

    public final void setUseLogicalNameReferencing(boolean value) {
        this.useLogicalNameReferencing = value;
    }

    public final InactivityMode getInactivityMode() {
        return this.inactivityMode;
    }

    public final void setInactivityMode(InactivityMode value) {
        this.inactivityMode = value;
    }

    public final boolean getForceInactivity() {
        return this.forceInactivity;
    }

    public final void setForceInactivity(boolean value) {
        this.forceInactivity = value;
    }

    public final GXObisCodeCollection getObisCodes() {
        return this.obisCodes;
    }

    public final boolean getUseIEC47() {
        return this.useIEC47;
    }

    public final void setUseIEC47(boolean value) {
        this.useIEC47 = value;
    }

    public final StartProtocolType getStartProtocol() {
        return this.startProtocol;
    }

    public final void setStartProtocol(StartProtocolType value) {
        this.startProtocol = value;
    }

    public final int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public final void setKeepAliveInterval(int value) {
        this.keepAliveInterval = value;
    }

    public final ArrayList<GXAuthentication> getSettings() {
        return this.settings;
    }

    public final void setSettings(ArrayList<GXAuthentication> value) {
        this.settings = value;
    }

    public final ArrayList<GXServerAddress> getServerSettings() {
        return this.serverSettings;
    }

    public final GXServerAddress getServer(HDLCAddressType type) {
        for (GXServerAddress it : this.getServerSettings()) {
            if (it.getHDLCAddress() != type) continue;
            return it;
        }
        return null;
    }

    public final GXAuthentication getAuthentication(Authentication authentication) {
        for (GXAuthentication it : this.getSettings()) {
            if (it.getType() != authentication) continue;
            return it;
        }
        return null;
    }

    public String getWebAddress() {
        return this.webAddress;
    }

    public void setWebAddress(String value) {
        this.webAddress = value;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String value) {
        this.info = value;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security value) {
        this.security = value;
    }

    public byte[] getSystemTitle() {
        return this.systemTitle;
    }

    public void setSystemTitle(byte[] value) {
        this.systemTitle = value;
    }

    public byte[] getServerSystemTitle() {
        return this.serverSystemTitle;
    }

    public void setServerSystemTitle(byte[] value) {
        this.serverSystemTitle = value;
    }

    public byte[] getBlockCipherKey() {
        return this.blockCipherKey;
    }

    public void setBlockCipherKey(byte[] value) {
        this.blockCipherKey = value;
    }

    public byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(byte[] value) {
        this.authenticationKey = value;
    }

    public List<InterfaceType> getSupporterdInterfaces() {
        return this.supporterdInterfaces;
    }
}

