/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.BaudRate;
import gurux.dlms.objects.enums.LocalPortResponseTime;
import gurux.dlms.objects.enums.OpticalProtocolMode;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSIECLocalPortSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private String password1;
    private String password2;
    private String password5;
    private OpticalProtocolMode defaultMode = OpticalProtocolMode.DEFAULT;
    private BaudRate defaultBaudrate = BaudRate.BAUDRATE_300;
    private BaudRate proposedBaudrate = BaudRate.BAUDRATE_300;
    private LocalPortResponseTime responseTime = LocalPortResponseTime.ms20;
    private String deviceAddress;

    public GXDLMSIECLocalPortSetup() {
        this("0.0.20.0.0.255");
    }

    public GXDLMSIECLocalPortSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSIECLocalPortSetup(String ln, int sn) {
        super(ObjectType.IEC_LOCAL_PORT_SETUP, ln, sn);
        this.setVersion(1);
    }

    public final OpticalProtocolMode getDefaultMode() {
        return this.defaultMode;
    }

    public final void setDefaultMode(OpticalProtocolMode value) {
        this.defaultMode = value;
    }

    public final BaudRate getDefaultBaudrate() {
        return this.defaultBaudrate;
    }

    public final void setDefaultBaudrate(BaudRate value) {
        this.defaultBaudrate = value;
    }

    public final BaudRate getProposedBaudrate() {
        return this.proposedBaudrate;
    }

    public final void setProposedBaudrate(BaudRate value) {
        this.proposedBaudrate = value;
    }

    public final LocalPortResponseTime getResponseTime() {
        return this.responseTime;
    }

    public final void setResponseTime(LocalPortResponseTime value) {
        this.responseTime = value;
    }

    public final String getDeviceAddress() {
        return this.deviceAddress;
    }

    public final void setDeviceAddress(String value) {
        this.deviceAddress = value;
    }

    public final String getPassword1() {
        return this.password1;
    }

    public final void setPassword1(String value) {
        this.password1 = value;
    }

    public final String getPassword2() {
        return this.password2;
    }

    public final void setPassword2(String value) {
        this.password2 = value;
    }

    public final String getPassword5() {
        return this.password5;
    }

    public final void setPassword5(String value) {
        this.password5 = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getDefaultMode(), this.getDefaultBaudrate(), this.getProposedBaudrate(), this.getResponseTime(), this.getDeviceAddress(), this.getPassword1(), this.getPassword2(), this.getPassword5()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        if (all || !this.isRead(7)) {
            attributes.add(7);
        }
        if (all || !this.isRead(8)) {
            attributes.add(8);
        }
        if (all || !this.isRead(9)) {
            attributes.add(9);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 9;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        if (index == 3) {
            return DataType.ENUM;
        }
        if (index == 4) {
            return DataType.ENUM;
        }
        if (index == 5) {
            return DataType.ENUM;
        }
        if (index == 6) {
            return DataType.OCTET_STRING;
        }
        if (index == 7) {
            return DataType.OCTET_STRING;
        }
        if (index == 8) {
            return DataType.OCTET_STRING;
        }
        if (index == 9) {
            return DataType.OCTET_STRING;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getDefaultMode().getValue();
        }
        if (e.getIndex() == 3) {
            return this.getDefaultBaudrate().ordinal();
        }
        if (e.getIndex() == 4) {
            return this.getProposedBaudrate().ordinal();
        }
        if (e.getIndex() == 5) {
            return this.getResponseTime().ordinal();
        }
        if (e.getIndex() == 6) {
            return GXCommon.getBytes(this.deviceAddress);
        }
        if (e.getIndex() == 7) {
            return GXCommon.getBytes(this.password1);
        }
        if (e.getIndex() == 8) {
            return GXCommon.getBytes(this.password2);
        }
        if (e.getIndex() == 9) {
            return GXCommon.getBytes(this.password5);
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setDefaultMode(OpticalProtocolMode.forValue(((Number)e.getValue()).intValue()));
        } else if (e.getIndex() == 3) {
            this.setDefaultBaudrate(BaudRate.values()[((Number)e.getValue()).intValue()]);
        } else if (e.getIndex() == 4) {
            this.setProposedBaudrate(BaudRate.values()[((Number)e.getValue()).intValue()]);
        } else if (e.getIndex() == 5) {
            this.setResponseTime(LocalPortResponseTime.values()[((Number)e.getValue()).intValue()]);
        } else if (e.getIndex() == 6) {
            this.setDeviceAddress(GXDLMSClient.changeType((byte[])e.getValue(), DataType.STRING, e.getSettings()).toString());
        } else if (e.getIndex() == 7) {
            this.setPassword1(GXDLMSClient.changeType((byte[])e.getValue(), DataType.STRING, e.getSettings()).toString());
        } else if (e.getIndex() == 8) {
            this.setPassword2(GXDLMSClient.changeType((byte[])e.getValue(), DataType.STRING, e.getSettings()).toString());
        } else if (e.getIndex() == 9) {
            this.setPassword5(GXDLMSClient.changeType((byte[])e.getValue(), DataType.STRING, e.getSettings()).toString());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.defaultMode = OpticalProtocolMode.forValue(reader.readElementContentAsInt("DefaultMode"));
        this.defaultBaudrate = BaudRate.values()[reader.readElementContentAsInt("DefaultBaudrate")];
        this.proposedBaudrate = BaudRate.values()[reader.readElementContentAsInt("ProposedBaudrate")];
        this.responseTime = LocalPortResponseTime.forValue(reader.readElementContentAsInt("ResponseTime"));
        this.deviceAddress = reader.readElementContentAsString("DeviceAddress");
        this.password1 = reader.readElementContentAsString("Password1");
        this.password2 = reader.readElementContentAsString("Password2");
        this.password5 = reader.readElementContentAsString("Password5");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("DefaultMode", this.defaultMode.getValue());
        writer.writeElementString("DefaultBaudrate", this.defaultBaudrate.ordinal());
        writer.writeElementString("ProposedBaudrate", this.proposedBaudrate.ordinal());
        writer.writeElementString("ResponseTime", this.responseTime.getValue());
        writer.writeElementString("DeviceAddress", this.deviceAddress);
        writer.writeElementString("Password1", this.password1);
        writer.writeElementString("Password2", this.password2);
        writer.writeElementString("Password5", this.password5);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Default Mode", "Default Baud rate", "Proposed Baud rate", "Response Time", "Device Address", "Password 1", "Password 2", "Password 5"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

