/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSActionItem;
import gurux.dlms.objects.GXDLMSEmergencyProfile;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSLimiter
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSObject monitoredValue;
    private int monitoredAttributeIndex;
    private Object thresholdActive;
    private Object thresholdNormal;
    private Object thresholdEmergency;
    private long minOverThresholdDuration;
    private long minUnderThresholdDuration;
    private GXDLMSEmergencyProfile emergencyProfile = new GXDLMSEmergencyProfile();
    private int[] emergencyProfileGroupIDs;
    private boolean emergencyProfileActive;
    private GXDLMSActionItem actionOverThreshold = new GXDLMSActionItem();
    private GXDLMSActionItem actionUnderThreshold = new GXDLMSActionItem();

    public GXDLMSLimiter() {
        super(ObjectType.LIMITER);
    }

    public GXDLMSLimiter(String ln) {
        super(ObjectType.LIMITER, ln, 0);
    }

    public GXDLMSLimiter(String ln, int sn) {
        super(ObjectType.LIMITER, ln, sn);
    }

    public final GXDLMSObject getMonitoredValue() {
        return this.monitoredValue;
    }

    public final void setMonitoredValue(GXDLMSObject value) {
        this.monitoredValue = value;
    }

    public final int getmonitoredAttributeIndex() {
        return this.monitoredAttributeIndex;
    }

    public final void setmonitoredAttributeIndex(int value) {
        this.monitoredAttributeIndex = value;
    }

    public final Object getThresholdActive() {
        return this.thresholdActive;
    }

    public final void setThresholdActive(Object value) {
        this.thresholdActive = value;
    }

    public final Object getThresholdNormal() {
        return this.thresholdNormal;
    }

    public final void setThresholdNormal(Object value) {
        this.thresholdNormal = value;
    }

    public final Object getThresholdEmergency() {
        return this.thresholdEmergency;
    }

    public final void setThresholdEmergency(Object value) {
        this.thresholdEmergency = value;
    }

    public final long getMinOverThresholdDuration() {
        return this.minOverThresholdDuration;
    }

    public final void setMinOverThresholdDuration(long value) {
        this.minOverThresholdDuration = value;
    }

    public final long getMinUnderThresholdDuration() {
        return this.minUnderThresholdDuration;
    }

    public final void setMinUnderThresholdDuration(long value) {
        this.minUnderThresholdDuration = value;
    }

    public final GXDLMSEmergencyProfile getEmergencyProfile() {
        return this.emergencyProfile;
    }

    public final int[] getEmergencyProfileGroupIDs() {
        return this.emergencyProfileGroupIDs;
    }

    public final void setEmergencyProfileGroupIDs(int[] value) {
        this.emergencyProfileGroupIDs = value;
    }

    public final boolean getEmergencyProfileActive() {
        return this.emergencyProfileActive;
    }

    public final void setEmergencyProfileActive(boolean value) {
        this.emergencyProfileActive = value;
    }

    public final GXDLMSActionItem getActionOverThreshold() {
        return this.actionOverThreshold;
    }

    public final void setActionOverThreshold(GXDLMSActionItem value) {
        this.actionOverThreshold = value;
    }

    public final GXDLMSActionItem getActionUnderThreshold() {
        return this.actionUnderThreshold;
    }

    public final void setActionUnderThreshold(GXDLMSActionItem value) {
        this.actionUnderThreshold = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.monitoredValue, this.thresholdActive, this.thresholdNormal, this.thresholdEmergency, this.minOverThresholdDuration, this.minUnderThresholdDuration, this.emergencyProfile, this.emergencyProfileGroupIDs, this.emergencyProfileActive, new Object[]{this.actionOverThreshold, this.actionUnderThreshold}};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 11;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.STRUCTURE;
        }
        if (index == 3) {
            return super.getDataType(index);
        }
        if (index == 4) {
            return super.getDataType(index);
        }
        if (index == 5) {
            return super.getDataType(index);
        }
        if (index == 6) {
            return DataType.UINT32;
        }
        if (index == 7) {
            return DataType.UINT32;
        }
        if (index == 8) {
            return DataType.STRUCTURE;
        }
        if (index == 9) {
            return DataType.ARRAY;
        }
        if (index == 10) {
            return DataType.BOOLEAN;
        }
        if (index == 11) {
            return DataType.STRUCTURE;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(3);
            if (this.monitoredValue == null) {
                GXCommon.setData(settings, data, DataType.UINT16, 0);
                GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(null));
                GXCommon.setData(settings, data, DataType.INT8, 0);
            } else {
                GXCommon.setData(settings, data, DataType.UINT16, this.monitoredValue.getObjectType().getValue());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(this.monitoredValue.getLogicalName()));
                GXCommon.setData(settings, data, DataType.INT8, this.monitoredAttributeIndex);
            }
            return data.array();
        }
        if (e.getIndex() == 3) {
            return this.thresholdActive;
        }
        if (e.getIndex() == 4) {
            return this.thresholdNormal;
        }
        if (e.getIndex() == 5) {
            return this.thresholdEmergency;
        }
        if (e.getIndex() == 6) {
            return this.minOverThresholdDuration;
        }
        if (e.getIndex() == 7) {
            return this.minUnderThresholdDuration;
        }
        if (e.getIndex() == 8) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(3);
            GXCommon.setData(settings, data, DataType.UINT16, this.emergencyProfile.getID());
            GXCommon.setData(settings, data, DataType.OCTET_STRING, this.emergencyProfile.getActivationTime());
            GXCommon.setData(settings, data, DataType.UINT32, this.emergencyProfile.getDuration());
            return data.array();
        }
        if (e.getIndex() == 9) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8((byte)DataType.ARRAY.getValue());
            data.setUInt8((byte)this.emergencyProfileGroupIDs.length);
            int[] nArray = this.emergencyProfileGroupIDs;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer it = nArray[i];
                GXCommon.setData(settings, data, DataType.UINT16, it);
            }
            return data.array();
        }
        if (e.getIndex() == 10) {
            return this.emergencyProfileActive;
        }
        if (e.getIndex() == 11) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(this.actionOverThreshold.getLogicalName()));
            GXCommon.setData(settings, data, DataType.UINT16, this.actionOverThreshold.getScriptSelector());
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(this.actionUnderThreshold.getLogicalName()));
            GXCommon.setData(settings, data, DataType.UINT16, this.actionUnderThreshold.getScriptSelector());
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            ObjectType ot = ObjectType.forValue(((Number)((List)e.getValue()).get(0)).intValue());
            String ln = GXCommon.toLogicalName(((List)e.getValue()).get(1));
            this.monitoredAttributeIndex = ((Number)((List)e.getValue()).get(2)).intValue();
            this.monitoredValue = settings.getObjects().findByLN(ot, ln);
        } else if (e.getIndex() == 3) {
            this.thresholdActive = e.getValue();
        } else if (e.getIndex() == 4) {
            this.thresholdNormal = e.getValue();
        } else if (e.getIndex() == 5) {
            this.thresholdEmergency = e.getValue();
        } else if (e.getIndex() == 6) {
            this.minOverThresholdDuration = ((Number)e.getValue()).longValue();
        } else if (e.getIndex() == 7) {
            this.minUnderThresholdDuration = ((Number)e.getValue()).longValue();
        } else if (e.getIndex() == 8) {
            List tmp = (List)e.getValue();
            this.emergencyProfile.setID(((Number)tmp.get(0)).intValue());
            this.emergencyProfile.setActivationTime((GXDateTime)GXDLMSClient.changeType((byte[])tmp.get(1), DataType.DATETIME, e.getSettings()));
            this.emergencyProfile.setDuration(((Number)tmp.get(2)).longValue());
        } else if (e.getIndex() == 9) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (e.getValue() != null) {
                for (Object it : (List)e.getValue()) {
                    list.add(((Number)it).intValue());
                }
            }
            this.emergencyProfileGroupIDs = GXDLMSObjectHelpers.toIntArray(list);
        } else if (e.getIndex() == 10) {
            this.emergencyProfileActive = (Boolean)e.getValue();
        } else if (e.getIndex() == 11) {
            List tmp = (List)e.getValue();
            List tmp1 = (List)tmp.get(0);
            List tmp2 = (List)tmp.get(1);
            this.actionOverThreshold.setLogicalName(GXCommon.toLogicalName(tmp1.get(0)));
            this.actionOverThreshold.setScriptSelector(((Number)tmp1.get(1)).intValue());
            this.actionUnderThreshold.setLogicalName(GXCommon.toLogicalName(tmp2.get(0)));
            this.actionUnderThreshold.setScriptSelector(((Number)tmp2.get(1)).intValue());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        if (reader.isStartElement("MonitoredValue", true)) {
            ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
            String ln = reader.readElementContentAsString("LN");
            if (ot != ObjectType.NONE && ln != null) {
                this.monitoredValue = reader.getObjects().findByLN(ot, ln);
                if (this.monitoredValue == null) {
                    this.monitoredValue = GXDLMSClient.createObject(ot);
                    this.monitoredValue.setLogicalName(ln);
                }
            }
            reader.readEndElement("MonitoredValue");
        }
        this.thresholdActive = reader.readElementContentAsObject("ThresholdActive", null, this, 3);
        this.thresholdNormal = reader.readElementContentAsObject("ThresholdNormal", null, this, 4);
        this.thresholdEmergency = reader.readElementContentAsObject("ThresholdEmergency", null, this, 5);
        this.minOverThresholdDuration = reader.readElementContentAsInt("MinOverThresholdDuration");
        this.minUnderThresholdDuration = reader.readElementContentAsInt("MinUnderThresholdDuration");
        if (reader.isStartElement("EmergencyProfile", true)) {
            this.emergencyProfile.setID(reader.readElementContentAsInt("ID"));
            this.emergencyProfile.setActivationTime(reader.readElementContentAsDateTime("Time"));
            this.emergencyProfile.setDuration(reader.readElementContentAsInt("Duration"));
            reader.readEndElement("EmergencyProfile");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (reader.isStartElement("EmergencyProfileGroupIDs", true)) {
            while (reader.isStartElement("Value", false)) {
                list.add(reader.readElementContentAsInt("Value"));
            }
            reader.readEndElement("EmergencyProfileGroupIDs");
        }
        this.emergencyProfileGroupIDs = GXCommon.toIntArray(list);
        boolean bl = this.emergencyProfileActive = reader.readElementContentAsInt("Active") != 0;
        if (reader.isStartElement("ActionOverThreshold", true)) {
            this.actionOverThreshold.setLogicalName(reader.readElementContentAsString("LN"));
            this.actionOverThreshold.setScriptSelector(reader.readElementContentAsInt("ScriptSelector"));
            reader.readEndElement("ActionOverThreshold");
        }
        if (reader.isStartElement("ActionUnderThreshold", true)) {
            this.actionUnderThreshold.setLogicalName(reader.readElementContentAsString("LN"));
            this.actionUnderThreshold.setScriptSelector(reader.readElementContentAsInt("ScriptSelector"));
            reader.readEndElement("ActionUnderThreshold");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.monitoredValue != null) {
            writer.writeStartElement("MonitoredValue");
            writer.writeElementString("ObjectType", this.monitoredValue.getObjectType().getValue());
            writer.writeElementString("LN", this.monitoredValue.getLogicalName());
            writer.writeEndElement();
        }
        writer.writeElementObject("ThresholdActive", this.thresholdActive, this.getDataType(3), this.getUIDataType(3));
        writer.writeElementObject("ThresholdNormal", this.thresholdNormal, this.getDataType(4), this.getUIDataType(4));
        writer.writeElementObject("ThresholdEmergency", this.thresholdEmergency, this.getDataType(5), this.getUIDataType(5));
        writer.writeElementString("MinOverThresholdDuration", this.minOverThresholdDuration);
        writer.writeElementString("MinUnderThresholdDuration", this.minUnderThresholdDuration);
        if (this.emergencyProfile != null) {
            writer.writeStartElement("EmergencyProfile");
            writer.writeElementString("ID", this.emergencyProfile.getID());
            writer.writeElementString("Time", this.emergencyProfile.getActivationTime());
            writer.writeElementString("Duration", this.emergencyProfile.getDuration());
            writer.writeEndElement();
        }
        if (this.emergencyProfileGroupIDs != null) {
            writer.writeStartElement("EmergencyProfileGroupIDs");
            for (int it : this.emergencyProfileGroupIDs) {
                writer.writeElementString("Value", it);
            }
            writer.writeEndElement();
        }
        writer.writeElementString("Active", this.emergencyProfileActive);
        if (this.actionOverThreshold != null) {
            writer.writeStartElement("ActionOverThreshold");
            writer.writeElementString("LN", this.actionOverThreshold.getLogicalName());
            writer.writeElementString("ScriptSelector", this.actionOverThreshold.getScriptSelector());
            writer.writeEndElement();
        }
        if (this.actionUnderThreshold != null) {
            writer.writeStartElement("ActionUnderThreshold");
            writer.writeElementString("LN", this.actionUnderThreshold.getLogicalName());
            writer.writeElementString("ScriptSelector", this.actionUnderThreshold.getScriptSelector());
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
        GXDLMSObject target;
        if (this.monitoredValue != null && (target = reader.getObjects().findByLN(this.monitoredValue.getObjectType(), this.monitoredValue.getLogicalName())) != null && target != this.monitoredValue) {
            this.monitoredValue = target;
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Monitored Value", "Active Threshold", "Normal Threshold", "Emergency Threshold", "Threshold Duration Min Over", "Threshold Duration Min Under", "Emergency Profile", "Emergency Profile Group", "Emergency Profile Active", "Actions"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

