/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSModemInitialisation;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.BaudRate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSModemConfiguration
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSModemInitialisation[] initialisationStrings = new GXDLMSModemInitialisation[0];
    private String[] modemProfile;
    private BaudRate communicationSpeed = BaudRate.BAUDRATE_300;

    static final String[] defultProfiles() {
        return new String[]{"OK", "CONNECT", "RING", "NO CARRIER", "ERROR", "CONNECT 1200", "NO DIAL TONE", "BUSY", "NO ANSWER", "CONNECT 600", "CONNECT 2400", "CONNECT 4800", "CONNECT 9600", "CONNECT 14 400", "CONNECT 28 800", "CONNECT 33 600", "CONNECT 56 000"};
    }

    public GXDLMSModemConfiguration() {
        super(ObjectType.MODEM_CONFIGURATION, "0.0.2.0.0.255", 0);
        this.modemProfile = GXDLMSModemConfiguration.defultProfiles();
    }

    public GXDLMSModemConfiguration(String ln) {
        super(ObjectType.MODEM_CONFIGURATION, ln, 0);
        this.modemProfile = GXDLMSModemConfiguration.defultProfiles();
    }

    public GXDLMSModemConfiguration(String ln, int sn) {
        super(ObjectType.MODEM_CONFIGURATION, ln, 0);
        this.modemProfile = GXDLMSModemConfiguration.defultProfiles();
    }

    public final BaudRate getCommunicationSpeed() {
        return this.communicationSpeed;
    }

    public final void setCommunicationSpeed(BaudRate value) {
        this.communicationSpeed = value;
    }

    public final GXDLMSModemInitialisation[] getInitialisationStrings() {
        return this.initialisationStrings;
    }

    public final void setInitialisationStrings(GXDLMSModemInitialisation[] value) {
        this.initialisationStrings = value;
    }

    public final String[] getModemProfile() {
        return this.modemProfile;
    }

    public final void setModemProfile(String[] value) {
        this.modemProfile = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getCommunicationSpeed(), this.getInitialisationStrings(), this.getModemProfile()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.communicationSpeed.ordinal();
        }
        if (e.getIndex() == 3) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            int cnt = 0;
            if (this.initialisationStrings != null) {
                cnt = this.initialisationStrings.length;
            }
            GXCommon.setObjectCount(cnt, data);
            if (cnt != 0) {
                for (GXDLMSModemInitialisation it : this.initialisationStrings) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(3);
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.getBytes(it.getRequest()));
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.getBytes(it.getResponse()));
                    GXCommon.setData(settings, data, DataType.UINT16, it.getDelay());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            int cnt = 0;
            if (this.modemProfile != null) {
                cnt = this.modemProfile.length;
            }
            GXCommon.setObjectCount(cnt, data);
            if (cnt != 0) {
                for (String it : this.modemProfile) {
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.getBytes(it));
                }
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.communicationSpeed = BaudRate.values()[((Number)e.getValue()).intValue()];
        } else if (e.getIndex() == 3) {
            this.initialisationStrings = null;
            if (e.getValue() != null) {
                ArrayList<GXDLMSModemInitialisation> items = new ArrayList<GXDLMSModemInitialisation>();
                for (Object it : (List)e.getValue()) {
                    List arr = (List)it;
                    GXDLMSModemInitialisation item = new GXDLMSModemInitialisation();
                    item.setRequest(GXDLMSClient.changeType((byte[])arr.get(0), DataType.STRING, e.getSettings()).toString());
                    item.setResponse(GXDLMSClient.changeType((byte[])arr.get(1), DataType.STRING, e.getSettings()).toString());
                    if (arr.size() > 2) {
                        item.setDelay(((Number)arr.get(2)).intValue());
                    }
                    items.add(item);
                }
                this.initialisationStrings = items.toArray(new GXDLMSModemInitialisation[items.size()]);
            }
        } else if (e.getIndex() == 4) {
            this.modemProfile = null;
            if (e.getValue() != null) {
                ArrayList<String> items = new ArrayList<String>();
                for (Object it : (List)e.getValue()) {
                    items.add(GXDLMSClient.changeType((byte[])it, DataType.STRING, e.getSettings()).toString());
                }
                this.modemProfile = items.toArray(new String[items.size()]);
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.communicationSpeed = BaudRate.values()[reader.readElementContentAsInt("CommunicationSpeed")];
        if (reader.isStartElement("InitialisationStrings", true)) {
            while (reader.isStartElement("Initialisation", true)) {
                GXDLMSModemInitialisation it = new GXDLMSModemInitialisation();
                it.setRequest(reader.readElementContentAsString("Request"));
                it.setResponse(reader.readElementContentAsString("Response"));
                it.setDelay(reader.readElementContentAsInt("Delay"));
            }
            reader.readEndElement("InitialisationStrings");
        }
        this.modemProfile = GXCommon.split(reader.readElementContentAsString("ModemProfile", ""), ';').toArray(new String[0]);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.communicationSpeed != BaudRate.BAUDRATE_300) {
            writer.writeElementString("CommunicationSpeed", this.communicationSpeed.ordinal());
        }
        if (this.initialisationStrings != null) {
            writer.writeStartElement("InitialisationStrings");
            for (GXDLMSModemInitialisation it : this.initialisationStrings) {
                writer.writeStartElement("Initialisation");
                writer.writeElementString("Request", it.getRequest());
                writer.writeElementString("Response", it.getResponse());
                writer.writeElementString("Delay", it.getDelay());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.modemProfile != null) {
            writer.writeElementString("ModemProfile", String.join((CharSequence)";", this.modemProfile));
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Communication Speed", "Initialisation Strings", "Modem Profile"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

