/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXStructure;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.NtpAuthenticationMethod;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSNtpSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private boolean activated;
    private String serverAddress;
    private int port = 123;
    private NtpAuthenticationMethod authentication;
    private Map<Long, byte[]> keys = new HashMap<Long, byte[]>();
    private byte[] clientKey;

    public GXDLMSNtpSetup() {
        this("0.0.25.10.0.255", 0);
    }

    public GXDLMSNtpSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSNtpSetup(String ln, int sn) {
        super(ObjectType.NTP_SETUP, ln, sn);
        this.authentication = NtpAuthenticationMethod.NO_SECURITY;
    }

    public final boolean getActivated() {
        return this.activated;
    }

    public final void setActivated(boolean value) {
        this.activated = value;
    }

    public final String getServerAddress() {
        return this.serverAddress;
    }

    public final void setServerAddress(String value) {
        this.serverAddress = value;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int value) {
        this.port = value;
    }

    public final NtpAuthenticationMethod getAuthentication() {
        return this.authentication;
    }

    public final void setAuthentication(NtpAuthenticationMethod value) {
        this.authentication = value;
    }

    public final Map<Long, byte[]> getKeys() {
        return this.keys;
    }

    public final void setKeys(Map<Long, byte[]> value) {
        this.keys = value;
    }

    public final byte[] getClientKey() {
        return this.clientKey;
    }

    public final void setClientKey(byte[] value) {
        this.clientKey = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.activated, this.serverAddress, this.port, this.authentication, this.keys, this.clientKey};
    }

    public final byte[][] synchronize(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    public final byte[][] addAuthenticationKey(GXDLMSClient client, int id, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE);
        bb.setUInt8(2);
        bb.setUInt8(DataType.UINT32);
        bb.setUInt32(id);
        bb.setUInt8(DataType.OCTET_STRING);
        GXCommon.setObjectCount(key.length, bb);
        bb.set(key);
        return client.method(this, 2, bb.array(), DataType.STRUCTURE);
    }

    public final byte[][] deleteAuthenticationKey(GXDLMSClient client, int id) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 3, id, DataType.INT8);
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 7;
    }

    @Override
    public final int getMethodCount() {
        return 3;
    }

    @Override
    public final DataType getUIDataType(int index) {
        if (index == 3) {
            return DataType.STRING;
        }
        return super.getUIDataType(index);
    }

    @Override
    public final DataType getDataType(int index) {
        DataType dt;
        switch (index) {
            case 1: {
                dt = DataType.OCTET_STRING;
                break;
            }
            case 2: {
                dt = DataType.BOOLEAN;
                break;
            }
            case 3: {
                dt = DataType.OCTET_STRING;
                break;
            }
            case 4: {
                dt = DataType.UINT16;
                break;
            }
            case 5: {
                dt = DataType.ENUM;
                break;
            }
            case 6: {
                dt = DataType.ARRAY;
                break;
            }
            case 7: {
                dt = DataType.OCTET_STRING;
                break;
            }
            default: {
                throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
            }
        }
        return dt;
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                ret = this.activated;
                break;
            }
            case 3: {
                ret = this.serverAddress;
                break;
            }
            case 4: {
                ret = this.port;
                break;
            }
            case 5: {
                ret = this.authentication.ordinal();
                break;
            }
            case 6: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                GXCommon.setObjectCount(this.keys.size(), bb);
                Iterator<Map.Entry<Long, byte[]>> iterator = this.keys.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, byte[]> tmp;
                    Map.Entry<Long, byte[]> it = tmp = iterator.next();
                    bb.setUInt8(DataType.STRUCTURE);
                    bb.setUInt8(2);
                    bb.setUInt8(DataType.UINT32.getValue());
                    bb.setUInt32(it.getKey());
                    bb.setUInt8(DataType.OCTET_STRING);
                    GXCommon.setObjectCount(it.getValue().length, bb);
                    bb.set(it.getValue());
                }
                ret = bb.array();
                break;
            }
            case 7: {
                ret = this.clientKey;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.activated = (Boolean)e.getValue();
                break;
            }
            case 3: {
                if (e.getValue() instanceof byte[]) {
                    this.serverAddress = new String((byte[])e.getValue());
                    break;
                }
                if (e.getValue() instanceof String) {
                    this.serverAddress = (String)e.getValue();
                    break;
                }
                this.serverAddress = null;
                break;
            }
            case 4: {
                this.port = ((Number)e.getValue()).intValue();
                break;
            }
            case 5: {
                this.authentication = NtpAuthenticationMethod.values()[((Number)e.getValue()).intValue()];
                break;
            }
            case 6: {
                this.keys.clear();
                if (e.getValue() == null) break;
                for (Object tmp : (GXArray)e.getValue()) {
                    GXStructure it = (GXStructure)tmp;
                    this.keys.put((long)((Long)it.get(0)), (byte[])it.get(1));
                }
                break;
            }
            case 7: {
                this.clientKey = (byte[])e.getValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.activated = reader.readElementContentAsInt("Activated", 1) != 0;
        this.serverAddress = reader.readElementContentAsString("ServerAddress", null);
        this.port = reader.readElementContentAsInt("Port", 0);
        this.authentication = NtpAuthenticationMethod.values()[reader.readElementContentAsInt("Authentication", 0)];
        this.keys.clear();
        if (reader.isStartElement("Keys", true)) {
            while (reader.isStartElement("Item", true)) {
                long id = reader.readElementContentAsLong("ID");
                byte[] key = GXCommon.hexToBytes(reader.readElementContentAsString("Key"));
                this.keys.put(id, key);
            }
        }
        this.clientKey = GXCommon.hexToBytes(reader.readElementContentAsString("ServerAddress", null));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Activated", this.activated);
        writer.writeElementString("ServerAddress", this.serverAddress);
        writer.writeElementString("Port", this.port);
        writer.writeElementString("Authentication", this.authentication.ordinal());
        writer.writeStartElement("Keys");
        Iterator<Map.Entry<Long, byte[]>> iterator = this.keys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, byte[]> tmp;
            Map.Entry<Long, byte[]> it = tmp = iterator.next();
            writer.writeStartElement("Item");
            writer.writeElementString("ID", it.getKey().toString());
            writer.writeElementString("Key", GXCommon.toHex(it.getValue(), false));
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeElementString("ClientKey", GXCommon.toHex(this.clientKey, false));
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Activated", "ServerAddress", "Port", "Authentication", "Keys", "ClientKey"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Synchronize", "Add authentication key", "Delete authentication key"};
    }
}

