/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.AccessMode3;
import gurux.dlms.enums.MethodAccessMode;
import gurux.dlms.enums.MethodAccessMode3;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.GXXmlWriterSettings;
import gurux.dlms.objects.IGXDLMSBase;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSObjectCollection
extends ArrayList<GXDLMSObject>
implements List<GXDLMSObject> {
    private static final long serialVersionUID = 1L;
    private Object parent;

    public GXDLMSObjectCollection() {
    }

    public GXDLMSObjectCollection(Object forParent) {
        this.parent = forParent;
    }

    public final Object getParent() {
        return this.parent;
    }

    final void setParent(Object value) {
        this.parent = value;
    }

    public final GXDLMSObjectCollection getObjects(ObjectType type) {
        GXDLMSObjectCollection items = new GXDLMSObjectCollection();
        for (GXDLMSObject it : this) {
            if (it.getObjectType() != type) continue;
            items.add(it);
        }
        return items;
    }

    public final GXDLMSObjectCollection getObjects(ObjectType[] types) {
        GXDLMSObjectCollection items = new GXDLMSObjectCollection();
        block0: for (GXDLMSObject it : this) {
            for (ObjectType type : types) {
                if (type != it.getObjectType()) continue;
                items.add(it);
                continue block0;
            }
        }
        return items;
    }

    public final GXDLMSObject findByLN(ObjectType type, String ln) {
        for (GXDLMSObject it : this) {
            if (type != ObjectType.NONE && it.getObjectType() != type || !it.getLogicalName().trim().equals(ln)) continue;
            return it;
        }
        return null;
    }

    public final GXDLMSObject findBySN(int sn) {
        for (GXDLMSObject it : this) {
            if (it.getShortName() != sn) continue;
            return it;
        }
        return null;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (GXDLMSObject it : this) {
            if (sb.length() != 1) {
                sb.append(", ");
            }
            sb.append(it.getName().toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public static GXDLMSObjectCollection load(String path) throws XMLStreamException, IOException {
        FileInputStream stream = new FileInputStream(path);
        try {
            GXDLMSObjectCollection gXDLMSObjectCollection = GXDLMSObjectCollection.load(stream);
            return gXDLMSObjectCollection;
        }
        finally {
            stream.close();
            stream = null;
        }
    }

    public static GXDLMSObjectCollection load(InputStream stream) throws XMLStreamException {
        GXDLMSObject obj = null;
        ObjectType type = null;
        GXXmlReader reader = new GXXmlReader(stream);
        while (!reader.isEOF()) {
            if (reader.isStartElement()) {
                String target = reader.getName();
                if ("Objects".equalsIgnoreCase(target)) {
                    reader.read();
                    continue;
                }
                if (target.startsWith("GXDLMS")) {
                    type = ObjectType.getEnum(target.substring(6));
                    if (type == null) {
                        throw new RuntimeException("Invalid object type: " + target + ".");
                    }
                    reader.read();
                    obj = GXDLMSClient.createObject(type);
                    obj.setVersion(0);
                    continue;
                }
                if ("Object".equalsIgnoreCase(target)) {
                    type = ObjectType.forValue(Integer.parseInt(reader.getAttribute(0)));
                    reader.read();
                    obj = GXDLMSClient.createObject(type);
                    obj.setVersion(0);
                    continue;
                }
                if ("SN".equalsIgnoreCase(target)) {
                    obj.setShortName(reader.readElementContentAsInt("SN"));
                    GXDLMSObject tmp = reader.getObjects().findBySN(obj.getShortName());
                    if (tmp == null) {
                        reader.getObjects().add(obj);
                        continue;
                    }
                    obj = tmp;
                    continue;
                }
                if ("LN".equalsIgnoreCase(target)) {
                    obj.setLogicalName(reader.readElementContentAsString("LN"));
                    GXDLMSObject tmp = reader.getObjects().findByLN(obj.getObjectType(), obj.getLogicalName());
                    if (tmp == null) {
                        reader.getObjects().add(obj);
                        continue;
                    }
                    tmp.setVersion(obj.getVersion());
                    obj = tmp;
                    continue;
                }
                if ("Description".equalsIgnoreCase(target)) {
                    obj.setDescription(reader.readElementContentAsString("Description"));
                    continue;
                }
                if ("Version".equalsIgnoreCase(target)) {
                    obj.setVersion(reader.readElementContentAsInt("Version"));
                    continue;
                }
                if ("Access".equalsIgnoreCase(target)) {
                    int pos = 0;
                    for (byte it : reader.readElementContentAsString("Access").getBytes()) {
                        ++pos;
                        if (obj.getVersion() < 3) {
                            obj.setAccess(pos, AccessMode.forValue(it - 48));
                            continue;
                        }
                        int tmp = it - 48;
                        if (tmp == 1) {
                            obj.getAccess3(pos).add(AccessMode3.READ);
                            continue;
                        }
                        if (tmp == 2) {
                            obj.getAccess3(pos).add(AccessMode3.WRITE);
                            continue;
                        }
                        if (tmp != 3) continue;
                        obj.getAccess3(pos).add(AccessMode3.READ);
                        obj.getAccess3(pos).add(AccessMode3.WRITE);
                    }
                    continue;
                }
                if ("Access3".equalsIgnoreCase(target)) {
                    String tmp = reader.readElementContentAsString("Access3");
                    if (tmp == null) continue;
                    for (int pos = 0; pos != tmp.length() / 4; ++pos) {
                        obj.getAccess3(pos).addAll(AccessMode3.forValue(Integer.parseInt(tmp.substring(4 * pos, 4 * pos + 4), 16)));
                    }
                    continue;
                }
                if ("MethodAccess".equalsIgnoreCase(target)) {
                    int pos = 0;
                    for (byte it : reader.readElementContentAsString("MethodAccess").getBytes()) {
                        ++pos;
                        if (obj.getVersion() < 3) {
                            obj.setMethodAccess(pos, MethodAccessMode.forValue(it - 48));
                            continue;
                        }
                        obj.getMethodAccess3(pos).addAll(MethodAccessMode3.forValue(it - 48));
                    }
                    continue;
                }
                if ("MethodAccess3".equalsIgnoreCase(target)) {
                    String tmp = reader.readElementContentAsString("MethodAccess3");
                    if (tmp == null) continue;
                    for (int pos = 0; pos != tmp.length() / 4; ++pos) {
                        obj.getMethodAccess3(pos).addAll(MethodAccessMode3.forValue(Integer.parseInt(tmp.substring(4 * pos, 4 * pos + 4), 16)));
                    }
                    continue;
                }
                ((IGXDLMSBase)((Object)obj)).load(reader);
                obj = null;
                continue;
            }
            reader.read();
        }
        for (GXDLMSObject it : reader.getObjects()) {
            ((IGXDLMSBase)((Object)it)).postLoad(reader);
        }
        return reader.getObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(String filename, GXXmlWriterSettings settings) throws XMLStreamException, IOException {
        FileOutputStream stream = new FileOutputStream(filename);
        try {
            this.save(stream, settings);
        }
        finally {
            stream.close();
            stream = null;
        }
    }

    private String getObjectName(ObjectType ot) {
        String name = String.valueOf((Object)ot).toLowerCase();
        CharSequence[] tmp = name.split("_");
        for (int pos = 0; pos != tmp.length; ++pos) {
            char[] array = tmp[pos].toCharArray();
            array[0] = Character.toUpperCase(array[0]);
            tmp[pos] = new String(array);
        }
        name = String.join((CharSequence)"", tmp);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(OutputStream stream, GXXmlWriterSettings settings) throws XMLStreamException {
        try (GXXmlWriter writer = new GXXmlWriter(stream, settings);){
            writer.writeStartDocument();
            writer.writeStartElement("Objects");
            int lnVersion = 2;
            for (GXDLMSObject it : this) {
                StringBuilder sb;
                String d;
                if (settings == null || !settings.getOld()) {
                    writer.writeStartElement("GXDLMS" + this.getObjectName(it.getObjectType()));
                } else {
                    writer.writeStartElement("Object", "Type", String.valueOf(it.getObjectType().getValue()), true);
                }
                if (it.getShortName() != 0) {
                    writer.writeElementString("SN", it.getShortName());
                }
                writer.writeElementString("LN", it.getLogicalName());
                if (it.getVersion() != 0) {
                    writer.writeElementString("Version", it.getVersion());
                }
                if ((d = it.getDescription()) != null && d.length() != 0) {
                    writer.writeElementString("Description", d);
                }
                if (lnVersion < 3) {
                    int pos;
                    sb = new StringBuilder();
                    for (pos = 1; pos != it.getAttributeCount() + 1; ++pos) {
                        sb.append(String.valueOf(it.getAccess(pos).getValue()));
                    }
                    writer.writeElementString("Access", sb.toString());
                    sb.setLength(0);
                    for (pos = 1; pos != it.getMethodCount() + 1; ++pos) {
                        sb.append(String.valueOf(it.getMethodAccess(pos).getValue()));
                    }
                    writer.writeElementString("MethodAccess", sb.toString());
                } else {
                    int value;
                    int pos;
                    sb = new StringBuilder();
                    for (pos = 1; pos != it.getAttributeCount() + 1; ++pos) {
                        value = 32768;
                        for (AccessMode3 accessMode3 : it.getAccess3(pos)) {
                            value |= accessMode3.getValue();
                        }
                        sb.append(Integer.toHexString(value));
                    }
                    writer.writeElementString("Access3", sb.toString());
                    sb.setLength(0);
                    for (pos = 1; pos != it.getMethodCount() + 1; ++pos) {
                        value = 32768;
                        for (MethodAccessMode3 methodAccessMode3 : it.getMethodAccess3(pos)) {
                            value |= methodAccessMode3.getValue();
                        }
                        sb.append(Integer.toHexString(value));
                    }
                    writer.writeElementString("MethodAccess3", sb.toString());
                }
                if (settings == null || settings.getValues()) {
                    ((IGXDLMSBase)((Object)it)).save(writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
    }
}

