/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPrimeNbOfdmPlcApplicationsIdentification
extends GXDLMSObject
implements IGXDLMSBase {
    private String firmwareVersion;
    private int vendorId;
    private int productId;

    public GXDLMSPrimeNbOfdmPlcApplicationsIdentification() {
        this("0.0.28.7.0.255", 0);
    }

    public GXDLMSPrimeNbOfdmPlcApplicationsIdentification(String ln) {
        this(ln, 0);
    }

    public GXDLMSPrimeNbOfdmPlcApplicationsIdentification(String ln, int sn) {
        super(ObjectType.PRIME_NB_OFDM_PLC_APPLICATIONS_IDENTIFICATION, ln, sn);
    }

    public final String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public final void setFirmwareVersion(String value) {
        this.firmwareVersion = value;
    }

    public final int getVendorId() {
        return this.vendorId;
    }

    public final void setVendorId(int value) {
        this.vendorId = value;
    }

    public final int getProductId() {
        return this.productId;
    }

    public final void setProductId(int value) {
        this.productId = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.firmwareVersion, this.vendorId, this.productId};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: 
            case 2: {
                return DataType.OCTET_STRING;
            }
            case 3: 
            case 4: {
                return DataType.UINT16;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                if (this.firmwareVersion == null) break;
                return this.firmwareVersion.getBytes();
            }
            case 3: {
                return this.vendorId;
            }
            case 4: {
                return this.productId;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.firmwareVersion = new String((byte[])e.getValue());
                break;
            }
            case 3: {
                this.vendorId = ((Number)e.getValue()).intValue();
                break;
            }
            case 4: {
                this.productId = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.firmwareVersion = reader.readElementContentAsString("FirmwareVersion");
        this.vendorId = reader.readElementContentAsInt("VendorId");
        this.productId = reader.readElementContentAsInt("ProductId");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("FirmwareVersion", this.firmwareVersion);
        writer.writeElementString("VendorId", this.vendorId);
        writer.writeElementString("ProductId", this.productId);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "FirmwareVersion", "VendorId", "ProductId"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

