/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPrimeNbOfdmPlcMacSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private short macMinSwitchSearchTime;
    private short macMaxPromotionPdu;
    private short macPromotionPduTxPeriod;
    private short macBeaconsPerFrame;
    private short macScpMaxTxAttempts;
    private short macCtlReTxTimer;
    private short macMaxCtlReTx;

    public GXDLMSPrimeNbOfdmPlcMacSetup() {
        this("0.0.28.2.0.255", 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacSetup(String ln, int sn) {
        super(ObjectType.PRIME_NB_OFDM_PLC_MAC_SETUP, ln, sn);
    }

    public final short getMacMinSwitchSearchTime() {
        return this.macMinSwitchSearchTime;
    }

    public final void setMacMinSwitchSearchTime(short value) {
        this.macMinSwitchSearchTime = value;
    }

    public final short getMacMaxPromotionPdu() {
        return this.macMaxPromotionPdu;
    }

    public final void setMacMaxPromotionPdu(short value) {
        this.macMaxPromotionPdu = value;
    }

    public final short getMacPromotionPduTxPeriod() {
        return this.macPromotionPduTxPeriod;
    }

    public final void setMacPromotionPduTxPeriod(short value) {
        this.macPromotionPduTxPeriod = value;
    }

    public final short getMacBeaconsPerFrame() {
        return this.macBeaconsPerFrame;
    }

    public final void setMacBeaconsPerFrame(short value) {
        this.macBeaconsPerFrame = value;
    }

    public final short getMacScpMaxTxAttempts() {
        return this.macScpMaxTxAttempts;
    }

    public final void setMacScpMaxTxAttempts(short value) {
        this.macScpMaxTxAttempts = value;
    }

    public final short getMacCtlReTxTimer() {
        return this.macCtlReTxTimer;
    }

    public final void setMacCtlReTxTimer(short value) {
        this.macCtlReTxTimer = value;
    }

    public final short getMacMaxCtlReTx() {
        return this.macMaxCtlReTx;
    }

    public final void setMacMaxCtlReTx(short value) {
        this.macMaxCtlReTx = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.macMinSwitchSearchTime, this.macMaxPromotionPdu, this.macPromotionPduTxPeriod, this.macBeaconsPerFrame, this.macScpMaxTxAttempts, this.macCtlReTxTimer, this.macMaxCtlReTx};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 8;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DataType.UINT8;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.macMinSwitchSearchTime;
            }
            case 3: {
                return this.macMaxPromotionPdu;
            }
            case 4: {
                return this.macPromotionPduTxPeriod;
            }
            case 5: {
                return this.macBeaconsPerFrame;
            }
            case 6: {
                return this.macScpMaxTxAttempts;
            }
            case 7: {
                return this.macCtlReTxTimer;
            }
            case 8: {
                return this.macMaxCtlReTx;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.macMinSwitchSearchTime = ((Number)e.getValue()).shortValue();
                break;
            }
            case 3: {
                this.macMaxPromotionPdu = ((Number)e.getValue()).shortValue();
                break;
            }
            case 4: {
                this.macPromotionPduTxPeriod = ((Number)e.getValue()).shortValue();
                break;
            }
            case 5: {
                this.macBeaconsPerFrame = ((Number)e.getValue()).shortValue();
                break;
            }
            case 6: {
                this.macScpMaxTxAttempts = ((Number)e.getValue()).shortValue();
                break;
            }
            case 7: {
                this.macCtlReTxTimer = ((Number)e.getValue()).shortValue();
                break;
            }
            case 8: {
                this.macMaxCtlReTx = ((Number)e.getValue()).shortValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.macMinSwitchSearchTime = (short)reader.readElementContentAsInt("MacMinSwitchSearchTime");
        this.macMaxPromotionPdu = (short)reader.readElementContentAsInt("MacMaxPromotionPdu");
        this.macPromotionPduTxPeriod = (short)reader.readElementContentAsInt("MacPromotionPduTxPeriod");
        this.macBeaconsPerFrame = (short)reader.readElementContentAsInt("MacBeaconsPerFrame");
        this.macScpMaxTxAttempts = (short)reader.readElementContentAsInt("MacScpMaxTxAttempts");
        this.macCtlReTxTimer = (short)reader.readElementContentAsInt("MacCtlReTxTimer");
        this.macMaxCtlReTx = (short)reader.readElementContentAsInt("MacMaxCtlReTx");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("MacMinSwitchSearchTime", this.macMinSwitchSearchTime);
        writer.writeElementString("MacMaxPromotionPdu", this.macMaxPromotionPdu);
        writer.writeElementString("MacPromotionPduTxPeriod", this.macPromotionPduTxPeriod);
        writer.writeElementString("MacBeaconsPerFrame", this.macBeaconsPerFrame);
        writer.writeElementString("MacScpMaxTxAttempts", this.macScpMaxTxAttempts);
        writer.writeElementString("MacCtlReTxTimer", this.macCtlReTxTimer);
        writer.writeElementString("MacMaxCtlReTx", this.macMaxCtlReTx);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "MacMinSwitchSearchTime", "MacMaxPromotionPdu", "MacPromotionPduTxPeriod", "MacBeaconsPerFrame", "MacScpMaxTxAttempts", "MacCtlReTxTimer", "MacMaxCtlReTx"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

