/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPrimeNbOfdmPlcPhysicalLayerCounters
extends GXDLMSObject
implements IGXDLMSBase {
    private int crcIncorrectCount;
    private int crcFailedCount;
    private int txDropCount;
    private int rxDropCount;

    public GXDLMSPrimeNbOfdmPlcPhysicalLayerCounters() {
        this("0.0.28.1.0.255", 0);
    }

    public GXDLMSPrimeNbOfdmPlcPhysicalLayerCounters(String ln) {
        this(ln, 0);
    }

    public GXDLMSPrimeNbOfdmPlcPhysicalLayerCounters(String ln, int sn) {
        super(ObjectType.PRIME_NB_OFDM_PLC_PHYSICAL_LAYER_COUNTERS, ln, sn);
    }

    public final int crcIncorrectCount() {
        return this.crcIncorrectCount;
    }

    public final void setCrcIncorrectCount(int value) {
        this.crcIncorrectCount = value;
    }

    public final int getCrcFailedCount() {
        return this.crcFailedCount;
    }

    public final void setCrcFailedCount(int value) {
        this.crcFailedCount = value;
    }

    public final int getTxDropCount() {
        return this.txDropCount;
    }

    public final void setTxDropCount(int value) {
        this.txDropCount = value;
    }

    public final int getRxDropCount() {
        return this.rxDropCount;
    }

    public final void setRxDropCount(int value) {
        this.rxDropCount = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.crcIncorrectCount, this.crcFailedCount, this.txDropCount, this.rxDropCount};
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.rxDropCount = 0;
            this.txDropCount = 0;
            this.crcFailedCount = 0;
            this.crcIncorrectCount = 0;
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 5;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return DataType.UINT16;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.crcIncorrectCount;
            }
            case 3: {
                return this.crcFailedCount;
            }
            case 4: {
                return this.txDropCount;
            }
            case 5: {
                return this.rxDropCount;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.crcIncorrectCount = ((Number)e.getValue()).intValue();
                break;
            }
            case 3: {
                this.crcFailedCount = ((Number)e.getValue()).intValue();
                break;
            }
            case 4: {
                this.txDropCount = ((Number)e.getValue()).intValue();
                break;
            }
            case 5: {
                this.rxDropCount = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.crcIncorrectCount = reader.readElementContentAsInt("CrcIncorrectCount");
        this.crcFailedCount = reader.readElementContentAsInt("CrcFailedCount");
        this.txDropCount = reader.readElementContentAsInt("TxDropCount");
        this.rxDropCount = reader.readElementContentAsInt("RxDropCount");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("CrcIncorrectCount", this.crcIncorrectCount);
        writer.writeElementString("CrcFailedCount", this.crcFailedCount);
        writer.writeElementString("TxDropCount", this.txDropCount);
        writer.writeElementString("RxDropCount", this.rxDropCount);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "CrcIncorrectCount", "CrcFailedCount", "TxDropCount", "RxDropCount"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset"};
    }
}

