/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.MessageType;
import gurux.dlms.objects.enums.ServiceType;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPushSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private ServiceType service;
    private String destination;
    private MessageType message;
    private List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> pushObjectList = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
    private List<Map.Entry<GXDateTime, GXDateTime>> communicationWindow = new ArrayList<Map.Entry<GXDateTime, GXDateTime>>();
    private int randomisationStartInterval;
    private int numberOfRetries;
    private int repetitionDelay;

    public GXDLMSPushSetup() {
        this("0.7.25.9.0.255");
    }

    public GXDLMSPushSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSPushSetup(String ln, int sn) {
        super(ObjectType.PUSH_SETUP, ln, sn);
        this.service = ServiceType.TCP;
        this.message = MessageType.COSEM_APDU;
    }

    public final ServiceType getService() {
        return this.service;
    }

    public final void setService(ServiceType value) {
        this.service = value;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final void setDestination(String value) {
        this.destination = value;
    }

    public final MessageType getMessage() {
        return this.message;
    }

    public final void setMessage(MessageType value) {
        this.message = value;
    }

    public final List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> getPushObjectList() {
        return this.pushObjectList;
    }

    public final List<Map.Entry<GXDateTime, GXDateTime>> getCommunicationWindow() {
        return this.communicationWindow;
    }

    public final int getRandomisationStartInterval() {
        return this.randomisationStartInterval;
    }

    public final void setRandomisationStartInterval(int value) {
        this.randomisationStartInterval = value;
    }

    public final int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public final void setNumberOfRetries(byte value) {
        this.numberOfRetries = value;
    }

    public final int getRepetitionDelay() {
        return this.repetitionDelay;
    }

    public final void setRepetitionDelay(int value) {
        this.repetitionDelay = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.pushObjectList, (Object)((Object)this.service) + " " + this.destination + " " + (Object)((Object)this.message), this.communicationWindow, this.randomisationStartInterval, this.numberOfRetries, this.repetitionDelay};
    }

    public void getPushValues(GXDLMSClient client, List<?> values) {
        if (values.size() != this.pushObjectList.size()) {
            throw new IllegalArgumentException("Size of the push object list is different than values.");
        }
        int pos = 0;
        ArrayList<GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>> objects = new ArrayList<GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>>();
        for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.pushObjectList) {
            GXDLMSObject obj = it.getKey();
            objects.add(new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, new GXDLMSCaptureObject(it.getValue().getAttributeIndex(), it.getValue().getDataIndex())));
            if (it.getValue().getAttributeIndex() == 0) {
                List tmp = (List)values.get(pos);
                for (int index = 1; index <= it.getKey().getAttributeCount(); ++index) {
                    client.updateValue(it.getKey(), index, tmp.get(index - 1));
                }
            } else {
                client.updateValue(obj, it.getValue().getAttributeIndex(), values.get(pos));
            }
            ++pos;
        }
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() != 1) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    public final byte[][] activate(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 1, 0, DataType.INT8);
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 7;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        if (index == 3) {
            return DataType.STRUCTURE;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        if (index == 5) {
            return DataType.UINT16;
        }
        if (index == 6) {
            return DataType.UINT8;
        }
        if (index == 7) {
            return DataType.UINT16;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        GXByteBuffer buff = new GXByteBuffer();
        if (e.getIndex() == 2) {
            buff.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(this.pushObjectList.size(), buff);
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.pushObjectList) {
                buff.setUInt8(DataType.STRUCTURE.getValue());
                buff.setUInt8(4);
                GXCommon.setData(settings, buff, DataType.UINT16, it.getKey().getObjectType().getValue());
                GXCommon.setData(settings, buff, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getKey().getLogicalName()));
                GXCommon.setData(settings, buff, DataType.INT8, it.getValue().getAttributeIndex());
                GXCommon.setData(settings, buff, DataType.UINT16, it.getValue().getDataIndex());
            }
            return buff.array();
        }
        if (e.getIndex() == 3) {
            buff.setUInt8(DataType.STRUCTURE.getValue());
            buff.setUInt8(3);
            GXCommon.setData(settings, buff, DataType.ENUM, this.getService().getValue());
            byte[] tmp = null;
            if (GXCommon.isHexString(this.destination)) {
                tmp = GXCommon.hexToBytes(this.destination);
            } else if (this.destination != null) {
                tmp = this.getDestination().getBytes();
            }
            GXCommon.setData(settings, buff, DataType.OCTET_STRING, tmp);
            GXCommon.setData(settings, buff, DataType.ENUM, this.getMessage().getValue());
            return buff.array();
        }
        if (e.getIndex() == 4) {
            buff.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(this.communicationWindow.size(), buff);
            for (Map.Entry<GXDateTime, GXDateTime> it : this.communicationWindow) {
                buff.setUInt8(DataType.STRUCTURE.getValue());
                buff.setUInt8(2);
                GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getKey());
                GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getValue());
            }
            return buff.array();
        }
        if (e.getIndex() == 5) {
            return this.randomisationStartInterval;
        }
        if (e.getIndex() == 6) {
            return this.numberOfRetries;
        }
        if (e.getIndex() == 7) {
            return this.repetitionDelay;
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.pushObjectList.clear();
            if (e.getValue() instanceof List) {
                for (Object it : (List)e.getValue()) {
                    List tmp = (List)it;
                    ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
                    String ln = GXCommon.toLogicalName(tmp.get(1));
                    GXDLMSObject obj = settings.getObjects().findByLN(type, ln);
                    if (obj == null) {
                        obj = GXDLMSClient.createObject(type);
                        obj.setLogicalName(ln);
                    }
                    GXDLMSCaptureObject co = new GXDLMSCaptureObject();
                    co.setAttributeIndex(((Number)tmp.get(2)).intValue());
                    co.setDataIndex(((Number)tmp.get(3)).intValue());
                    GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject> ent = new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, co);
                    this.pushObjectList.add(ent);
                }
            }
        } else if (e.getIndex() == 3) {
            List tmp = (List)e.getValue();
            if (tmp != null) {
                this.setService(ServiceType.forValue(((Number)tmp.get(0)).intValue()));
                byte[] tmp2 = (byte[])tmp.get(1);
                if (GXByteBuffer.isAsciiString(tmp2)) {
                    this.setDestination(new String(tmp2));
                } else {
                    this.setDestination(GXCommon.toHex(tmp2, false));
                }
                this.setMessage(MessageType.forValue(((Number)tmp.get(2)).intValue()));
            }
        } else if (e.getIndex() == 4) {
            this.communicationWindow.clear();
            if (e.getValue() instanceof List) {
                for (Object it : (List)e.getValue()) {
                    List tmp = (List)it;
                    GXDateTime start = (GXDateTime)GXDLMSClient.changeType((byte[])tmp.get(0), DataType.DATETIME, e.getSettings());
                    GXDateTime end = (GXDateTime)GXDLMSClient.changeType((byte[])tmp.get(1), DataType.DATETIME, e.getSettings());
                    this.communicationWindow.add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
                }
            }
        } else if (e.getIndex() == 5) {
            this.randomisationStartInterval = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 6) {
            this.numberOfRetries = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 7) {
            this.repetitionDelay = ((Number)e.getValue()).intValue();
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.pushObjectList.clear();
        if (reader.isStartElement("ObjectList", true)) {
            while (reader.isStartElement("Item", true)) {
                ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
                String ln = reader.readElementContentAsString("LN");
                int ai = reader.readElementContentAsInt("AI");
                int di = reader.readElementContentAsInt("DI");
                reader.readEndElement("ObjectList");
                GXDLMSCaptureObject co = new GXDLMSCaptureObject(ai, di);
                GXDLMSObject obj = reader.getObjects().findByLN(ot, ln);
                if (obj == null) {
                    obj = GXDLMSClient.createObject(ot);
                    obj.setLogicalName(ln);
                }
                this.pushObjectList.add(new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, co));
            }
            reader.readEndElement("ObjectList");
        }
        this.service = ServiceType.forValue(reader.readElementContentAsInt("Service"));
        this.destination = reader.readElementContentAsString("Destination");
        this.message = MessageType.forValue(reader.readElementContentAsInt("Message"));
        this.communicationWindow.clear();
        if (reader.isStartElement("CommunicationWindow", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDateTime start = reader.readElementContentAsDateTime("Start");
                GXDateTime end = reader.readElementContentAsDateTime("End");
                this.communicationWindow.add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
            }
            reader.readEndElement("CommunicationWindow");
        }
        this.randomisationStartInterval = reader.readElementContentAsInt("RandomisationStartInterval");
        this.numberOfRetries = reader.readElementContentAsInt("NumberOfRetries");
        this.repetitionDelay = reader.readElementContentAsInt("RepetitionDelay");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.pushObjectList != null) {
            writer.writeStartElement("ObjectList");
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> entry : this.pushObjectList) {
                writer.writeStartElement("Item");
                writer.writeElementString("ObjectType", entry.getKey().getObjectType().getValue());
                writer.writeElementString("LN", entry.getKey().getLogicalName());
                writer.writeElementString("AI", entry.getValue().getAttributeIndex());
                writer.writeElementString("DI", entry.getValue().getDataIndex());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.service != null) {
            writer.writeElementString("Service", this.service.getValue());
        }
        writer.writeElementString("Destination", this.destination);
        if (this.message != null) {
            writer.writeElementString("Message", this.message.getValue());
        }
        if (this.communicationWindow != null) {
            writer.writeStartElement("CommunicationWindow");
            for (Map.Entry<Object, Object> entry : this.communicationWindow) {
                writer.writeStartElement("Item");
                writer.writeElementString("Start", (GXDateTime)entry.getKey());
                writer.writeElementString("End", (GXDateTime)entry.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("RandomisationStartInterval", this.randomisationStartInterval);
        writer.writeElementString("NumberOfRetries", this.numberOfRetries);
        writer.writeElementString("RepetitionDelay", this.repetitionDelay);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Object List", "Send Destination And Method", "Communication Window", "Randomisation Start Interval", "Number Of Retries", "Repetition Delay"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Push"};
    }
}

