/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectDefinition;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class GXDLMSRegisterActivation
extends GXDLMSObject
implements IGXDLMSBase {
    private List<GXDLMSObjectDefinition> registerAssignment = new ArrayList<GXDLMSObjectDefinition>();
    private List<Map.Entry<byte[], byte[]>> maskList = new ArrayList<Map.Entry<byte[], byte[]>>();
    private byte[] activeMask;

    public GXDLMSRegisterActivation() {
        super(ObjectType.REGISTER_ACTIVATION);
    }

    public GXDLMSRegisterActivation(String ln) {
        super(ObjectType.REGISTER_ACTIVATION, ln, 0);
    }

    public GXDLMSRegisterActivation(String ln, int sn) {
        super(ObjectType.REGISTER_ACTIVATION, ln, sn);
    }

    public final List<GXDLMSObjectDefinition> getRegisterAssignment() {
        return this.registerAssignment;
    }

    public final List<Map.Entry<byte[], byte[]>> getMaskList() {
        return this.maskList;
    }

    public final byte[] getActiveMask() {
        return this.activeMask;
    }

    public final void setActiveMask(byte[] value) {
        this.activeMask = value;
    }

    final void addRegister(GXDLMSObjectDefinition item) {
        this.registerAssignment.add(item);
    }

    void addMask() {
    }

    void deleteMask() {
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getRegisterAssignment(), this.getMaskList(), this.getActiveMask()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 3;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.OCTET_STRING;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            data.setUInt8(this.getRegisterAssignment().size());
            for (GXDLMSObjectDefinition it : this.getRegisterAssignment()) {
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(2);
                GXCommon.setData(settings, data, DataType.UINT16, it.getObjectType().getValue());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getLogicalName()));
            }
            return data.array();
        }
        if (e.getIndex() == 3) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            data.setUInt8(this.maskList.size());
            for (Map.Entry<byte[], byte[]> it : this.maskList) {
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(2);
                GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getKey());
                data.setUInt8(DataType.ARRAY.getValue());
                data.setUInt8(it.getValue().length);
                for (byte b : it.getValue()) {
                    GXCommon.setData(settings, data, DataType.UINT8, b);
                }
            }
            return data.array();
        }
        if (e.getIndex() == 4) {
            return this.getActiveMask();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.registerAssignment.clear();
            if (e.getValue() != null) {
                for (Object it : (List)e.getValue()) {
                    GXDLMSObjectDefinition item = new GXDLMSObjectDefinition();
                    item.setObjectType(ObjectType.forValue(((Number)((List)it).get(0)).intValue()));
                    item.setLogicalName(GXCommon.toLogicalName((byte[])((List)it).get(1)));
                    this.registerAssignment.add(item);
                }
            }
        } else if (e.getIndex() == 3) {
            this.maskList.clear();
            if (e.getValue() != null) {
                for (Object it : (List)e.getValue()) {
                    byte[] key = (byte[])((List)it).get(0);
                    List arr = (List)((List)it).get(1);
                    byte[] tmp = new byte[arr.size()];
                    for (int pos = 0; pos != tmp.length; ++pos) {
                        tmp[pos] = ((Number)arr.get(pos)).byteValue();
                    }
                    this.maskList.add(new GXSimpleEntry<byte[], byte[]>(key, tmp));
                }
            }
        } else if (e.getIndex() == 4) {
            if (e.getValue() == null) {
                this.setActiveMask(null);
            } else {
                this.setActiveMask((byte[])e.getValue());
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.registerAssignment.clear();
        if (reader.isStartElement("RegisterAssignment", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSObjectDefinition it = new GXDLMSObjectDefinition();
                it.setObjectType(ObjectType.forValue(reader.readElementContentAsInt("ObjectType")));
                it.setLogicalName(reader.readElementContentAsString("LN"));
                this.registerAssignment.add(it);
            }
            reader.readEndElement("RegisterAssignment");
        }
        this.maskList.clear();
        if (reader.isStartElement("MaskList", true)) {
            while (reader.isStartElement("Item", true)) {
                byte[] mask = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Mask"));
                byte[] i = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Index"));
                this.maskList.add(new GXSimpleEntry<byte[], byte[]>(mask, i));
            }
            reader.readEndElement("MaskList");
        }
        this.activeMask = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("ActiveMask"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.registerAssignment != null) {
            writer.writeStartElement("RegisterAssignment");
            for (GXDLMSObjectDefinition gXDLMSObjectDefinition : this.registerAssignment) {
                writer.writeStartElement("Item");
                writer.writeElementString("ObjectType", gXDLMSObjectDefinition.getObjectType().getValue());
                writer.writeElementString("LN", gXDLMSObjectDefinition.getLogicalName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.maskList != null) {
            writer.writeStartElement("MaskList");
            for (Map.Entry entry : this.maskList) {
                writer.writeStartElement("Item");
                writer.writeElementString("Mask", GXDLMSTranslator.toHex((byte[])entry.getKey()));
                writer.writeElementString("Index", GXDLMSTranslator.toHex((byte[])entry.getValue()).replace(" ", ";"));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.activeMask != null) {
            writer.writeElementString("ActiveMask", GXDLMSTranslator.toHex(this.activeMask));
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Register Assignment", "Mask List", "Active Mask"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Add register", "Add mask", "Delete mask"};
    }
}

