/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSScript;
import gurux.dlms.objects.GXDLMSScriptAction;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ScriptActionType;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSScriptTable
extends GXDLMSObject
implements IGXDLMSBase {
    private List<GXDLMSScript> scripts = new ArrayList<GXDLMSScript>();

    public GXDLMSScriptTable() {
        this(null, 0);
    }

    public GXDLMSScriptTable(String ln) {
        this(ln, 0);
    }

    public GXDLMSScriptTable(String ln, int sn) {
        super(ObjectType.SCRIPT_TABLE, ln, sn);
    }

    public final List<GXDLMSScript> getScripts() {
        return this.scripts;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getScripts()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            int cnt = this.scripts.size();
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(cnt, data);
            for (GXDLMSScript it : this.scripts) {
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(2);
                GXCommon.setData(settings, data, DataType.UINT16, it.getId());
                data.setUInt8(DataType.ARRAY.getValue());
                data.setUInt8(it.getActions().size());
                for (GXDLMSScriptAction a : it.getActions()) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(5);
                    GXCommon.setData(settings, data, DataType.ENUM, a.getType().ordinal());
                    if (a.getTarget() == null) {
                        GXCommon.setData(settings, data, DataType.UINT16, a.getObjectType().getValue());
                        GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(a.getLogicalName()));
                    } else {
                        GXCommon.setData(settings, data, DataType.UINT16, a.getTarget().getObjectType().getValue());
                        GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(a.getTarget().getLogicalName()));
                    }
                    GXCommon.setData(settings, data, DataType.INT8, a.getIndex());
                    GXCommon.setData(settings, data, a.getParameterType(), a.getParameter());
                }
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.scripts.clear();
            if (e.getValue() instanceof List && !((List)e.getValue()).isEmpty()) {
                if (((List)e.getValue()).get(0) instanceof List) {
                    for (Object item : (List)e.getValue()) {
                        GXDLMSScript script = new GXDLMSScript();
                        script.setId(((Number)((List)item).get(0)).intValue());
                        this.scripts.add(script);
                        for (Object tmp : (List)((List)item).get(1)) {
                            List arr = (List)tmp;
                            GXDLMSScriptAction it = new GXDLMSScriptAction();
                            int val = ((Number)arr.get(0)).intValue();
                            ScriptActionType type = ScriptActionType.NONE;
                            if (val > 0) {
                                type = ScriptActionType.values()[val];
                            }
                            it.setType(type);
                            ObjectType ot = ObjectType.forValue(((Number)arr.get(1)).intValue());
                            String ln = GXCommon.toLogicalName((byte[])arr.get(2));
                            GXDLMSObject t = settings.getObjects().findByLN(ot, ln);
                            if (t == null) {
                                t = GXDLMSClient.createObject(ot);
                                t.setLogicalName(ln);
                            }
                            it.setTarget(t);
                            it.setIndex(((Number)arr.get(3)).intValue());
                            Object param = arr.get(4);
                            it.setParameter(param, GXDLMSConverter.getDLMSDataType(param));
                            script.getActions().add(it);
                        }
                    }
                } else {
                    GXDLMSScript script = new GXDLMSScript();
                    script.setId(((Number)((List)e.getValue()).get(0)).intValue());
                    List arr = (List)((List)e.getValue()).get(1);
                    GXDLMSScriptAction it = new GXDLMSScriptAction();
                    ScriptActionType type = ScriptActionType.values()[((Number)arr.get(0)).intValue() - 1];
                    it.setType(type);
                    ObjectType ot = ObjectType.forValue(((Number)arr.get(1)).intValue());
                    String ln = GXCommon.toLogicalName((byte[])arr.get(2));
                    GXDLMSObject t = settings.getObjects().findByLN(ot, ln);
                    if (t == null) {
                        t = GXDLMSClient.createObject(ot);
                        t.setLogicalName(ln);
                    }
                    it.setTarget(t);
                    it.setIndex(((Number)arr.get(3)).intValue());
                    it.setParameter(arr.get(4), DataType.NONE);
                    script.getActions().add(it);
                }
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    public final byte[][] execute(GXDLMSClient client, GXDLMSScript script) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, script.getId(), DataType.UINT16);
    }

    public final byte[][] execute(GXDLMSClient client, int scriptId) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, scriptId, DataType.UINT16);
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.scripts.clear();
        if (reader.isStartElement("Scripts", true)) {
            while (reader.isStartElement("Script", true)) {
                GXDLMSScript it = new GXDLMSScript();
                this.scripts.add(it);
                it.setId(reader.readElementContentAsInt("ID"));
                if (!reader.isStartElement("Actions", true)) continue;
                while (reader.isStartElement("Action", true)) {
                    GXDLMSScriptAction a = new GXDLMSScriptAction();
                    a.setType(ScriptActionType.values()[reader.readElementContentAsInt("Type")]);
                    ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
                    String ln = reader.readElementContentAsString("LN");
                    GXDLMSObject t = reader.getObjects().findByLN(ot, ln);
                    if (t == null) {
                        t = GXDLMSClient.createObject(ot);
                        t.setLogicalName(ln);
                    }
                    a.setTarget(t);
                    a.setIndex(reader.readElementContentAsInt("Index"));
                    DataType dt2 = DataType.forValue(reader.readElementContentAsInt("ParameterDataType"));
                    a.setParameter(reader.readElementContentAsObject("Parameter", null, null, 0), dt2);
                    it.getActions().add(a);
                }
                reader.readEndElement("Actions");
            }
            reader.readEndElement("Scripts");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.scripts != null) {
            writer.writeStartElement("Scripts");
            for (GXDLMSScript it : this.scripts) {
                writer.writeStartElement("Script");
                writer.writeElementString("ID", it.getId());
                writer.writeStartElement("Actions");
                for (GXDLMSScriptAction a : it.getActions()) {
                    writer.writeStartElement("Action");
                    writer.writeElementString("Type", a.getType().ordinal());
                    if (a.getTarget() == null) {
                        writer.writeElementString("ObjectType", ObjectType.NONE.getValue());
                        writer.writeElementString("LN", "0.0.0.0.0.0");
                        writer.writeElementString("Index", "0");
                        writer.writeElementString("ParameterDataType", DataType.NONE.getValue());
                        writer.writeElementObject("Parameter", "");
                    } else {
                        writer.writeElementString("ObjectType", a.getTarget().getObjectType().getValue());
                        writer.writeElementString("LN", a.getTarget().getLogicalName());
                        writer.writeElementString("Index", a.getIndex());
                        writer.writeElementString("ParameterDataType", a.getParameterType().getValue());
                        writer.writeElementObject("Parameter", a.getParameter());
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Scripts"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Execute"};
    }
}

