/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects.enums;

import java.util.HashMap;

public enum AccountStatus {
    NEW_INACTIVE_ACCOUNT(1),
    ACTIVE(2),
    CLOSED(3);

    private int intValue;
    private static HashMap<Integer, AccountStatus> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, AccountStatus> getMappings() {
        Class<AccountStatus> clazz = AccountStatus.class;
        synchronized (AccountStatus.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private AccountStatus(int value) {
        this.intValue = value;
        AccountStatus.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static AccountStatus forValue(int value) {
        AccountStatus ret = AccountStatus.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid account status enum value.");
        }
        return ret;
    }
}

