/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects.enums;

import java.util.HashMap;

public enum ServiceType {
    TCP(0),
    UDP(1),
    FTP(2),
    SMTP(3),
    SMS(4),
    HDLC(5),
    M_BUS(6),
    ZIGBEE(7);

    private int intValue;
    private static HashMap<Integer, ServiceType> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, ServiceType> getMappings() {
        if (mappings != null) return mappings;
        Class<ServiceType> clazz = ServiceType.class;
        synchronized (ServiceType.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private ServiceType(int value) {
        this.intValue = value;
        ServiceType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static ServiceType forValue(int value) {
        ServiceType ret = ServiceType.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid service type enum value.");
        }
        return ret;
    }
}

