/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.secure;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.secure.GXCiphering;
import gurux.dlms.secure.GXSecure;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class GXDLMSSecureClient
extends GXDLMSClient {
    private GXCiphering ciphering = new GXCiphering("ABCDEFGH".getBytes());

    public GXDLMSSecureClient() {
        this(false);
    }

    public GXDLMSSecureClient(boolean useLogicalNameReferencing) {
        this(useLogicalNameReferencing, 16, 1, Authentication.NONE, null, InterfaceType.HDLC);
    }

    public GXDLMSSecureClient(boolean useLogicalNameReferencing, int clientAddress, int serverAddress, Authentication forAuthentication, String password, InterfaceType interfaceType) {
        super(useLogicalNameReferencing, clientAddress, serverAddress, forAuthentication, password, interfaceType);
        this.setCipher(this.ciphering);
    }

    public final GXCiphering getCiphering() {
        return this.ciphering;
    }

    public static byte[] encrypt(byte[] kek, byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return GXSecure.encryptAesKeyWrapping(data, kek);
    }

    public static byte[] decrypt(byte[] kek, byte[] data) {
        if (kek == null) {
            throw new NullPointerException("Key Encrypting Key");
        }
        if (kek.length < 16) {
            throw new IllegalArgumentException("Key Encrypting Key");
        }
        if (kek.length % 8 != 0) {
            throw new IllegalArgumentException("Key Encrypting Key");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length < 16) {
            throw new IllegalArgumentException("data");
        }
        if (data.length % 8 != 0) {
            throw new IllegalArgumentException("data");
        }
        try {
            return GXSecure.decryptAesKeyWrapping(data, kek);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public byte[] getServerSystemTitle() {
        return this.getSettings().getPreEstablishedSystemTitle();
    }

    public void setServerSystemTitle(byte[] value) {
        this.getSettings().setPreEstablishedSystemTitle(value);
    }
}

