/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.secure;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXCryptoKeyParameter;
import gurux.dlms.GXDLMSExceptionResponse;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXICipher;
import gurux.dlms.asn.GXAsn1BitString;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1Integer;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.CryptoKeyType;
import gurux.dlms.enums.ExceptionServiceError;
import gurux.dlms.enums.ExceptionStateError;
import gurux.dlms.enums.KeyAgreementScheme;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.Signing;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.enums.CertificateType;
import gurux.dlms.objects.enums.SecurityPolicy;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.secure.AesGcmParameter;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class GXSecure {
    private static final byte[] IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private static final Logger LOGGER = Logger.getLogger(GXSecure.class.getName());

    private GXSecure() {
    }

    private static int getBlocklength(byte[] data) {
        if (data.length % 16 == 0) {
            return data.length;
        }
        return data.length + (16 - data.length % 16);
    }

    static byte[] aes1Encrypt(byte[] data, byte[] secret) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        byte[] d = new byte[GXSecure.getBlocklength(data)];
        byte[] s = new byte[16];
        System.arraycopy(data, 0, d, 0, data.length);
        System.arraycopy(secret, 0, s, 0, secret.length);
        IvParameterSpec ivspec = new IvParameterSpec(new byte[16]);
        SecretKeySpec keyToBeWrapped2 = new SecretKeySpec(s, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(1, (Key)keyToBeWrapped2, ivspec);
        return cipher.doFinal(d);
    }

    static byte[] aes1Decrypt(byte[] data, byte[] secret) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        byte[] d = new byte[GXSecure.getBlocklength(data)];
        byte[] s = new byte[16];
        System.arraycopy(data, 0, d, 0, data.length);
        System.arraycopy(secret, 0, s, 0, secret.length);
        IvParameterSpec ivspec = new IvParameterSpec(new byte[16]);
        SecretKeySpec keyToBeWrapped2 = new SecretKeySpec(s, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(2, (Key)keyToBeWrapped2, ivspec);
        return cipher.doFinal(d);
    }

    static byte[] encryptAesKeyWrapping(byte[] data, byte[] kek) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        if (kek == null || kek.length % 8 != 0) {
            throw new IllegalArgumentException("Key Encrypting Key");
        }
        int n = data.length / 8;
        if (n * 8 != data.length) {
            throw new IllegalArgumentException("Invalid data.");
        }
        byte[] block = new byte[data.length + IV.length];
        byte[] buf = new byte[8 + IV.length];
        System.arraycopy(IV, 0, block, 0, IV.length);
        System.arraycopy(data, 0, block, IV.length, data.length);
        SecretKeySpec keyToBeWrapped2 = new SecretKeySpec(kek, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, keyToBeWrapped2);
        for (int j = 0; j != 6; ++j) {
            for (int i = 1; i <= n; ++i) {
                System.arraycopy(block, 0, buf, 0, IV.length);
                System.arraycopy(block, 8 * i, buf, IV.length, 8);
                buf = cipher.doFinal(buf);
                int t = n * j + i;
                int k = 1;
                while (t != 0) {
                    byte v = (byte)t;
                    int n2 = IV.length - k;
                    buf[n2] = (byte)(buf[n2] ^ v);
                    t >>= 8;
                    ++k;
                }
                System.arraycopy(buf, 0, block, 0, 8);
                System.arraycopy(buf, 8, block, 8 * i, 8);
            }
        }
        return block;
    }

    static byte[] decryptAesKeyWrapping(byte[] input, byte[] kek) {
        if (kek == null || kek.length % 8 != 0) {
            throw new IllegalArgumentException("Key Encrypting Key");
        }
        int n = input.length / 8;
        if (n * 8 != input.length) {
            throw new IllegalArgumentException("Invalid data.");
        }
        byte[] block = input.length > IV.length ? new byte[input.length - IV.length] : new byte[IV.length];
        byte[] a = new byte[IV.length];
        byte[] buf = new byte[8 + IV.length];
        System.arraycopy(input, 0, a, 0, IV.length);
        System.arraycopy(input, 0 + IV.length, block, 0, input.length - IV.length);
        if (--n == 0) {
            n = 1;
        }
        try {
            SecretKeySpec keyToBeWrapped2 = new SecretKeySpec(kek, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, keyToBeWrapped2);
            for (int j = 5; j >= 0; --j) {
                for (int i = n; i >= 1; --i) {
                    System.arraycopy(a, 0, buf, 0, IV.length);
                    System.arraycopy(block, 8 * (i - 1), buf, IV.length, 8);
                    int t = n * j + i;
                    int k = 1;
                    while (t != 0) {
                        byte v = (byte)t;
                        int n2 = IV.length - k;
                        buf[n2] = (byte)(buf[n2] ^ v);
                        t >>= 8;
                        ++k;
                    }
                    buf = cipher.doFinal(buf);
                    System.arraycopy(buf, 0, a, 0, 8);
                    System.arraycopy(buf, 8, block, 8 * (i - 1), 8);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        if (!GXCommon.compare(a, IV)) {
            throw new ArithmeticException("AES key wrapping failed.");
        }
        return block;
    }

    public static byte[] secure(GXDLMSSettings settings, GXICipher cipher, long ic, byte[] data, byte[] secret) throws InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        try {
            if (settings.getAuthentication() == Authentication.HIGH) {
                return GXSecure.aes1Encrypt(data, secret);
            }
            GXByteBuffer challenge = new GXByteBuffer();
            if (settings.getAuthentication() == Authentication.HIGH_GMAC) {
                challenge.set(data);
            } else if (settings.getAuthentication() == Authentication.HIGH_SHA256) {
                challenge.set(secret);
            } else {
                challenge.set(data);
                challenge.set(secret);
            }
            byte[] d = challenge.array();
            switch (settings.getAuthentication()) {
                case HIGH_MD5: {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    d = md.digest(d);
                    break;
                }
                case HIGH_SHA1: {
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    d = md.digest(d);
                    break;
                }
                case HIGH_SHA256: {
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    d = md.digest(d);
                    break;
                }
                case HIGH_GMAC: {
                    AesGcmParameter p = new AesGcmParameter(settings, 0, Security.AUTHENTICATION, cipher.getSecuritySuite(), ic, secret, cipher.getBlockCipherKey(), cipher.getAuthenticationKey());
                    p.setType(1);
                    challenge.clear();
                    challenge.setUInt8(Security.AUTHENTICATION.getValue() | settings.getCipher().getSecuritySuite().getValue());
                    challenge.setUInt32(p.getInvocationCounter());
                    challenge.set(GXSecure.encryptAesGcm(true, p, d));
                    d = challenge.array();
                    break;
                }
                case HIGH_ECDSA: {
                    Signature sig;
                    if (settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_1) {
                        sig = Signature.getInstance("SHA256withECDSA");
                    } else if (settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_2) {
                        sig = Signature.getInstance("SHA384withECDSA");
                    } else {
                        throw new IllegalArgumentException("Invalid security suite.");
                    }
                    if (cipher.getSigningKeyPair() == null) {
                        throw new IllegalArgumentException("SigningKeyPair is empty.");
                    }
                    sig.initSign(cipher.getSigningKeyPair().getPrivate());
                    sig.update(secret);
                    d = sig.sign();
                    GXAsn1Sequence seq = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(d);
                    GXByteBuffer bb = new GXByteBuffer();
                    bb.set(((GXAsn1Integer)seq.get(0)).getByteArray());
                    if (settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_1) {
                        if (bb.size() != 32) {
                            bb.move(1, 0, 32);
                        }
                        bb.set(((GXAsn1Integer)seq.get(1)).getByteArray());
                        if (bb.size() != 64) {
                            bb.move(33, 32, 32);
                        }
                    } else {
                        if (bb.size() != 48) {
                            bb.move(1, 0, 48);
                        }
                        bb.set(((GXAsn1Integer)seq.get(1)).getByteArray());
                        if (bb.size() != 96) {
                            bb.move(49, 48, 48);
                        }
                    }
                    d = bb.array();
                    break;
                }
            }
            return d;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static byte[] generateChallenge(Authentication authentication, byte size) {
        Random r = new Random();
        int len = size;
        if (size == 0 || size == 16 && authentication == Authentication.HIGH_ECDSA) {
            len = authentication == Authentication.HIGH_ECDSA ? r.nextInt(32) + 32 : r.nextInt(57) + 8;
        }
        byte[] result = new byte[len];
        for (int pos = 0; pos != len; ++pos) {
            result[pos] = (byte)r.nextInt(122);
        }
        return result;
    }

    public static byte[] generateKDF(String hashAlg, byte[] z, int keyDataLen, byte[] algorithmID, byte[] partyUInfo, byte[] partyVInfo, byte[] suppPubInfo, byte[] suppPrivInfo) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.set(algorithmID);
        bb.set(partyUInfo);
        bb.set(partyVInfo);
        if (suppPubInfo != null) {
            bb.set(suppPubInfo);
        }
        if (suppPrivInfo != null) {
            bb.set(suppPrivInfo);
        }
        return GXSecure.generateKDF(hashAlg, z, keyDataLen, bb.array());
    }

    private static byte[] generateKDF(String hashAlg, byte[] z, int keyDataLen, byte[] otherInfo) {
        byte[] key = new byte[keyDataLen / 8];
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlg);
            int hashLen = md.getDigestLength();
            int cnt = key.length / hashLen;
            byte[] v = new byte[4];
            for (int pos = 1; pos <= cnt; ++pos) {
                md.reset();
                GXSecure.getBytes(v, pos);
                md.update(v);
                md.update(z);
                md.update(otherInfo);
                byte[] hash = md.digest();
                if (pos < cnt) {
                    System.arraycopy(hash, 0, key, hashLen * (pos - 1), hashLen);
                    continue;
                }
                if (key.length % hashLen == 0) {
                    System.arraycopy(hash, 0, key, hashLen * (pos - 1), hashLen);
                    continue;
                }
                System.arraycopy(hash, 0, key, hashLen * (pos - 1), key.length % hashLen);
            }
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void getBytes(byte[] buff, int value) {
        buff[0] = (byte)(value >>> 24);
        buff[1] = (byte)(value >>> 16 & 0xFF);
        buff[2] = (byte)(value >>> 8 & 0xFF);
        buff[3] = (byte)(value & 0xFF);
    }

    public static byte[] getEphemeralPublicKeyData(int keyId, PublicKey ephemeralKey) {
        GXAsn1BitString tmp = (GXAsn1BitString)((GXAsn1Sequence)GXAsn1Converter.fromByteArray(ephemeralKey.getEncoded())).get(1);
        GXByteBuffer epk = new GXByteBuffer(tmp.getValue());
        epk.getData()[0] = (byte)keyId;
        return epk.array();
    }

    public static byte[] getEphemeralPublicKeySignature(int keyId, PublicKey ephemeralKey, PrivateKey signKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] epk = GXSecure.getEphemeralPublicKeyData(keyId, ephemeralKey);
        Signature instance = Signature.getInstance("SHA256withECDSA");
        instance.initSign(signKey);
        instance.update(epk);
        byte[] sign = instance.sign();
        GXAsn1Sequence tmp2 = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(sign);
        LOGGER.log(Level.FINEST, "{0}", GXCommon.toHex(sign));
        GXByteBuffer data = new GXByteBuffer(64);
        byte[] arr = ((GXAsn1Integer)tmp2.get(0)).getByteArray();
        if (arr.length < 32) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.size(32 - arr.length);
            bb.set(arr);
            arr = bb.array();
        }
        data.set(arr, arr.length - 32, 32);
        arr = ((GXAsn1Integer)tmp2.get(1)).getByteArray();
        data.set(arr, arr.length - 32, 32);
        return data.array();
    }

    public static boolean validateEphemeralPublicKeySignature(byte[] data, byte[] sign, PublicKey publicSigningKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        GXAsn1Integer a = new GXAsn1Integer(sign, 0, 32);
        GXAsn1Integer b = new GXAsn1Integer(sign, 32, 32);
        GXAsn1Sequence s = new GXAsn1Sequence();
        s.add(a);
        s.add(b);
        byte[] tmp = GXAsn1Converter.toByteArray(s);
        Signature instance = Signature.getInstance("SHA256withECDSA");
        instance.initVerify(publicSigningKey);
        instance.update(data);
        boolean v = instance.verify(tmp);
        if (!v) {
            LOGGER.log(Level.FINEST, "Data: {0}", GXCommon.toHex(data));
            LOGGER.log(Level.FINEST, "Sign: {0}", GXCommon.toHex(sign));
        }
        return v;
    }

    private static Cipher getCipher(AesGcmParameter p, boolean encrypt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        GXByteBuffer iv = new GXByteBuffer();
        iv.set(p.getSystemTitle());
        iv.setUInt32(p.getInvocationCounter());
        SecretKeySpec eks = new SecretKeySpec(p.getBlockCipherKey(), "AES");
        Cipher c = Cipher.getInstance("AES/GCM/NoPadding");
        int mode = encrypt ? 1 : 2;
        c.init(mode, (Key)eks, new GCMParameterSpec(96, iv.array()));
        return c;
    }

    private static byte[] countTag(Cipher c, AesGcmParameter p, byte[] data) throws IllegalBlockSizeException, BadPaddingException {
        GXByteBuffer data2 = new GXByteBuffer();
        data2.setUInt8(p.getSecurity().getValue() | p.getSecuritySuite().getValue());
        data2.set(p.getAuthenticationKey());
        if (data != null) {
            data2.set(data);
        }
        c.updateAAD(data2.array());
        byte[] tmp = c.doFinal();
        byte[] tag = new byte[12];
        System.arraycopy(tmp, 0, tag, 0, 12);
        return tag;
    }

    private static byte[] encrypt(Cipher c, byte[] data) throws IllegalBlockSizeException, BadPaddingException {
        byte[] es = c.doFinal(data);
        byte[] tmp = new byte[es.length - 12];
        System.arraycopy(es, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public static byte[] encryptAesGcm(boolean encrypt, AesGcmParameter p, byte[] data) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        CryptoKeyType keyType;
        Cipher c = GXSecure.getCipher(p, encrypt || p.getSecurity() != Security.AUTHENTICATION_ENCRYPTION);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Authentication key: {0}", GXCommon.toHex(p.getAuthenticationKey()));
            LOGGER.log(Level.FINEST, "Block cipher key key: {0}", GXCommon.toHex(p.getBlockCipherKey()));
        }
        switch (p.getSecurity()) {
            case AUTHENTICATION: {
                keyType = CryptoKeyType.AUTHENTICATION;
                break;
            }
            case ENCRYPTION: {
                keyType = CryptoKeyType.BLOCK_CIPHER;
                break;
            }
            case AUTHENTICATION_ENCRYPTION: {
                keyType = CryptoKeyType.forValue(CryptoKeyType.AUTHENTICATION.getValue() | CryptoKeyType.BLOCK_CIPHER.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Security");
            }
        }
        GXByteBuffer bb = new GXByteBuffer(10 + data.length);
        if (encrypt) {
            if (p.getType() == -1) {
                bb.setUInt8(p.getSecurity().getValue() | p.getSecuritySuite().getValue());
                bb.setUInt32(p.getInvocationCounter());
            }
            if (p.getSecurity() == Security.AUTHENTICATION) {
                byte[] tmp = GXSecure.countTag(c, p, data);
                if (p.getType() == -1) {
                    bb.set(data);
                }
                bb.set(tmp);
            } else if (p.getSecurity() == Security.ENCRYPTION) {
                bb.set(GXSecure.encrypt(c, data));
            } else if (p.getSecurity() == Security.AUTHENTICATION_ENCRYPTION) {
                byte[] crypted = null;
                if (p.getSettings() != null) {
                    crypted = GXCommon.crypt(p.getSettings(), CertificateType.DIGITAL_SIGNATURE, data, true, keyType, 33, p.getSecurity(), p.getSecuritySuite(), p.getInvocationCounter());
                }
                if (crypted != null) {
                    bb.set(crypted);
                } else {
                    GXByteBuffer data2 = new GXByteBuffer();
                    data2.setUInt8(p.getSecurity().getValue() | p.getSecuritySuite().getValue());
                    data2.set(p.getAuthenticationKey());
                    c.updateAAD(data2.array());
                    bb.set(c.doFinal(data));
                }
            }
            if (p.getType() == -1) {
                GXByteBuffer bb2 = new GXByteBuffer(5 + bb.size());
                bb2.setUInt8(p.getTag());
                if (p.getTag() == 219 || p.getTag() == 220 || p.getTag() == 15) {
                    GXCommon.setObjectCount(p.getSystemTitle().length, bb2);
                    bb2.set(p.getSystemTitle());
                }
                GXCommon.setObjectCount(bb.size(), bb2);
                bb2.set(bb);
                return bb2.array();
            }
            return bb.array();
        }
        if (p.getSecurity() == Security.ENCRYPTION) {
            byte[] tmp2 = c.doFinal(data);
            byte[] tmp = new byte[tmp2.length - 12];
            System.arraycopy(tmp2, 0, tmp, 0, tmp.length);
            return tmp;
        }
        if (p.getSecurity() == Security.AUTHENTICATION) {
            byte[] received = new byte[12];
            System.arraycopy(data, data.length - 12, received, 0, 12);
            GXByteBuffer data2 = new GXByteBuffer();
            data2.set(data);
            data2.size(data2.size() - 12);
            byte[] counted = GXSecure.countTag(c, p, data2.array());
            if (!GXCommon.compare(counted, received)) {
                throw new AEADBadTagException();
            }
            return data2.array();
        }
        try {
            byte[] tmp = null;
            if (p.getSettings() != null) {
                tmp = GXCommon.crypt(p.getSettings(), CertificateType.DIGITAL_SIGNATURE, data, false, keyType, 40, p.getSecurity(), p.getSecuritySuite(), p.getInvocationCounter());
            }
            if (tmp != null) {
                return tmp;
            }
            GXByteBuffer data2 = new GXByteBuffer();
            int tag = p.getSecurity().getValue() | p.getSecuritySuite().getValue();
            if (p.isCompressed()) {
                tag |= 0x80;
            }
            if (p.isBroadcasted()) {
                tag |= 0x40;
            }
            data2.setUInt8(tag);
            data2.set(p.getAuthenticationKey());
            c.updateAAD(data2.array());
            return c.doFinal(data);
        }
        catch (Exception ex) {
            if (p.getXml() == null) {
                LOGGER.log(Level.SEVERE, "Decrypt failed. Invalid authentication tag.");
                throw ex;
            }
            if (ex instanceof AEADBadTagException) {
                p.getXml().appendComment("Authentication tag is invalid.");
                c = GXSecure.getCipher(p, true);
                bb.set(data, 0, data.length - 12);
                byte[] tmp2 = c.doFinal(bb.array());
                byte[] tmp = new byte[tmp2.length - 12];
                System.arraycopy(tmp2, 0, tmp, 0, tmp.length);
                return tmp;
            }
            throw ex;
        }
    }

    static byte[] decryptAesGcm(GXICipher c, AesGcmParameter p, GXByteBuffer data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] decrypted;
            int length;
            GXByteBuffer kdf;
            KeyAgreement ka;
            int len;
            if (data == null || data.size() - data.position() < 2) {
                throw new IllegalArgumentException("cryptedData");
            }
            short cmd = data.getUInt8();
            switch (cmd) {
                case 219: 
                case 220: {
                    len = GXCommon.getObjectCount(data);
                    if (len != 0) {
                        byte[] title = new byte[len];
                        data.get(title);
                        p.setSystemTitle(title);
                    }
                    if (p.getSystemTitle() != null && p.getSystemTitle().length == 8) break;
                    if (p.getXml() == null) {
                        throw new IllegalArgumentException("Invalid sender system title.");
                    }
                    p.getXml().appendComment("Invalid sender system title.");
                    break;
                }
                case 33: 
                case 37: 
                case 38: 
                case 40: 
                case 44: 
                case 45: 
                case 46: 
                case 65: 
                case 69: 
                case 70: 
                case 72: 
                case 76: 
                case 77: 
                case 78: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 215: 
                case 221: 
                case 223: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("cryptedData");
                }
            }
            short value = 0;
            KeyPair kp = null;
            PrivateKey key = null;
            PublicKey pub = null;
            GXByteBuffer transactionId = null;
            if (cmd == 221 || cmd == 223) {
                transactionId = new GXByteBuffer();
                len = GXCommon.getObjectCount(data);
                if (len != 0) {
                    GXCommon.setObjectCount(len, transactionId);
                    transactionId.set(data, len);
                    p.setTransactionId(transactionId.getUInt64());
                } else {
                    p.setTransactionId(BigInteger.ZERO);
                }
                len = GXCommon.getObjectCount(data);
                byte[] tmp = new byte[len];
                if (len != 0) {
                    data.get(tmp);
                    p.setSystemTitle(tmp);
                }
                if (p.getSystemTitle() == null || p.getSystemTitle().length != 8) {
                    if (p.getXml() == null) {
                        throw new IllegalArgumentException("Invalid sender system title.");
                    }
                    p.getXml().appendComment("Invalid sender system title.");
                }
                len = GXCommon.getObjectCount(data);
                tmp = new byte[len];
                data.get(tmp);
                p.setRecipientSystemTitle(tmp);
                len = GXCommon.getObjectCount(data);
                if (len != 0) {
                    tmp = new byte[len];
                    data.get(tmp);
                    p.setDateTime(tmp);
                }
                if ((len = (int)data.getUInt8()) != 0) {
                    tmp = new byte[len];
                    data.get(tmp);
                    p.setOtherInformation(tmp);
                }
                if (cmd == 221) {
                    data.getUInt8();
                    data.getUInt8();
                    data.getUInt8();
                    value = data.getUInt8();
                    p.setKeyParameters(value);
                    if (value == KeyAgreementScheme.ONE_PASS_DIFFIE_HELLMAN.ordinal()) {
                        p.getSettings().getCipher().setSigning(Signing.ONE_PASS_DIFFIE_HELLMAN);
                        len = GXCommon.getObjectCount(data);
                        GXByteBuffer bb = new GXByteBuffer();
                        bb.set(data, len);
                        if (p.getXml() != null) {
                            p.setKeyCipheredData(bb.array());
                        }
                        if (((kp = p.getSettings().getCipher().getKeyAgreementKeyPair()) == null || kp.getPublic() == null) && (pub = (PublicKey)p.getSettings().getKey(CertificateType.KEY_AGREEMENT, p.getSystemTitle(), false)) != null) {
                            p.getSettings().getCipher().setKeyAgreementKeyPair(new KeyPair(pub, p.getSettings().getCipher().getKeyAgreementKeyPair().getPrivate()));
                        }
                        if (kp.getPrivate() == null && (key = (PrivateKey)p.getSettings().getKey(CertificateType.KEY_AGREEMENT, p.getSystemTitle(), true)) != null) {
                            p.getSettings().getCipher().setKeyAgreementKeyPair(new KeyPair(p.getSettings().getCipher().getKeyAgreementKeyPair().getPublic(), key));
                        }
                        if (kp.getPublic() != null) {
                            int keySize = len / 2;
                            pub = GXAsn1Converter.getPublicKey(bb.subArray(0, keySize));
                        }
                    } else if (value == KeyAgreementScheme.STATIC_UNIFIED_MODEL.ordinal()) {
                        p.getSettings().getCipher().setSigning(Signing.STATIC_UNIFIED_MODEL);
                        len = GXCommon.getObjectCount(data);
                        if (len != 0) {
                            throw new IllegalArgumentException("Invalid key parameters");
                        }
                        kp = p.getSettings().getCipher().getKeyAgreementKeyPair();
                        pub = kp == null || kp.getPublic() == null ? (PublicKey)p.getSettings().getKey(CertificateType.KEY_AGREEMENT, p.getSystemTitle(), false) : p.getSettings().getCipher().getKeyAgreementKeyPair().getPublic();
                        key = kp.getPrivate() == null ? (PrivateKey)p.getSettings().getKey(CertificateType.KEY_AGREEMENT, p.getRecipientSystemTitle(), true) : p.getSettings().getCipher().getKeyAgreementKeyPair().getPrivate();
                        if (kp.getPublic() == null || kp.getPrivate() == null) {
                            kp = new KeyPair(pub, key);
                            p.getSettings().getCipher().setKeyAgreementKeyPair(kp);
                        }
                    }
                } else {
                    p.getSettings().getCipher().setSigning(Signing.GENERAL_SIGNING);
                    kp = p.getSettings().getCipher().getSigningKeyPair();
                    if (kp.getPublic() == null || kp.getPrivate() == null) {
                        if (kp.getPublic() == null) {
                            key = p.getSettings().getCipher().getSigningKeyPair().getPrivate();
                            pub = (PublicKey)p.getSettings().getKey(CertificateType.DIGITAL_SIGNATURE, p.getSystemTitle(), false);
                            kp = new KeyPair(pub, key);
                            p.getSettings().getCipher().setSigningKeyPair(kp);
                        }
                        if (kp.getPrivate() == null) {
                            pub = p.getSettings().getCipher().getSigningKeyPair().getPublic();
                            key = (PrivateKey)p.getSettings().getKey(CertificateType.DIGITAL_SIGNATURE, p.getRecipientSystemTitle(), true);
                            kp = new KeyPair(pub, key);
                            p.getSettings().getCipher().setSigningKeyPair(kp);
                        }
                    }
                }
            }
            int contentStart = data.position();
            len = GXCommon.getObjectCount(data);
            if (len > data.available()) {
                throw new IllegalArgumentException("Not enought data.");
            }
            p.setCipheredContent(data.subArray(data.position(), len));
            if (cmd == 223) {
                if (!GXCommon.isCiphered(data.getUInt8())) {
                    data.position(data.position() - 1);
                    if (p.getSettings().isServer()) {
                        ArrayList<SecurityPolicy> list = new ArrayList<SecurityPolicy>();
                        list.add(SecurityPolicy.ENCRYPTED_REQUEST);
                        list.add(SecurityPolicy.AUTHENTICATED_REQUEST);
                        if (p.getSettings().getCipher().getSecurityPolicy().containsAll(list)) {
                            throw new GXDLMSExceptionResponse(ExceptionStateError.SERVICE_NOT_ALLOWED, ExceptionServiceError.DECIPHERING_ERROR, 0);
                        }
                    }
                    return data.remaining();
                }
                len = GXCommon.getObjectCount(data);
                if (len > data.available()) {
                    throw new Exception("Not enought data.");
                }
            }
            short sc = data.getUInt8();
            p.setSecuritySuite(SecuritySuite.forValue(sc & 3));
            p.setSecurity(Security.forValue(sc & 0x30));
            if ((sc & 0x80) != 0) {
                LOGGER.log(Level.FINEST, "Compression is used.");
            }
            if ((sc & 0x40) != 0) {
                LOGGER.log(Level.FINEST, "Key_Set is used.");
                if (p.getXml() == null) {
                    throw new GXDLMSExceptionResponse(ExceptionStateError.SERVICE_NOT_ALLOWED, ExceptionServiceError.DECIPHERING_ERROR, null);
                }
            }
            if ((sc & 0x20) != 0) {
                LOGGER.log(Level.FINEST, "Encryption is applied.");
            }
            if ((sc & 0x10) != 0) {
                LOGGER.log(Level.FINEST, "Authentication is applied.");
            }
            if (value != 0 && p.getXml() != null && kp.getPublic() == null) {
                return p.getCipheredContent();
            }
            byte[] algID = GXCommon.hexToBytes("60857405080300");
            if (cmd == 223 && p.getSecurity() != Security.NONE) {
                if (p.getXml() == null || kp.getPrivate() != null && kp.getPublic() != null) {
                    LOGGER.log(Level.FINEST, "Private signing key: ", kp.getPrivate());
                    LOGGER.log(Level.FINEST, "Public signing key: ", kp.getPublic());
                }
            } else if (value == KeyAgreementScheme.ONE_PASS_DIFFIE_HELLMAN.ordinal()) {
                ka = KeyAgreement.getInstance("ECDH");
                ka.init(kp.getPrivate());
                ka.doPhase(kp.getPublic(), true);
                byte[] z = ka.generateSecret();
                LOGGER.log(Level.FINEST, "Private agreement key {0}", GXCommon.toHex(GXAsn1Converter.rawValue(key), true));
                LOGGER.log(Level.FINEST, "Public ephemeral key: {0}", GXCommon.toHex(GXAsn1Converter.rawValue(pub), true));
                LOGGER.log(Level.FINEST, "Shared secret: {0}", GXCommon.toHex(z, true));
                kdf = new GXByteBuffer();
                kdf.set(GXSecure.generateKDF("SHA-256", z, 256, algID, p.getSystemTitle(), p.getRecipientSystemTitle(), null, null));
                LOGGER.log(Level.FINEST, "KDF {0}", kdf);
                p.setBlockCipherKey(kdf.subArray(0, 16));
            } else if (value == KeyAgreementScheme.STATIC_UNIFIED_MODEL.ordinal()) {
                ka = KeyAgreement.getInstance("ECDH");
                ka.init(p.getSettings().getCipher().getKeyAgreementKeyPair().getPrivate());
                ka.doPhase(kp.getPublic(), true);
                byte[] z = ka.generateSecret();
                LOGGER.log(Level.FINEST, "Private Agreement key: {0}", GXDLMSTranslator.toHex(GXAsn1Converter.rawValue(p.getSettings().getCipher().getKeyAgreementKeyPair().getPrivate())));
                LOGGER.log(Level.FINEST, "Public Agreement key: {0}", GXDLMSTranslator.toHex(GXAsn1Converter.rawValue(pub)));
                LOGGER.log(Level.FINEST, "Shared secret {0}", GXCommon.toHex(z, true));
                kdf = new GXByteBuffer();
                kdf.set(GXSecure.generateKDF("SHA-256", z, 256, algID, p.getSystemTitle(), transactionId.array(), p.getRecipientSystemTitle(), null));
                LOGGER.log(Level.FINEST, "KDF {0}", kdf);
                LOGGER.log(Level.FINEST, "Authentication key {0}", GXDLMSTranslator.toHex(p.getAuthenticationKey()));
                p.setBlockCipherKey(kdf.subArray(0, 16));
            }
            if (p.getXml() == null && value != 0 && kp.getPublic() == null) {
                throw new IllegalArgumentException("Invalid Key-id value.");
            }
            long invocationCounter = 0L;
            if (p.getSecurity() != Security.NONE) {
                invocationCounter = data.getUInt32();
            }
            if (p.getSettings().getInvocationCounter() != null && p.getSettings().getInvocationCounter().getValue() instanceof Number) {
                if (invocationCounter < ((Number)p.getSettings().getInvocationCounter().getValue()).longValue()) {
                    throw new GXDLMSExceptionResponse(ExceptionStateError.SERVICE_NOT_ALLOWED, ExceptionServiceError.INVOCATION_COUNTER_ERROR, p.getSettings().getInvocationCounter().getValue());
                }
                p.getSettings().getInvocationCounter().setValue(invocationCounter);
            }
            p.setInvocationCounter(invocationCounter);
            if (p.getAuthenticationKey() == null || p.getBlockCipherKey() == null) {
                if (p.getSettings().getCryptoNotifier() == null) {
                    throw new Exception("Failed to get the block cipher key.");
                }
                GXCryptoKeyParameter args = new GXCryptoKeyParameter();
                args.setInvocationCounter(invocationCounter);
                args.setSystemTitle(p.getSystemTitle());
                if (p.getBlockCipherKey() == null) {
                    args.setKeyType(CryptoKeyType.forValue(args.getKeyType().getValue() | CryptoKeyType.BLOCK_CIPHER.getValue()));
                }
                if (p.getAuthenticationKey() == null) {
                    args.setKeyType(CryptoKeyType.forValue(args.getKeyType().getValue() | CryptoKeyType.AUTHENTICATION.getValue()));
                }
                p.getSettings().getCryptoNotifier().onKey(p.getSettings().getCryptoNotifier(), args);
                if (p.getBlockCipherKey() == null) {
                    if (args.getBlockCipherKey() == null || args.getBlockCipherKey().length != 16 && args.getBlockCipherKey().length != 32) {
                        throw new Exception("Invalid Block cipher key.");
                    }
                    p.setBlockCipherKey(args.getBlockCipherKey());
                }
                if (p.getAuthenticationKey() == null) {
                    if (args.getAuthenticationKey() == null || args.getAuthenticationKey().length != 16 && args.getAuthenticationKey().length != 32) {
                        throw new Exception("Invalid authentication key.");
                    }
                    p.setAuthenticationKey(args.getAuthenticationKey());
                }
            }
            LOGGER.log(Level.FINEST, "Decrypt settings {0}", p.toString());
            LOGGER.log(Level.FINEST, "Encrypted {0}", GXCommon.toHex(data.getData(), false, data.position(), data.available()));
            byte[] tag = null;
            if (p.getSecurity() != Security.ENCRYPTION) {
                tag = new byte[12];
            }
            if (p.getSecurity() == Security.AUTHENTICATION) {
                byte[] encryptedData;
                try {
                    encryptedData = GXSecure.encryptAesGcm(false, p, data.remaining());
                }
                catch (AEADBadTagException e) {
                    LOGGER.log(Level.SEVERE, "Decrypt failed. Invalid authentication tag.");
                    encryptedData = null;
                    if (p.getXml() == null) {
                        throw e;
                    }
                    p.getXml().appendComment("Decrypt failed. Invalid authentication tag.");
                }
                return encryptedData;
            }
            byte[] ciphertext = null;
            if (p.getSecurity() == Security.ENCRYPTION) {
                length = len - 5;
                ciphertext = new byte[length];
                data.get(ciphertext);
            } else if (p.getSecurity() == Security.AUTHENTICATION_ENCRYPTION) {
                length = len - 12 - 5;
                ciphertext = new byte[length];
                data.get(ciphertext);
                data.get(tag);
            }
            if (p.getSecurity() != Security.NONE) {
                GXByteBuffer bb = new GXByteBuffer();
                bb.set(ciphertext);
                bb.set(tag);
                decrypted = GXSecure.encryptAesGcm(false, p, bb.array());
                LOGGER.log(Level.FINEST, "Decrypted: {0}", GXCommon.toHex(decrypted, true));
            } else {
                length = len;
                decrypted = new byte[length];
                data.get(decrypted);
            }
            if (cmd == 223) {
                GXByteBuffer signedData = new GXByteBuffer();
                signedData.set(data.getData(), 1, contentStart - 1);
                signedData.set(p.getCipheredContent());
                len = GXCommon.getObjectCount(data);
                byte[] s = new byte[len];
                data.get(s);
                p.setSignature(s);
                LOGGER.log(Level.FINEST, "Verifying signature for sender: {0}", GXCommon.toHex(p.getSystemTitle(), true));
                if (p.getXml() == null) {
                    if (kp.getPublic() == null) {
                        throw new IllegalArgumentException("Public key is not set.");
                    }
                    if (!GXSecure.validateEphemeralPublicKeySignature(signedData.array(), p.getSignature(), kp.getPublic())) {
                        throw new Exception("Invalid signature.");
                    }
                } else if (kp.getPublic() == null && kp.getPrivate() == null) {
                    p.getXml().appendComment("Failed to verify signed data. Public key is not set.");
                } else if (!GXSecure.validateEphemeralPublicKeySignature(signedData.array(), p.getSignature(), kp.getPublic())) {
                    p.getXml().appendComment("Failed to verify signed data. Invalid signature.");
                }
            }
            return decrypted;
        }
        catch (AEADBadTagException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            throw new GXDLMSExceptionResponse(ExceptionStateError.SERVICE_NOT_ALLOWED, ExceptionServiceError.DECIPHERING_ERROR, null);
        }
    }
}

