/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.internal.GXCommon;

public class GXBitString {
    private String value;

    public GXBitString() {
    }

    public GXBitString(String val) {
        this.value = val;
    }

    public GXBitString(byte val, int count) {
        StringBuilder sb = new StringBuilder();
        GXCommon.toBitString(sb, val, 8);
        this.value = count != 8 ? sb.toString().substring(0, count) : sb.toString();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public final String toString() {
        return this.value;
    }

    private static void toBitString(StringBuilder sb, int value, int count) {
        if (count > 8) {
            count = 8;
        }
        for (int pos = 0; pos != count; ++pos) {
            if ((value & 1 << pos) != 0) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        }
    }

    public static String toBitString(long value, int count) {
        StringBuilder sb = new StringBuilder();
        GXBitString.toBitString(sb, (byte)(value & 0xFFL), count);
        if (count > 8) {
            GXBitString.toBitString(sb, (byte)(value >> 8 & 0xFFL), count - 8);
            if (count > 16) {
                GXBitString.toBitString(sb, (byte)(value >> 16 & 0xFFL), count - 16);
                if (count > 24) {
                    GXBitString.toBitString(sb, (byte)(value >> 24 & 0xFFL), count - 24);
                }
            }
        }
        if (sb.length() > count) {
            return sb.substring(0, count);
        }
        return sb.toString();
    }

    public int toInteger() {
        int val = 0;
        if (this.value != null) {
            for (int pos = 0; pos != this.value.length(); ++pos) {
                if (this.value.charAt(pos) == '1') {
                    val |= 1 << pos;
                    continue;
                }
                if (this.value.charAt(pos) == '0') continue;
                throw new IllegalArgumentException("Invalid parameter");
            }
        }
        return val;
    }
}

