/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.ClockType;
import gurux.dlms.GXAPDU;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXCoAPSettings;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSAccessItem;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSGateway;
import gurux.dlms.GXDLMSLNCommandHandler;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSLimits;
import gurux.dlms.GXDLMSSNCommandHandler;
import gurux.dlms.GXDLMSSNParameters;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.GXDate;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXHdlcSettings;
import gurux.dlms.GXICipher;
import gurux.dlms.GXMBusSettings;
import gurux.dlms.GXPlcSettings;
import gurux.dlms.GXReplyData;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXTime;
import gurux.dlms.GXWriteItem;
import gurux.dlms.IGXCryptoNotifier;
import gurux.dlms.SerialNumberCounter;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1Integer;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.AccessMode3;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.MethodAccessMode;
import gurux.dlms.enums.MethodAccessMode3;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.RequestTypes;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.enums.Signing;
import gurux.dlms.enums.SourceDiagnostic;
import gurux.dlms.enums.Standard;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.manufacturersettings.GXObisCodeCollection;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSData;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import gurux.dlms.objects.GXDLMSProfileGeneric;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.CertificateType;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.secure.GXSecure;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class GXDLMSClient {
    private boolean useProtectedRelease = false;
    protected GXDLMSTranslator translator;
    private byte[] initializeChallenge;
    private int initializePduSize;
    private int initializeMaxInfoTX;
    private int initializeMaxInfoRX;
    private int initializeWindowSizeTX;
    private int initializeWindowSizeRX;
    private boolean throwExceptions;
    private String manufacturerId;
    protected final GXDLMSSettings settings = new GXDLMSSettings(false, this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null);
    private GXObisCodeCollection obisCodes;
    private static final Logger LOGGER = Logger.getLogger(GXDLMSClient.class.getName());
    private boolean isAuthenticationRequired = false;

    public GXDLMSClient() {
        this(false);
    }

    public GXDLMSClient(boolean useLogicalNameReferencing) {
        this(useLogicalNameReferencing, 16, 1, Authentication.NONE, null, InterfaceType.HDLC);
    }

    public GXDLMSClient(boolean useLogicalNameReferencing, int clientAddress, int serverAddress, Authentication forAuthentication, String password, InterfaceType interfaceType) {
        this.setUseLogicalNameReferencing(useLogicalNameReferencing);
        this.setClientAddress(clientAddress);
        this.setServerAddress(serverAddress);
        this.setAuthentication(forAuthentication);
        this.setPassword(GXCommon.getBytes(password));
        this.setInterfaceType(interfaceType);
        this.settings.getPlc().reset();
    }

    public int getVersion() {
        return this.settings.getVersion();
    }

    public void setVersion(int value) {
        this.settings.setVersion(value);
    }

    protected final void setCipher(GXICipher value) {
        this.settings.setCipher(value);
    }

    protected final GXDLMSSettings getSettings() {
        return this.settings;
    }

    public final GXDLMSObjectCollection getObjects() {
        return this.settings.getObjects();
    }

    public final GXObisCodeCollection getObisCodes() {
        return this.obisCodes;
    }

    public final void setObisCodes(GXObisCodeCollection value) {
        this.obisCodes = value;
    }

    public final void setStartingPacketIndex(int value) {
        this.settings.setStartingPacketIndex(value);
    }

    public final int getUserId() {
        return this.settings.getUserId();
    }

    public final void setUserId(int value) {
        if (value < -1 || value > 255) {
            throw new IllegalArgumentException("Invalid user Id.");
        }
        this.settings.setUserId(value);
    }

    public final int getClientAddress() {
        return this.settings.getClientAddress();
    }

    public final void setClientAddress(int value) {
        this.settings.setClientAddress(value);
    }

    public final int getServerAddress() {
        return this.settings.getServerAddress();
    }

    public final void setServerAddress(int value) {
        this.settings.setServerAddress(value);
    }

    public final int getServerAddressSize() {
        return this.settings.getServerAddressSize();
    }

    public final void setServerAddressSize(int value) {
        this.settings.setServerAddressSize(value);
    }

    public byte[] getSourceSystemTitle() {
        return this.settings.getSourceSystemTitle();
    }

    public final byte getGbtWindowSize() {
        return this.settings.getGbtWindowSize();
    }

    public final void setGbtWindowSize(byte value) {
        this.settings.setGbtWindowSize(value);
    }

    public final int getMaxReceivePDUSize() {
        return this.settings.getMaxPduSize();
    }

    public final void setMaxReceivePDUSize(int value) {
        this.settings.setMaxPduSize(value);
    }

    public final boolean getUseLogicalNameReferencing() {
        return this.settings.getUseLogicalNameReferencing();
    }

    public final void setUseLogicalNameReferencing(boolean value) {
        this.settings.setUseLogicalNameReferencing(value);
    }

    public final byte[] getCtoSChallenge() {
        return this.settings.getCtoSChallenge();
    }

    public final void setCtoSChallenge(byte[] value) {
        this.settings.setUseCustomChallenge(value != null);
        this.settings.setCtoSChallenge(value);
    }

    public boolean getUseUtc2NormalTime() {
        return this.settings.getUseUtc2NormalTime();
    }

    public void setUseUtc2NormalTime(boolean value) {
        this.settings.setUseUtc2NormalTime(value);
    }

    public boolean getIncreaseInvocationCounterForGMacAuthentication() {
        return this.settings.getIncreaseInvocationCounterForGMacAuthentication();
    }

    public void setIncreaseInvocationCounterForGMacAuthentication(boolean value) {
        this.settings.setIncreaseInvocationCounterForGMacAuthentication(value);
    }

    public Set<DateTimeSkips> getDateTimeSkips() {
        return this.settings.getDateTimeSkips();
    }

    public void setDateTimeSkips(Set<DateTimeSkips> value) {
        this.settings.setDateTimeSkips(value);
    }

    public Set<DateTimeSkips> getDateTimeSkipsOnRead() {
        return this.settings.getDateTimeSkipsOnRead();
    }

    public void setDateTimeSkipsOnRead(Set<DateTimeSkips> value) {
        this.settings.setDateTimeSkipsOnRead(value);
    }

    public Standard getStandard() {
        return this.settings.getStandard();
    }

    public void setStandard(Standard value) {
        this.settings.setStandard(value);
    }

    public final byte[] getPassword() {
        return this.settings.getPassword();
    }

    public final void setPassword(byte[] value) {
        this.settings.setPassword(value);
    }

    public final void setPassword(String value) {
        this.settings.setPassword(value.getBytes());
    }

    public final Set<Conformance> getNegotiatedConformance() {
        return this.settings.getNegotiatedConformance();
    }

    public final Set<Conformance> getProposedConformance() {
        return this.settings.getProposedConformance();
    }

    public final void setProposedConformance(Set<Conformance> value) {
        this.settings.setProposedConformance(value);
    }

    public final Authentication getAuthentication() {
        return this.settings.getAuthentication();
    }

    public final void setAuthentication(Authentication value) {
        this.settings.setAuthentication(value);
    }

    public final Priority getPriority() {
        return this.settings.getPriority();
    }

    public final void setPriority(Priority value) {
        this.settings.setPriority(value);
    }

    public final ServiceClass getServiceClass() {
        return this.settings.getServiceClass();
    }

    public final void setServiceClass(ServiceClass value) {
        this.settings.setServiceClass(value);
    }

    public final int getInvokeID() {
        return this.settings.getInvokeID();
    }

    public final void setInvokeID(int value) {
        this.settings.setInvokeID(value);
    }

    public final boolean getAutoIncreaseInvokeID() {
        return this.settings.getAutoIncreaseInvokeID();
    }

    public final void setAutoIncreaseInvokeID(boolean value) {
        this.settings.setAutoIncreaseInvokeID(value);
    }

    public final InterfaceType getInterfaceType() {
        return this.settings.getInterfaceType();
    }

    public final void setInterfaceType(InterfaceType value) {
        this.settings.setInterfaceType(value);
    }

    public final GXDLMSLimits getLimits() {
        return (GXDLMSLimits)this.settings.getHdlcSettings();
    }

    public final GXHdlcSettings getHdlcSettings() {
        return this.settings.getHdlcSettings();
    }

    public final GXPlcSettings getPlc() {
        return this.settings.getPlc();
    }

    public final GXMBusSettings getMbus() {
        return this.settings.getMbus();
    }

    public final GXCoAPSettings getCoap() {
        return this.settings.getCoap();
    }

    public final GXDLMSGateway getGateway() {
        return this.settings.getGateway();
    }

    public final void setGateway(GXDLMSGateway value) {
        this.settings.setGateway(value);
    }

    public final String getProtocolVersion() {
        return this.settings.getProtocolVersion();
    }

    public final void setProtocolVersion(String value) {
        this.settings.setProtocolVersion(value);
    }

    public final byte[] snrmRequest() {
        return this.snrmRequest(false);
    }

    public final byte[] snrmRequest(boolean forceParameters) {
        this.initializeMaxInfoTX = this.getHdlcSettings().getMaxInfoTX();
        this.initializeMaxInfoRX = this.getHdlcSettings().getMaxInfoRX();
        this.initializeWindowSizeTX = this.getHdlcSettings().getWindowSizeTX();
        this.initializeWindowSizeRX = this.getHdlcSettings().getWindowSizeRX();
        this.settings.setConnected(0);
        this.isAuthenticationRequired = false;
        this.settings.resetFrameSequence();
        if (this.getInterfaceType() == InterfaceType.PLC_HDLC) {
            return GXDLMS.getMacHdlcFrame(this.settings, 147, 0, null);
        }
        if (this.getInterfaceType() != InterfaceType.HDLC && this.getInterfaceType() != InterfaceType.HDLC_WITH_MODE_E) {
            return new byte[0];
        }
        GXByteBuffer data = new GXByteBuffer(25);
        data.setUInt8(129);
        data.setUInt8(128);
        data.setUInt8(0);
        int maxInfoTX = this.getHdlcSettings().getMaxInfoTX();
        int maxInfoRX = this.getHdlcSettings().getMaxInfoRX();
        if (this.getHdlcSettings().isUseFrameSize()) {
            byte[] primaryAddress = GXDLMS.getHdlcAddressBytes(this.settings.getServerAddress(), this.settings.getServerAddressSize());
            byte[] secondaryAddress = GXDLMS.getHdlcAddressBytes(this.settings.getClientAddress(), 0);
            maxInfoTX -= 10 + secondaryAddress.length;
            maxInfoRX -= 10 + primaryAddress.length;
        }
        if (forceParameters || 128 != this.getHdlcSettings().getMaxInfoTX() || 128 != this.getHdlcSettings().getMaxInfoRX() || 1 != this.getHdlcSettings().getWindowSizeTX() || 1 != this.getHdlcSettings().getWindowSizeRX()) {
            data.setUInt8(5);
            GXDLMS.appendHdlcParameter(data, maxInfoTX);
            data.setUInt8(6);
            GXDLMS.appendHdlcParameter(data, maxInfoRX);
            data.setUInt8(7);
            data.setUInt8(4);
            data.setUInt32(this.getHdlcSettings().getWindowSizeTX());
            data.setUInt8(8);
            data.setUInt8(4);
            data.setUInt32(this.getHdlcSettings().getWindowSizeRX());
        }
        if (data.size() != 3) {
            data.setUInt8(2, data.size() - 3);
        } else {
            data = null;
        }
        return GXDLMS.getHdlcFrame(this.settings, -109, data);
    }

    public final void parseUAResponse(byte[] data) {
        GXDLMS.parseSnrmUaResponse(new GXByteBuffer(data), this.settings);
        this.settings.setConnected(1);
    }

    public final void parseUAResponse(GXByteBuffer data) {
        GXDLMS.parseSnrmUaResponse(data, this.settings);
    }

    public final byte[][] aarqRequest() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (this.isPreEstablishedConnection()) {
            return new byte[0][];
        }
        this.initializePduSize = this.getMaxReceivePDUSize();
        this.initializeChallenge = this.settings.getCtoSChallenge();
        this.settings.getNegotiatedConformance().clear();
        this.settings.setConnected(this.settings.getConnected() & 0xFFFFFFFD);
        GXByteBuffer buff = new GXByteBuffer(20);
        this.settings.resetBlockIndex();
        this.settings.setServerPublicKeyCertificate(null);
        GXDLMS.checkInit(this.settings);
        this.settings.setStoCChallenge(null);
        if (this.getAutoIncreaseInvokeID()) {
            this.settings.setInvokeID(0);
        } else {
            this.settings.setInvokeID(1);
        }
        this.settings.setEphemeralBlockCipherKey(null);
        this.settings.setEphemeralBroadcastBlockCipherKey(null);
        this.settings.setEphemeralAuthenticationKey(null);
        if (this.getAuthentication().ordinal() > Authentication.LOW.ordinal()) {
            this.settings.setCtoSChallenge(GXSecure.generateChallenge(this.settings.getAuthentication(), this.settings.getChallengeSize()));
        } else {
            this.settings.setCtoSChallenge(null);
        }
        GXAPDU.generateAarq(this.settings, this.settings.getCipher(), null, buff);
        if (this.settings.getUseLogicalNameReferencing()) {
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 96, 0, buff, null, 255, 0);
            reply = GXDLMS.getLnMessages(p);
        } else {
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 96, 0, 0, null, buff);
            reply = GXDLMS.getSnMessages(p);
        }
        return (byte[][])reply.toArray((T[])new byte[0][]);
    }

    public final void parseAareResponse(GXByteBuffer reply) {
        boolean bl = this.isAuthenticationRequired = GXAPDU.parsePDU(this.settings, this.settings.getCipher(), reply, null) == SourceDiagnostic.AUTHENTICATION_REQUIRED;
        if (this.settings.getDLMSVersion() != 6) {
            throw new IllegalArgumentException("Invalid DLMS version number.");
        }
        if (!this.isAuthenticationRequired) {
            this.settings.setConnected(this.settings.getConnected() | 2);
        }
    }

    public final boolean getIsAuthenticationRequired() {
        return this.isAuthenticationRequired;
    }

    public final byte[][] getApplicationAssociationRequest() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        byte[] pw;
        if (this.settings.getAuthentication() != Authentication.HIGH_ECDSA && this.settings.getAuthentication() != Authentication.HIGH_GMAC && (this.settings.getPassword() == null || this.settings.getPassword().length == 0)) {
            throw new IllegalArgumentException("Password is invalid.");
        }
        this.settings.resetBlockIndex();
        if (this.manufacturerId == "LGZ" && this.getAuthentication() == Authentication.HIGH) {
            byte[] pw2 = GXDLMSClient.encryptLandisGyrHighLevelAuthentication(this.settings.getPassword(), this.settings.getStoCChallenge());
            if (this.getUseLogicalNameReferencing()) {
                return this.method("0.0.40.0.0.255", ObjectType.ASSOCIATION_LOGICAL_NAME, 1, pw2, DataType.OCTET_STRING);
            }
            return this.method(64000, ObjectType.ASSOCIATION_SHORT_NAME, 8, pw2, DataType.OCTET_STRING);
        }
        if (this.settings.getAuthentication() == Authentication.HIGH_GMAC) {
            pw = this.settings.getCipher().getSystemTitle();
        } else if (this.settings.getAuthentication() == Authentication.HIGH_SHA256) {
            GXByteBuffer tmp = new GXByteBuffer();
            tmp.set(this.settings.getPassword());
            tmp.set(this.settings.getCipher().getSystemTitle());
            tmp.set(this.settings.getSourceSystemTitle());
            tmp.set(this.settings.getStoCChallenge());
            tmp.set(this.settings.getCtoSChallenge());
            pw = tmp.array();
        } else if (this.settings.getAuthentication() == Authentication.HIGH_ECDSA) {
            PublicKey pub = null;
            PrivateKey pk = null;
            if (this.settings.getCipher().getSigningKeyPair() != null) {
                pub = this.settings.getCipher().getSigningKeyPair().getPublic();
                pk = this.settings.getCipher().getSigningKeyPair().getPrivate();
            }
            if (pub == null) {
                pub = (PublicKey)this.settings.getKey(CertificateType.DIGITAL_SIGNATURE, this.settings.getSourceSystemTitle(), false);
                this.settings.getCipher().setSigningKeyPair(new KeyPair(pub, pk));
            }
            if (pk == null) {
                pk = (PrivateKey)this.settings.getKey(CertificateType.DIGITAL_SIGNATURE, this.settings.getCipher().getSystemTitle(), true);
                this.settings.getCipher().setSigningKeyPair(new KeyPair(pub, pk));
            }
            GXByteBuffer tmp = new GXByteBuffer();
            tmp.set(this.settings.getCipher().getSystemTitle());
            tmp.set(this.settings.getSourceSystemTitle());
            tmp.set(this.settings.getStoCChallenge());
            tmp.set(this.settings.getCtoSChallenge());
            LOGGER.log(Level.INFO, "StoC " + tmp.toHex(true, 0));
            pw = tmp.array();
        } else {
            pw = this.settings.getPassword();
        }
        long ic = this.settings.getCipher().getInvocationCounter();
        byte[] challenge = GXSecure.secure(this.settings, this.settings.getCipher(), ic, this.settings.getStoCChallenge(), pw);
        if (this.settings.getCipher() != null && this.settings.getIncreaseInvocationCounterForGMacAuthentication()) {
            this.settings.getCipher().setInvocationCounter(++ic);
        }
        if (this.getUseLogicalNameReferencing()) {
            return this.method("0.0.40.0.0.255", ObjectType.ASSOCIATION_LOGICAL_NAME, 1, challenge, DataType.OCTET_STRING);
        }
        return this.method(64000, ObjectType.ASSOCIATION_SHORT_NAME, 8, challenge, DataType.OCTET_STRING);
    }

    public final void parseApplicationAssociationResponse(GXByteBuffer reply) throws InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (this.manufacturerId != null && this.settings.getAuthentication() == Authentication.HIGH && "LGZ".compareTo(this.manufacturerId) == 0) {
            this.settings.setConnected(this.settings.getConnected() | 2);
        } else {
            GXDataInfo info = new GXDataInfo();
            boolean equals = false;
            long ic = 0L;
            byte[] value = (byte[])GXCommon.getData(this.settings, reply, info);
            if (value != null) {
                if (this.settings.getAuthentication() == Authentication.HIGH_ECDSA) {
                    try {
                        Signature ver;
                        if (this.settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_1) {
                            ver = Signature.getInstance("SHA256withECDSA");
                        } else if (this.settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_2) {
                            ver = Signature.getInstance("SHA384withECDSA");
                        } else {
                            throw new IllegalArgumentException("Invalid security suite.");
                        }
                        ver.initVerify(this.settings.getCipher().getSigningKeyPair().getPublic());
                        GXByteBuffer bb = new GXByteBuffer();
                        bb.set(this.settings.getSourceSystemTitle());
                        bb.set(this.settings.getCipher().getSystemTitle());
                        bb.set(this.settings.getCtoSChallenge());
                        bb.set(this.settings.getStoCChallenge());
                        ver.update(bb.array());
                        bb.size(0);
                        bb.set(value);
                        value = this.settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_1 ? GXAsn1Converter.toByteArray(new Object[]{new GXAsn1Integer(bb.subArray(0, 32)), new GXAsn1Integer(bb.subArray(32, 32))}) : GXAsn1Converter.toByteArray(new Object[]{new GXAsn1Integer(bb.subArray(0, 48)), new GXAsn1Integer(bb.subArray(48, 48))});
                        equals = ver.verify(value);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex.getMessage());
                    }
                } else {
                    byte[] secret;
                    if (this.settings.getAuthentication() == Authentication.HIGH_GMAC) {
                        secret = this.settings.getSourceSystemTitle();
                        GXByteBuffer bb = new GXByteBuffer(value);
                        bb.getUInt8();
                        ic = bb.getUInt32();
                    } else if (this.settings.getAuthentication() == Authentication.HIGH_SHA256) {
                        GXByteBuffer tmp2 = new GXByteBuffer();
                        tmp2.set(this.settings.getPassword());
                        tmp2.set(this.settings.getSourceSystemTitle());
                        tmp2.set(this.settings.getCipher().getSystemTitle());
                        tmp2.set(this.settings.getCtoSChallenge());
                        tmp2.set(this.settings.getStoCChallenge());
                        secret = tmp2.array();
                    } else {
                        secret = this.settings.getPassword();
                    }
                    byte[] tmp = GXSecure.secure(this.settings, this.settings.getCipher(), ic, this.settings.getCtoSChallenge(), secret);
                    GXByteBuffer challenge = new GXByteBuffer(tmp);
                    equals = challenge.compare(value);
                    if (!equals) {
                        String str = "Invalid StoC:" + GXCommon.toHex(value, true) + "-" + GXCommon.toHex(tmp, true);
                        LOGGER.log(Level.INFO, str);
                    }
                }
            } else {
                LOGGER.log(Level.INFO, "Server did not accept CtoS.");
            }
            if (!equals) {
                throw new GXDLMSException("parseApplicationAssociationResponse failed.  Server to Client do not match.");
            }
            this.settings.setConnected(this.settings.getConnected() | 2);
        }
    }

    public byte[][] releaseRequest() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if ((this.settings.getConnected() & 2) == 0) {
            return null;
        }
        this.setMaxReceivePDUSize(this.initializePduSize);
        GXByteBuffer buff = new GXByteBuffer();
        if (!this.useProtectedRelease) {
            buff.setUInt8(3);
            buff.setUInt8(128);
            buff.setUInt8(1);
            buff.setUInt8(0);
        } else {
            buff.setUInt8(0);
            buff.setUInt8(128);
            buff.setUInt8(1);
            buff.setUInt8(0);
            GXAPDU.generateUserInformation(this.settings, this.settings.getCipher(), null, buff);
            if (this.settings.isCiphered(false)) {
                this.settings.getCipher().setInvocationCounter(this.settings.getCipher().getInvocationCounter() + 1L);
            }
            buff.setUInt8(0, (byte)(buff.size() - 1));
        }
        if (this.getUseLogicalNameReferencing()) {
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 98, 0, buff, null, 255, 0);
            reply = GXDLMS.getLnMessages(p);
        } else {
            reply = GXDLMS.getSnMessages(new GXDLMSSNParameters(this.settings, 98, 255, 255, null, buff));
        }
        this.settings.setConnected(this.settings.getConnected() & 0xFFFFFFFD);
        this.settings.setCtoSChallenge(this.initializeChallenge);
        return (byte[][])reply.toArray((T[])new byte[0][]);
    }

    public final byte[] disconnectRequest() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.disconnectRequest(false);
    }

    public final byte[] disconnectRequest(boolean force) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (this.isPreEstablishedConnection()) {
            return new byte[0];
        }
        byte[] reply = null;
        if (force || this.settings.getConnected() != 0) {
            if (GXDLMS.useHdlc(this.getInterfaceType())) {
                reply = this.settings.getInterfaceType() == InterfaceType.PLC_HDLC ? GXDLMS.getMacHdlcFrame(this.settings, 83, 0, null) : GXDLMS.getHdlcFrame(this.settings, 83, null);
            } else if ((this.settings.getConnected() & 2) != 0) {
                reply = this.releaseRequest()[0];
            }
        }
        this.getHdlcSettings().setMaxInfoTX(this.initializeMaxInfoTX);
        this.getHdlcSettings().setMaxInfoRX(this.initializeMaxInfoRX);
        this.getHdlcSettings().setWindowSizeTX(this.initializeWindowSizeTX);
        this.getHdlcSettings().setWindowSizeRX(this.initializeWindowSizeRX);
        this.settings.setConnected(0);
        this.settings.resetFrameSequence();
        return reply;
    }

    static GXDLMSObject createDLMSObject(int classID, Object version, int baseName, Object ln, Object accessRights, int lnVersion) {
        ObjectType type = ObjectType.forValue(classID);
        GXDLMSObject obj = GXDLMSClient.createObject(type);
        GXDLMSClient.updateObjectData(obj, type, version, baseName, (byte[])ln, accessRights, lnVersion);
        return obj;
    }

    private GXDLMSObjectCollection parseSNObjects(GXByteBuffer buff, boolean onlyKnownObjects, boolean ignoreInactiveObjects) {
        buff.position(0);
        short size = buff.getUInt8();
        if (size != 1) {
            throw new GXDLMSException("Invalid response.");
        }
        GXDLMSObjectCollection items = new GXDLMSObjectCollection(this);
        long cnt = GXCommon.getObjectCount(buff);
        GXDataInfo info = new GXDataInfo();
        for (long objPos = 0L; objPos != cnt && buff.position() != buff.size(); ++objPos) {
            String str;
            info.setCount(0);
            info.setIndex(0);
            info.setType(DataType.NONE);
            List objects = (List)GXCommon.getData(this.settings, buff, info);
            if (objects.size() != 4) {
                throw new GXDLMSException("Invalid structure format.");
            }
            int classID = ((Number)objects.get(1)).intValue() & 0xFFFF;
            int baseName = ((Number)objects.get(0)).intValue() & 0xFFFF;
            if (baseName <= 0) continue;
            GXDLMSObject comp = GXDLMSClient.createDLMSObject(classID, objects.get(2), baseName, objects.get(3), null, 2);
            if (!onlyKnownObjects || comp.getClass() != GXDLMSObject.class) {
                if (!ignoreInactiveObjects || !"0.0.127.0.0.0".equals(comp.getLogicalName())) {
                    items.add(comp);
                    continue;
                }
                str = "Inactive object : " + String.valueOf(classID) + " " + String.valueOf(baseName);
                LOGGER.log(Level.FINE, str);
                continue;
            }
            str = "Unknown object : " + String.valueOf(classID) + " " + String.valueOf(baseName);
            LOGGER.log(Level.FINE, str);
        }
        return items;
    }

    private static void updateObjectData(GXDLMSObject obj, ObjectType objectType, Object version, Object baseName, byte[] logicalName, Object accessRights, int lnVersion) {
        obj.setObjectType(objectType);
        if (accessRights instanceof List && ((List)accessRights).size() == 2) {
            int tmp;
            int id;
            List access = (List)accessRights;
            for (Object attributeAccess : (List)access.get(0)) {
                id = ((Number)((List)attributeAccess).get(0)).intValue();
                if (id <= 0) continue;
                tmp = ((Number)((List)attributeAccess).get(1)).intValue();
                if (lnVersion < 3) {
                    obj.setAccess(id, AccessMode.forValue(tmp));
                    continue;
                }
                obj.setAccess3(id, AccessMode3.forValue(tmp));
            }
            for (Object methodAccess : (List)access.get(1)) {
                id = ((Number)((List)methodAccess).get(0)).intValue();
                tmp = ((List)methodAccess).get(1) instanceof Boolean ? (((Boolean)((List)methodAccess).get(1)).booleanValue() ? 1 : 0) : ((Number)((List)methodAccess).get(1)).intValue();
                if (lnVersion < 3) {
                    obj.setMethodAccess(id, MethodAccessMode.forValue(tmp));
                    continue;
                }
                obj.setMethodAccess3(id, MethodAccessMode3.forValue(tmp));
            }
        }
        if (baseName != null) {
            obj.setShortName(((Number)baseName).intValue());
        }
        if (version != null) {
            obj.setVersion(((Number)version).intValue());
        }
        obj.setLogicalName(GXCommon.toLogicalName(logicalName));
    }

    public final GXDLMSObjectCollection parseObjects(GXByteBuffer data, boolean onlyKnownObjects) {
        return this.parseObjects(data, onlyKnownObjects, true);
    }

    public final GXDLMSObjectCollection parseObjects(GXByteBuffer data, boolean onlyKnownObjects, boolean ignoreInactiveObjects) {
        GXDLMSConverter converter = new GXDLMSConverter(this.getStandard());
        return this.parseObjects(data, onlyKnownObjects, ignoreInactiveObjects, converter);
    }

    public final GXDLMSObjectCollection parseObjects(GXByteBuffer data, boolean onlyKnownObjects, boolean ignoreInactiveObjects, GXDLMSConverter converter) {
        if (data == null) {
            throw new GXDLMSException("Invalid parameter.");
        }
        GXDLMSObjectCollection objects = this.getUseLogicalNameReferencing() ? this.parseLNObjects(data, onlyKnownObjects, ignoreInactiveObjects) : this.parseSNObjects(data, onlyKnownObjects, ignoreInactiveObjects);
        this.settings.getObjects().addAll(objects);
        if (converter != null) {
            converter.updateOBISCodeInformation(objects);
        }
        return objects;
    }

    private GXDLMSObjectCollection parseLNObjects(GXByteBuffer buff, boolean onlyKnownObjects, boolean ignoreInactiveObjects) {
        byte size = buff.getInt8();
        if (size != 1) {
            throw new GXDLMSException("Invalid response.");
        }
        GXDLMSObjectCollection items = new GXDLMSObjectCollection(this);
        GXDataInfo info = new GXDataInfo();
        long cnt = GXCommon.getObjectCount(buff);
        int objectCnt = 0;
        int lnVersion = 2;
        int pos = buff.position();
        while (buff.position() != buff.size() && cnt != (long)objectCnt) {
            info.clear();
            List objects = (List)GXCommon.getData(this.settings, buff, info);
            if (objects.size() != 4) {
                throw new GXDLMSException("Invalid structure format.");
            }
            ++objectCnt;
            int ot = ((Number)objects.get(0)).intValue() & 0xFFFF;
            if (ot != ObjectType.ASSOCIATION_LOGICAL_NAME.getValue() || !"0.0.40.0.0.255".equals(GXCommon.toLogicalName((byte[])objects.get(2)))) continue;
            lnVersion = ((Number)objects.get(1)).intValue();
            break;
        }
        objectCnt = 0;
        buff.position(pos);
        for (long objPos = 0L; objPos != cnt && buff.position() != buff.size(); ++objPos) {
            String str;
            info.setType(DataType.NONE);
            info.setIndex(0);
            info.setCount(0);
            List objects = (List)GXCommon.getData(this.settings, buff, info);
            if (objects.size() != 4) {
                throw new GXDLMSException("Invalid structure format.");
            }
            int classID = ((Number)objects.get(0)).intValue() & 0xFFFF;
            if (classID <= 0) continue;
            GXDLMSObject comp = GXDLMSClient.createDLMSObject(classID, objects.get(1), 0, objects.get(2), objects.get(3), lnVersion);
            if (!onlyKnownObjects || comp.getClass() != GXDLMSObject.class) {
                if (!ignoreInactiveObjects || !"0.0.127.0.0.0".equals(comp.getLogicalName())) {
                    items.add(comp);
                    continue;
                }
                str = "Inactive object : " + String.valueOf(classID) + " " + comp.getLogicalName();
                LOGGER.log(Level.INFO, str);
                continue;
            }
            str = "Unknown object : " + String.valueOf(classID) + " " + GXCommon.toLogicalName((byte[])objects.get(2));
            LOGGER.log(Level.INFO, str);
        }
        return items;
    }

    public final Object updateValue(GXDLMSObject target, int attributeIndex, Object value) {
        return this.updateValue(target, attributeIndex, value, null);
    }

    public final Object updateValue(GXDLMSObject target, int attributeIndex, Object value, Object parameters) {
        Object val = value;
        if (val instanceof byte[]) {
            DataType type = target.getUIDataType(attributeIndex);
            if (type == DataType.DATETIME && ((byte[])val).length == 5) {
                type = DataType.DATE;
                target.setUIDataType(attributeIndex, type);
            }
            if (type != DataType.NONE) {
                val = GXDLMSClient.changeType((byte[])value, type, this.settings);
            }
        }
        ValueEventArgs e = new ValueEventArgs(this.settings, target, attributeIndex, 0, parameters);
        e.setValue(val);
        target.setValue(this.settings, e);
        return target.getValues()[attributeIndex - 1];
    }

    public static Object getValue(GXByteBuffer data) {
        GXDataInfo info = new GXDataInfo();
        return GXCommon.getData(null, data, info);
    }

    public static Object getValue(GXByteBuffer data, boolean useUtc) {
        GXDataInfo info = new GXDataInfo();
        GXDLMSSettings settings = new GXDLMSSettings(false, null);
        settings.setUseUtc2NormalTime(useUtc);
        return GXCommon.getData(settings, data, info);
    }

    public final void updateValues(List<Map.Entry<GXDLMSObject, Integer>> list, List<?> values) {
        int pos = 0;
        for (Map.Entry<GXDLMSObject, Integer> it : list) {
            ValueEventArgs e = new ValueEventArgs(this.settings, it.getKey(), (int)it.getValue(), 0, null);
            e.setValue(values.get(pos));
            it.getKey().setValue(this.settings, e);
            ++pos;
        }
    }

    public static Object changeType(byte[] value, DataType type) {
        return GXDLMSClient.changeType(value, type, false);
    }

    public static Object changeType(byte[] value, DataType type, boolean useUtc) {
        if (value == null) {
            return null;
        }
        GXDLMSSettings settings = new GXDLMSSettings(false, null);
        settings.setUseUtc2NormalTime(useUtc);
        return GXDLMSClient.changeType(value, type, settings);
    }

    public Object changeType2(byte[] value, DataType type) {
        if (value == null) {
            return null;
        }
        return GXDLMSClient.changeType(value, type, this.settings);
    }

    public static Object changeType(byte[] value, DataType type, GXDLMSSettings settings) {
        if (value == null) {
            return null;
        }
        if (type == DataType.NONE) {
            return GXCommon.toHex(value, true);
        }
        if (type == DataType.OCTET_STRING && value instanceof byte[]) {
            return new GXByteBuffer(value);
        }
        if (type == DataType.STRING && !GXByteBuffer.isAsciiString(value)) {
            return new GXByteBuffer(value);
        }
        if (value.length == 0 && (type == DataType.STRING || type == DataType.OCTET_STRING)) {
            return "";
        }
        if (value.length == 0 && type == DataType.DATETIME) {
            return new GXDateTime(new Date(0L));
        }
        if (value.length == 0 && type == DataType.DATE) {
            return new GXDate(new Date(0L));
        }
        if (value.length == 0 && type == DataType.TIME) {
            return new GXTime(new Date(0L));
        }
        GXDataInfo info = new GXDataInfo();
        info.setType(type);
        Object ret = GXCommon.getData(settings, new GXByteBuffer(value), info);
        if (!info.isComplete()) {
            throw new IllegalArgumentException("Change type failed. Not enought data.");
        }
        return ret;
    }

    public final byte[][] getObjectsRequest() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.getObjectsRequest(null);
    }

    public final byte[][] getObjectsRequest(String ln) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        this.settings.resetBlockIndex();
        Object name = this.getUseLogicalNameReferencing() ? (ln == null || ln.isEmpty() ? "0.0.40.0.0.255" : ln) : Short.valueOf((short)-1536);
        return this.read(name, ObjectType.ASSOCIATION_LOGICAL_NAME, 2);
    }

    public final byte[][] method(GXDLMSObject item, int index, Object data, DataType type) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.method(item.getName(), item.getObjectType(), index, data, type);
    }

    public final byte[][] method(Object name, ObjectType objectType, int methodIndex, Object value, DataType dataType) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.method(name, objectType, methodIndex, value, dataType, 0);
    }

    public final byte[][] method(Object name, ObjectType objectType, int methodIndex, Object value, DataType dataType, int mode) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (name == null || methodIndex < 1) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        this.settings.resetBlockIndex();
        int index = methodIndex;
        DataType type = dataType;
        if (type == DataType.NONE && value != null && (type = GXDLMSConverter.getDLMSDataType(value)) == DataType.NONE) {
            throw new GXDLMSException("Invalid parameter. In java value type must give.");
        }
        GXByteBuffer data = new GXByteBuffer();
        GXByteBuffer attributeDescriptor = new GXByteBuffer();
        GXCommon.setData(this.settings, data, type, value);
        if (this.getUseLogicalNameReferencing()) {
            attributeDescriptor.setUInt16(objectType.getValue());
            attributeDescriptor.set(GXCommon.logicalNameToBytes((String)name));
            attributeDescriptor.setUInt8((byte)methodIndex);
            if (type == DataType.NONE) {
                attributeDescriptor.setUInt8(0);
            } else {
                attributeDescriptor.setUInt8(1);
            }
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 195, 1, attributeDescriptor, data, 255, 0);
            p.accessMode = mode;
            reply = GXDLMS.getLnMessages(p);
        } else {
            int[] ind = new int[1];
            int[] count = new int[1];
            GXDLMS.getActionInfo(objectType, ind, count);
            if (index > count[0]) {
                throw new IllegalArgumentException("methodIndex");
            }
            int sn = GXCommon.intValue(name);
            index = ind[0] + (index - 1) * 8;
            attributeDescriptor.setUInt16(sn += index);
            if (type != DataType.NONE) {
                attributeDescriptor.setUInt8(1);
            } else {
                attributeDescriptor.setUInt8(0);
            }
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 6, 1, 2, attributeDescriptor, data);
            reply = GXDLMS.getSnMessages(p);
        }
        return (byte[][])reply.toArray((T[])new byte[0][]);
    }

    public final byte[][] write(GXDLMSObject item, int index) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        DataType ui;
        ValueEventArgs e = new ValueEventArgs(this.settings, item, index, 0, null);
        Object value = item.getValue(this.settings, e);
        DataType type = item.getDataType(index);
        if (type == DataType.OCTET_STRING && value instanceof String && (ui = item.getUIDataType(index)) == DataType.STRING) {
            return this.write(item.getName(), ((String)value).getBytes(), type, item.getObjectType(), index);
        }
        return this.write(item.getName(), value, type, item.getObjectType(), index);
    }

    public final byte[][] write(Object name, Object value, DataType dataType, ObjectType objectType, int index) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.write(name, value, dataType, objectType, index, 0);
    }

    final byte[][] write(Object name, Object value, DataType dataType, ObjectType objectType, int index, int mode) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (index < 1) {
            throw new GXDLMSException("Invalid parameter");
        }
        this.settings.resetBlockIndex();
        DataType type = dataType;
        if (type == DataType.NONE && value != null && (type = GXDLMSConverter.getDLMSDataType(value)) == DataType.NONE) {
            throw new GXDLMSException("Invalid parameter. In java value type must give.");
        }
        GXByteBuffer data = new GXByteBuffer();
        GXByteBuffer attributeDescriptor = new GXByteBuffer();
        GXCommon.setData(this.settings, data, type, value);
        if (this.getUseLogicalNameReferencing()) {
            attributeDescriptor.setUInt16(objectType.getValue());
            attributeDescriptor.set(GXCommon.logicalNameToBytes((String)name));
            attributeDescriptor.setUInt8(index);
            attributeDescriptor.setUInt8(0);
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 193, 1, attributeDescriptor, data, 255, 0);
            p.accessMode = mode;
            p.blockIndex = this.settings.getBlockIndex();
            p.blockNumberAck = this.settings.getBlockNumberAck();
            p.streaming = false;
            reply = GXDLMS.getLnMessages(p);
        } else {
            int sn = GXCommon.intValue(name);
            attributeDescriptor.setUInt16(sn += (index - 1) * 8);
            attributeDescriptor.setUInt8(1);
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 6, 1, 2, attributeDescriptor, data);
            reply = GXDLMS.getSnMessages(p);
        }
        return (byte[][])reply.toArray((T[])new byte[0][0]);
    }

    public final byte[][] writeList2(List<GXWriteItem> list) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        Object p;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.settings.resetBlockIndex();
        GXByteBuffer data = new GXByteBuffer();
        GXByteBuffer bb = new GXByteBuffer();
        if (this.getUseLogicalNameReferencing()) {
            bb.setUInt8(list.size());
            for (GXWriteItem it : list) {
                bb.setUInt16(it.getTarget().getObjectType().getValue());
                bb.set(GXCommon.logicalNameToBytes(it.getTarget().getLogicalName()));
                bb.setUInt8(it.getIndex());
                bb.setUInt8(0);
            }
        } else {
            for (GXWriteItem it : list) {
                bb.setUInt8(2);
                int sn = GXCommon.intValue(it.getTarget().getShortName());
                bb.setUInt16(sn += (it.getIndex() - 1) * 8);
            }
        }
        GXCommon.setObjectCount(list.size(), bb);
        for (GXWriteItem it : list) {
            ValueEventArgs e = new ValueEventArgs(this.settings, it.getTarget(), it.getIndex(), it.getSelector(), it.getParameters());
            Object value = it.getTarget().getValue(this.settings, e);
            DataType type = it.getDataType();
            if ((type == null || type == DataType.NONE) && value != null && (type = it.getTarget().getDataType(it.getIndex())) == DataType.NONE && (type = GXDLMSConverter.getDLMSDataType(value)) == DataType.NONE) {
                throw new GXDLMSException("Invalid parameter.  In java value type must give.");
            }
            GXCommon.setData(this.settings, data, type, value);
        }
        if (this.getUseLogicalNameReferencing()) {
            p = new GXDLMSLNParameters(this.settings, 0L, 193, 4, bb, data, 255, 0);
            reply = GXDLMS.getLnMessages((GXDLMSLNParameters)p);
        } else {
            p = new GXDLMSSNParameters(this.settings, 6, list.size(), 4, bb, data);
            reply = GXDLMS.getSnMessages((GXDLMSSNParameters)p);
        }
        return (byte[][])reply.toArray((T[])new byte[0][0]);
    }

    public final byte[][] writeList(List<Map.Entry<GXDLMSObject, Integer>> list) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (!this.getNegotiatedConformance().contains((Object)Conformance.MULTIPLE_REFERENCES)) {
            throw new IllegalArgumentException("Meter doesn't support multiple objects writing with one request.");
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.settings.resetBlockIndex();
        GXByteBuffer data = new GXByteBuffer();
        GXByteBuffer bb = new GXByteBuffer();
        if (this.getUseLogicalNameReferencing()) {
            bb.setUInt8(list.size());
            for (Map.Entry<GXDLMSObject, Integer> entry : list) {
                bb.setUInt16(entry.getKey().getObjectType().getValue());
                bb.set(GXCommon.logicalNameToBytes(entry.getKey().getLogicalName()));
                bb.setUInt8(entry.getValue());
                bb.setUInt8(0);
            }
        } else {
            for (Map.Entry<GXDLMSObject, Integer> entry : list) {
                bb.setUInt8(2);
                int n = GXCommon.intValue(entry.getKey().getShortName());
                bb.setUInt16(n += (entry.getValue() - 1) * 8);
            }
        }
        GXCommon.setObjectCount(list.size(), bb);
        for (Map.Entry<GXDLMSObject, Integer> entry : list) {
            ValueEventArgs valueEventArgs = new ValueEventArgs(this.settings, entry.getKey(), (int)entry.getValue(), 0, null);
            Object value = entry.getKey().getValue(this.settings, valueEventArgs);
            DataType type = entry.getKey().getDataType(entry.getValue());
            if ((type == null || type == DataType.NONE) && value != null && (type = GXDLMSConverter.getDLMSDataType(value)) == DataType.NONE) {
                throw new GXDLMSException("Invalid parameter.  In java value type must give.");
            }
            GXCommon.setData(this.settings, data, type, value);
        }
        if (this.getUseLogicalNameReferencing()) {
            int mode = 0;
            for (Map.Entry<GXDLMSObject, Integer> entry : list) {
                int m = AccessMode3.toInteger(entry.getKey().getAccess3(entry.getValue()));
                if (m <= mode) continue;
                mode = m;
            }
            GXDLMSLNParameters gXDLMSLNParameters = new GXDLMSLNParameters(this.settings, 0L, 193, 4, bb, data, 255, 0);
            gXDLMSLNParameters.accessMode = mode;
            reply = GXDLMS.getLnMessages(gXDLMSLNParameters);
        } else {
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 6, list.size(), 4, bb, data);
            reply = GXDLMS.getSnMessages(p);
        }
        return (byte[][])reply.toArray((T[])new byte[0][0]);
    }

    public final byte[][] read(Object name, ObjectType objectType, int attributeOrdinal) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.read(name, objectType, attributeOrdinal, null, 0);
    }

    private byte[][] read(Object name, ObjectType objectType, int attributeOrdinal, GXByteBuffer data, int mode) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (attributeOrdinal < 1) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        GXByteBuffer attributeDescriptor = new GXByteBuffer();
        this.settings.resetBlockIndex();
        if (this.getUseLogicalNameReferencing()) {
            attributeDescriptor.setUInt16(objectType.getValue());
            attributeDescriptor.set(GXCommon.logicalNameToBytes((String)name));
            attributeDescriptor.setUInt8(attributeOrdinal);
            if (data == null || data.size() == 0) {
                attributeDescriptor.setUInt8(0);
            } else {
                attributeDescriptor.setUInt8(1);
            }
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 192, 1, attributeDescriptor, data, 255, 0);
            p.accessMode = mode;
            reply = GXDLMS.getLnMessages(p);
        } else {
            int sn = GXCommon.intValue(name);
            attributeDescriptor.setUInt16(sn += (attributeOrdinal - 1) * 8);
            int requestType = data != null && data.size() != 0 ? 4 : 2;
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 5, 1, requestType, attributeDescriptor, data);
            reply = GXDLMS.getSnMessages(p);
        }
        return (byte[][])reply.toArray((T[])new byte[0][0]);
    }

    public final byte[][] read(GXDLMSObject item, int attributeOrdinal) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.read(item.getName(), item.getObjectType(), attributeOrdinal);
    }

    public final byte[][] readList(List<Map.Entry<GXDLMSObject, Integer>> list) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        if (!this.getNegotiatedConformance().contains((Object)Conformance.MULTIPLE_REFERENCES)) {
            throw new IllegalArgumentException("Meter doesn't support multiple objects reading with one request.");
        }
        ArrayList<byte[]> messages = new ArrayList<byte[]>();
        GXByteBuffer data = new GXByteBuffer();
        this.settings.resetBlockIndex();
        if (this.getUseLogicalNameReferencing()) {
            int mode = 0;
            for (Map.Entry<GXDLMSObject, Integer> it : list) {
                int m = AccessMode3.toInteger(it.getKey().getAccess3(it.getValue()));
                if (m <= mode) continue;
                mode = m;
            }
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 192, 3, data, null, 255, 0);
            p.accessMode = mode;
            int pos = 0;
            int count = (this.settings.getMaxPduSize() - 12) / 10;
            if (list.size() < count) {
                count = list.size();
            }
            if (count > 10) {
                count = 10;
            }
            GXCommon.setObjectCount(count, data);
            for (Map.Entry<GXDLMSObject, Integer> it : list) {
                data.setUInt16(it.getKey().getObjectType().getValue());
                List<String> items = GXCommon.split(it.getKey().getLogicalName(), '.');
                if (items.size() != 6) {
                    throw new IllegalArgumentException("Invalid Logical Name.");
                }
                for (String it2 : items) {
                    data.setUInt8(Integer.valueOf(it2).byteValue());
                }
                data.setUInt8(it.getValue());
                data.setUInt8(0);
                if (++pos % count != 0 || list.size() == pos) continue;
                messages.addAll(GXDLMS.getLnMessages(p));
                data.clear();
                if (list.size() - pos < count) {
                    GXCommon.setObjectCount(list.size() - pos, data);
                    continue;
                }
                GXCommon.setObjectCount(count, data);
            }
            messages.addAll(GXDLMS.getLnMessages(p));
        } else {
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 5, list.size(), 255, data, null);
            for (Map.Entry<GXDLMSObject, Integer> it : list) {
                data.setUInt8(2);
                int sn = GXCommon.intValue(it.getKey().getShortName());
                data.setUInt16(sn += (it.getValue() - 1) * 8);
            }
            messages.addAll(GXDLMS.getSnMessages(p));
        }
        return (byte[][])messages.toArray((T[])new byte[0][0]);
    }

    public final byte[] keepAlive() {
        if (this.getInterfaceType() == InterfaceType.WRAPPER) {
            return new byte[0];
        }
        return GXDLMS.getHdlcFrame(this.settings, this.settings.getReceiverReady(), null);
    }

    public final byte[][] readRowsByEntry(GXDLMSProfileGeneric pg, int index, int count) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.readRowsByEntry(pg, index, count, null);
    }

    public final byte[][] readRowsByEntry(GXDLMSProfileGeneric pg, int index, int count, List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> columns) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        int pos = 0;
        int columnStart = 1;
        int columnEnd = 0;
        if (columns != null && !columns.isEmpty()) {
            if (pg.getCaptureObjects() == null || pg.getCaptureObjects().isEmpty()) {
                throw new IllegalArgumentException("Read capture objects first.");
            }
            columnStart = pg.getCaptureObjects().size();
            columnEnd = 1;
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> c : columns) {
                pos = 0;
                boolean found = false;
                for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : pg.getCaptureObjects()) {
                    ++pos;
                    if (it.getKey().getObjectType() != c.getKey().getObjectType() || it.getKey().getLogicalName().compareTo(c.getKey().getLogicalName()) != 0 || it.getValue().getAttributeIndex() != c.getValue().getAttributeIndex() || it.getValue().getDataIndex() != c.getValue().getDataIndex()) continue;
                    found = true;
                    if (pos < columnStart) {
                        columnStart = pos;
                    }
                    columnEnd = pos;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Invalid column: " + c.getKey().getLogicalName());
            }
        }
        return this.readRowsByEntry(pg, index, count, columnStart, columnEnd);
    }

    public final byte[][] readRowsByEntry(GXDLMSProfileGeneric pg, int index, int count, int columnStart, int columnEnd) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (pg.getCaptureObjects().isEmpty()) {
            throw new RuntimeException("Capture objects not read.");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (columnStart < 1) {
            throw new IllegalArgumentException("columnStart");
        }
        if (columnEnd < 0) {
            throw new IllegalArgumentException("columnEnd");
        }
        pg.clearBuffer();
        GXByteBuffer buff = new GXByteBuffer(19);
        buff.setUInt8(2);
        buff.setUInt8(DataType.STRUCTURE.getValue());
        buff.setUInt8(4);
        GXCommon.setData(this.settings, buff, DataType.UINT32, index);
        if (count == 0) {
            GXCommon.setData(this.settings, buff, DataType.UINT32, count);
        } else {
            GXCommon.setData(this.settings, buff, DataType.UINT32, index + count - 1);
        }
        GXCommon.setData(this.settings, buff, DataType.UINT16, columnStart);
        GXCommon.setData(this.settings, buff, DataType.UINT16, columnEnd);
        int mode = AccessMode3.toInteger(pg.getAccess3(2));
        return this.read(pg.getName(), ObjectType.PROFILE_GENERIC, 2, buff, mode);
    }

    public final byte[][] readRowsByRange(GXDLMSProfileGeneric pg, GXDateTime start, GXDateTime end) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.readByRange(pg, start, end, null);
    }

    public final byte[][] readRowsByRange(GXDLMSProfileGeneric pg, Date start, Date end) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.readByRange(pg, start, end, null);
    }

    public final byte[][] readRowsByRange(GXDLMSProfileGeneric pg, Date start, Date end, List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> columns) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.readByRange(pg, start, end, columns);
    }

    public final byte[][] readRowsByRange(GXDLMSProfileGeneric pg, Calendar start, Calendar end) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.readByRange(pg, start, end, null);
    }

    public final byte[][] readRowsByRange(GXDLMSProfileGeneric pg, Calendar start, Calendar end, List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> columns) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.readByRange(pg, start, end, columns);
    }

    private byte[][] readByRange(GXDLMSProfileGeneric pg, Object start, Object end, List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> columns) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (pg.getCaptureObjects().isEmpty()) {
            throw new RuntimeException("Capture objects not read.");
        }
        pg.clearBuffer();
        this.settings.resetBlockIndex();
        GXDateTime s = GXCommon.getDateTime(start);
        GXDateTime e = GXCommon.getDateTime(end);
        GXDLMSObject sort = pg.getSortObject();
        if (sort == null) {
            sort = pg.getCaptureObjects().get(0).getKey();
        }
        String ln = "0.0.1.0.0.255";
        ObjectType type = ObjectType.CLOCK;
        ClockType clockType = ClockType.CLOCK;
        if (sort instanceof GXDLMSData) {
            if ("0.0.1.1.0.255".equals(sort.getLogicalName())) {
                clockType = ClockType.UNIX;
                ln = "0.0.1.1.0.255";
                type = ObjectType.DATA;
            } else if ("0.0.1.2.0.255".equals(sort.getLogicalName())) {
                clockType = ClockType.HIGH_RESOLUTION;
                ln = "0.0.1.2.0.255";
                type = ObjectType.DATA;
            }
        }
        GXByteBuffer buff = new GXByteBuffer(51);
        buff.setUInt8(1);
        buff.setUInt8(DataType.STRUCTURE.getValue());
        buff.setUInt8(4);
        buff.setUInt8(DataType.STRUCTURE.getValue());
        buff.setUInt8(4);
        GXCommon.setData(this.settings, buff, DataType.UINT16, type.getValue());
        GXCommon.setData(this.settings, buff, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(ln));
        GXCommon.setData(this.settings, buff, DataType.INT8, 2);
        GXCommon.setData(this.settings, buff, DataType.UINT16, 0);
        if (clockType == ClockType.CLOCK) {
            GXCommon.setData(this.settings, buff, DataType.OCTET_STRING, s);
            GXCommon.setData(this.settings, buff, DataType.OCTET_STRING, e);
        } else if (clockType == ClockType.UNIX) {
            GXCommon.setData(this.settings, buff, DataType.UINT32, GXDateTime.toUnixTime(s));
            GXCommon.setData(this.settings, buff, DataType.UINT32, GXDateTime.toUnixTime(e));
        } else if (clockType == ClockType.HIGH_RESOLUTION) {
            GXCommon.setData(this.settings, buff, DataType.UINT64, GXDateTime.toHighResolutionTime(s));
            GXCommon.setData(this.settings, buff, DataType.UINT64, GXDateTime.toHighResolutionTime(e));
        }
        buff.setUInt8(DataType.ARRAY.getValue());
        if (columns == null) {
            buff.setUInt8(0);
        } else {
            GXCommon.setObjectCount(columns.size(), buff);
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : columns) {
                buff.setUInt8(DataType.STRUCTURE.getValue());
                buff.setUInt8(4);
                GXCommon.setData(this.settings, buff, DataType.UINT16, it.getKey().getObjectType().getValue());
                GXCommon.setData(this.settings, buff, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getKey().getLogicalName()));
                GXCommon.setData(this.settings, buff, DataType.INT8, it.getValue().getAttributeIndex());
                GXCommon.setData(this.settings, buff, DataType.INT16, it.getValue().getDataIndex());
            }
        }
        int mode = AccessMode3.toInteger(pg.getAccess3(2));
        return this.read(pg.getName(), ObjectType.PROFILE_GENERIC, 2, buff, mode);
    }

    public static GXDLMSObject createObject(ObjectType type) {
        return GXDLMS.createObject(type);
    }

    public final byte[] receiverReady(RequestTypes type) {
        return GXDLMS.receiverReady(this.settings, type);
    }

    public final byte[] receiverReady(Set<RequestTypes> type) {
        return GXDLMS.receiverReady(this.settings, type);
    }

    public final byte[] receiverReady(GXReplyData reply) {
        try {
            return GXDLMS.receiverReady(this.settings, reply);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final boolean getData(byte[] reply, GXReplyData data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.getData(new GXByteBuffer(reply), data, null);
    }

    public final boolean getData(byte[] reply, GXReplyData data, GXReplyData notify) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.getData(new GXByteBuffer(reply), data, notify);
    }

    public final boolean getData(GXByteBuffer reply, GXReplyData data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.getData(reply, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getData(GXByteBuffer reply, GXReplyData data, GXReplyData notify) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        data.setXml(null);
        boolean ret = false;
        try {
            ret = GXDLMS.getData(this.settings, reply, data, notify);
        }
        catch (Exception ex) {
            if (this.translator == null || this.throwExceptions) {
                throw ex;
            }
            ret = true;
        }
        if (ret && this.translator != null && data.getMoreData().isEmpty()) {
            if (data.getXml() == null) {
                data.setXml(new GXDLMSTranslatorStructure(this.translator.getOutputType(), this.translator.isOmitXmlNameSpace(), this.translator.isHex(), this.translator.getShowStringAsHex(), this.translator.isComments(), this.translator.tags));
            }
            int pos = data.getData().position();
            try {
                GXByteBuffer data2 = data.getData();
                if (data.getCommand() == 196) {
                    GXByteBuffer tmp = new GXByteBuffer(4 + data.getData().size());
                    tmp.setUInt8(data.getCommand());
                    tmp.setUInt8(1);
                    tmp.setUInt8((byte)data.getInvokeId());
                    tmp.setUInt8(0);
                    tmp.set(data.getData());
                    data.setData(tmp);
                } else if (data.getCommand() == 199) {
                    GXByteBuffer tmp = new GXByteBuffer(6 + data.getData().size());
                    tmp.setUInt8(data.getCommand());
                    tmp.setUInt8(1);
                    tmp.setUInt8((byte)data.getInvokeId());
                    tmp.setUInt8(0);
                    tmp.setUInt8(1);
                    tmp.setUInt8(0);
                    tmp.set(data.getData());
                    data.setData(tmp);
                } else if (data.getCommand() == 12) {
                    GXByteBuffer tmp = new GXByteBuffer(3 + data.getData().size());
                    tmp.setUInt8(data.getCommand());
                    tmp.setUInt8(2);
                    tmp.setUInt8((byte)data.getInvokeId());
                    tmp.setUInt8(0);
                    tmp.set(data.getData());
                    data.setData(tmp);
                }
                data.getData().position(0);
                if (data.getCommand() == 147 || data.getCommand() == 115) {
                    data.getXml().appendStartTag(data.getCommand());
                    if (data.getData().size() != 0) {
                        this.translator.pduToXml(data.getXml(), data.getData(), this.translator.isOmitXmlDeclaration(), this.translator.isOmitXmlNameSpace(), true, null);
                    }
                    data.getXml().appendEndTag(data.getCommand());
                } else {
                    if (data.getData().size() != 0) {
                        this.translator.pduToXml(data.getXml(), data.getData(), this.translator.isOmitXmlDeclaration(), this.translator.isOmitXmlNameSpace(), true, null);
                    }
                    data.setData(data2);
                }
            }
            finally {
                data.getData().position(pos);
            }
        }
        return ret;
    }

    public static int getServerAddress(int serialNumber) {
        return GXDLMSClient.getServerAddress(serialNumber, null);
    }

    public static int getServerAddress(int serialNumber, String formula) {
        if (formula == null || formula.length() == 0) {
            return 0x4000 | SerialNumberCounter.count(serialNumber, "SN % 10000 + 1000");
        }
        return 0x4000 | SerialNumberCounter.count(serialNumber, formula);
    }

    public static int getServerAddress(int logicalAddress, int physicalAddress) {
        return GXDLMSClient.getServerAddress(logicalAddress, physicalAddress, 0);
    }

    public static int getServerAddress(int logicalAddress, int physicalAddress, int addressSize) {
        if (addressSize < 4 && physicalAddress < 128 && logicalAddress < 128) {
            return logicalAddress << 7 | physicalAddress;
        }
        if (physicalAddress < 16384 && logicalAddress < 16384) {
            return logicalAddress << 14 | physicalAddress;
        }
        throw new IllegalArgumentException("Invalid logical or physical address.");
    }

    public final byte[][] accessRequest(Date time, List<GXDLMSAccessItem> list) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        GXCommon.setObjectCount(list.size(), bb);
        int mode = 0;
        for (GXDLMSAccessItem it : list) {
            bb.setUInt8(it.getCommand());
            bb.setUInt16(it.getTarget().getObjectType().getValue());
            bb.set(GXCommon.logicalNameToBytes(it.getTarget().getLogicalName()));
            bb.setUInt8(it.getIndex());
            int m = AccessMode3.toInteger(it.getTarget().getAccess3(it.getIndex()));
            if (m <= mode) continue;
            mode = m;
        }
        GXCommon.setObjectCount(list.size(), bb);
        for (GXDLMSAccessItem it : list) {
            if (it.getCommand() == 1) {
                bb.setUInt8(0);
                continue;
            }
            if (it.getCommand() == 2 || it.getCommand() == 3) {
                Object value = ((IGXDLMSBase)((Object)it.getTarget())).getValue(this.settings, new ValueEventArgs(it.getTarget(), it.getIndex(), 0, null));
                DataType type = it.getTarget().getDataType(it.getIndex());
                if (type == DataType.NONE) {
                    type = GXDLMSConverter.getDLMSDataType(value);
                }
                GXCommon.setData(this.settings, bb, type, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid command.");
        }
        GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 217, 255, null, bb, 255, 0);
        p.accessMode = mode;
        if (time != null && time != new Date(0L)) {
            p.setTime(new GXDateTime(time));
        }
        return (byte[][])GXDLMS.getLnMessages(p).toArray((T[])new byte[0][0]);
    }

    public final void parseAccessResponse(List<GXDLMSAccessItem> list, GXByteBuffer data) {
        GXDataInfo info = new GXDataInfo();
        int cnt = GXCommon.getObjectCount(data);
        if (list.size() != cnt) {
            throw new IllegalArgumentException("List size and values size do not match.");
        }
        for (GXDLMSAccessItem it : list) {
            info.clear();
            it.setValue(GXCommon.getData(this.settings, data, info));
        }
        cnt = GXCommon.getObjectCount(data);
        if (list.size() != cnt) {
            throw new IllegalArgumentException("List size and values size do not match.");
        }
        for (GXDLMSAccessItem it : list) {
            data.getUInt8();
            it.setError(ErrorCode.forValue(data.getUInt8()));
            if (it.getCommand() != 1 || it.getError() != ErrorCode.OK) continue;
            ValueEventArgs ve = new ValueEventArgs(this.settings, it.getTarget(), it.getIndex(), 0, null);
            ve.setValue(it.getValue());
            ((IGXDLMSBase)((Object)it.getTarget())).setValue(this.settings, ve);
        }
    }

    public static Set<Conformance> getInitialConformance(boolean useLogicalNameReferencing) {
        HashSet<Conformance> list = new HashSet<Conformance>();
        if (useLogicalNameReferencing) {
            list.addAll(Arrays.asList(Conformance.BLOCK_TRANSFER_WITH_ACTION, Conformance.BLOCK_TRANSFER_WITH_SET_OR_WRITE, Conformance.BLOCK_TRANSFER_WITH_GET_OR_READ, Conformance.SET, Conformance.SELECTIVE_ACCESS, Conformance.ACTION, Conformance.MULTIPLE_REFERENCES, Conformance.GET, Conformance.ACCESS, Conformance.GENERAL_PROTECTION, Conformance.DELTA_VALUE_ENCODING));
        } else {
            list.addAll(Arrays.asList(Conformance.INFORMATION_REPORT, Conformance.READ, Conformance.UN_CONFIRMED_WRITE, Conformance.WRITE, Conformance.PARAMETERIZED_ACCESS, Conformance.MULTIPLE_REFERENCES, Conformance.DELTA_VALUE_ENCODING));
        }
        return list;
    }

    public Object parseReport(GXReplyData reply, List<Map.Entry<GXDLMSObject, Integer>> list) throws Exception {
        if (reply.getCommand() == 194) {
            GXDLMSLNCommandHandler.handleEventNotification(this.settings, reply, list);
            return null;
        }
        if (reply.getCommand() == 24) {
            GXDLMSSNCommandHandler.handleInformationReport(this.settings, reply, list);
            return null;
        }
        if (reply.getCommand() == 15) {
            return reply.getValue();
        }
        throw new IllegalArgumentException("Invalid command. " + reply.getCommand());
    }

    public final List<Map.Entry<GXDLMSObject, Integer>> parsePushObjects(List<?> data) {
        ArrayList<Map.Entry<GXDLMSObject, Integer>> objects = new ArrayList<Map.Entry<GXDLMSObject, Integer>>();
        if (data != null) {
            GXDLMSConverter c = new GXDLMSConverter(this.getStandard());
            for (Object it : data) {
                List tmp = (List)it;
                int classID = ((Number)tmp.get(0)).intValue() & 0xFFFF;
                if (classID <= 0) continue;
                GXDLMSObject comp = this.getObjects().findByLN(ObjectType.forValue(classID), GXCommon.toLogicalName((byte[])tmp.get(1)));
                if (comp == null) {
                    comp = GXDLMSClient.createDLMSObject(classID, 0, 0, tmp.get(1), null, 2);
                    this.settings.getObjects().add(comp);
                    c.updateOBISCodeInformation(comp);
                }
                if (comp.getClass() != GXDLMSObject.class) {
                    objects.add(new GXSimpleEntry<GXDLMSObject, Integer>(comp, ((Number)tmp.get(2)).intValue()));
                    continue;
                }
                String str = "Unknown object: " + String.valueOf(classID) + " " + GXCommon.toLogicalName((byte[])tmp.get(1));
                LOGGER.log(Level.INFO, str);
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getFrameSize(GXByteBuffer data) {
        int ret;
        switch (this.getInterfaceType()) {
            case HDLC: 
            case HDLC_WITH_MODE_E: {
                ret = 0;
                int index = data.position();
                try {
                    short ch;
                    if (data.available() <= 8) break;
                    for (int pos = data.position(); pos < data.size() && (ch = data.getUInt8()) != 126; ++pos) {
                    }
                    short frame = data.getUInt8();
                    if ((frame & 7) != 0) {
                        ret = (frame & 7) << 8;
                    }
                    ret += data.getUInt8();
                    break;
                }
                finally {
                    data.position(index);
                }
            }
            case WRAPPER: {
                if (data.available() < 8 || data.getUInt16(data.position()) != 1) {
                    ret = 8 - data.available();
                    break;
                }
                ret = 8 + data.getUInt16(data.position() + 6) - data.available();
                break;
            }
            case PLC: {
                if (data.available() < 2 || data.getUInt8(data.position()) != 2) {
                    ret = 2 - data.available();
                    break;
                }
                ret = 2 + data.getUInt8(data.position() + 1) - data.available();
                break;
            }
            case PLC_HDLC: {
                ret = GXDLMS.getPlcSfskFrameSize(data) - data.available();
                if (ret >= 2) break;
                ret = 36 - data.available() % 36;
                break;
            }
            default: {
                ret = 1;
            }
        }
        if (ret < 1) {
            ret = 1;
        }
        return ret;
    }

    boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    void setThrowExceptions(boolean value) {
        this.throwExceptions = value;
    }

    public static void getHdlcAddressInfo(GXByteBuffer reply, int[] target, int[] source, short[] type) {
        GXDLMS.getHdlcAddressInfo(reply, target, source, type);
    }

    public void setUseProtectedRelease(boolean protectedRelease) {
        this.useProtectedRelease = protectedRelease;
    }

    public boolean getUseProtectedRelease() {
        return this.useProtectedRelease;
    }

    public String getManufacturerId() {
        return this.manufacturerId;
    }

    public void setManufacturerId(String value) {
        if (value != null && value.length() != 3) {
            throw new IllegalArgumentException("Manufacturer ID is 3 chars long string");
        }
        this.manufacturerId = value;
    }

    public static byte[] encryptLandisGyrHighLevelAuthentication(byte[] password, byte[] seed) {
        byte[] crypted = (byte[])seed.clone();
        for (int pos = 0; pos != password.length; ++pos) {
            if (password[pos] != 48) {
                int n = pos;
                crypted[n] = (byte)(crypted[n] + (password[pos] - 48));
                if (crypted[pos] > 57 && crypted[pos] < 65) {
                    int n2 = pos;
                    crypted[n2] = (byte)(crypted[n2] + 7);
                }
            }
            if (crypted[pos] <= 70) continue;
            crypted[pos] = (byte)(48 + crypted[pos] - 71);
        }
        return crypted;
    }

    public final boolean getOverwriteAttributeAccessRights() {
        return this.settings.getOverwriteAttributeAccessRights();
    }

    public final void setOverwriteAttributeAccessRights(boolean value) {
        this.settings.setOverwriteAttributeAccessRights(value);
    }

    public final boolean canRead(GXDLMSObject target, int index) {
        Set<AccessMode3> m;
        if ((target.getAccess(index).getValue() & AccessMode.READ.getValue()) == 0 && !(m = target.getAccess3(index)).isEmpty()) {
            if (!m.contains((Object)AccessMode3.READ)) {
                return false;
            }
            Security security = Security.NONE;
            Signing signing = Signing.NONE;
            if (this.settings.getCipher() != null) {
                security = this.settings.getCipher().getSecurity();
                signing = this.settings.getCipher().getSigning();
            }
            if (m.contains((Object)AccessMode3.AUTHENTICATED_REQUEST) || m.contains((Object)AccessMode3.AUTHENTICATED_RESPONSE) && (security.getValue() & Security.AUTHENTICATION.getValue()) == 0) {
                return false;
            }
            if (m.contains((Object)AccessMode3.ENCRYPTED_REQUEST) || m.contains((Object)AccessMode3.ENCRYPTED_RESPONSE) && (security.getValue() & Security.ENCRYPTION.getValue()) == 0) {
                return false;
            }
            if (m.contains((Object)AccessMode3.DIGITALLY_SIGNED_REQUEST) || m.contains((Object)AccessMode3.DIGITALLY_SIGNED_RESPONSE) && (signing.ordinal() & Signing.GENERAL_SIGNING.ordinal()) == 0) {
                return false;
            }
        }
        return true;
    }

    public final boolean canWrite(GXDLMSObject target, int index) {
        Set<AccessMode3> m;
        if ((target.getAccess(index).getValue() & AccessMode.WRITE.getValue()) == 0 && !(m = target.getAccess3(index)).isEmpty()) {
            if (!m.contains((Object)AccessMode3.WRITE)) {
                return false;
            }
            Security security = Security.NONE;
            Signing signing = Signing.NONE;
            if (this.settings.getCipher() != null) {
                security = this.settings.getCipher().getSecurity();
                signing = this.settings.getCipher().getSigning();
            }
            if (m.contains((Object)AccessMode3.AUTHENTICATED_REQUEST) || m.contains((Object)AccessMode3.AUTHENTICATED_RESPONSE) && (security.getValue() & Security.AUTHENTICATION.getValue()) == 0) {
                return false;
            }
            if (m.contains((Object)AccessMode3.ENCRYPTED_REQUEST) || m.contains((Object)AccessMode3.ENCRYPTED_RESPONSE) && (security.getValue() & Security.ENCRYPTION.getValue()) == 0) {
                return false;
            }
            if (m.contains((Object)AccessMode3.DIGITALLY_SIGNED_REQUEST) || m.contains((Object)AccessMode3.DIGITALLY_SIGNED_RESPONSE) && (signing.ordinal() & Signing.GENERAL_SIGNING.ordinal()) == 0) {
                return false;
            }
        }
        return true;
    }

    public final boolean canInvoke(GXDLMSObject target, int index) {
        Set<MethodAccessMode3> m;
        if (target.getMethodAccess(index).getValue() == MethodAccessMode.NO_ACCESS.getValue() && !(m = target.getMethodAccess3(index)).isEmpty()) {
            if (!m.contains((Object)MethodAccessMode3.ACCESS)) {
                return false;
            }
            Security security = Security.NONE;
            Signing signing = Signing.NONE;
            if (this.settings.getCipher() != null) {
                security = this.settings.getCipher().getSecurity();
                signing = this.settings.getCipher().getSigning();
            }
            if (m.contains((Object)MethodAccessMode3.AUTHENTICATED_REQUEST) || m.contains((Object)MethodAccessMode3.AUTHENTICATED_RESPONSE) && (security.getValue() & Security.AUTHENTICATION.getValue()) == 0) {
                return false;
            }
            if (m.contains((Object)MethodAccessMode3.ENCRYPTED_REQUEST) || m.contains((Object)MethodAccessMode3.ENCRYPTED_RESPONSE) && (security.getValue() & Security.ENCRYPTION.getValue()) == 0) {
                return false;
            }
            if (m.contains((Object)MethodAccessMode3.DIGITALLY_SIGNED_REQUEST) || m.contains((Object)MethodAccessMode3.DIGITALLY_SIGNED_RESPONSE) && (signing.ordinal() & Signing.GENERAL_SIGNING.ordinal()) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isPreEstablishedConnection() {
        return this.settings.getPreEstablishedSystemTitle() != null;
    }
}

