/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXAPDU;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSLNCommandHandler;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSSNCommandHandler;
import gurux.dlms.GXDLMSSNParameters;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslatorMessage;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.GXDLMSXmlSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXReplyData;
import gurux.dlms.HdlcFrameType;
import gurux.dlms.IGXCryptoNotifier;
import gurux.dlms.ReleaseRequestReason;
import gurux.dlms.ReleaseResponseReason;
import gurux.dlms.Service;
import gurux.dlms.ServiceError;
import gurux.dlms.TranslatorOutputType;
import gurux.dlms.TranslatorSimpleTags;
import gurux.dlms.TranslatorStandardTags;
import gurux.dlms.enums.AssociationResult;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.Command;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.RequestTypes;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.enums.SourceDiagnostic;
import gurux.dlms.internal.CoAPContentType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.plc.enums.PlcDestinationAddress;
import gurux.dlms.plc.enums.PlcSourceAddress;
import gurux.dlms.secure.AesGcmParameter;
import gurux.dlms.secure.GXCiphering;
import java.io.StringReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GXDLMSTranslator {
    HashMap<Integer, String> tags = new HashMap();
    HashMap<String, Integer> tagsByName = new HashMap();
    private boolean hex = true;
    private boolean showStringAsHex;
    private boolean multipleFrames = false;
    private GXByteBuffer pduFrames = new GXByteBuffer();
    private boolean pduOnly;
    private final TranslatorOutputType outputType;
    private boolean omitXmlDeclaration = false;
    private boolean omitXmlNameSpace = false;
    private boolean comments = false;
    private Security security = Security.NONE;
    private SecuritySuite securitySuite = SecuritySuite.SUITE_0;
    private byte[] systemTitle;
    private byte[] serverSystemTitle;
    private byte[] dedicatedKey;
    private byte[] blockCipherKey;
    private byte[] authenticationKey;
    private int invocationCounter;
    private boolean useGeneralProtection;
    private boolean completePdu;

    public GXDLMSTranslator() {
        this(TranslatorOutputType.SIMPLE_XML);
    }

    public GXDLMSTranslator(TranslatorOutputType type) {
        this.outputType = type;
        GXDLMSTranslator.getTags(this.outputType, this.tags, this.tagsByName);
    }

    public final TranslatorOutputType getOutputType() {
        return this.outputType;
    }

    public final boolean getPduOnly() {
        return this.pduOnly;
    }

    public final void setPduOnly(boolean value) {
        this.pduOnly = value;
    }

    public final Security getSecurity() {
        return this.security;
    }

    public final void setSecurity(Security value) {
        this.security = value;
    }

    public final SecuritySuite getSecuritySuite() {
        return this.securitySuite;
    }

    public final void setSecuritySuite(SecuritySuite value) {
        this.securitySuite = value;
    }

    public final byte[] getSystemTitle() {
        return this.systemTitle;
    }

    public final void setSystemTitle(byte[] value) {
        this.systemTitle = value;
    }

    public byte[] getServerSystemTitle() {
        return this.serverSystemTitle;
    }

    public void setServerSystemTitle(byte[] value) {
        this.serverSystemTitle = value;
    }

    public byte[] getDedicatedKey() {
        return this.dedicatedKey;
    }

    public void setDedicatedKey(byte[] value) {
        this.dedicatedKey = value;
    }

    public final byte[] getBlockCipherKey() {
        return this.blockCipherKey;
    }

    public final void setBlockCipherKey(byte[] value) {
        this.blockCipherKey = value;
    }

    public final byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public final void setAuthenticationKey(byte[] value) {
        this.authenticationKey = value;
    }

    public final int getInvocationCounter() {
        return this.invocationCounter;
    }

    public final void setInvocationCounter(int value) {
        this.invocationCounter = value;
    }

    public static byte[] hexToBytes(String value) {
        if (value == null) {
            return new byte[0];
        }
        return GXCommon.hexToBytes(value.replace("\r\n", "").replace("\n", ""));
    }

    public static String toHex(byte[] bytes) {
        return GXCommon.toHex(bytes, true);
    }

    public static String toHex(byte[] bytes, boolean addSpace) {
        return GXCommon.toHex(bytes, addSpace);
    }

    public final boolean getCompletePdu() {
        return this.completePdu;
    }

    public final void setCompletePdu(boolean value) {
        this.completePdu = value;
    }

    public final void setCompleatePdu(boolean value) {
        this.completePdu = value;
    }

    public final boolean getShowStringAsHex() {
        return this.showStringAsHex;
    }

    public final void setShowStringAsHex(boolean value) {
        this.showStringAsHex = value;
    }

    public final boolean findNextFrame(GXByteBuffer data, GXByteBuffer pdu) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXDLMSSettings settings = new GXDLMSSettings(true, null);
        GXReplyData reply = new GXReplyData();
        reply.setXml(new GXDLMSTranslatorStructure(this.outputType, this.isOmitXmlNameSpace(), this.hex, this.getShowStringAsHex(), this.comments, this.tags));
        while (data.position() < data.size()) {
            boolean found;
            int pos;
            if (data.getUInt8(data.position()) == 126) {
                pos = data.position();
                settings.setInterfaceType(InterfaceType.HDLC);
                found = GXDLMS.getData(settings, data, reply, null);
                data.position(pos);
                if (found) {
                    break;
                }
            } else if (data.getUInt16(data.position()) == 1) {
                pos = data.position();
                settings.setInterfaceType(InterfaceType.WRAPPER);
                found = GXDLMS.getData(settings, data, reply, null);
                data.position(pos);
                if (found) {
                    break;
                }
            } else if (GXDLMS.isWiredMBusData(data)) {
                pos = data.position();
                found = GXDLMS.getData(settings, data, reply, null);
                data.position(pos);
                if (found) break;
            }
            data.position(data.position() + 1);
        }
        if (pdu != null) {
            pdu.clear();
            pdu.set(reply.getData().getData(), 0, reply.getData().size());
        }
        return data.position() != data.size();
    }

    public final boolean findNextFrame(GXByteBuffer data, GXByteBuffer pdu, InterfaceType type) {
        GXDLMSSettings settings = new GXDLMSSettings(true, null);
        settings.setInterfaceType(type);
        GXReplyData reply = new GXReplyData();
        reply.setXml(new GXDLMSTranslatorStructure(this.outputType, this.omitXmlNameSpace, this.hex, this.getShowStringAsHex(), this.comments, this.tags));
        try {
            while (data.position() < data.size()) {
                boolean found;
                int pos;
                if (type == InterfaceType.HDLC && data.getUInt8(data.position()) == 126 || data.available() > 1 && type == InterfaceType.WRAPPER && data.getUInt16(data.position()) == 1) {
                    pos = data.position();
                    found = GXDLMS.getData(settings, data, reply, null);
                    data.position(pos);
                    if (found) {
                        break;
                    }
                } else if (type == InterfaceType.WIRELESS_MBUS) {
                    pos = data.position();
                    settings.setInterfaceType(InterfaceType.WIRELESS_MBUS);
                    found = GXDLMS.getData(settings, data, reply, null);
                    data.position(pos);
                    if (found) break;
                }
                data.position(data.position() + 1);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid DLMS frame.");
        }
        if (pdu != null) {
            pdu.clear();
            pdu.set(reply.getData().getData(), 0, reply.getData().size());
        }
        return data.position() != data.size();
    }

    static void addTag(HashMap<Integer, String> list, int value, String text) {
        list.put(value, text);
    }

    private static void getTags(TranslatorOutputType type, HashMap<Integer, String> list, HashMap<String, Integer> tagsByName) {
        if (type == TranslatorOutputType.SIMPLE_XML) {
            TranslatorSimpleTags.getGeneralTags(type, list);
            TranslatorSimpleTags.getSnTags(type, list);
            TranslatorSimpleTags.getLnTags(type, list);
            TranslatorSimpleTags.getGloTags(type, list);
            TranslatorSimpleTags.getDedTags(type, list);
            TranslatorSimpleTags.getTranslatorTags(type, list);
            TranslatorSimpleTags.getDataTypeTags(list);
            TranslatorSimpleTags.getPlcTags(list);
        } else {
            TranslatorStandardTags.getGeneralTags(type, list);
            TranslatorStandardTags.getSnTags(type, list);
            TranslatorStandardTags.getLnTags(type, list);
            TranslatorStandardTags.getGloTags(type, list);
            TranslatorStandardTags.getDedTags(type, list);
            TranslatorStandardTags.getTranslatorTags(type, list);
            TranslatorStandardTags.getDataTypeTags(list);
            TranslatorStandardTags.getPlcTags(list);
        }
        boolean lowercase = type == TranslatorOutputType.SIMPLE_XML;
        for (Map.Entry<Integer, String> it : list.entrySet()) {
            String str = it.getValue();
            if (lowercase) {
                str = str.toLowerCase();
            }
            if (tagsByName.containsKey(str)) continue;
            tagsByName.put(str, it.getKey());
        }
    }

    final byte[] getPdu(byte[] value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.getPdu(new GXByteBuffer(value));
    }

    public static InterfaceType getDlmsFraming(GXByteBuffer value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        for (int pos = value.position(); pos != value.size(); ++pos) {
            if (value.getUInt8(pos) == 126) {
                return InterfaceType.HDLC;
            }
            if (value.available() > 1 && value.getUInt16(pos) == 1) {
                return InterfaceType.WRAPPER;
            }
            if (value.getUInt8(pos) == 2) {
                return InterfaceType.PLC;
            }
            if (value.getUInt8(pos) == 104) {
                return InterfaceType.WIRED_MBUS;
            }
            if (GXDLMS.isCoAPData(value)) {
                return InterfaceType.COAP;
            }
            if (GXDLMS.isWirelessMBusData(value)) {
                return InterfaceType.WIRELESS_MBUS;
            }
            if (GXDLMS.getPlcSfskFrameSize(value) == 0) continue;
            return InterfaceType.PLC_HDLC;
        }
        throw new IllegalArgumentException("Invalid DLMS framing.");
    }

    final byte[] getPdu(GXByteBuffer value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        InterfaceType framing = GXDLMSTranslator.getDlmsFraming(value);
        GXReplyData data = new GXReplyData();
        data.setXml(new GXDLMSTranslatorStructure(this.outputType, this.omitXmlNameSpace, this.hex, this.getShowStringAsHex(), this.comments, this.tags));
        GXDLMSSettings settings = new GXDLMSSettings(true, this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null);
        settings.setInterfaceType(framing);
        GXDLMS.getData(settings, value, data, null);
        return data.getData().array();
    }

    private void getCiphering(GXDLMSSettings settings, boolean force) {
        if (force || this.security != Security.NONE) {
            GXCiphering c = new GXCiphering(this.systemTitle);
            c.setSecurity(this.security);
            c.setSecuritySuite(this.securitySuite);
            c.setSystemTitle(this.systemTitle);
            c.setBlockCipherKey(this.blockCipherKey);
            c.setAuthenticationKey(this.authenticationKey);
            c.setInvocationCounter(this.invocationCounter);
            if (this.dedicatedKey != null && this.dedicatedKey.length != 0) {
                c.setDedicatedKey(this.dedicatedKey);
            }
            if (this.serverSystemTitle != null && this.serverSystemTitle.length != 0) {
                settings.setSourceSystemTitle(this.serverSystemTitle);
            }
            if (this.useGeneralProtection) {
                settings.getProposedConformance().add(Conformance.GENERAL_PROTECTION);
                settings.getNegotiatedConformance().add(Conformance.GENERAL_PROTECTION);
            } else {
                settings.getProposedConformance().remove((Object)Conformance.GENERAL_PROTECTION);
                settings.getNegotiatedConformance().remove((Object)Conformance.GENERAL_PROTECTION);
            }
            settings.setCipher(c);
        } else {
            settings.setCipher(null);
        }
    }

    public void clear() {
        this.multipleFrames = false;
        this.pduFrames.clear();
    }

    public final String messageToXml(byte[] value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.messageToXml(new GXByteBuffer(value));
    }

    private void checkFrame(short frame, GXDLMSTranslatorStructure xml) {
        if (frame == 147) {
            xml.appendComment("SNRM frame.");
        } else if (frame == 115) {
            xml.appendComment("UA frame.");
        } else if ((frame & HdlcFrameType.S_FRAME.getValue()) == HdlcFrameType.S_FRAME.getValue()) {
            xml.appendComment("S frame.");
        } else if ((frame & 1) == HdlcFrameType.U_FRAME.getValue()) {
            xml.appendComment("U frame.");
        } else if (frame == 16) {
            xml.appendComment("AARQ frame.");
        } else if (frame == 48) {
            xml.appendComment("AARE frame.");
        } else {
            xml.appendComment("I frame.");
        }
    }

    public final String messageToXml(GXByteBuffer value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXDLMSTranslatorMessage msg = new GXDLMSTranslatorMessage();
        msg.setMessage(value);
        this.messageToXml(msg);
        return msg.getXml();
    }

    private static void updateAddress(GXDLMSSettings settings, GXDLMSTranslatorMessage msg) {
        Boolean reply = false;
        switch (msg.getCommand()) {
            case 5: 
            case 6: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 37: 
            case 38: 
            case 65: 
            case 69: 
            case 70: 
            case 83: 
            case 96: 
            case 98: 
            case 147: 
            case 192: 
            case 193: 
            case 195: 
            case 200: 
            case 201: 
            case 203: 
            case 208: 
            case 209: 
            case 211: 
            case 217: 
            case 230: {
                reply = false;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 56: 
            case 72: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 88: 
            case 97: 
            case 99: 
            case 115: 
            case 151: 
            case 194: 
            case 196: 
            case 197: 
            case 199: 
            case 202: 
            case 204: 
            case 205: 
            case 207: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 231: {
                reply = true;
            }
        }
        if (reply.booleanValue()) {
            msg.setTargetAddress(settings.getClientAddress());
            msg.setSourceAddress(settings.getServerAddress());
        } else {
            msg.setSourceAddress(settings.getClientAddress());
            msg.setTargetAddress(settings.getServerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageToXml(GXDLMSTranslatorMessage msg) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (msg.getMessage() == null || msg.getMessage().size() == 0) {
            throw new IllegalArgumentException("value");
        }
        try {
            GXDLMSTranslatorStructure xml = new GXDLMSTranslatorStructure(this.outputType, this.omitXmlNameSpace, this.hex, this.getShowStringAsHex(), this.comments, this.tags);
            GXReplyData data = new GXReplyData();
            data.setXml(xml);
            GXByteBuffer value = msg.getMessage();
            int offset = value.position();
            GXDLMSSettings settings = new GXDLMSSettings(true, this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null);
            this.getCiphering(settings, true);
            if (value.getUInt8(value.position()) == 126) {
                settings.setInterfaceType(InterfaceType.HDLC);
                if (GXDLMS.getData(settings, value, data, null)) {
                    msg.setMoreData(data.getMoreData());
                    msg.setSourceAddress(data.getSourceAddress());
                    msg.setTargetAddress(data.getTargetAddress());
                    if (!this.getPduOnly()) {
                        xml.appendLine("<HDLC len=\"" + xml.integerToHex((long)data.getPacketLength() - (long)offset, 0) + "\" >");
                        xml.appendLine("<TargetAddress Value=\"" + xml.integerToHex(settings.getServerAddress(), 0) + "\" />");
                        xml.appendLine("<SourceAddress Value=\"" + xml.integerToHex(settings.getClientAddress(), 0) + "\" />");
                        if (this.comments) {
                            this.checkFrame(data.getFrameId(), xml);
                        }
                        xml.appendLine("<FrameType Value=\"" + xml.integerToHex(data.getFrameId(), 2, true) + "\" />");
                    }
                    if (data.getData().size() == 0) {
                        if ((data.getFrameId() & 1) != 0 && data.getCommand() == 0) {
                            if (!this.getCompletePdu()) {
                                xml.appendLine("<Command Value=\"NextFrame\" />");
                            }
                            this.multipleFrames = true;
                        } else {
                            msg.setCommand(data.getCommand());
                            xml.appendStartTag(data.getCommand());
                            xml.appendEndTag(data.getCommand());
                        }
                    } else if (this.multipleFrames || data.isMoreData()) {
                        if (this.getCompletePdu()) {
                            this.pduFrames.set(data.getData().getData());
                            if (data.getMoreData().isEmpty()) {
                                xml.appendLine(this.pduToXml(this.pduFrames, true, true, msg));
                                this.pduFrames.clear();
                            }
                        } else {
                            xml.appendLine("<NextFrame Value=\"" + GXCommon.toHex(data.getData().getData(), false, data.getData().position(), data.getData().size() - data.getData().position()) + "\" />");
                        }
                        if (data.getMoreData().contains((Object)RequestTypes.DATABLOCK)) {
                            this.multipleFrames = false;
                        }
                    } else {
                        if (!this.getPduOnly()) {
                            xml.appendLine("<PDU>");
                        }
                        if (this.pduFrames.size() != 0) {
                            this.pduFrames.set(data.getData().getData());
                            xml.appendLine(this.pduToXml(this.pduFrames, true, true, msg));
                            this.pduFrames.clear();
                        } else if (data.getCommand() == 147 || data.getCommand() == 115) {
                            xml.appendStartTag(data.getCommand());
                            this.pduToXml(xml, data.getData(), true, true, true, msg);
                            xml.appendEndTag(data.getCommand());
                            xml.setXmlLength(xml.getXmlLength() + 2);
                        } else {
                            xml.appendLine(this.pduToXml(data.getData(), true, true, msg));
                        }
                        xml.trim();
                        if (!this.getPduOnly()) {
                            xml.appendLine("</PDU>");
                        }
                    }
                    if (!this.getPduOnly()) {
                        xml.appendLine("</HDLC>");
                    }
                }
                msg.setXml(xml.toString());
                return;
            }
            if (value.getUInt16(value.position()) == 1) {
                settings.setInterfaceType(InterfaceType.WRAPPER);
                GXDLMS.getData(settings, value, data, null);
                if (msg.getCommand() == 96) {
                    msg.setSystemTitle(settings.getCipher().getSystemTitle());
                } else if (msg.getCommand() == 97) {
                    msg.setSystemTitle(settings.getSourceSystemTitle());
                }
                if (!this.getPduOnly()) {
                    xml.appendLine("<WRAPPER len=\"" + xml.integerToHex((long)data.getPacketLength() - (long)offset, 0) + "\" >");
                    xml.appendLine("<TargetAddress Value=\"" + xml.integerToHex(settings.getClientAddress(), 0) + "\" />");
                    xml.appendLine("<SourceAddress Value=\"" + xml.integerToHex(settings.getServerAddress(), 0) + "\" />");
                }
                if (data.getData().size() == 0) {
                    xml.appendLine("<Command Value=\"" + Command.toString(data.getCommand()) + "\" />");
                } else {
                    if (!this.getPduOnly()) {
                        xml.appendLine("<PDU>");
                    }
                    xml.appendLine(this.pduToXml(data.getData(), true, true, msg));
                    xml.trim();
                    if (!this.getPduOnly()) {
                        xml.appendLine("</PDU>");
                    }
                }
                if (!this.getPduOnly()) {
                    xml.appendLine("</WRAPPER>");
                }
                msg.setXml(xml.toString());
                return;
            }
            if (value.getUInt8(value.position()) == 2) {
                msg.setInterfaceType(InterfaceType.PLC);
                settings.setInterfaceType(InterfaceType.PLC);
                GXDLMS.getData(settings, value, data, null);
                if (msg.getCommand() == 96) {
                    msg.setSystemTitle(settings.getCipher().getSystemTitle());
                } else if (msg.getCommand() == 97) {
                    msg.setSystemTitle(settings.getSourceSystemTitle());
                }
                if (!this.pduOnly) {
                    xml.appendLine("<Plc len=\"" + xml.integerToHex((long)data.getPacketLength() - (long)offset, 0) + "\" >");
                    if (this.comments) {
                        if (data.getClientAddress() == PlcSourceAddress.INITIATOR.getValue()) {
                            xml.appendComment("Initiator");
                        } else if (data.getClientAddress() == PlcSourceAddress.NEW.getValue()) {
                            xml.appendComment("New");
                        }
                    }
                    xml.appendLine("<SourceAddress Value=\"" + xml.integerToHex(data.getClientAddress(), 0) + "\" />");
                    if (this.comments && data.getServerAddress() == PlcDestinationAddress.ALL_PHYSICAL.getValue()) {
                        xml.appendComment("AllPhysical");
                    }
                    xml.appendLine("<DestinationAddress Value=\"" + xml.integerToHex(data.getServerAddress(), 0) + "\" />");
                }
                if (data.getData().size() == 0) {
                    xml.appendLine("<Command Value=\"" + Command.toString(data.getCommand()) + "\" />");
                } else {
                    if (!this.pduOnly) {
                        xml.appendLine("<PDU>");
                    }
                    xml.appendLine(this.pduToXml(data.getData(), this.omitXmlDeclaration, this.omitXmlNameSpace, msg));
                    xml.trim();
                    if (!this.pduOnly) {
                        xml.appendLine("</PDU>");
                    }
                }
                if (!this.pduOnly) {
                    xml.appendLine("</Plc>");
                }
                msg.setXml(xml.toString());
                return;
            }
            if (GXDLMS.getPlcSfskFrameSize(value) != 0) {
                msg.setInterfaceType(InterfaceType.PLC_HDLC);
                settings.setInterfaceType(InterfaceType.PLC_HDLC);
                GXDLMS.getData(settings, value, data, null);
                if (msg.getCommand() == 96) {
                    msg.setSystemTitle(settings.getCipher().getSystemTitle());
                } else if (msg.getCommand() == 97) {
                    msg.setSystemTitle(settings.getSourceSystemTitle());
                }
                if (!this.pduOnly) {
                    xml.appendLine("<PlcSFsk len=\"" + xml.integerToHex((long)data.getPacketLength() - (long)offset, 0) + "\" >");
                    if (this.comments) {
                        if (data.getClientAddress() == PlcSourceAddress.INITIATOR.getValue()) {
                            xml.appendComment("Initiator");
                        } else if (data.getClientAddress() == PlcSourceAddress.NEW.getValue()) {
                            xml.appendComment("New");
                        }
                    }
                    xml.appendLine("<SourceAddress Value=\"" + xml.integerToHex(data.getClientAddress(), 0) + "\" />");
                    if (this.comments && data.getServerAddress() == PlcDestinationAddress.ALL_PHYSICAL.getValue()) {
                        xml.appendComment("AllPhysical");
                    }
                    xml.appendLine("<DestinationAddress Value=\"" + xml.integerToHex(data.getServerAddress(), 0) + "\" />");
                }
                if (data.getData().size() == 0) {
                    xml.appendLine("<Command Value=\"" + Command.toString(data.getCommand()) + "\" />");
                } else {
                    if (!this.pduOnly) {
                        xml.appendLine("<PDU>");
                    }
                    xml.appendLine(this.pduToXml(data.getData(), this.omitXmlDeclaration, this.omitXmlNameSpace, msg));
                    xml.trim();
                    if (!this.pduOnly) {
                        xml.appendLine("</PDU>");
                    }
                }
                if (!this.pduOnly) {
                    xml.appendLine("</PlcSFsk>");
                }
                msg.setXml(xml.toString());
                return;
            }
            if (msg.getInterfaceType() == InterfaceType.WIRED_MBUS || msg.getInterfaceType() == InterfaceType.HDLC || GXDLMS.isWiredMBusData(msg.getMessage())) {
                msg.setInterfaceType(InterfaceType.WIRED_MBUS);
                settings.setInterfaceType(InterfaceType.WIRED_MBUS);
                int len = xml.getXmlLength();
                GXDLMS.getData(settings, value, data, null);
                if (msg.getCommand() == 96) {
                    msg.setSystemTitle(settings.getCipher().getSystemTitle());
                } else if (msg.getCommand() == 97) {
                    msg.setSystemTitle(settings.getSourceSystemTitle());
                }
                String tmp = xml.toString().substring(len);
                xml.setXmlLength(len);
                if (!this.getPduOnly()) {
                    xml.appendLine("<WiredMBus len=\"" + xml.integerToHex((long)data.getPacketLength() - (long)offset, 0) + "\" >");
                    xml.appendLine("<TargetAddress Value=\"" + xml.integerToHex(settings.getServerAddress(), 0) + "\" />");
                    xml.appendLine("<SourceAddress Value=\"" + xml.integerToHex(settings.getClientAddress(), 0) + "\" />");
                    xml.append(tmp);
                }
                if (data.getData().size() == 0) {
                    xml.appendLine("<Command Value=\"" + Command.toString(data.getCommand()) + "\" />");
                } else if (this.multipleFrames || data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                    if (this.completePdu) {
                        this.pduFrames.set(data.getData().getData());
                        if (data.getMoreData().isEmpty()) {
                            xml.appendLine(this.pduToXml(this.pduFrames, true, true, msg));
                            this.pduFrames.clear();
                        }
                    } else {
                        xml.appendLine("<NextFrame Value=\"" + GXCommon.toHex(data.getData().getData(), false, data.getData().position(), data.getData().size() - data.getData().position()) + "\" />");
                    }
                    if (data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                        this.multipleFrames = true;
                    }
                    if (RequestTypes.toInteger(data.getMoreData()) == RequestTypes.DATABLOCK.getValue()) {
                        this.multipleFrames = false;
                    }
                } else {
                    if (!this.pduOnly) {
                        xml.appendLine("<PDU>");
                    }
                    if (this.pduFrames.size() != 0) {
                        this.pduFrames.set(data.getData());
                        data.getData().clear();
                        data.getData().set(this.pduFrames);
                    }
                    xml.appendLine(this.pduToXml(data.getData(), this.omitXmlDeclaration, this.omitXmlNameSpace, msg));
                    xml.trim();
                    if (!this.pduOnly) {
                        xml.appendLine("</PDU>");
                    }
                }
                if (!this.pduOnly) {
                    xml.appendLine("</WiredMBus>");
                }
                GXDLMSTranslator.updateAddress(settings, msg);
                msg.setXml(xml.toString());
                return;
            }
            if (msg.getInterfaceType() == InterfaceType.COAP || msg.getInterfaceType() == InterfaceType.HDLC || GXDLMS.isCoAPData(msg.getMessage())) {
                msg.setInterfaceType(InterfaceType.COAP);
                settings.setInterfaceType(InterfaceType.COAP);
                settings.getCoap().reset();
                GXDLMS.getData(settings, msg.getMessage(), data, null);
                msg.setMoreData(data.getMoreData());
                if (!this.pduOnly) {
                    xml.appendLine("<CoAP len=\"" + xml.integerToHex(data.getData().size(), 0, this.hex) + "\" >");
                    switch (settings.getCoap().getClassCode()) {
                        case METHOD: {
                            xml.appendLine("<Code Value=\"Method." + (Object)((Object)settings.getCoap().getMethod()) + "\" />");
                            break;
                        }
                        case SUCCESS: {
                            xml.appendLine("<Code Value=\"Success." + (Object)((Object)settings.getCoap().getSuccess()) + "\" />");
                            break;
                        }
                        case CLIENT_ERROR: {
                            xml.appendLine("<Code Value=\"ClientError." + (Object)((Object)settings.getCoap().getClientError()) + "\" />");
                            break;
                        }
                        case SERVER_ERROR: {
                            xml.appendLine("<Code Value=\"ServerError." + (Object)((Object)settings.getCoap().getServerError()) + "\" />");
                            break;
                        }
                        case SIGNALING: {
                            xml.appendLine("<Code Value=\"Signaling." + (Object)((Object)settings.getCoap().getSignaling()) + "\" />");
                        }
                    }
                    xml.appendLine("<MessageId Value=\"" + settings.getCoap().getMessageId() + "\" />");
                    xml.appendLine("<Token Value=\"" + settings.getCoap().getToken() + "\" />");
                    if (settings.getCoap().getHost() != null) {
                        xml.appendLine("<Host Value=\"" + settings.getCoap().getHost() + "\" />");
                    }
                    if (settings.getCoap().getPort() != 0) {
                        xml.appendLine("<Port Value=\"" + settings.getCoap().getPort() + "\" />");
                    }
                    if (settings.getCoap().getPath() != null) {
                        xml.appendLine("<Path Value=\"" + settings.getCoap().getPath() + "\" />");
                    }
                    if (settings.getCoap().getContentFormat() != CoAPContentType.NONE) {
                        xml.appendLine("<ContentType Value=\"" + (Object)((Object)settings.getCoap().getContentFormat()) + "\" />");
                    }
                    if (settings.getCoap().getIfNoneMatch() != CoAPContentType.NONE) {
                        xml.appendLine("<IfNoneMatch Value=\"" + (Object)((Object)settings.getCoap().getIfNoneMatch()) + "\" />");
                    }
                    if (settings.getCoap().getMaxAge() != 0) {
                        xml.appendLine("<MaxAge Value=\"" + settings.getCoap().getMaxAge() + "\" />");
                    }
                    if (data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                        xml.appendLine("<MoreData BlockNumber=\"" + settings.getCoap().getBlockNumber() + "\" />");
                    }
                    for (int it : settings.getCoap().getOptions().keySet()) {
                        Object tmp = settings.getCoap().getOptions().get(it);
                        if (tmp instanceof byte[]) {
                            xml.appendLine("<Unknown " + it + " Value=\"0x" + GXDLMSTranslator.toHex((byte[])tmp) + "\" />");
                            continue;
                        }
                        xml.appendLine("<Unknown " + it + " Value=\"" + tmp + "\" />");
                    }
                }
                if (!this.pduOnly) {
                    xml.appendLine("<PDU>");
                }
                String pdu = null;
                if (!this.multipleFrames && data.getMoreData().isEmpty() && data.getData().getData() != null) {
                    pdu = this.pduToXml(data.getData(), this.omitXmlDeclaration, this.omitXmlNameSpace, msg);
                } else {
                    this.multipleFrames = true;
                    if (!this.completePdu) {
                        if (data.getData().size() != 0) {
                            pdu = "<Block Value=\"" + GXCommon.toHex(data.getData().getData(), false, data.getData().position(), data.getData().size() - data.getData().position()) + "\" />";
                        }
                    } else {
                        this.pduFrames.set(data.getData().getData());
                    }
                    if (this.pduFrames.size() != 0 && data.getMoreData().isEmpty()) {
                        this.multipleFrames = false;
                        try {
                            pdu = this.pduToXml(this.pduFrames, this.omitXmlDeclaration, this.omitXmlNameSpace, msg);
                        }
                        finally {
                            this.pduFrames.clear();
                        }
                    } else {
                        this.multipleFrames = true;
                    }
                }
                if (pdu != null) {
                    xml.appendLine(pdu);
                }
                xml.trim();
                if (!this.pduOnly) {
                    xml.appendLine("</PDU>");
                }
                if (!this.pduOnly) {
                    xml.appendLine("</CoAP>");
                }
                GXDLMSTranslator.updateAddress(settings, msg);
                msg.setXml(xml.toString());
                return;
            }
            if ((msg.getInterfaceType() == InterfaceType.HDLC || msg.getInterfaceType() == InterfaceType.WIRELESS_MBUS) && GXDLMS.isWirelessMBusData(msg.getMessage())) {
                msg.setInterfaceType(InterfaceType.WIRELESS_MBUS);
                settings.setInterfaceType(InterfaceType.WIRELESS_MBUS);
                int len = xml.getXmlLength();
                GXDLMS.getData(settings, msg.getMessage(), data, null);
                msg.setMoreData(data.getMoreData());
                msg.setSourceAddress(data.getSourceAddress());
                msg.setTargetAddress(data.getTargetAddress());
                String tmp = xml.toString().substring(len);
                xml.setXmlLength(len);
                if (!this.pduOnly) {
                    xml.appendLine("<WirelessMBus len=\"" + xml.integerToHex(data.getPacketLength() - offset, 0, this.hex) + "\" >");
                    xml.appendLine("<TargetAddress Value=\"" + xml.integerToHex(data.getServerAddress(), 0) + "\" />");
                    xml.appendLine("<SourceAddress Value=\"" + xml.integerToHex(data.getClientAddress(), 0) + "\" />");
                    xml.append(tmp);
                }
                if (data.getData().size() == 0) {
                    xml.appendLine("<Command Value=\"" + Command.toString(data.getCommand()) + "\" />");
                } else {
                    if (!this.pduOnly) {
                        xml.appendLine("<PDU>");
                    }
                    xml.appendLine(this.pduToXml(data.getData(), this.omitXmlDeclaration, this.omitXmlNameSpace, msg));
                    xml.trim();
                    if (!this.pduOnly) {
                        xml.appendLine("</PDU>");
                    }
                }
                if (!this.pduOnly) {
                    xml.appendLine("</WirelessMBus>");
                }
                GXDLMSTranslator.updateAddress(settings, msg);
                msg.setXml(xml.toString());
                return;
            }
            if (msg.getInterfaceType() == InterfaceType.SMS && msg.getMessage().available() > 2) {
                msg.setInterfaceType(InterfaceType.SMS);
                settings.setInterfaceType(InterfaceType.SMS);
                GXDLMS.getData(settings, msg.getMessage(), data, null);
                msg.setMoreData(data.getMoreData());
                msg.setSourceAddress(data.getSourceAddress());
                msg.setTargetAddress(data.getTargetAddress());
                String pdu = this.pduToXml(data.getData(), this.omitXmlDeclaration, this.omitXmlNameSpace, msg);
                if (!this.pduOnly) {
                    xml.appendLine("<SMS len=\"" + xml.integerToHex(data.getData().size(), 0, this.hex) + "\" >");
                    xml.appendLine("<Destination AP Value=\"" + xml.integerToHex(data.getClientAddress(), 0) + "\" />");
                    xml.appendLine("<Source AP Value=\"" + xml.integerToHex(data.getServerAddress(), 0) + "\" />");
                }
                if (!this.pduOnly) {
                    xml.appendLine("<PDU>");
                }
                xml.appendLine(pdu);
                xml.trim();
                if (!this.pduOnly) {
                    xml.appendLine("</PDU>");
                }
                if (!this.pduOnly) {
                    xml.appendLine("</SMS>");
                }
                GXDLMSTranslator.updateAddress(settings, msg);
                msg.setXml(xml.toString());
                return;
            }
        }
        catch (RuntimeException ex) {
            Logger.getLogger(GXDLMSTranslator.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        throw new IllegalArgumentException("Invalid DLMS framing.");
    }

    public final String pduToXml(String pdu) {
        return this.pduToXml(GXDLMSTranslator.hexToBytes(pdu));
    }

    public final String pduToXml(byte[] value) {
        GXByteBuffer tmp = new GXByteBuffer(value);
        return this.pduToXml(tmp);
    }

    private void getUa(GXByteBuffer data, GXDLMSTranslatorStructure xml) {
        data.getUInt8();
        data.getUInt8();
        data.getUInt8();
        block11: while (data.position() < data.size()) {
            Number val;
            short id = data.getUInt8();
            short len = data.getUInt8();
            switch (len) {
                case 1: {
                    val = data.getUInt8();
                    break;
                }
                case 2: {
                    val = data.getUInt16();
                    break;
                }
                case 4: {
                    val = data.getUInt32();
                    break;
                }
                default: {
                    throw new GXDLMSException("Invalid Exception.");
                }
            }
            switch (id) {
                case 5: {
                    xml.appendLine("<MaxInfoTX Value=\"" + val.toString() + "\" />");
                    continue block11;
                }
                case 6: {
                    xml.appendLine("<MaxInfoRX Value=\"" + val.toString() + "\" />");
                    continue block11;
                }
                case 7: {
                    xml.appendLine("<WindowSizeTX Value=\"" + val.toString() + "\" />");
                    continue block11;
                }
                case 8: {
                    xml.appendLine("<WindowSizeRX Value=\"" + val.toString() + "\" />");
                    continue block11;
                }
            }
            throw new GXDLMSException("Invalid UA response.");
        }
    }

    public final String pduToXml(GXByteBuffer value) {
        return this.pduToXml(value, this.omitXmlDeclaration, this.omitXmlNameSpace, null);
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean value) {
        this.comments = value;
    }

    private String pduToXml(GXByteBuffer value, boolean omitDeclaration, boolean omitNameSpace, GXDLMSTranslatorMessage arg) {
        GXDLMSTranslatorStructure xml = new GXDLMSTranslatorStructure(this.outputType, this.omitXmlNameSpace, this.hex, this.getShowStringAsHex(), this.comments, this.tags);
        return this.pduToXml(xml, value, omitDeclaration, omitNameSpace, true, arg);
    }

    private void handleDiscoverRequest(GXReplyData data) {
        short responseProbability = data.getData().getUInt8();
        short allowedTimeSlots = data.getData().getUInt8();
        short discoverReportInitialCredit = data.getData().getUInt8();
        short icEqualCredit = data.getData().getUInt8();
        data.getXml().appendLine("<ResponseProbability Value=\"" + String.valueOf(responseProbability) + "\" />");
        data.getXml().appendLine("<AllowedTimeSlots Value=\"" + String.valueOf(allowedTimeSlots) + "\" />");
        data.getXml().appendLine("<DiscoverReportInitialCredit Value=\"" + String.valueOf(discoverReportInitialCredit) + "\" />");
        data.getXml().appendLine("<ICEqualCredit Value=\"" + String.valueOf(icEqualCredit) + "\" />");
    }

    private void handleRegisterRequest(InterfaceType interfaceType, GXReplyData data) {
        byte[] st = interfaceType == InterfaceType.PLC_HDLC ? new byte[8] : new byte[6];
        data.getData().get(st);
        data.getXml().appendLine("<ActiveInitiator Value=\"" + GXCommon.toHex(st, true) + "\" />");
        int count = data.getData().getUInt8();
        for (int pos = 0; pos != count; ++pos) {
            data.getData().get(st);
            data.getXml().appendLine("<SystemTitle Value=\"" + GXCommon.toHex(st, true) + "\" />");
            int address = data.getData().getUInt16();
            data.getXml().appendLine("<MacAddress Value=\"" + String.valueOf(address) + "\" />");
        }
    }

    private void handleDiscoverResponse(GXDLMSSettings settings, GXReplyData data) {
        int count = data.getData().getUInt8();
        for (int pos = 0; pos != count; ++pos) {
            byte[] st = settings.getInterfaceType() == InterfaceType.PLC ? new byte[6] : new byte[8];
            data.getData().get(st);
            data.getXml().appendLine("<SystemTitle Value=\"" + GXCommon.toHex(st, true) + "\" />");
        }
        if (data.getData().getUInt8() != 0) {
            short alarmDescriptor = data.getData().getUInt8();
            data.getXml().appendLine("<AlarmDescriptor Value=\"" + String.valueOf(alarmDescriptor) + "\" />");
        }
    }

    String pduToXml(GXDLMSTranslatorStructure xml, GXByteBuffer value, boolean omitDeclaration, boolean omitNameSpace, boolean allowUnknownCommand, GXDLMSTranslatorMessage msg) {
        if (value == null || value.size() == 0) {
            throw new IllegalArgumentException("value");
        }
        try {
            GXDLMSSettings settings = new GXDLMSSettings(true, this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null);
            short cmd = value.getUInt8();
            if (msg != null) {
                msg.setCommand(cmd);
            }
            this.getCiphering(settings, GXCommon.isCiphered(cmd));
            GXReplyData data = new GXReplyData();
            switch (cmd) {
                case 96: {
                    value.position(0);
                    GXAPDU.parsePDU(settings, settings.getCipher(), value, xml);
                    if (settings.getCipher() != null && settings.getCipher().getDedicatedKey() != null) {
                        this.setDedicatedKey(settings.getCipher().getDedicatedKey());
                    }
                    if (msg == null) break;
                    msg.setSystemTitle(settings.getSourceSystemTitle());
                    msg.setDedicatedKey(settings.getCipher().getDedicatedKey());
                    break;
                }
                case 1: {
                    value.position(0);
                    settings = new GXDLMSSettings(true, this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null);
                    GXAPDU.parseInitiate(true, settings, settings.getCipher(), value, xml);
                    break;
                }
                case 8: {
                    value.position(0);
                    settings = new GXDLMSSettings(false, this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null);
                    this.getCiphering(settings, true);
                    GXAPDU.parseInitiate(true, settings, settings.getCipher(), value, xml);
                    break;
                }
                case 129: {
                    if (msg != null) {
                        msg.setCommand(115);
                    }
                    value.position(0);
                    this.getUa(value, xml);
                    break;
                }
                case 97: {
                    value.position(0);
                    settings = new GXDLMSSettings(false, this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null);
                    this.getCiphering(settings, true);
                    GXAPDU.parsePDU(settings, settings.getCipher(), value, xml);
                    if (msg == null) break;
                    msg.setSystemTitle(settings.getSourceSystemTitle());
                    break;
                }
                case 192: {
                    GXDLMSLNCommandHandler.handleGetRequest(settings, null, value, null, xml, 0);
                    break;
                }
                case 193: {
                    GXDLMSLNCommandHandler.handleSetRequest(settings, null, value, null, xml, 0);
                    break;
                }
                case 5: {
                    GXDLMSSNCommandHandler.handleReadRequest(settings, null, value, null, xml, 0);
                    break;
                }
                case 195: {
                    GXDLMSLNCommandHandler.handleMethodRequest(settings, null, value, null, null, xml, 0);
                    break;
                }
                case 6: {
                    GXDLMSSNCommandHandler.handleWriteRequest(settings, null, value, null, xml, 0);
                    break;
                }
                case 217: {
                    GXDLMSLNCommandHandler.handleAccessRequest(settings, null, value, null, xml, 0);
                    break;
                }
                case 15: {
                    data.setXml(xml);
                    data.setData(value);
                    value.position(0);
                    GXDLMS.getPdu(settings, data);
                    break;
                }
                case 24: {
                    data.setXml(xml);
                    data.setData(value);
                    GXDLMSSNCommandHandler.handleInformationReport(settings, data, null);
                    break;
                }
                case 194: {
                    data.setXml(xml);
                    data.setData(value);
                    GXDLMSLNCommandHandler.handleEventNotification(settings, data, null);
                    break;
                }
                case 12: 
                case 13: 
                case 196: 
                case 197: 
                case 199: 
                case 218: 
                case 224: {
                    data.setXml(xml);
                    data.setData(value);
                    value.position(0);
                    GXDLMS.getPdu(settings, data);
                    break;
                }
                case 221: {
                    data.setXml(xml);
                    data.setData(value);
                    value.position(0);
                    GXDLMS.getPdu(settings, data);
                    break;
                }
                case 98: {
                    xml.appendStartTag(cmd);
                    value.getUInt8();
                    if (value.available() != 0) {
                        value.getUInt8();
                        value.getUInt8();
                        String str = xml.getOutputType() == TranslatorOutputType.SIMPLE_XML ? TranslatorSimpleTags.releaseRequestReasonToString(ReleaseRequestReason.forValue(value.getUInt8())) : TranslatorStandardTags.releaseRequestReasonToString(ReleaseRequestReason.forValue(value.getUInt8()));
                        xml.appendLine(65315, "Value", str);
                        if (value.available() != 0) {
                            if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                                xml.appendStartTag(171);
                            }
                            GXAPDU.parsePDU2(settings, settings.getCipher(), value, xml);
                            if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                                xml.appendEndTag(171);
                            }
                        }
                    }
                    xml.appendEndTag(cmd);
                    break;
                }
                case 99: {
                    xml.appendStartTag(cmd);
                    value.getUInt8();
                    if (value.available() != 0) {
                        value.getUInt8();
                        value.getUInt8();
                        String str = xml.getOutputType() == TranslatorOutputType.SIMPLE_XML ? TranslatorSimpleTags.releaseResponseReasonToString(ReleaseResponseReason.forValue(value.getUInt8())) : TranslatorStandardTags.releaseResponseReasonToString(ReleaseResponseReason.forValue(value.getUInt8()));
                        xml.appendLine(65315, "Value", str);
                        if (value.available() != 0) {
                            GXAPDU.parsePDU2(settings, settings.getCipher(), value, xml);
                        }
                    }
                    xml.appendEndTag(cmd);
                    break;
                }
                case 37: 
                case 38: 
                case 44: 
                case 45: 
                case 46: 
                case 76: 
                case 78: 
                case 200: 
                case 201: 
                case 203: 
                case 204: 
                case 205: 
                case 207: 
                case 208: 
                case 209: 
                case 211: 
                case 212: 
                case 213: 
                case 215: {
                    int cnt;
                    if (settings.getCipher() != null && this.comments) {
                        int originalPosition = value.position();
                        int len = xml.getXmlLength();
                        try {
                            AesGcmParameter p;
                            value.position(value.position() - 1);
                            short c = cmd;
                            byte[] st = c == 37 || c == 38 || c == 200 || c == 201 || c == 203 || c == 208 || c == 209 || c == 211 ? settings.getCipher().getSystemTitle() : settings.getSourceSystemTitle();
                            if (st != null && (p = (c == 208 || c == 209 || c == 76 || c == 77 || c == 212 || c == 213 || c == 211 || c == 215) && settings.getCipher().getDedicatedKey() != null && settings.getCipher().getDedicatedKey().length != 0 ? new AesGcmParameter(settings, st, settings.getCipher().getDedicatedKey(), settings.getCipher().getAuthenticationKey()) : new AesGcmParameter(settings, st, settings.getCipher().getBlockCipherKey(), settings.getCipher().getAuthenticationKey())).getBlockCipherKey() != null) {
                                p.setXml(xml);
                                GXByteBuffer data2 = new GXByteBuffer(GXCiphering.decrypt(settings.getCipher(), p, value));
                                xml.startComment("Decrypt data: " + data2.toString());
                                this.pduToXml(xml, data2, omitDeclaration, omitNameSpace, false, msg);
                                xml.endComment();
                            }
                        }
                        catch (Exception e) {
                            if (msg != null) {
                                msg.setCommand(cmd);
                            }
                            xml.setXmlLength(len);
                        }
                        value.position(originalPosition);
                    }
                    if ((cnt = GXCommon.getObjectCount(value)) != value.size() - value.position()) {
                        xml.appendComment("Invalid length: " + String.valueOf(cnt) + ". It should be: " + String.valueOf(value.size() - value.position()));
                    }
                    xml.appendLine(cmd, "Value", GXCommon.toHex(value.getData(), false, value.position(), value.size() - value.position()));
                    break;
                }
                case 219: 
                case 220: {
                    int len;
                    if (settings.getCipher() != null && this.comments) {
                        len = xml.getXmlLength();
                        int originalPosition = value.position();
                        try {
                            GXByteBuffer tmp = new GXByteBuffer();
                            tmp.set(value.getData(), value.position() - 1, value.size() - value.position() + 1);
                            AesGcmParameter p = new AesGcmParameter(settings, settings.getCipher().getSystemTitle(), settings.getCipher().getBlockCipherKey(), settings.getCipher().getAuthenticationKey());
                            p.setXml(xml);
                            tmp = new GXByteBuffer(GXCiphering.decrypt(settings.getCipher(), p, tmp));
                            len = xml.getXmlLength();
                            xml.startComment("Decrypt data: " + tmp.toString());
                            this.pduToXml(xml, tmp, omitDeclaration, omitNameSpace, false, msg);
                            xml.endComment();
                        }
                        catch (Exception e) {
                            xml.setXmlLength(len);
                            value.position(originalPosition);
                            value.position(value.position() - 1);
                            try {
                                byte[] st = settings.getSourceSystemTitle();
                                if (st != null) {
                                    AesGcmParameter p = new AesGcmParameter(settings, st, settings.getCipher().getBlockCipherKey(), settings.getCipher().getAuthenticationKey());
                                    GXByteBuffer data2 = new GXByteBuffer(GXCiphering.decrypt(settings.getCipher(), p, value));
                                    xml.startComment("Decrypt data: " + data2.toString());
                                    this.pduToXml(xml, data2, omitDeclaration, omitNameSpace, false, msg);
                                    xml.endComment();
                                }
                            }
                            catch (Exception ex) {
                                if (msg != null) {
                                    msg.setCommand(cmd);
                                }
                                xml.setXmlLength(len);
                            }
                        }
                    }
                    len = GXCommon.getObjectCount(value);
                    byte[] tmp = new byte[len];
                    value.get(tmp);
                    xml.appendStartTag(219);
                    xml.appendLine(65348, null, GXCommon.toHex(tmp, false, 0, len));
                    len = GXCommon.getObjectCount(value);
                    tmp = new byte[len];
                    value.get(tmp);
                    xml.appendLine(65347, null, GXCommon.toHex(tmp, false, 0, len));
                    xml.appendEndTag(219);
                    break;
                }
                case 14: {
                    data.setXml(xml);
                    data.setData(value);
                    GXDLMS.handleConfirmedServiceError(data);
                    break;
                }
                case 230: 
                case 231: {
                    data.setXml(xml);
                    data.setData(value);
                    short id = value.getUInt8();
                    int len = GXCommon.getObjectCount(value);
                    byte[] tmp = new byte[len];
                    value.get(tmp);
                    xml.appendStartTag(cmd);
                    xml.appendLine(65402, null, String.valueOf(id));
                    xml.appendLine(65403, null, GXCommon.toHex(tmp, false, 0, len));
                    this.pduToXml(xml, new GXByteBuffer(value.remaining()), omitDeclaration, omitNameSpace, allowUnknownCommand, msg);
                    xml.appendEndTag(cmd);
                    break;
                }
                case 216: {
                    data.setXml(xml);
                    data.setData(value);
                    GXDLMS.handleExceptionResponse(data);
                    break;
                }
                case 29: {
                    data.setXml(xml);
                    data.setData(value);
                    xml.appendStartTag(cmd);
                    this.handleDiscoverRequest(data);
                    xml.appendEndTag(cmd);
                    break;
                }
                case 30: {
                    data.setXml(xml);
                    data.setData(value);
                    xml.appendStartTag(cmd);
                    this.handleDiscoverResponse(settings, data);
                    xml.appendEndTag(cmd);
                    break;
                }
                case 28: {
                    data.setXml(xml);
                    data.setData(value);
                    xml.appendStartTag(cmd);
                    this.handleRegisterRequest(msg.getInterfaceType(), data);
                    xml.appendEndTag(cmd);
                    break;
                }
                case 26: {
                    data.setXml(xml);
                    data.setData(value);
                    xml.appendStartTag(cmd);
                    GXDLMS.handleExceptionResponse(data);
                    xml.appendEndTag(cmd);
                    break;
                }
                case 31: {
                    data.setXml(xml);
                    data.setData(value);
                    xml.appendStartTag(cmd);
                    GXDLMS.handleExceptionResponse(data);
                    xml.appendEndTag(cmd);
                    break;
                }
                default: {
                    if (!allowUnknownCommand) {
                        throw new IllegalArgumentException("Invalid command.");
                    }
                    value.position(value.position() - 1);
                    xml.appendLine("<Data=\"" + GXCommon.toHex(value.getData(), false, value.position(), value.size() - value.position()) + "\" />");
                }
            }
            if (this.outputType == TranslatorOutputType.STANDARD_XML) {
                StringBuilder sb = new StringBuilder();
                if (!omitDeclaration) {
                    sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
                }
                if (!omitNameSpace) {
                    if (cmd != 97 && cmd != 96 && cmd != 98 && cmd != 99) {
                        sb.append("<x:xDLMS-APDU xmlns:x=\"http://www.dlms.com/COSEMpdu\">\r\n");
                    } else {
                        sb.append("<x:aCSE-APDU xmlns:x=\"http://www.dlms.com/COSEMpdu\">\r\n");
                    }
                }
                sb.append(xml.toString());
                if (!omitNameSpace) {
                    if (cmd != 97 && cmd != 96 && cmd != 98 && cmd != 99) {
                        sb.append("</x:xDLMS-APDU>\r\n");
                    } else {
                        sb.append("</x:aCSE-APDU>\r\n");
                    }
                }
                return sb.toString();
            }
            return xml.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    private static void getCommand(Node node, GXDLMSXmlSettings s, int tag) {
        s.setCommand(tag);
        switch (tag) {
            case 1: 
            case 5: 
            case 6: 
            case 14: 
            case 96: 
            case 98: 
            case 147: 
            case 192: 
            case 193: 
            case 195: 
            case 216: 
            case 217: {
                s.getSettings().setServer(false);
                break;
            }
            case 33: 
            case 37: 
            case 38: 
            case 200: 
            case 201: 
            case 203: 
            case 208: 
            case 209: 
            case 211: {
                s.getSettings().setServer(false);
                s.setCommand(tag);
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                s.getSettings().getCipher().setSecurity(Security.forValue(tmp[0]));
                s.getData().set(tmp);
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 24: 
            case 83: 
            case 97: 
            case 99: 
            case 115: 
            case 194: 
            case 196: 
            case 197: 
            case 199: 
            case 218: 
            case 224: {
                break;
            }
            case 40: 
            case 44: 
            case 45: 
            case 202: 
            case 204: 
            case 205: 
            case 207: 
            case 210: 
            case 212: 
            case 213: 
            case 215: {
                s.setCommand(tag);
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                s.getSettings().getCipher().setSecurity(Security.forValue(tmp[0]));
                s.getData().set(tmp);
                break;
            }
            case 219: {
                s.setCommand(tag);
                break;
            }
            case 221: {
                s.setCommand(tag);
                break;
            }
            case 65380: {
                s.setCommand(0);
                break;
            }
            case 230: {
                s.setGwCommand(230);
                s.getSettings().setServer(false);
                break;
            }
            case 231: {
                s.setGwCommand(231);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Command: " + node.getNodeName());
            }
        }
    }

    private static boolean getFrame(Node node, GXDLMSXmlSettings s, int tag) {
        boolean found = true;
        switch (tag) {
            case 65281: {
                s.getSettings().setInterfaceType(InterfaceType.WRAPPER);
                break;
            }
            case 65282: {
                s.getSettings().setInterfaceType(InterfaceType.HDLC);
                break;
            }
            case 65284: {
                s.getSettings().setServerAddress(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 65285: {
                s.getSettings().setClientAddress(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            default: {
                found = false;
            }
        }
        return found;
    }

    private static int getNodeCount(Node node) {
        int cnt = 0;
        for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
            Node node2 = node.getChildNodes().item(pos);
            if (node2.getNodeType() != 1) continue;
            ++cnt;
        }
        return cnt;
    }

    private static boolean handleAarqAare(Node node, GXDLMSXmlSettings s, int tag) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        block0 : switch (tag) {
            case 161: {
                if (s.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                    int value = Integer.parseInt(node.getFirstChild().getNodeValue());
                    switch (value) {
                        case 1: {
                            s.getSettings().setUseLogicalNameReferencing(true);
                            break block0;
                        }
                        case 2: {
                            s.getSettings().setUseLogicalNameReferencing(false);
                            break block0;
                        }
                        case 3: {
                            s.getSettings().setUseLogicalNameReferencing(true);
                            break block0;
                        }
                        case 4: {
                            s.getSettings().setUseLogicalNameReferencing(false);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Invalid application context name.");
                }
                if (node.getAttributes().item(0).getNodeValue().compareTo("SN") == 0 || node.getAttributes().item(0).getNodeValue().compareTo("SN_WITH_CIPHERING") == 0) {
                    s.getSettings().setUseLogicalNameReferencing(false);
                    break;
                }
                if (node.getAttributes().item(0).getNodeValue().compareTo("LN") == 0 || node.getAttributes().item(0).getNodeValue().compareTo("LN_WITH_CIPHERING") == 0) {
                    s.getSettings().setUseLogicalNameReferencing(true);
                    break;
                }
                throw new IllegalArgumentException("Invalid Reference type name.");
            }
            case 33: {
                s.getSettings().setServer(false);
                s.setCommand(tag);
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                s.getSettings().getCipher().setSecurity(Security.forValue(tmp[0]));
                s.getData().set(tmp);
                break;
            }
            case 40: {
                s.setCommand(tag);
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                s.getSettings().getCipher().setSecurity(Security.forValue(tmp[0]));
                s.getData().set(tmp);
                break;
            }
            case 219: {
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 171: {
                if (s.getOutputType() != TranslatorOutputType.STANDARD_XML) break;
                GXByteBuffer bb = new GXByteBuffer();
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                bb.set(tmp);
                if (s.getSettings().isServer()) {
                    s.getSettings().setProposedConformance(Conformance.forValue(0xFFFFFF));
                }
                GXAPDU.parseInitiate(false, s.getSettings(), s.getSettings().getCipher(), bb, null);
                if (s.getSettings().isServer()) break;
                s.getSettings().setProposedConformance(s.getSettings().getNegotiatedConformance());
                break;
            }
            case 138: 
            case 48640: 
            case 48641: 
            case 48646: {
                break;
            }
            case 48644: {
                String str = GXDLMSTranslator.getValue(node, s);
                s.getSettings().setUseLogicalNameReferencing(Integer.parseInt(str, 16) == 7);
                break;
            }
            case 137: 
            case 139: {
                if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    s.getSettings().setAuthentication(Authentication.valueOfString(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                s.getSettings().setAuthentication(Authentication.forValue(Integer.parseInt(GXDLMSTranslator.getValue(node, s))));
                break;
            }
            case 172: {
                if (s.getSettings().getAuthentication() == Authentication.LOW) {
                    s.getSettings().setPassword(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                s.getSettings().setCtoSChallenge(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 168: {
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                s.getSettings().getCipher().setDedicatedKey(tmp);
                break;
            }
            case 166: {
                s.getSettings().setCtoSChallenge(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 169: {
                s.getSettings().setUserId(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 165: {
                s.getSettings().setUserId(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 173: {
                s.getSettings().setUserId(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 164: {
                s.getSettings().setStoCChallenge(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 48643: 
            case 48645: {
                Set<Conformance> list = s.getSettings().isServer() ? s.getSettings().getNegotiatedConformance() : s.getSettings().getProposedConformance();
                list.clear();
                if (s.getOutputType() != TranslatorOutputType.STANDARD_XML) break;
                String nodes = node.getFirstChild().getNodeValue();
                for (String it : nodes.split(" ")) {
                    if (it.trim().isEmpty()) continue;
                    list.add(TranslatorStandardTags.valueOfConformance(it.trim()));
                }
                break;
            }
            case 48648: {
                Set<Conformance> list = s.getSettings().isServer() ? s.getSettings().getNegotiatedConformance() : s.getSettings().getProposedConformance();
                list.add(TranslatorSimpleTags.valueOfConformance(node.getAttributes().getNamedItem("Name").getNodeValue()));
                break;
            }
            case 162: {
                s.setResult(AssociationResult.forValue(s.parseInt(GXDLMSTranslator.getValue(node, s))));
                break;
            }
            case 48642: 
            case 48647: {
                s.getSettings().setMaxPduSize(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 163: {
                s.setDiagnostic(SourceDiagnostic.NONE);
                break;
            }
            case 41729: {
                s.setDiagnostic(SourceDiagnostic.forValue(s.parseInt(GXDLMSTranslator.getValue(node, s))));
                break;
            }
            case 48649: {
                break;
            }
            case 170: {
                if (s.getSettings().getAuthentication() == Authentication.LOW) {
                    s.getSettings().setPassword(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                if (s.getCommand() == 96) {
                    s.getSettings().setCtoSChallenge(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                s.getSettings().setStoCChallenge(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 136: {
                break;
            }
            case 128: {
                s.getSettings().setStoCChallenge(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 65302: {
                s.setResult(AssociationResult.forValue(Integer.parseInt(GXDLMSTranslator.getValue(node, s))));
                break;
            }
            case 14: {
                if (s.getCommand() != 0) break;
                s.getSettings().setServer(false);
                s.setCommand(tag);
                break;
            }
            case 65315: {
                if (s.getCommand() == 98) {
                    if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        s.setReason((byte)TranslatorSimpleTags.valueOfReleaseRequestReason(GXDLMSTranslator.getValue(node, s)).getValue());
                        break;
                    }
                    s.setReason((byte)TranslatorStandardTags.valueOfReleaseRequestReason(GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    s.setReason((byte)TranslatorSimpleTags.valueOfReleaseResponseReason(GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                s.setReason((byte)TranslatorStandardTags.valueOfReleaseResponseReason(GXDLMSTranslator.getValue(node, s)).getValue());
                break;
            }
            case 65344: {
                s.getAttributeDescriptor().setUInt8(14);
                s.getAttributeDescriptor().setUInt8(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 65345: {
                if (s.getCommand() != 97) break;
                s.getAttributeDescriptor().setUInt8(6);
                for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
                    Node node2 = node.getChildNodes().item(pos);
                    if (node2.getNodeType() != 1) continue;
                    s.getAttributeDescriptor().setUInt8((byte)TranslatorSimpleTags.getInitiate(GXDLMSTranslator.getValue(node2, s)));
                }
                return false;
            }
            case 65404: {
                String str = GXDLMSTranslator.getValue(node, s);
                GXByteBuffer pv = new GXByteBuffer();
                pv.setUInt8((byte)(8 - str.length()));
                GXCommon.setBitString(pv, str, false);
                s.getSettings().setProtocolVersion(str);
                break;
            }
            case 65405: 
            case 65409: {
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                s.getAttributeDescriptor().setUInt8((byte)(tag == 65405 ? 162 : 163));
                s.getAttributeDescriptor().setUInt8(3);
                s.getAttributeDescriptor().setUInt8(4);
                s.getAttributeDescriptor().setUInt8((byte)tmp.length);
                s.getAttributeDescriptor().set(tmp);
                break;
            }
            case 65406: {
                s.getAttributeDescriptor().setUInt8(166);
                s.getAttributeDescriptor().setUInt8(3);
                s.getAttributeDescriptor().setUInt8(2);
                s.getAttributeDescriptor().setUInt8(1);
                s.getAttributeDescriptor().setUInt8((byte)s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 65407: {
                s.getAttributeDescriptor().setUInt8(165);
                s.getAttributeDescriptor().setUInt8(3);
                s.getAttributeDescriptor().setUInt8(2);
                s.getAttributeDescriptor().setUInt8(1);
                s.getAttributeDescriptor().setUInt8((byte)s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 65408: {
                s.getAttributeDescriptor().setUInt8(164);
                s.getAttributeDescriptor().setUInt8(3);
                s.getAttributeDescriptor().setUInt8(2);
                s.getAttributeDescriptor().setUInt8(1);
                s.getAttributeDescriptor().setUInt8((byte)s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case 65410: {
                if (Boolean.parseBoolean(GXDLMSTranslator.getValue(node, s))) {
                    s.getAttributeDescriptor().setUInt8(1);
                    break;
                }
                s.getAttributeDescriptor().setUInt8(0);
                break;
            }
            case 65348: {
                break;
            }
            case 65347: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AARQ node: " + node.getNodeName());
            }
        }
        return true;
    }

    private static String getValue(Node node, GXDLMSXmlSettings s) {
        if (s.getOutputType() == TranslatorOutputType.STANDARD_XML) {
            Node tmp = node.getFirstChild();
            if (tmp == null) {
                return "";
            }
            String str = tmp.getNodeValue();
            if (str == null) {
                return "";
            }
            return str.trim();
        }
        Node tmp = node.getAttributes().getNamedItem("Value");
        if (tmp == null) {
            return "";
        }
        return tmp.getNodeValue();
    }

    static ErrorCode valueOfErrorCode(TranslatorOutputType type, String value) {
        if (type == TranslatorOutputType.STANDARD_XML) {
            return TranslatorStandardTags.valueOfErrorCode(value);
        }
        return TranslatorSimpleTags.valueOfErrorCode(value);
    }

    static String errorCodeToString(TranslatorOutputType type, ErrorCode value) {
        if (type == TranslatorOutputType.STANDARD_XML) {
            return TranslatorStandardTags.errorCodeToString(value);
        }
        return TranslatorSimpleTags.errorCodeToString(value);
    }

    private static void readNode(Node node, GXDLMSXmlSettings s) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        GXByteBuffer preData = null;
        String str = s.getOutputType() == TranslatorOutputType.SIMPLE_XML ? node.getNodeName().toLowerCase() : (node.getNodeName().startsWith("x:") ? node.getNodeName().substring(2) : node.getNodeName());
        int tag = 0;
        if (s.getCommand() != 14 || s.getTags().containsKey(str)) {
            tag = s.getTags().get(str);
        }
        if (s.getCommand() == 0) {
            if ((s.getSettings().getClientAddress() != 0 && s.getSettings().getServerAddress() != 0 || !GXDLMSTranslator.getFrame(node, s, tag)) && tag != 65283 && tag != 65318) {
                GXDLMSTranslator.getCommand(node, s, tag);
            }
        } else if (s.getCommand() == 96 || s.getCommand() == 97 || s.getCommand() == 1 || s.getCommand() == 8) {
            if (!GXDLMSTranslator.handleAarqAare(node, s, tag)) {
                return;
            }
        } else if (tag >= 0xFF0000) {
            if (tag == DataType.DATETIME.getValue() + 0xFF0000 || s.getCommand() == 194 && s.getAttributeDescriptor().size() == 0) {
                if ((preData = GXDLMSTranslator.updateDateTime(node, s, preData)) == null && s.getCommand() == 221) {
                    s.getData().setUInt8(0);
                }
            } else {
                if (s.getCommand() == 199) {
                    s.getAttributeDescriptor().setUInt8(0);
                }
                preData = GXDLMSTranslator.updateDataType(node, s, tag);
            }
        } else if (s.getCommand() == 14) {
            ServiceError se;
            if (s.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                if (tag == 65346) {
                    s.getAttributeDescriptor().setUInt8(1);
                } else {
                    se = TranslatorStandardTags.getServiceError(str.substring(2));
                    s.getAttributeDescriptor().setUInt8(se.getValue());
                    s.getAttributeDescriptor().setUInt8(TranslatorStandardTags.getError(se, GXDLMSTranslator.getValue(node, s)));
                }
            } else if (tag != 65345) {
                if (s.getAttributeDescriptor().size() == 0) {
                    s.getAttributeDescriptor().setUInt8(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                } else {
                    se = TranslatorSimpleTags.getServiceError(str);
                    s.getAttributeDescriptor().setUInt8(se.getValue());
                    s.getAttributeDescriptor().setUInt8(TranslatorSimpleTags.getError(se, GXDLMSTranslator.getValue(node, s)));
                }
            }
        } else {
            switch (tag) {
                case 49153: 
                case 49154: 
                case 49155: 
                case 49409: 
                case 49410: 
                case 49411: 
                case 49412: {
                    s.setRequestType((byte)(tag & 0xF));
                    break;
                }
                case 50177: 
                case 50178: 
                case 50179: 
                case 50433: 
                case 50434: 
                case 50435: 
                case 50436: 
                case 50437: {
                    s.setRequestType((byte)(tag & 0xF));
                    break;
                }
                case 3074: {
                    s.setCount(s.getCount() + 1);
                    s.setRequestType((byte)(tag & 0xF));
                    break;
                }
                case 1284: {
                    s.setRequestType(4);
                    break;
                }
                case 1285: {
                    s.setRequestType(5);
                    s.setCount(s.getCount() + 1);
                    break;
                }
                case 49921: 
                case 49922: 
                case 49923: {
                    s.setRequestType((byte)(tag & 0xFF));
                    break;
                }
                case 50945: 
                case 50946: 
                case 50947: 
                case 50948: {
                    s.setRequestType((byte)(tag & 0xFF));
                    break;
                }
                case 3072: 
                case 65312: {
                    if (s.getCommand() == 5 || s.getCommand() == 12 || s.getCommand() == 192) {
                        s.setCount(s.getCount() + 1);
                        s.setRequestType(0);
                        break;
                    }
                    if (s.getCommand() != 196 && s.getCommand() != 199) break;
                    s.getData().setUInt8(0);
                    break;
                }
                case 65288: {
                    s.setCount(s.getCount() + 1);
                    s.getAttributeDescriptor().setUInt8(ErrorCode.OK.getValue());
                    break;
                }
                case 65289: {
                    s.setCount(s.getCount() + 1);
                    s.getAttributeDescriptor().setUInt8(1);
                    s.getAttributeDescriptor().setUInt8(GXDLMSTranslator.valueOfErrorCode(s.getOutputType(), GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                case 65286: {
                    break;
                }
                case 65316: {
                    break;
                }
                case 65287: {
                    if (s.getCommand() == 218 && s.getData().size() == 0) {
                        s.getData().setUInt8(0);
                    }
                    if (s.getOutputType() != TranslatorOutputType.SIMPLE_XML && s.getCommand() == 6) break;
                    GXCommon.setObjectCount(GXDLMSTranslator.getNodeCount(node), s.getData());
                    break;
                }
                case 55809: 
                case 55810: 
                case 55811: {
                    s.getData().setUInt8(0xFF & tag);
                    break;
                }
                case 65314: {
                    preData = GXDLMSTranslator.updateDateTime(node, s, preData);
                    if (preData != null || s.getCommand() != 221) break;
                    s.getData().setUInt8(0);
                    break;
                }
                case 65366: {
                    if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        GXDLMSTranslator.updateDateTime(node, s, preData);
                        break;
                    }
                    str = GXDLMSTranslator.getValue(node, s);
                    s.setTime(new GXDateTime(GXCommon.getGeneralizedTime(str)));
                    break;
                }
                case 65367: {
                    preData = GXDLMSTranslator.updateDateTime(node, s, preData);
                    break;
                }
                case 65313: {
                    long value = s.parseShort(GXDLMSTranslator.getValue(node, s));
                    s.getSettings().updateInvokeId((short)value);
                    break;
                }
                case 65320: {
                    long value = s.parseLong(GXDLMSTranslator.getValue(node, s));
                    if ((value & Integer.MIN_VALUE) != 0L) {
                        s.getSettings().setPriority(Priority.HIGH);
                    } else {
                        s.getSettings().setPriority(Priority.NORMAL);
                    }
                    if ((value & 0x40000000L) != 0L) {
                        s.getSettings().setServiceClass(ServiceClass.CONFIRMED);
                    } else {
                        s.getSettings().setServiceClass(ServiceClass.UN_CONFIRMED);
                    }
                    s.getSettings().setLongInvokeID(value & 0xFFFFFFFL);
                    break;
                }
                case 136: {
                    break;
                }
                case 128: {
                    s.getSettings().setStoCChallenge(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65290: {
                    break;
                }
                case 65291: {
                    s.getAttributeDescriptor().setUInt16(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65292: {
                    s.getAttributeDescriptor().add(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65293: {
                    s.getAttributeDescriptor().setUInt8(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                    if (s.getCommand() == 217 || s.getCommand() == 194) break;
                    s.getAttributeDescriptor().setUInt8(0);
                    break;
                }
                case 65294: {
                    s.getAttributeDescriptor().setUInt8(s.getAttributeDescriptor().size() - 1, 1);
                    break;
                }
                case 65295: {
                    s.getAttributeDescriptor().set(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65296: {
                    break;
                }
                case 65297: {
                    s.getAttributeDescriptor().setUInt8(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65298: {
                    if (s.getCommand() == 192 || s.getCommand() == 196 || s.getCommand() == 193 || s.getCommand() == 197 || s.getCommand() == 195 || s.getCommand() == 199) {
                        s.getAttributeDescriptor().setUInt32(s.parseLong(GXDLMSTranslator.getValue(node, s)));
                        break;
                    }
                    s.getAttributeDescriptor().setUInt16(s.parseInt(GXDLMSTranslator.getValue(node, s)));
                    if (s.getCommand() != 13) break;
                    s.setCount(1);
                    s.setRequestType(2);
                    break;
                }
                case 65299: {
                    if (s.getCommand() == 196 || s.getCommand() == 199) {
                        s.getData().setUInt8(0);
                    }
                    byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                    GXCommon.setObjectCount(tmp.length, s.getData());
                    s.getData().set(tmp);
                    break;
                }
                case 65300: {
                    break;
                }
                case 65301: {
                    s.getAttributeDescriptor().setUInt8(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                    s.getAttributeDescriptor().setUInt8(0);
                    break;
                }
                case 162: 
                case 65302: 
                case 65413: {
                    if (s.getCommand() == 192 || s.getRequestType() == 3) {
                        GXCommon.setObjectCount(node.getChildNodes().getLength(), s.getAttributeDescriptor());
                        break;
                    }
                    if (s.getCommand() == 197 || s.getCommand() == 199) {
                        str = GXDLMSTranslator.getValue(node, s);
                        if (str.isEmpty()) break;
                        s.getAttributeDescriptor().setUInt8(GXDLMSTranslator.valueOfErrorCode(s.getOutputType(), str).getValue());
                        break;
                    }
                    if (s.getCommand() != 218 || (str = GXDLMSTranslator.getValue(node, s)).isEmpty()) break;
                    s.getData().setUInt8(GXDLMSTranslator.valueOfErrorCode(s.getOutputType(), str).getValue());
                    break;
                }
                case 65315: {
                    if (s.getCommand() == 98) {
                        if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                            s.setReason((byte)TranslatorSimpleTags.valueOfReleaseRequestReason(GXDLMSTranslator.getValue(node, s)).getValue());
                            break;
                        }
                        s.setReason((byte)TranslatorStandardTags.valueOfReleaseRequestReason(GXDLMSTranslator.getValue(node, s)).getValue());
                        break;
                    }
                    if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        s.setReason((byte)TranslatorSimpleTags.valueOfReleaseResponseReason(GXDLMSTranslator.getValue(node, s)).getValue());
                        break;
                    }
                    s.setReason((byte)TranslatorStandardTags.valueOfReleaseResponseReason(GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                case 65303: {
                    s.getAttributeDescriptor().setUInt8(1);
                    break;
                }
                case 65304: {
                    s.getAttributeDescriptor().setUInt8(s.getAttributeDescriptor().size() - 1, 1);
                    break;
                }
                case 65305: {
                    break;
                }
                case 65344: {
                    if (s.getAttributeDescriptor().size() == 0) {
                        s.getAttributeDescriptor().setUInt8(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                        break;
                    }
                    s.getAttributeDescriptor().setUInt8(ServiceError.SERVICE.getValue());
                    s.getAttributeDescriptor().setUInt8(Service.valueOf(GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                case 65306: {
                    s.getData().setUInt8(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65307: {
                    break;
                }
                case 65308: {
                    GXCommon.setObjectCount(GXDLMSTranslator.getNodeCount(node), s.getAttributeDescriptor());
                    break;
                }
                case 55553: 
                case 55554: 
                case 55555: 
                case 65309: {
                    if (s.getCommand() == 193) break;
                    s.getAttributeDescriptor().setUInt8(tag & 0xFF);
                    break;
                }
                case 1282: 
                case 1536: 
                case 1538: {
                    if (s.getCommand() == 217 || s.getCommand() == 218) break;
                    if (s.getOutputType() != TranslatorOutputType.STANDARD_XML || tag != 1536) {
                        if (s.getRequestType() == 255) {
                            s.getAttributeDescriptor().setUInt8(2);
                        } else {
                            s.getAttributeDescriptor().setUInt8(s.getRequestType());
                            s.setRequestType(255);
                        }
                        s.setCount(s.getCount() + 1);
                    } else if (s.getCommand() != 24 && s.getRequestType() != 4) {
                        s.getAttributeDescriptor().setUInt8(s.getCount());
                    }
                    if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        s.getAttributeDescriptor().setUInt16(Integer.parseInt(GXDLMSTranslator.getValue(node, s), 16));
                        break;
                    }
                    str = GXDLMSTranslator.getValue(node, s);
                    if (str.isEmpty()) break;
                    s.getAttributeDescriptor().setUInt16(Short.parseShort(str));
                    break;
                }
                case 65319: {
                    break;
                }
                case 3073: {
                    ErrorCode err = GXDLMSTranslator.valueOfErrorCode(s.getOutputType(), GXDLMSTranslator.getValue(node, s));
                    s.setCount(s.getCount() + 1);
                    s.getData().setUInt8(1);
                    s.getData().setUInt8(err.getValue());
                    break;
                }
                case 65321: {
                    break;
                }
                case 65328: {
                    break;
                }
                case 65329: {
                    break;
                }
                case 65330: {
                    s.getAttributeDescriptor().setUInt8(GXDLMSTranslator.getNodeCount(node));
                    break;
                }
                case 65331: {
                    break;
                }
                case 65332: {
                    s.getAttributeDescriptor().setUInt8(GXDLMSTranslator.getNodeCount(node));
                    break;
                }
                case 65333: {
                    break;
                }
                case 65334: {
                    s.getData().setUInt8(GXDLMSTranslator.getNodeCount(node));
                    break;
                }
                case 65335: {
                    break;
                }
                case 65336: {
                    s.getData().setUInt8(0);
                    s.getData().setUInt8(GXDLMSTranslator.getNodeCount(node));
                    break;
                }
                case 65337: {
                    break;
                }
                case 65348: {
                    byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                    s.getSettings().setSourceSystemTitle(tmp);
                    break;
                }
                case 33: 
                case 65347: {
                    byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                    if (s.getCommand() == 221) {
                        GXCommon.setObjectCount(tmp.length, s.getData());
                    } else if (s.getCommand() == 98) {
                        s.getData().setUInt8(190);
                        GXCommon.setObjectCount(4 + tmp.length, s.getData());
                        s.getData().setUInt8(4);
                        GXCommon.setObjectCount(2 + tmp.length, s.getData());
                        s.getData().setUInt8(33);
                        GXCommon.setObjectCount(tmp.length, s.getData());
                    }
                    s.getData().set(tmp);
                    break;
                }
                case 65349: {
                    break;
                }
                case 171: {
                    byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                    if (s.getOutputType() != TranslatorOutputType.SIMPLE_XML || s.getCommand() != 98) {
                        s.getData().setUInt8(190);
                        s.getData().setUInt8(2 + tmp.length);
                        s.getData().setUInt8(4);
                        s.getData().setUInt8(tmp.length);
                    }
                    s.getData().set(tmp);
                    break;
                }
                case 65350: {
                    byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                    GXCommon.setObjectCount(tmp.length, s.getData());
                    s.getData().set(tmp);
                    break;
                }
                case 65351: 
                case 65352: 
                case 65353: 
                case 65363: 
                case 65364: {
                    byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                    GXCommon.setObjectCount(tmp.length, s.getData());
                    s.getData().set(tmp);
                    break;
                }
                case 65360: {
                    s.getData().setUInt8(1);
                    break;
                }
                case 65361: {
                    s.getData().setUInt8(2);
                    break;
                }
                case 65362: {
                    s.getData().setUInt8(1);
                    s.getData().setUInt8(Integer.parseInt(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65365: {
                    break;
                }
                case 65369: {
                    long value = Byte.parseByte(GXDLMSTranslator.getValue(node, s));
                    if (s.getCommand() == 147 && !s.getSettings().isServer() || s.getCommand() == 115 && s.getSettings().isServer()) {
                        s.getSettings().getHdlcSettings().setMaxInfoRX((int)value);
                    }
                    s.getData().setUInt8(6);
                    s.getData().setUInt8(1);
                    s.getData().setUInt8((byte)value);
                    break;
                }
                case 65368: {
                    long value = Byte.parseByte(GXDLMSTranslator.getValue(node, s));
                    if (s.getCommand() == 147 && !s.getSettings().isServer() || s.getCommand() == 115 && s.getSettings().isServer()) {
                        s.getSettings().getHdlcSettings().setMaxInfoTX((int)value);
                    }
                    s.getData().setUInt8(5);
                    s.getData().setUInt8(1);
                    s.getData().setUInt8((byte)value);
                    break;
                }
                case 65377: {
                    long value = Byte.parseByte(GXDLMSTranslator.getValue(node, s));
                    if (s.getCommand() == 147 && !s.getSettings().isServer() || s.getCommand() == 115 && s.getSettings().isServer()) {
                        s.getSettings().getHdlcSettings().setWindowSizeRX((byte)value);
                    }
                    s.getData().setUInt8(8);
                    s.getData().setUInt8(4);
                    s.getData().setUInt32(value);
                    break;
                }
                case 65376: {
                    long value = Byte.parseByte(GXDLMSTranslator.getValue(node, s));
                    if (s.getCommand() == 147 && !s.getSettings().isServer() || s.getCommand() == 115 && s.getSettings().isServer()) {
                        s.getSettings().getHdlcSettings().setWindowSizeTX((byte)value);
                    }
                    s.getData().setUInt8(7);
                    s.getData().setUInt8(4);
                    s.getData().setUInt32(value);
                    break;
                }
                case 1: {
                    break;
                }
                case 65378: {
                    GXCommon.setObjectCount(GXDLMSTranslator.getNodeCount(node), s.getData());
                    break;
                }
                case 65379: {
                    s.getData().setUInt8(GXDLMSTranslator.valueOfErrorCode(s.getOutputType(), GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                case 65311: {
                    break;
                }
                case 65380: {
                    break;
                }
                case 65381: {
                    s.getAttributeDescriptor().setUInt8(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65382: {
                    s.getAttributeDescriptor().setUInt16(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65383: {
                    s.getData().set(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65384: {
                    GXDLMSTranslator.getNodeTypes(s, node);
                    return;
                }
                case 65385: {
                    if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        GXDLMSTranslator.getNodeValues(s, node);
                        break;
                    }
                    byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                    GXCommon.setObjectCount(tmp.length, s.getData());
                    s.getData().set(tmp);
                    break;
                }
                case 65402: {
                    s.setNetworkId(s.parseShort(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                case 65403: {
                    s.setPhysicalDeviceAddress(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    s.setCommand(0);
                    break;
                }
                case 65412: {
                    if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        s.getAttributeDescriptor().setUInt8(TranslatorSimpleTags.valueofStateError(GXDLMSTranslator.getValue(node, s)).getValue());
                        break;
                    }
                    s.getAttributeDescriptor().setUInt8(TranslatorStandardTags.valueofStateError(GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                case 65345: {
                    if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        s.getAttributeDescriptor().setUInt8(TranslatorSimpleTags.valueOfExceptionServiceError(GXDLMSTranslator.getValue(node, s)).getValue());
                        break;
                    }
                    s.getAttributeDescriptor().setUInt8(TranslatorStandardTags.valueOfExceptionServiceError(GXDLMSTranslator.getValue(node, s)).getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid node: " + node.getNodeName());
                }
            }
        }
        int cnt = 0;
        for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
            Node node2 = node.getChildNodes().item(pos);
            if (node2.getNodeType() != 1) continue;
            GXDLMSTranslator.readNode(node2, s);
            ++cnt;
        }
        if (preData != null) {
            GXCommon.setObjectCount(cnt, preData);
            preData.set(s.getData());
            s.getData().size(0);
            s.getData().set(preData);
        }
    }

    private static void getNodeValues(GXDLMSXmlSettings s, Node node) {
        int cnt = 1;
        int offset = 2;
        if (DataType.forValue(s.getData().getUInt8(2)) == DataType.STRUCTURE) {
            cnt = s.getData().getUInt8(3);
            offset = 4;
        }
        DataType[] types = new DataType[cnt];
        for (int pos = 0; pos != cnt; ++pos) {
            types[pos] = DataType.forValue(s.getData().getUInt8(offset + pos));
        }
        GXByteBuffer tmp = new GXByteBuffer();
        GXByteBuffer tmp2 = new GXByteBuffer();
        for (int row = 0; row != node.getChildNodes().getLength(); ++row) {
            String str = node.getChildNodes().item(row).getNodeValue();
            for (String r : str.split("[\n]")) {
                if ("".equals(r.trim()) || "\r".equals(r)) continue;
                int col = 0;
                for (String it : r.trim().split("[;]")) {
                    tmp.clear();
                    GXCommon.setData(null, tmp, types[col % types.length], GXDLMSConverter.changeType(it, types[col % types.length]));
                    if (tmp.size() == 1) {
                        s.getData().setUInt8(0);
                    } else {
                        tmp2.set(tmp.subArray(1, tmp.size() - 1));
                    }
                    ++col;
                }
            }
        }
        GXCommon.setObjectCount(tmp2.size(), s.getData());
        s.getData().set(tmp2);
    }

    private static void getNodeTypes(GXDLMSXmlSettings s, Node node) {
        int len = GXDLMSTranslator.getNodeCount(node);
        if (len > 1) {
            s.getData().setUInt8(DataType.STRUCTURE.getValue());
            GXCommon.setObjectCount(len, s.getData());
        }
        for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
            String str;
            Node node2 = node.getChildNodes().item(pos);
            if (node2.getNodeType() != 1) continue;
            if (s.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                str = node2.getNodeName().toLowerCase();
            } else {
                str = node2.getNodeName();
                if (str.startsWith("x:")) {
                    str = str.substring(2);
                }
            }
            int tag = s.getTags().get(str);
            s.getData().setUInt8(tag - 0xFF0000);
        }
    }

    private static GXByteBuffer updateDateTime(Node node, GXDLMSXmlSettings s, GXByteBuffer preData) {
        GXByteBuffer bb = preData;
        if (s.getRequestType() != 255) {
            bb = GXDLMSTranslator.updateDataType(node, s, DataType.DATETIME.getValue() + 0xFF0000);
        } else {
            DataType dt = DataType.DATETIME;
            byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
            if (tmp.length != 0) {
                if (tmp.length == 5) {
                    dt = DataType.DATE;
                } else if (tmp.length == 4) {
                    dt = DataType.TIME;
                }
                boolean useUtc = s.getSettings() != null ? s.getSettings().getUseUtc2NormalTime() : false;
                s.setTime((GXDateTime)GXDLMSClient.changeType(tmp, dt, useUtc));
            }
        }
        return bb;
    }

    private static GXByteBuffer updateDataType(Node node, GXDLMSXmlSettings s, int tag) {
        GXByteBuffer preData = null;
        String v = GXDLMSTranslator.getValue(node, s);
        if (s.isTemplate() || v.equals("*")) {
            s.setTemplate(true);
            return preData;
        }
        DataType dt = DataType.forValue(tag - 0xFF0000);
        switch (dt) {
            case ARRAY: {
                s.getData().setUInt8(DataType.ARRAY.getValue());
                preData = new GXByteBuffer(s.getData());
                s.getData().size(0);
                break;
            }
            case BCD: {
                GXCommon.setData(null, s.getData(), DataType.BCD, s.parseShort(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case BITSTRING: {
                GXCommon.setData(null, s.getData(), DataType.BITSTRING, GXDLMSTranslator.getValue(node, s));
                break;
            }
            case BOOLEAN: {
                GXCommon.setData(null, s.getData(), DataType.BOOLEAN, s.parseShort(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case DATE: {
                GXCommon.setData(null, s.getData(), DataType.DATE, GXDLMSClient.changeType(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)), DataType.DATE, false));
                break;
            }
            case DATETIME: {
                byte[] tmp = GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s));
                if (tmp.length == 5) {
                    dt = DataType.DATE;
                } else if (tmp.length == 4) {
                    dt = DataType.TIME;
                }
                boolean useUtc = s.getSettings() != null ? s.getSettings().getUseUtc2NormalTime() : false;
                GXCommon.setData(null, s.getData(), dt, GXDLMSClient.changeType(tmp, dt, useUtc));
                break;
            }
            case ENUM: {
                GXCommon.setData(null, s.getData(), DataType.ENUM, s.parseShort(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case FLOAT32: {
                GXDLMSTranslator.getFloat32(node, s);
                break;
            }
            case FLOAT64: {
                GXDLMSTranslator.getFloat64(node, s);
                break;
            }
            case INT16: {
                GXCommon.setData(null, s.getData(), DataType.INT16, s.parseShort(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case INT32: {
                GXCommon.setData(null, s.getData(), DataType.INT32, s.parseInt(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case INT64: {
                GXCommon.setData(null, s.getData(), DataType.INT64, s.parseLong(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case INT8: {
                GXCommon.setData(null, s.getData(), DataType.INT8, s.parseShort(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case NONE: {
                GXCommon.setData(null, s.getData(), DataType.NONE, null);
                break;
            }
            case OCTET_STRING: {
                GXDLMSTranslator.getOctetString(node, s);
                break;
            }
            case STRING: {
                if (s.isShowStringAsHex()) {
                    GXCommon.setData(null, s.getData(), DataType.STRING, GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                GXCommon.setData(null, s.getData(), DataType.STRING, GXDLMSTranslator.getValue(node, s));
                break;
            }
            case STRING_UTF8: {
                if (s.isShowStringAsHex()) {
                    GXCommon.setData(null, s.getData(), DataType.STRING_UTF8, GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)));
                    break;
                }
                GXCommon.setData(null, s.getData(), DataType.STRING_UTF8, GXDLMSTranslator.getValue(node, s));
                break;
            }
            case STRUCTURE: {
                s.getData().setUInt8(DataType.STRUCTURE.getValue());
                preData = new GXByteBuffer(s.getData());
                s.getData().size(0);
                break;
            }
            case TIME: {
                boolean useUtc = s.getSettings() != null ? s.getSettings().getUseUtc2NormalTime() : false;
                GXCommon.setData(null, s.getData(), DataType.TIME, GXDLMSClient.changeType(GXCommon.hexToBytes(GXDLMSTranslator.getValue(node, s)), DataType.TIME, useUtc));
                break;
            }
            case UINT16: {
                GXCommon.setData(null, s.getData(), DataType.UINT16, s.parseShort(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case UINT32: {
                GXCommon.setData(null, s.getData(), DataType.UINT32, s.parseLong(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case UINT64: {
                GXCommon.setData(null, s.getData(), DataType.UINT64, s.parseLong(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case UINT8: {
                GXCommon.setData(null, s.getData(), DataType.UINT8, s.parseShort(GXDLMSTranslator.getValue(node, s)));
                break;
            }
            case COMPACT_ARRAY: {
                s.getData().setUInt8(dt.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node: " + node.getNodeName());
            }
        }
        return preData;
    }

    private static void getOctetString(Node node, GXDLMSXmlSettings s) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setHexString(GXDLMSTranslator.getValue(node, s));
        GXCommon.setData(null, s.getData(), DataType.OCTET_STRING, bb.array());
    }

    private static void getFloat32(Node node, GXDLMSXmlSettings s) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setHexString(GXDLMSTranslator.getValue(node, s));
        GXCommon.setData(null, s.getData(), DataType.FLOAT32, Float.valueOf(bb.getFloat()));
    }

    private static void getFloat64(Node node, GXDLMSXmlSettings s) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setHexString(GXDLMSTranslator.getValue(node, s));
        GXCommon.setData(null, s.getData(), DataType.FLOAT64, bb.getDouble());
    }

    public final String xmlToHexPdu(String xml) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return GXCommon.toHex(this.xmlToPdu(xml, null), false);
    }

    public final String xmlToHexPdu(String xml, boolean addSpace) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return GXCommon.toHex(this.xmlToPdu(xml, null), addSpace);
    }

    public final byte[] xmlToPdu(String xml) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.xmlToPdu(xml, null);
    }

    public final byte[] xmlToPdu(String xml, GXDLMSXmlSettings settings) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        Document doc;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        GXDLMSXmlSettings s = settings;
        if (s == null) {
            s = new GXDLMSXmlSettings(this.outputType, this.hex, this.getShowStringAsHex(), this.tagsByName);
        }
        GXDLMSTranslator.readNode(doc.getDocumentElement(), s);
        GXByteBuffer bb = new GXByteBuffer();
        switch (s.getCommand()) {
            case 1: {
                GXAPDU.getInitiateRequest(s.getSettings(), bb, s.getSettings().getCipher().getDedicatedKey() != null);
                break;
            }
            case 8: {
                bb.set(GXAPDU.getUserInformation(s.getSettings(), s.getSettings().getCipher()));
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                GXDLMSSNParameters sn = new GXDLMSSNParameters(s.getSettings(), s.getCommand(), s.getCount(), s.getRequestType(), s.getAttributeDescriptor(), s.getData());
                GXDLMS.getSNPdu(sn, bb);
                break;
            }
            case 192: 
            case 193: 
            case 195: 
            case 196: 
            case 197: 
            case 199: {
                GXDLMSLNParameters ln = new GXDLMSLNParameters(s.getSettings(), 0L, s.getCommand(), s.getRequestType(), s.getAttributeDescriptor(), s.getData(), 255, 0);
                GXDLMS.getLNPdu(ln, bb);
                break;
            }
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 200: 
            case 201: 
            case 203: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 211: 
            case 212: 
            case 213: 
            case 215: {
                bb.setUInt8(s.getCommand());
                GXCommon.setObjectCount(s.getData().size(), bb);
                bb.set(s.getData());
                break;
            }
            case 151: {
                break;
            }
            case 147: {
                s.getSettings().setServer(false);
                bb.set(GXDLMS.getHdlcFrame(s.getSettings(), -109, null));
                break;
            }
            case 115: {
                break;
            }
            case 33: 
            case 96: {
                GXAPDU.generateAarq(s.getSettings(), s.getSettings().getCipher(), s.getData(), bb);
                break;
            }
            case 40: 
            case 97: {
                GXAPDU.generateAARE(0, s.getSettings(), bb, s.getResult(), (Object)s.getDiagnostic(), s.getSettings().getCipher(), s.getAttributeDescriptor(), s.getData());
                break;
            }
            case 83: {
                break;
            }
            case 98: {
                bb.setUInt8(s.getCommand());
                bb.setUInt8(3 + s.getData().size());
                bb.setUInt8(128);
                bb.setUInt8(1);
                bb.setUInt8(s.getReason());
                if (s.getData().size() == 0) {
                    bb.setUInt8(0);
                    break;
                }
                bb.set(s.getData());
                break;
            }
            case 99: {
                bb.setUInt8(s.getCommand());
                bb.setUInt8(3);
                bb.setUInt8(128);
                bb.setUInt8(1);
                bb.setUInt8(s.getReason());
                break;
            }
            case 14: 
            case 216: {
                bb.setUInt8(s.getCommand());
                bb.set(s.getAttributeDescriptor());
                break;
            }
            case 224: {
                GXDLMSLNParameters ln = new GXDLMSLNParameters(s.getSettings(), 0L, s.getCommand(), s.getRequestType(), s.getAttributeDescriptor(), s.getData(), 255, 0);
                GXDLMS.getLNPdu(ln, bb);
                break;
            }
            case 217: {
                GXDLMSLNParameters ln = new GXDLMSLNParameters(s.getSettings(), 0L, s.getCommand(), s.getRequestType(), s.getAttributeDescriptor(), s.getData(), 255, 0);
                GXDLMS.getLNPdu(ln, bb);
                break;
            }
            case 218: {
                GXDLMSLNParameters ln = new GXDLMSLNParameters(s.getSettings(), 0L, s.getCommand(), s.getRequestType(), s.getAttributeDescriptor(), s.getData(), 255, 0);
                GXDLMS.getLNPdu(ln, bb);
                break;
            }
            case 15: {
                GXDLMSLNParameters ln = new GXDLMSLNParameters(s.getSettings(), 0L, s.getCommand(), s.getRequestType(), s.getAttributeDescriptor(), s.getData(), 255, 0);
                ln.setTime(s.getTime());
                GXDLMS.getLNPdu(ln, bb);
                break;
            }
            case 24: {
                GXDLMSSNParameters sn = new GXDLMSSNParameters(s.getSettings(), s.getCommand(), s.getCount(), s.getRequestType(), s.getAttributeDescriptor(), s.getData());
                sn.setTime(s.getTime());
                GXDLMS.getSNPdu(sn, bb);
                break;
            }
            case 194: {
                GXDLMSLNParameters ln = new GXDLMSLNParameters(s.getSettings(), 0L, s.getCommand(), s.getRequestType(), s.getAttributeDescriptor(), s.getData(), 255, 0);
                ln.setTime(s.getTime());
                GXDLMS.getLNPdu(ln, bb);
                break;
            }
            case 219: {
                bb.setUInt8(s.getCommand());
                GXCommon.setObjectCount(s.getSettings().getSourceSystemTitle().length, bb);
                bb.set(s.getSettings().getSourceSystemTitle());
                GXCommon.setObjectCount(s.getData().size(), bb);
                bb.set(s.getData());
                break;
            }
            case 221: {
                bb.setUInt8(s.getCommand());
                bb.set(s.getData());
                break;
            }
            case 202: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid command.");
            }
        }
        if (s.getPhysicalDeviceAddress() != null) {
            GXByteBuffer bb2 = new GXByteBuffer();
            bb2.setUInt8(s.getGwCommand());
            bb2.setUInt8(s.getNetworkId());
            GXCommon.setObjectCount(s.getPhysicalDeviceAddress().length, bb2);
            bb2.set(s.getPhysicalDeviceAddress());
            bb2.set(bb);
            return bb2.array();
        }
        return bb.array();
    }

    public final boolean isHex() {
        return this.hex;
    }

    public final void setHex(boolean value) {
        this.hex = value;
    }

    public final boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    public final void setOmitXmlDeclaration(boolean value) {
        this.omitXmlDeclaration = value;
    }

    public final boolean isOmitXmlNameSpace() {
        return this.omitXmlNameSpace;
    }

    public final void setOmitXmlNameSpace(boolean value) {
        this.omitXmlNameSpace = value;
    }

    public final String dataToXml(GXByteBuffer data) {
        GXDataInfo di = new GXDataInfo();
        GXDLMSTranslatorStructure xml = new GXDLMSTranslatorStructure(this.outputType, this.omitXmlNameSpace, this.hex, this.getShowStringAsHex(), this.comments, this.tags);
        di.setXml(xml);
        GXCommon.getData(null, data, di);
        return di.getXml().toString();
    }

    private void getAllDataNodes(NodeList nodes, GXDLMSXmlSettings s) {
        for (int pos = 0; pos != nodes.getLength(); ++pos) {
            Node it = nodes.item(pos);
            if (it.getNodeType() != 1) continue;
            int tag = s.getOutputType() == TranslatorOutputType.SIMPLE_XML ? s.getTags().get(it.getNodeName().toLowerCase()).intValue() : s.getTags().get(it.getNodeName()).intValue();
            if (tag == 65299) {
                s.getData().setHexString(it.getNodeValue());
                continue;
            }
            GXByteBuffer preData = GXDLMSTranslator.updateDataType(it, s, tag);
            if (preData == null) continue;
            GXCommon.setObjectCount(it.getChildNodes().getLength(), preData);
            preData.set(s.getData());
            s.getData().size(0);
            s.getData().set(preData);
            this.getAllDataNodes(it.getChildNodes(), s);
        }
    }

    public final byte[] xmlToData(String xml) {
        Document doc;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        GXDLMSXmlSettings s = new GXDLMSXmlSettings(this.outputType, this.hex, this.getShowStringAsHex(), this.tagsByName);
        this.getAllDataNodes(doc.getDocumentElement().getChildNodes(), s);
        return s.getData().array();
    }

    public boolean getUseGeneralProtection() {
        return this.useGeneralProtection;
    }

    public void setUseGeneralProtection(boolean value) {
        this.useGeneralProtection = value;
    }
}

