/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.ReleaseRequestReason;
import gurux.dlms.ReleaseResponseReason;
import gurux.dlms.Service;
import gurux.dlms.ServiceError;
import gurux.dlms.TranslatorOutputType;
import gurux.dlms.enums.Access;
import gurux.dlms.enums.ApplicationReference;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.Definition;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ExceptionServiceError;
import gurux.dlms.enums.ExceptionStateError;
import gurux.dlms.enums.HardwareResource;
import gurux.dlms.enums.Initiate;
import gurux.dlms.enums.LoadDataSet;
import gurux.dlms.enums.Task;
import gurux.dlms.enums.VdeStateError;
import java.util.HashMap;
import java.util.Map;

final class TranslatorSimpleTags {
    private TranslatorSimpleTags() {
    }

    static void getGeneralTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 147, "Snrm");
        GXDLMSTranslator.addTag(list, 151, "UnacceptableFrame");
        GXDLMSTranslator.addTag(list, 31, "DisconnectMode");
        GXDLMSTranslator.addTag(list, 115, "Ua");
        GXDLMSTranslator.addTag(list, 96, "AssociationRequest");
        GXDLMSTranslator.addTag(list, 97, "AssociationResponse");
        GXDLMSTranslator.addTag(list, 161, "ApplicationContextName");
        GXDLMSTranslator.addTag(list, 8, "InitiateResponse");
        GXDLMSTranslator.addTag(list, 1, "InitiateRequest");
        GXDLMSTranslator.addTag(list, 48640, "NegotiatedQualityOfService");
        GXDLMSTranslator.addTag(list, 48649, "ProposedQualityOfService");
        GXDLMSTranslator.addTag(list, 48641, "ProposedDlmsVersionNumber");
        GXDLMSTranslator.addTag(list, 48642, "ProposedMaxPduSize");
        GXDLMSTranslator.addTag(list, 48643, "ProposedConformance");
        GXDLMSTranslator.addTag(list, 48644, "VaaName");
        GXDLMSTranslator.addTag(list, 48645, "NegotiatedConformance");
        GXDLMSTranslator.addTag(list, 48646, "NegotiatedDlmsVersionNumber");
        GXDLMSTranslator.addTag(list, 48647, "NegotiatedMaxPduSize");
        GXDLMSTranslator.addTag(list, 48648, "ConformanceBit");
        GXDLMSTranslator.addTag(list, 138, "SenderACSERequirements");
        GXDLMSTranslator.addTag(list, 136, "ResponderACSERequirement");
        GXDLMSTranslator.addTag(list, 137, "MechanismName");
        GXDLMSTranslator.addTag(list, 139, "MechanismName");
        GXDLMSTranslator.addTag(list, 172, "CallingAuthentication");
        GXDLMSTranslator.addTag(list, 128, "RespondingAuthentication");
        GXDLMSTranslator.addTag(list, 98, "ReleaseRequest");
        GXDLMSTranslator.addTag(list, 99, "ReleaseResponse");
        GXDLMSTranslator.addTag(list, 83, "DisconnectRequest");
        GXDLMSTranslator.addTag(list, 162, "AssociationResult");
        GXDLMSTranslator.addTag(list, 163, "ResultSourceDiagnostic");
        GXDLMSTranslator.addTag(list, 41729, "ACSEServiceUser");
        GXDLMSTranslator.addTag(list, 41730, "ACSEServiceProvider");
        GXDLMSTranslator.addTag(list, 166, "CallingAPTitle");
        GXDLMSTranslator.addTag(list, 164, "RespondingAPTitle");
        GXDLMSTranslator.addTag(list, 168, "DedicatedKey");
        GXDLMSTranslator.addTag(list, 171, "UserInformation");
        GXDLMSTranslator.addTag(list, 14, "ConfirmedServiceError");
        GXDLMSTranslator.addTag(list, 24, "InformationReportRequest");
        GXDLMSTranslator.addTag(list, 194, "EventNotificationRequest");
        GXDLMSTranslator.addTag(list, 216, "ExceptionResponse");
        GXDLMSTranslator.addTag(list, 65412, "StateError");
        GXDLMSTranslator.addTag(list, 65345, "ServiceError");
    }

    static void getSnTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        list.put(5, "ReadRequest");
        list.put(6, "WriteRequest");
        list.put(1536, "VariableName");
        list.put(13, "WriteResponse");
        list.put(1282, "VariableName");
        list.put(1284, "ParameterisedAccess");
        list.put(1285, "BlockNumberAccess");
        list.put(1538, "VariableName");
        list.put(12, "ReadResponse");
        list.put(3074, "DataBlockResult");
        list.put(3072, "Data");
        list.put(3073, "DataAccessError");
    }

    static void getLnTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 192, "GetRequest");
        list.put(49153, "GetRequestNormal");
        list.put(49154, "GetRequestForNextDataBlock");
        list.put(49155, "GetRequestWithList");
        GXDLMSTranslator.addTag(list, 193, "SetRequest");
        list.put(49409, "SetRequestNormal");
        list.put(49410, "SetRequestFirstDataBlock");
        list.put(49411, "SetRequestWithDataBlock");
        list.put(49412, "SetRequestWithList");
        GXDLMSTranslator.addTag(list, 195, "ActionRequest");
        list.put(49921, "ActionRequestNormal");
        list.put(49922, "ActionRequestForNextPBlock");
        list.put(49923, "ActionRequestWithList");
        list.put(49924, "ActionRequestWithFirstBlock");
        list.put(49925, "ActionRequestWithListAndFirstBlock");
        list.put(49926, "ActionRequestWithBlock");
        GXDLMSTranslator.addTag(list, 199, "ActionResponse");
        list.put(50945, "ActionResponseNormal");
        list.put(50946, "ActionResponseWithPBlock");
        list.put(50947, "ActionResponseWithList");
        list.put(50948, "ActionResponseWithBlock");
        list.put(15, "DataNotification");
        GXDLMSTranslator.addTag(list, 196, "GetResponse");
        list.put(50177, "GetResponseNormal");
        list.put(50178, "GetResponsewithDataBlock");
        list.put(50179, "GetResponseWithList");
        GXDLMSTranslator.addTag(list, 197, "SetResponse");
        list.put(50433, "SetResponseNormal");
        list.put(50434, "SetResponseDataBlock");
        list.put(50435, "SetResponseWithLastDataBlock");
        list.put(50437, "SetResponseWithList");
        GXDLMSTranslator.addTag(list, 217, "AccessRequest");
        list.put(55553, "AccessRequestGet");
        list.put(55554, "AccessRequestSet");
        list.put(55555, "AccessRequestAction");
        GXDLMSTranslator.addTag(list, 218, "AccessResponse");
        list.put(55809, "AccessResponseGet");
        list.put(55810, "AccessResponseSet");
        list.put(55811, "AccessResponseAction");
        list.put(65329, "AccessRequestBody");
        list.put(65330, "AccessRequestSpecification");
        list.put(65331, "_AccessRequestSpecification");
        list.put(65332, "AccessRequestListOfData");
        list.put(65333, "AccessResponseBody");
        list.put(65334, "AccessResponseSpecification");
        list.put(65335, "_AccessResponseSpecification");
        list.put(65336, "AccessResponseListOfData");
        list.put(65344, "Service");
        list.put(65345, "ServiceError");
        list.put(224, "GeneralBlockTransfer");
        GXDLMSTranslator.addTag(list, 169, "CallingAEInvocationId");
        GXDLMSTranslator.addTag(list, 165, "CalledAEInvocationId");
        GXDLMSTranslator.addTag(list, 173, "RespondingAEInvocationId");
        GXDLMSTranslator.addTag(list, 230, "GatewayRequest");
        GXDLMSTranslator.addTag(list, 231, "GatewayResponse");
    }

    static void getPlcTags(HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 29, "DiscoverRequest");
        GXDLMSTranslator.addTag(list, 30, "DiscoverReport");
        GXDLMSTranslator.addTag(list, 28, "RegisterRequest");
        GXDLMSTranslator.addTag(list, 25, "PingRequest");
        GXDLMSTranslator.addTag(list, 26, "PingResponse");
    }

    static void getGloTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 33, "glo_InitiateRequest");
        GXDLMSTranslator.addTag(list, 40, "glo_InitiateResponse");
        GXDLMSTranslator.addTag(list, 200, "glo_GetRequest");
        GXDLMSTranslator.addTag(list, 204, "glo_GetResponse");
        GXDLMSTranslator.addTag(list, 201, "glo_SetRequest");
        GXDLMSTranslator.addTag(list, 205, "glo_SetResponse");
        GXDLMSTranslator.addTag(list, 203, "glo_ActionRequest");
        GXDLMSTranslator.addTag(list, 207, "glo_ActionResponse");
        GXDLMSTranslator.addTag(list, 37, "glo_ReadRequest");
        GXDLMSTranslator.addTag(list, 44, "glo_ReadResponse");
        GXDLMSTranslator.addTag(list, 38, "glo_WriteRequest");
        GXDLMSTranslator.addTag(list, 45, "glo_WriteResponse");
        GXDLMSTranslator.addTag(list, 219, "GeneralGloCiphering");
        GXDLMSTranslator.addTag(list, 221, "GeneralCiphering");
        GXDLMSTranslator.addTag(list, 46, "glo_ConfirmedServiceError");
    }

    static void getDedTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 65, "ded_InitiateRequest");
        GXDLMSTranslator.addTag(list, 72, "ded_InitiateResponse");
        GXDLMSTranslator.addTag(list, 208, "ded_GetRequest");
        GXDLMSTranslator.addTag(list, 212, "ded_GetResponse");
        GXDLMSTranslator.addTag(list, 209, "ded_SetRequest");
        GXDLMSTranslator.addTag(list, 213, "ded_SetResponse");
        GXDLMSTranslator.addTag(list, 211, "ded_ActionRequest");
        GXDLMSTranslator.addTag(list, 215, "ded_ActionResponse");
        GXDLMSTranslator.addTag(list, 220, "GeneralDedCiphering");
        GXDLMSTranslator.addTag(list, 78, "ded_ConfirmedServiceError");
    }

    static void getTranslatorTags(TranslatorOutputType type, HashMap<Integer, String> list) {
        GXDLMSTranslator.addTag(list, 65281, "Wrapper");
        GXDLMSTranslator.addTag(list, 65282, "Hdlc");
        GXDLMSTranslator.addTag(list, 65283, "Pdu");
        GXDLMSTranslator.addTag(list, 65284, "TargetAddress");
        GXDLMSTranslator.addTag(list, 65285, "SourceAddress");
        GXDLMSTranslator.addTag(list, 65380, "FrameType");
        GXDLMSTranslator.addTag(list, 65286, "ListOfVariableAccessSpecification");
        GXDLMSTranslator.addTag(list, 65287, "ListOfData");
        GXDLMSTranslator.addTag(list, 65288, "Success");
        GXDLMSTranslator.addTag(list, 65289, "DataAccessError");
        GXDLMSTranslator.addTag(list, 65290, "AttributeDescriptor");
        GXDLMSTranslator.addTag(list, 65291, "ClassId");
        GXDLMSTranslator.addTag(list, 65292, "InstanceId");
        GXDLMSTranslator.addTag(list, 65293, "AttributeId");
        GXDLMSTranslator.addTag(list, 65294, "MethodInvocationParameters");
        GXDLMSTranslator.addTag(list, 65295, "Selector");
        GXDLMSTranslator.addTag(list, 65296, "Parameter");
        GXDLMSTranslator.addTag(list, 65297, "LastBlock");
        GXDLMSTranslator.addTag(list, 65298, "BlockNumber");
        GXDLMSTranslator.addTag(list, 65299, "RawData");
        GXDLMSTranslator.addTag(list, 65300, "MethodDescriptor");
        GXDLMSTranslator.addTag(list, 65301, "MethodId");
        GXDLMSTranslator.addTag(list, 65302, "Result");
        GXDLMSTranslator.addTag(list, 65413, "PBlock");
        GXDLMSTranslator.addTag(list, 65303, "ReturnParameters");
        GXDLMSTranslator.addTag(list, 65304, "AccessSelection");
        GXDLMSTranslator.addTag(list, 65305, "Value");
        GXDLMSTranslator.addTag(list, 65306, "AccessSelector");
        GXDLMSTranslator.addTag(list, 65307, "AccessParameters");
        GXDLMSTranslator.addTag(list, 65308, "AttributeDescriptorList");
        GXDLMSTranslator.addTag(list, 65309, "AttributeDescriptorWithSelection");
        GXDLMSTranslator.addTag(list, 65310, "ReadDataBlockAccess");
        GXDLMSTranslator.addTag(list, 65311, "WriteDataBlockAccess");
        GXDLMSTranslator.addTag(list, 65312, "Data");
        GXDLMSTranslator.addTag(list, 65313, "InvokeIdAndPriority");
        GXDLMSTranslator.addTag(list, 65320, "LongInvokeIdAndPriority");
        GXDLMSTranslator.addTag(list, 65314, "DateTime");
        GXDLMSTranslator.addTag(list, 65366, "CurrentTime");
        GXDLMSTranslator.addTag(list, 65367, "Time");
        GXDLMSTranslator.addTag(list, 65315, "Reason");
        GXDLMSTranslator.addTag(list, 65321, "NotificationBody");
        GXDLMSTranslator.addTag(list, 65328, "DataValue");
        GXDLMSTranslator.addTag(list, 65347, "CipheredService");
        GXDLMSTranslator.addTag(list, 65348, "SystemTitle");
        GXDLMSTranslator.addTag(list, 65349, "DataBlock");
        GXDLMSTranslator.addTag(list, 65350, "TransactionId");
        GXDLMSTranslator.addTag(list, 65351, "OriginatorSystemTitle");
        GXDLMSTranslator.addTag(list, 65352, "RecipientSystemTitle");
        GXDLMSTranslator.addTag(list, 65353, "OtherInformation");
        GXDLMSTranslator.addTag(list, 65360, "KeyInfo");
        GXDLMSTranslator.addTag(list, 65364, "CipheredContent");
        GXDLMSTranslator.addTag(list, 65361, "AgreedKey");
        GXDLMSTranslator.addTag(list, 65362, "KeyParameters");
        GXDLMSTranslator.addTag(list, 65363, "KeyCipheredData");
        GXDLMSTranslator.addTag(list, 65365, "AttributeValue");
        GXDLMSTranslator.addTag(list, 65368, "MaxInfoRX");
        GXDLMSTranslator.addTag(list, 65369, "MaxInfoTX");
        GXDLMSTranslator.addTag(list, 65376, "WindowSizeRX");
        GXDLMSTranslator.addTag(list, 65377, "WindowSizeTX");
        GXDLMSTranslator.addTag(list, 65378, "ValueList");
        GXDLMSTranslator.addTag(list, 65379, "DataAccessResult");
        GXDLMSTranslator.addTag(list, 65381, "BlockControl");
        GXDLMSTranslator.addTag(list, 65382, "BlockNumberAck");
        GXDLMSTranslator.addTag(list, 65383, "BlockData");
        GXDLMSTranslator.addTag(list, 65384, "ContentsDescription");
        GXDLMSTranslator.addTag(list, 65385, "ArrayContents");
        GXDLMSTranslator.addTag(list, 65402, "NetworkId");
        GXDLMSTranslator.addTag(list, 65403, "PhysicalDeviceAddress");
        GXDLMSTranslator.addTag(list, 65404, "ProtocolVersion");
        GXDLMSTranslator.addTag(list, 65405, "CalledAPTitle");
        GXDLMSTranslator.addTag(list, 65406, "CalledAPInvocationId");
        GXDLMSTranslator.addTag(list, 65407, "CalledAEInvocationId");
        GXDLMSTranslator.addTag(list, 65408, "CallingApInvocationId");
        GXDLMSTranslator.addTag(list, 65409, "CalledAEQualifier");
    }

    static void getDataTypeTags(HashMap<Integer, String> list) {
        list.put(0xFF0000 + DataType.NONE.getValue(), "None");
        list.put(0xFF0000 + DataType.ARRAY.getValue(), "Array");
        list.put(0xFF0000 + DataType.BCD.getValue(), "BCD");
        list.put(0xFF0000 + DataType.BITSTRING.getValue(), "BitString");
        list.put(0xFF0000 + DataType.BOOLEAN.getValue(), "Boolean");
        list.put(0xFF0000 + DataType.COMPACT_ARRAY.getValue(), "CompactArray");
        list.put(0xFF0000 + DataType.DATE.getValue(), "Date");
        list.put(0xFF0000 + DataType.DATETIME.getValue(), "DateTime");
        list.put(0xFF0000 + DataType.ENUM.getValue(), "Enum");
        list.put(0xFF0000 + DataType.FLOAT32.getValue(), "Float32");
        list.put(0xFF0000 + DataType.FLOAT64.getValue(), "Float64");
        list.put(0xFF0000 + DataType.INT16.getValue(), "Int16");
        list.put(0xFF0000 + DataType.INT32.getValue(), "Int32");
        list.put(0xFF0000 + DataType.INT64.getValue(), "Int64");
        list.put(0xFF0000 + DataType.INT8.getValue(), "Int8");
        list.put(0xFF0000 + DataType.OCTET_STRING.getValue(), "OctetString");
        list.put(0xFF0000 + DataType.STRING.getValue(), "String");
        list.put(0xFF0000 + DataType.STRING_UTF8.getValue(), "StringUTF8");
        list.put(0xFF0000 + DataType.STRUCTURE.getValue(), "Structure");
        list.put(0xFF0000 + DataType.TIME.getValue(), "Time");
        list.put(0xFF0000 + DataType.UINT16.getValue(), "UInt16");
        list.put(0xFF0000 + DataType.UINT32.getValue(), "UInt32");
        list.put(0xFF0000 + DataType.UINT64.getValue(), "UInt64");
        list.put(0xFF0000 + DataType.UINT8.getValue(), "UInt8");
    }

    static String errorCodeToString(ErrorCode value) {
        String str;
        switch (value) {
            case ACCESS_VIOLATED: {
                str = "AccessViolated";
                break;
            }
            case DATA_BLOCK_NUMBER_INVALID: {
                str = "DataBlockNumberInvalid";
                break;
            }
            case DATA_BLOCK_UNAVAILABLE: {
                str = "DataBlockUnavailable";
                break;
            }
            case HARDWARE_FAULT: {
                str = "HardwareFault";
                break;
            }
            case INCONSISTENT_CLASS: {
                str = "InconsistentClass";
                break;
            }
            case LONG_GET_OR_READ_ABORTED: {
                str = "LongGetOrReadAborted";
                break;
            }
            case LONG_SET_OR_WRITE_ABORTED: {
                str = "LongSetOrWriteAborted";
                break;
            }
            case NO_LONG_GET_OR_READ_IN_PROGRESS: {
                str = "NoLongGetOrReadInProgress";
                break;
            }
            case NO_LONG_SET_OR_WRITE_IN_PROGRESS: {
                str = "NoLongSetOrWriteInProgress";
                break;
            }
            case OK: {
                str = "Success";
                break;
            }
            case OTHER_REASON: {
                str = "OtherReason";
                break;
            }
            case READ_WRITE_DENIED: {
                str = "ReadWriteDenied";
                break;
            }
            case TEMPORARY_FAILURE: {
                str = "TemporaryFailure";
                break;
            }
            case UNAVAILABLE_OBJECT: {
                str = "UnavailableObject";
                break;
            }
            case UNDEFINED_OBJECT: {
                str = "UndefinedObject";
                break;
            }
            case UNMATCHED_TYPE: {
                str = "UnmatchedType";
                break;
            }
            default: {
                throw new IllegalArgumentException("Error code: " + String.valueOf((Object)value));
            }
        }
        return str;
    }

    static ErrorCode valueOfErrorCode(String value) {
        ErrorCode v;
        if ("AccessViolated".equalsIgnoreCase(value)) {
            v = ErrorCode.ACCESS_VIOLATED;
        } else if ("DataBlockNumberInvalid".equalsIgnoreCase(value)) {
            v = ErrorCode.DATA_BLOCK_NUMBER_INVALID;
        } else if ("DataBlockUnavailable".equalsIgnoreCase(value)) {
            v = ErrorCode.DATA_BLOCK_UNAVAILABLE;
        } else if ("HardwareFault".equalsIgnoreCase(value)) {
            v = ErrorCode.HARDWARE_FAULT;
        } else if ("InconsistentClass".equalsIgnoreCase(value)) {
            v = ErrorCode.INCONSISTENT_CLASS;
        } else if ("LongGetOrReadAborted".equalsIgnoreCase(value)) {
            v = ErrorCode.LONG_GET_OR_READ_ABORTED;
        } else if ("LongSetOrWriteAborted".equalsIgnoreCase(value)) {
            v = ErrorCode.LONG_SET_OR_WRITE_ABORTED;
        } else if ("NoLongGetOrReadInProgress".equalsIgnoreCase(value)) {
            v = ErrorCode.NO_LONG_GET_OR_READ_IN_PROGRESS;
        } else if ("NoLongSetOrWriteInProgress".equalsIgnoreCase(value)) {
            v = ErrorCode.NO_LONG_SET_OR_WRITE_IN_PROGRESS;
        } else if ("Success".equalsIgnoreCase(value)) {
            v = ErrorCode.OK;
        } else if ("OtherReason".equalsIgnoreCase(value)) {
            v = ErrorCode.OTHER_REASON;
        } else if ("ReadWriteDenied".equalsIgnoreCase(value)) {
            v = ErrorCode.READ_WRITE_DENIED;
        } else if ("TemporaryFailure".equalsIgnoreCase(value)) {
            v = ErrorCode.TEMPORARY_FAILURE;
        } else if ("UnavailableObject".equalsIgnoreCase(value)) {
            v = ErrorCode.UNAVAILABLE_OBJECT;
        } else if ("UndefinedObject".equalsIgnoreCase(value)) {
            v = ErrorCode.UNDEFINED_OBJECT;
        } else if ("UnmatchedType".equalsIgnoreCase(value)) {
            v = ErrorCode.UNMATCHED_TYPE;
        } else {
            throw new IllegalArgumentException("Error code: " + value);
        }
        return v;
    }

    private static Map<ServiceError, String> getServiceErrors() {
        HashMap<ServiceError, String> list = new HashMap<ServiceError, String>();
        list.put(ServiceError.APPLICATION_REFERENCE, "ApplicationReference");
        list.put(ServiceError.HARDWARE_RESOURCE, "HardwareResource");
        list.put(ServiceError.VDE_STATE_ERROR, "VdeStateError");
        list.put(ServiceError.SERVICE, "Service");
        list.put(ServiceError.DEFINITION, "Definition");
        list.put(ServiceError.ACCESS, "Access");
        list.put(ServiceError.INITIATE, "Initiate");
        list.put(ServiceError.LOAD_DATASET, "LoadDataSet");
        list.put(ServiceError.TASK, "Task");
        return list;
    }

    static Map<ApplicationReference, String> getApplicationReference() {
        HashMap<ApplicationReference, String> list = new HashMap<ApplicationReference, String>();
        list.put(ApplicationReference.APPLICATION_CONTEXT_UNSUPPORTED, "ApplicationContextUnsupported");
        list.put(ApplicationReference.APPLICATION_REFERENCE_INVALID, "ApplicationReferenceInvalid");
        list.put(ApplicationReference.APPLICATION_UNREACHABLE, "ApplicationUnreachable");
        list.put(ApplicationReference.DECIPHERING_ERROR, "DecipheringError");
        list.put(ApplicationReference.OTHER, "Other");
        list.put(ApplicationReference.PROVIDER_COMMUNICATION_ERROR, "ProviderCommunicationError");
        list.put(ApplicationReference.TIME_ELAPSED, "TimeElapsed");
        return list;
    }

    static Map<HardwareResource, String> getHardwareResource() {
        HashMap<HardwareResource, String> list = new HashMap<HardwareResource, String>();
        list.put(HardwareResource.MASS_STORAGE_UNAVAILABLE, "MassStorageUnavailable");
        list.put(HardwareResource.MEMORY_UNAVAILABLE, "MemoryUnavailable");
        list.put(HardwareResource.OTHER, "Other");
        list.put(HardwareResource.OTHER_RESOURCE_UNAVAILABLE, "OtherResourceUnavailable");
        list.put(HardwareResource.PROCESSOR_RESOURCE_UNAVAILABLE, "ProcessorResourceUnavailable");
        return list;
    }

    static Map<VdeStateError, String> getVdeStateError() {
        HashMap<VdeStateError, String> list = new HashMap<VdeStateError, String>();
        list.put(VdeStateError.LOADING_DATASET, "LoadingDataSet");
        list.put(VdeStateError.NO_DLMS_CONTEXT, "NoDlmsContext");
        list.put(VdeStateError.OTHER, "Other");
        list.put(VdeStateError.STATUS_INOPERABLE, "StatusInoperable");
        list.put(VdeStateError.STATUS_NO_CHANGE, "StatusNochange");
        return list;
    }

    static Map<Service, String> getService() {
        HashMap<Service, String> list = new HashMap<Service, String>();
        list.put(Service.OTHER, "Other");
        list.put(Service.PDU_SIZE, "PduSize");
        list.put(Service.UNSUPPORTED, "ServiceUnsupported");
        return list;
    }

    static Map<Definition, String> getDefinition() {
        HashMap<Definition, String> list = new HashMap<Definition, String>();
        list.put(Definition.OBJECT_ATTRIBUTE_INCONSISTENT, "ObjectAttributeInconsistent");
        list.put(Definition.OBJECT_CLASS_INCONSISTENT, "ObjectClassInconsistent");
        list.put(Definition.OBJECT_UNDEFINED, "ObjectUndefined");
        list.put(Definition.OTHER, "Other");
        return list;
    }

    static Map<Access, String> getAccess() {
        HashMap<Access, String> list = new HashMap<Access, String>();
        list.put(Access.HARDWARE_FAULT, "HardwareFault");
        list.put(Access.OBJECT_ACCESS_INVALID, "ObjectAccessInvalid");
        list.put(Access.OBJECT_UNAVAILABLE, "ObjectUnavailable");
        list.put(Access.OTHER, "Other");
        list.put(Access.SCOPE_OF_ACCESS_VIOLATED, "ScopeOfAccessViolated");
        return list;
    }

    static Map<Initiate, String> getInitiate() {
        HashMap<Initiate, String> list = new HashMap<Initiate, String>();
        list.put(Initiate.DLMS_VERSION_TOO_LOW, "DlmsVersionTooLow");
        list.put(Initiate.INCOMPATIBLE_CONFORMANCE, "IncompatibleConformance");
        list.put(Initiate.OTHER, "Other");
        list.put(Initiate.PDU_SIZE_TOO_SHORT, "PduSizeTooShort");
        list.put(Initiate.REFUSED_BY_THE_VDE_HANDLER, "RefusedByTheVDEHandler");
        return list;
    }

    static Map<LoadDataSet, String> getLoadDataSet() {
        HashMap<LoadDataSet, String> list = new HashMap<LoadDataSet, String>();
        list.put(LoadDataSet.DATASET_NOT_READY, "DataSetNotReady");
        list.put(LoadDataSet.DATASET_SIZE_TOO_LARGE, "DatasetSizeTooLarge");
        list.put(LoadDataSet.INTERPRETATION_FAILURE, "InterpretationFailure");
        list.put(LoadDataSet.NOT_AWAITED_SEGMENT, "NotAwaitedSegment");
        list.put(LoadDataSet.NOT_LOADABLE, "NotLoadable");
        list.put(LoadDataSet.OTHER, "Other");
        list.put(LoadDataSet.PRIMITIVE_OUT_OF_SEQUENCE, "PrimitiveOutOfSequence");
        list.put(LoadDataSet.STORAGE_FAILURE, "StorageFailure");
        return list;
    }

    static Map<Task, String> getTask() {
        HashMap<Task, String> list = new HashMap<Task, String>();
        list.put(Task.NO_REMOTE_CONTROL, "NoRemoteControl");
        list.put(Task.OTHER, "Other");
        list.put(Task.TI_RUNNING, "tiRunning");
        list.put(Task.TI_STOPPED, "tiStopped");
        list.put(Task.TI_UNUSABLE, "tiUnusable");
        return list;
    }

    static String getServiceErrorValue(ServiceError error, byte value) {
        switch (error) {
            case APPLICATION_REFERENCE: {
                return TranslatorSimpleTags.getApplicationReference().get((Object)ApplicationReference.forValue(value));
            }
            case HARDWARE_RESOURCE: {
                return TranslatorSimpleTags.getHardwareResource().get((Object)HardwareResource.forValue(value));
            }
            case VDE_STATE_ERROR: {
                return TranslatorSimpleTags.getVdeStateError().get((Object)VdeStateError.forValue(value));
            }
            case SERVICE: {
                return TranslatorSimpleTags.getService().get((Object)Service.forValue(value));
            }
            case DEFINITION: {
                return TranslatorSimpleTags.getDefinition().get((Object)Definition.forValue(value));
            }
            case ACCESS: {
                return TranslatorSimpleTags.getAccess().get((Object)Access.forValue(value));
            }
            case INITIATE: {
                return TranslatorSimpleTags.getInitiate().get((Object)Initiate.forValue(value));
            }
            case LOAD_DATASET: {
                return TranslatorSimpleTags.getLoadDataSet().get((Object)LoadDataSet.forValue(value));
            }
            case TASK: {
                return TranslatorSimpleTags.getTask().get((Object)Task.forValue(value));
            }
            case OTHER_ERROR: {
                return String.valueOf(value);
            }
        }
        return "";
    }

    static String serviceErrorToString(ServiceError error) {
        return TranslatorSimpleTags.getServiceErrors().get((Object)error);
    }

    static String stateErrorToString(ExceptionStateError error) {
        switch (error) {
            case SERVICE_NOT_ALLOWED: {
                return "ServiceNotAllowed";
            }
            case SERVICE_UNKNOWN: {
                return "ServiceUnknown";
            }
        }
        throw new IllegalArgumentException();
    }

    static String exceptionServiceErrorToString(ExceptionServiceError error) {
        switch (error) {
            case OPERATION_NOT_POSSIBLE: {
                return "OperationNotPossible";
            }
            case SERVICE_NOT_SUPPORTED: {
                return "ServiceNotSupported";
            }
            case OTHER_REASON: {
                return "OtherReason";
            }
            case PDU_TOO_LONG: {
                return "PduTooLong";
            }
            case DECIPHERING_ERROR: {
                return "DecipheringError";
            }
            case INVOCATION_COUNTER_ERROR: {
                return "InvocationCounterError";
            }
        }
        throw new IllegalArgumentException();
    }

    static ExceptionStateError valueofStateError(String value) {
        if ("ServiceNotAllowed".equalsIgnoreCase(value)) {
            return ExceptionStateError.SERVICE_NOT_ALLOWED;
        }
        if ("ServiceUnknown".equalsIgnoreCase(value)) {
            return ExceptionStateError.SERVICE_UNKNOWN;
        }
        throw new IllegalArgumentException();
    }

    static ExceptionServiceError valueOfExceptionServiceError(String value) {
        if ("OperationNotPossible".equalsIgnoreCase(value)) {
            return ExceptionServiceError.OPERATION_NOT_POSSIBLE;
        }
        if ("ServiceNotSupported".equalsIgnoreCase(value)) {
            return ExceptionServiceError.SERVICE_NOT_SUPPORTED;
        }
        if ("OtherReason".equalsIgnoreCase(value)) {
            return ExceptionServiceError.OTHER_REASON;
        }
        if ("PduTooLong".equalsIgnoreCase(value)) {
            return ExceptionServiceError.PDU_TOO_LONG;
        }
        if ("DecipheringError".equalsIgnoreCase(value)) {
            return ExceptionServiceError.DECIPHERING_ERROR;
        }
        if ("InvocationCounterError".equalsIgnoreCase(value)) {
            return ExceptionServiceError.INVOCATION_COUNTER_ERROR;
        }
        throw new IllegalArgumentException();
    }

    static ServiceError getServiceError(String value) {
        ServiceError error = null;
        for (Map.Entry<ServiceError, String> it : TranslatorSimpleTags.getServiceErrors().entrySet()) {
            if (value.compareTo(it.getValue().toLowerCase()) != 0) continue;
            error = it.getKey();
            break;
        }
        if (error == null) {
            throw new IllegalArgumentException();
        }
        return error;
    }

    private static int getApplicationReference(String value) {
        int ret = -1;
        for (Map.Entry<ApplicationReference, String> it : TranslatorSimpleTags.getApplicationReference().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getHardwareResource(String value) {
        int ret = -1;
        for (Map.Entry<HardwareResource, String> it : TranslatorSimpleTags.getHardwareResource().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getVdeStateError(String value) {
        int ret = -1;
        for (Map.Entry<VdeStateError, String> it : TranslatorSimpleTags.getVdeStateError().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getService(String value) {
        int ret = -1;
        for (Map.Entry<Service, String> it : TranslatorSimpleTags.getService().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getDefinition(String value) {
        int ret = -1;
        for (Map.Entry<Definition, String> it : TranslatorSimpleTags.getDefinition().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getAccess(String value) {
        int ret = -1;
        for (Map.Entry<Access, String> it : TranslatorSimpleTags.getAccess().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    static int getInitiate(String value) {
        int ret = -1;
        for (Map.Entry<Initiate, String> it : TranslatorSimpleTags.getInitiate().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getLoadDataSet(String value) {
        int ret = -1;
        for (Map.Entry<LoadDataSet, String> it : TranslatorSimpleTags.getLoadDataSet().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static int getTask(String value) {
        int ret = -1;
        for (Map.Entry<Task, String> it : TranslatorSimpleTags.getTask().entrySet()) {
            if (value.compareTo(it.getValue()) != 0) continue;
            ret = it.getKey().getValue();
            break;
        }
        if (ret == -1) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    static byte getError(ServiceError serviceError, String value) {
        int ret = 0;
        switch (serviceError) {
            case APPLICATION_REFERENCE: {
                ret = TranslatorSimpleTags.getApplicationReference(value);
                break;
            }
            case HARDWARE_RESOURCE: {
                ret = TranslatorSimpleTags.getHardwareResource(value);
                break;
            }
            case VDE_STATE_ERROR: {
                ret = TranslatorSimpleTags.getVdeStateError(value);
                break;
            }
            case SERVICE: {
                ret = TranslatorSimpleTags.getService(value);
                break;
            }
            case DEFINITION: {
                ret = TranslatorSimpleTags.getDefinition(value);
                break;
            }
            case ACCESS: {
                ret = TranslatorSimpleTags.getAccess(value);
                break;
            }
            case INITIATE: {
                ret = TranslatorSimpleTags.getInitiate(value);
                break;
            }
            case LOAD_DATASET: {
                ret = TranslatorSimpleTags.getLoadDataSet(value);
                break;
            }
            case TASK: {
                ret = TranslatorSimpleTags.getTask(value);
                break;
            }
            case OTHER_ERROR: {
                ret = Integer.parseInt(value);
                break;
            }
        }
        return (byte)ret;
    }

    static String conformancetoString(Conformance value) {
        String str;
        switch (value) {
            case ACCESS: {
                str = "Access";
                break;
            }
            case ACTION: {
                str = "Action";
                break;
            }
            case ATTRIBUTE_0_SUPPORTED_WITH_GET: {
                str = "Attribute0SupportedWithGet";
                break;
            }
            case ATTRIBUTE_0_SUPPORTED_WITH_SET: {
                str = "Attribute0SupportedWithSet";
                break;
            }
            case BLOCK_TRANSFER_WITH_ACTION: {
                str = "BlockTransferWithAction";
                break;
            }
            case BLOCK_TRANSFER_WITH_GET_OR_READ: {
                str = "BlockTransferWithGetOrRead";
                break;
            }
            case BLOCK_TRANSFER_WITH_SET_OR_WRITE: {
                str = "BlockTransferWithSetOrWrite";
                break;
            }
            case DATA_NOTIFICATION: {
                str = "DataNotification";
                break;
            }
            case EVENT_NOTIFICATION: {
                str = "EventNotification";
                break;
            }
            case GENERAL_BLOCK_TRANSFER: {
                str = "GeneralBlockTransfer";
                break;
            }
            case GENERAL_PROTECTION: {
                str = "GeneralProtection";
                break;
            }
            case GET: {
                str = "Get";
                break;
            }
            case INFORMATION_REPORT: {
                str = "InformationReport";
                break;
            }
            case MULTIPLE_REFERENCES: {
                str = "MultipleReferences";
                break;
            }
            case PARAMETERIZED_ACCESS: {
                str = "ParameterizedAccess";
                break;
            }
            case PRIORITY_MGMT_SUPPORTED: {
                str = "PriorityMgmtSupported";
                break;
            }
            case READ: {
                str = "Read";
                break;
            }
            case RESERVED_SEVEN: {
                str = "ReservedSeven";
                break;
            }
            case RESERVED_ZERO: {
                str = "ReservedZero";
                break;
            }
            case SELECTIVE_ACCESS: {
                str = "SelectiveAccess";
                break;
            }
            case SET: {
                str = "Set";
                break;
            }
            case UN_CONFIRMED_WRITE: {
                str = "UnconfirmedWrite";
                break;
            }
            case DELTA_VALUE_ENCODING: {
                str = "DeltaValueEncoding";
                break;
            }
            case WRITE: {
                str = "Write";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)value));
            }
        }
        return str;
    }

    public static Conformance valueOfConformance(String value) {
        Conformance ret;
        if ("Access".equalsIgnoreCase(value)) {
            ret = Conformance.ACCESS;
        } else if ("Action".equalsIgnoreCase(value)) {
            ret = Conformance.ACTION;
        } else if ("Attribute0SupportedWithGet".equalsIgnoreCase(value)) {
            ret = Conformance.ATTRIBUTE_0_SUPPORTED_WITH_GET;
        } else if ("Attribute0SupportedWithSet".equalsIgnoreCase(value)) {
            ret = Conformance.ATTRIBUTE_0_SUPPORTED_WITH_SET;
        } else if ("BlockTransferWithAction".equalsIgnoreCase(value)) {
            ret = Conformance.BLOCK_TRANSFER_WITH_ACTION;
        } else if ("BlockTransferWithGetOrRead".equalsIgnoreCase(value)) {
            ret = Conformance.BLOCK_TRANSFER_WITH_GET_OR_READ;
        } else if ("BlockTransferWithSetOrWrite".equalsIgnoreCase(value)) {
            ret = Conformance.BLOCK_TRANSFER_WITH_SET_OR_WRITE;
        } else if ("DataNotification".equalsIgnoreCase(value)) {
            ret = Conformance.DATA_NOTIFICATION;
        } else if ("EventNotification".equalsIgnoreCase(value)) {
            ret = Conformance.EVENT_NOTIFICATION;
        } else if ("GeneralBlockTransfer".equalsIgnoreCase(value)) {
            ret = Conformance.GENERAL_BLOCK_TRANSFER;
        } else if ("GeneralProtection".equalsIgnoreCase(value)) {
            ret = Conformance.GENERAL_PROTECTION;
        } else if ("Get".equalsIgnoreCase(value)) {
            ret = Conformance.GET;
        } else if ("InformationReport".equalsIgnoreCase(value)) {
            ret = Conformance.INFORMATION_REPORT;
        } else if ("MultipleReferences".equalsIgnoreCase(value)) {
            ret = Conformance.MULTIPLE_REFERENCES;
        } else if ("ParameterizedAccess".equalsIgnoreCase(value)) {
            ret = Conformance.PARAMETERIZED_ACCESS;
        } else if ("PriorityMgmtSupported".equalsIgnoreCase(value)) {
            ret = Conformance.PRIORITY_MGMT_SUPPORTED;
        } else if ("Read".equalsIgnoreCase(value)) {
            ret = Conformance.READ;
        } else if ("ReservedSeven".equalsIgnoreCase(value)) {
            ret = Conformance.RESERVED_SEVEN;
        } else if ("DeltaValueEncoding".equalsIgnoreCase(value)) {
            ret = Conformance.DELTA_VALUE_ENCODING;
        } else if ("ReservedZero".equalsIgnoreCase(value)) {
            ret = Conformance.RESERVED_ZERO;
        } else if ("SelectiveAccess".equalsIgnoreCase(value)) {
            ret = Conformance.SELECTIVE_ACCESS;
        } else if ("Set".equalsIgnoreCase(value)) {
            ret = Conformance.SET;
        } else if ("UnconfirmedWrite".equalsIgnoreCase(value)) {
            ret = Conformance.UN_CONFIRMED_WRITE;
        } else if ("Write".equalsIgnoreCase(value)) {
            ret = Conformance.WRITE;
        } else {
            throw new IllegalArgumentException(value);
        }
        return ret;
    }

    static String releaseResponseReasonToString(ReleaseResponseReason value) {
        String str;
        switch (value) {
            case NORMAL: {
                str = "Normal";
                break;
            }
            case NOT_FINISHED: {
                str = "NotFinished";
                break;
            }
            case USER_DEFINED: {
                str = "UserDefined";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)value));
            }
        }
        return str;
    }

    static ReleaseResponseReason valueOfReleaseResponseReason(String value) {
        ReleaseResponseReason ret;
        if ("Normal".equalsIgnoreCase(value)) {
            ret = ReleaseResponseReason.NORMAL;
        } else if ("NotFinished".equalsIgnoreCase(value)) {
            ret = ReleaseResponseReason.NOT_FINISHED;
        } else if ("UserDefined".equalsIgnoreCase(value)) {
            ret = ReleaseResponseReason.USER_DEFINED;
        } else {
            throw new IllegalArgumentException(value);
        }
        return ret;
    }

    static String releaseRequestReasonToString(ReleaseRequestReason value) {
        String str;
        switch (value) {
            case NORMAL: {
                str = "Normal";
                break;
            }
            case URGENT: {
                str = "Urgent";
                break;
            }
            case USER_DEFINED: {
                str = "UserDefined";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)value));
            }
        }
        return str;
    }

    static ReleaseRequestReason valueOfReleaseRequestReason(String value) {
        ReleaseRequestReason ret;
        if ("Normal".equalsIgnoreCase(value)) {
            ret = ReleaseRequestReason.NORMAL;
        } else if ("Urgent".equalsIgnoreCase(value)) {
            ret = ReleaseRequestReason.URGENT;
        } else if ("UserDefined".equalsIgnoreCase(value)) {
            ret = ReleaseRequestReason.USER_DEFINED;
        } else {
            throw new IllegalArgumentException(value);
        }
        return ret;
    }
}

