/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXx509Certificate;
import gurux.dlms.asn.enums.KeyUsage;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GXx509CertificateCollection
extends ArrayList<GXx509Certificate>
implements List<GXx509Certificate> {
    private static final long serialVersionUID = 1L;

    public GXx509Certificate findBySerial(BigInteger serialNumber, String issuer) {
        for (GXx509Certificate it : this) {
            if (!it.getSerialNumber().equals(serialNumber) || !it.getIssuer().equalsIgnoreCase(issuer)) continue;
            return it;
        }
        return null;
    }

    public GXx509Certificate findBySystemTitle(byte[] systemTitle, KeyUsage usage) {
        String cn = GXAsn1Converter.systemTitleToSubject(systemTitle);
        int u = usage.getValue();
        for (GXx509Certificate it : this) {
            if (KeyUsage.toInteger(it.getKeyUsage()) != u || systemTitle != null && !it.getSubject().contains(cn)) continue;
            return it;
        }
        return null;
    }

    public List<GXx509Certificate> getCertificates(Set<KeyUsage> usage) {
        ArrayList<GXx509Certificate> list = new ArrayList<GXx509Certificate>();
        int u = KeyUsage.toInteger(usage);
        for (GXx509Certificate it : this) {
            if (KeyUsage.toInteger(it.getKeyUsage()) != u) continue;
            list.add(it);
        }
        return list;
    }

    public GXx509Certificate findByCommonName(String commonName, Set<KeyUsage> usage) {
        int value = KeyUsage.toInteger(usage);
        for (GXx509Certificate it : this) {
            if (KeyUsage.toInteger(it.getKeyUsage()) != value || commonName != null && !it.getSubject().contains(commonName)) continue;
            return it;
        }
        return null;
    }

    public GXx509Certificate find(GXx509Certificate cert) {
        for (GXx509Certificate it : this) {
            if (it.getSerialNumber() != cert.getSerialNumber()) continue;
            return it;
        }
        return null;
    }

    public void importFromDirectory(String directory) {
        File dir = new File(directory);
        if (dir.exists()) {
            String[] files;
            for (String it : files = dir.list()) {
                try {
                    if (!it.endsWith(".pem")) continue;
                    File f = new File(it);
                    GXx509Certificate cert = GXx509Certificate.load(f.toPath());
                    this.add(cert);
                }
                catch (Exception ex) {
                    Logger.getLogger(GXx509CertificateCollection.class.getName()).log(Level.SEVERE, "Failed to load x509 certificate: {0}", it);
                }
            }
        }
    }
}

