/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn.enums;

import java.util.HashMap;

public enum X509Certificate {
    UNKNOWN(""),
    OLD_AUTHORITY_KEY_IDENTIFIER("2.5.29.1"),
    OLD_PRIMARY_KEY_ATTRIBUTES("2.5.29.2"),
    CERTIFICATE_POLICIES("2.5.29.3"),
    PRIMARY_KEY_USAGE_RESTRICTION("2.5.29.4"),
    SUBJECT_DIRECTORY_ATTRIBUTES("2.5.29.9"),
    SUBJECT_KEY_IDENTIFIER("2.5.29.14"),
    KEY_USAGE("2.5.29.15"),
    PRIVATE_KEY_USAGE_PERIOD("2.5.29.16"),
    SUBJECT_ALTERNATIVE_NAME("2.5.29.17"),
    ISSUER_ALTERNATIVE_NAME("2.5.29.18"),
    BASIC_CONSTRAINTS("2.5.29.19"),
    CRL_NUMBER("2.5.29.20"),
    REASON_CODE("2.5.29.21"),
    HOLD_INSTRUCTION_CODE("2.5.29.23"),
    INVALIDITY_DATE("2.5.29.24"),
    DELTA_CRL_INDICATOR("2.5.29.27"),
    ISSUING_DISTRIBUTION_POINT("2.5.29.28"),
    CERTIFICATE_ISSUER("2.5.29.29"),
    NAME_CONSTRAINTS("2.5.29.30"),
    CRL_DISTRIBUTION_POINTS("2.5.29.31"),
    CERTIFICATE_POLICIES_2("2.5.29.32"),
    POLICY_MAPPINGS("2.5.29.33"),
    AUTHORITY_KEY_IDENTIFIER("2.5.29.35"),
    POLICY_CONSTRAINTS("2.5.29.36"),
    EXTENDED_KEY_USAGE("2.5.29.37"),
    FRESHEST_CRL("2.5.29.46");

    private String value;
    private static HashMap<String, X509Certificate> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, X509Certificate> getMappings() {
        Class<X509Certificate> clazz = X509Certificate.class;
        synchronized (X509Certificate.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private X509Certificate(String mode) {
        this.value = mode;
        X509Certificate.getMappings().put(new String(mode), this);
    }

    public final String getValue() {
        return this.value;
    }

    public static X509Certificate forValue(String value) {
        X509Certificate ret = X509Certificate.getMappings().get(value);
        if (ret == null) {
            ret = UNKNOWN;
        }
        return ret;
    }
}

