/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.enums;

public enum Authentication {
    NONE,
    LOW,
    HIGH,
    HIGH_MD5,
    HIGH_SHA1,
    HIGH_GMAC,
    HIGH_SHA256,
    HIGH_ECDSA;


    public int getValue() {
        return this.ordinal();
    }

    public static Authentication forValue(int value) {
        return Authentication.values()[value];
    }

    public String toString() {
        String str;
        Authentication value = Authentication.forValue(this.getValue());
        switch (value) {
            case HIGH: {
                str = "High";
                break;
            }
            case HIGH_GMAC: {
                str = "HighGMac";
                break;
            }
            case HIGH_MD5: {
                str = "HighMd5";
                break;
            }
            case HIGH_SHA1: {
                str = "HighSha1";
                break;
            }
            case HIGH_ECDSA: {
                str = "HighECDSA";
                break;
            }
            case HIGH_SHA256: {
                str = "HighSha256";
                break;
            }
            case LOW: {
                str = "Low";
                break;
            }
            case NONE: {
                str = "None";
                break;
            }
            default: {
                str = "";
            }
        }
        return str;
    }

    public static Authentication valueOfString(String value) {
        Authentication v;
        if ("None".equalsIgnoreCase(value)) {
            v = NONE;
        } else if ("Low".equalsIgnoreCase(value)) {
            v = LOW;
        } else if ("High".equalsIgnoreCase(value)) {
            v = HIGH;
        } else if ("HighMd5".equalsIgnoreCase(value)) {
            v = HIGH_MD5;
        } else if ("HighSha1".equalsIgnoreCase(value)) {
            v = HIGH_SHA1;
        } else if ("HighSha256".equalsIgnoreCase(value)) {
            v = HIGH_SHA256;
        } else if ("HighGMac".equalsIgnoreCase(value)) {
            v = HIGH_GMAC;
        } else if ("HighECDSA".equalsIgnoreCase(value)) {
            v = HIGH_ECDSA;
        } else {
            throw new IllegalArgumentException(value);
        }
        return v;
    }
}

