/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.AutoAnswerMode;
import gurux.dlms.objects.enums.AutoAnswerStatus;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class GXDLMSAutoAnswer
extends GXDLMSObject
implements IGXDLMSBase {
    private AutoAnswerMode mode;
    private List<Map.Entry<GXDateTime, GXDateTime>> listeningWindow = new ArrayList<Map.Entry<GXDateTime, GXDateTime>>();
    private AutoAnswerStatus status;
    private int numberOfCalls;
    private int numberOfRingsInListeningWindow;
    private int numberOfRingsOutListeningWindow;

    public GXDLMSAutoAnswer() {
        this("0.0.2.2.0.255", 0);
    }

    public GXDLMSAutoAnswer(String ln) {
        this(ln, 0);
    }

    public GXDLMSAutoAnswer(String ln, int sn) {
        super(ObjectType.AUTO_ANSWER, ln, sn);
        this.mode = AutoAnswerMode.NONE;
        this.status = AutoAnswerStatus.INACTIVE;
    }

    public final AutoAnswerMode getMode() {
        return this.mode;
    }

    public final void setMode(AutoAnswerMode value) {
        this.mode = value;
    }

    public final List<Map.Entry<GXDateTime, GXDateTime>> getListeningWindow() {
        return this.listeningWindow;
    }

    public final void setListeningWindow(List<Map.Entry<GXDateTime, GXDateTime>> value) {
        this.listeningWindow = value;
    }

    public final AutoAnswerStatus getStatus() {
        return this.status;
    }

    public final void setStatus(AutoAnswerStatus value) {
        this.status = value;
    }

    public final int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public final void setNumberOfCalls(int value) {
        this.numberOfCalls = value;
    }

    public final int getNumberOfRingsInListeningWindow() {
        return this.numberOfRingsInListeningWindow;
    }

    public final void setNumberOfRingsInListeningWindow(int value) {
        this.numberOfRingsInListeningWindow = value;
    }

    public final int getNumberOfRingsOutListeningWindow() {
        return this.numberOfRingsOutListeningWindow;
    }

    public final void setNumberOfRingsOutListeningWindow(int value) {
        this.numberOfRingsOutListeningWindow = value;
    }

    @Override
    public final Object[] getValues() {
        String str = String.valueOf(this.numberOfRingsInListeningWindow) + "/" + String.valueOf(this.numberOfRingsOutListeningWindow);
        return new Object[]{this.getLogicalName(), this.getMode(), this.getListeningWindow(), this.getStatus(), this.getNumberOfCalls(), str};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.ENUM;
        }
        if (index == 5) {
            return DataType.UINT8;
        }
        if (index == 6) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getMode().ordinal();
        }
        if (e.getIndex() == 3) {
            int cnt = this.getListeningWindow().size();
            GXByteBuffer buff = new GXByteBuffer();
            buff.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(cnt, buff);
            if (cnt != 0) {
                for (Map.Entry<GXDateTime, GXDateTime> it : this.listeningWindow) {
                    buff.setUInt8(DataType.STRUCTURE.getValue());
                    buff.setUInt8(2);
                    GXCommon.setData(null, buff, DataType.OCTET_STRING, it.getKey());
                    GXCommon.setData(null, buff, DataType.OCTET_STRING, it.getValue());
                }
            }
            return buff.array();
        }
        if (e.getIndex() == 4) {
            return this.getStatus().getValue();
        }
        if (e.getIndex() == 5) {
            return this.getNumberOfCalls();
        }
        if (e.getIndex() == 6) {
            GXByteBuffer buff = new GXByteBuffer();
            buff.setUInt8(DataType.STRUCTURE.getValue());
            GXCommon.setObjectCount(2, buff);
            GXCommon.setData(null, buff, DataType.UINT8, this.numberOfRingsInListeningWindow);
            GXCommon.setData(null, buff, DataType.UINT8, this.numberOfRingsOutListeningWindow);
            return buff.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setMode(AutoAnswerMode.values()[((Number)e.getValue()).byteValue() & 0xFF]);
        } else if (e.getIndex() == 3) {
            this.getListeningWindow().clear();
            if (e.getValue() != null) {
                for (Object item : (List)e.getValue()) {
                    GXDateTime start = (GXDateTime)GXDLMSClient.changeType((byte[])((List)item).get(0), DataType.DATETIME, e.getSettings());
                    GXDateTime end = (GXDateTime)GXDLMSClient.changeType((byte[])((List)item).get(1), DataType.DATETIME, e.getSettings());
                    this.getListeningWindow().add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
                }
            }
        } else if (e.getIndex() == 4) {
            this.setStatus(AutoAnswerStatus.forValue(((Number)e.getValue()).intValue()));
        } else if (e.getIndex() == 5) {
            this.setNumberOfCalls(((Number)e.getValue()).intValue());
        } else if (e.getIndex() == 6) {
            this.numberOfRingsInListeningWindow = 0;
            this.numberOfRingsOutListeningWindow = 0;
            if (e.getValue() != null) {
                this.numberOfRingsInListeningWindow = ((Number)((List)e.getValue()).get(0)).intValue();
                this.numberOfRingsOutListeningWindow = ((Number)((List)e.getValue()).get(1)).intValue();
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.mode = AutoAnswerMode.values()[reader.readElementContentAsInt("Mode")];
        this.listeningWindow.clear();
        if (reader.isStartElement("ListeningWindow", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDateTime start = reader.readElementContentAsDateTime("Start");
                GXDateTime end = reader.readElementContentAsDateTime("End");
                this.listeningWindow.add(new AbstractMap.SimpleEntry<GXDateTime, GXDateTime>(start, end));
            }
            reader.readEndElement("ListeningWindow");
        }
        this.status = AutoAnswerStatus.values()[reader.readElementContentAsInt("Status")];
        this.numberOfCalls = reader.readElementContentAsInt("NumberOfCalls");
        this.numberOfRingsInListeningWindow = reader.readElementContentAsInt("NumberOfRingsInListeningWindow");
        this.numberOfRingsOutListeningWindow = reader.readElementContentAsInt("NumberOfRingsOutListeningWindow");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.mode != null) {
            writer.writeElementString("Mode", this.mode.ordinal());
        }
        if (this.listeningWindow != null) {
            writer.writeStartElement("ListeningWindow");
            for (Map.Entry<GXDateTime, GXDateTime> it : this.listeningWindow) {
                writer.writeStartElement("Item");
                writer.writeElementString("Start", it.getKey());
                writer.writeElementString("End", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.status != null) {
            writer.writeElementString("Status", this.status.getValue());
        }
        writer.writeElementString("NumberOfCalls", this.numberOfCalls);
        writer.writeElementString("NumberOfRingsInListeningWindow", this.numberOfRingsInListeningWindow);
        writer.writeElementString("NumberOfRingsOutListeningWindow", this.numberOfRingsOutListeningWindow);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Mode", "Listening Window", "Status", "Number Of Calls", "Number Of Rings In Listening Window"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

