/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXEnum;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXStructure;
import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt8;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSMacPosTable;
import gurux.dlms.objects.GXDLMSNeighbourTable;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.GainResolution;
import gurux.dlms.objects.enums.Modulation;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSG3PlcMacSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private int shortAddress;
    private int rcCoord;
    private int panId;
    private ArrayList<Map.Entry<Short, byte[]>> keyTable;
    private short frameCounter;
    private String toneMask;
    private short tmrTtl;
    private short maxFrameRetries;
    private short neighbourTableEntryTtl;
    private GXDLMSNeighbourTable[] neighbourTable;
    private short highPriorityWindowSize;
    private short cscmFairnessLimit;
    private short beaconRandomizationWindowLength;
    private short a;
    private short k;
    private short minCwAttempts;
    private short cenelecLegacyMode;
    private short rccLegacyMode;
    private short maxBe;
    private short maxCsmaBackoffs;
    private short minBe;
    private boolean macBroadcastMaxCwEnabled;
    private short macTransmitAtten;
    private GXDLMSMacPosTable[] macPosTable;
    private short macDuplicateDetectionTtl;

    public GXDLMSG3PlcMacSetup() {
        this("0.0.29.1.0.255", 0);
    }

    public GXDLMSG3PlcMacSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSG3PlcMacSetup(String ln, int sn) {
        super(ObjectType.G3_PLC_MAC_SETUP, ln, sn);
        this.setVersion(3);
        this.keyTable = new ArrayList();
        this.shortAddress = 65535;
        this.rcCoord = 65535;
        this.panId = 65535;
        this.frameCounter = 0;
        this.tmrTtl = (short)2;
        this.maxFrameRetries = (short)5;
        this.neighbourTableEntryTtl = (short)255;
        this.highPriorityWindowSize = (short)7;
        this.cscmFairnessLimit = (short)25;
        this.beaconRandomizationWindowLength = (short)12;
        this.a = (short)8;
        this.k = (short)5;
        this.minCwAttempts = (short)10;
        this.cenelecLegacyMode = 1;
        this.rccLegacyMode = 1;
        this.maxBe = (short)8;
        this.maxCsmaBackoffs = (short)50;
        this.minBe = (short)3;
    }

    public final int getShortAddress() {
        return this.shortAddress;
    }

    public final void setShortAddress(int value) {
        this.shortAddress = value;
    }

    public final int getRcCoord() {
        return this.rcCoord;
    }

    public final void setRcCoord(int value) {
        this.rcCoord = value;
    }

    public final int getPANId() {
        return this.panId;
    }

    public final void setPANId(int value) {
        this.panId = value;
    }

    public final ArrayList<Map.Entry<Short, byte[]>> getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(ArrayList<Map.Entry<Short, byte[]>> value) {
        this.keyTable = value;
    }

    public final short getFrameCounter() {
        return this.frameCounter;
    }

    public final void setFrameCounter(short value) {
        this.frameCounter = value;
    }

    public final String getToneMask() {
        return this.toneMask;
    }

    public final void setToneMask(String value) {
        this.toneMask = value;
    }

    public final short getTmrTtl() {
        return this.tmrTtl;
    }

    public final void setTmrTtl(short value) {
        this.tmrTtl = value;
    }

    public final short getMaxFrameRetries() {
        return this.maxFrameRetries;
    }

    public final void setMaxFrameRetries(short value) {
        this.maxFrameRetries = value;
    }

    public final short getNeighbourTableEntryTtl() {
        return this.neighbourTableEntryTtl;
    }

    public final void setNeighbourTableEntryTtl(short value) {
        this.neighbourTableEntryTtl = value;
    }

    public final GXDLMSNeighbourTable[] getNeighbourTable() {
        return this.neighbourTable;
    }

    public final void setNeighbourTable(GXDLMSNeighbourTable[] value) {
        this.neighbourTable = value;
    }

    public final short getHighPriorityWindowSize() {
        return this.highPriorityWindowSize;
    }

    public final void setHighPriorityWindowSize(short value) {
        this.highPriorityWindowSize = value;
    }

    public final short getCscmFairnessLimit() {
        return this.cscmFairnessLimit;
    }

    public final void setCscmFairnessLimit(short value) {
        this.cscmFairnessLimit = value;
    }

    public final short getBeaconRandomizationWindowLength() {
        return this.beaconRandomizationWindowLength;
    }

    public final void setBeaconRandomizationWindowLength(short value) {
        this.beaconRandomizationWindowLength = value;
    }

    public final short getA() {
        return this.a;
    }

    public final void setA(short value) {
        this.a = value;
    }

    public final short getK() {
        return this.k;
    }

    public final void setK(short value) {
        this.k = value;
    }

    public final short getMinCwAttempts() {
        return this.minCwAttempts;
    }

    public final void setMinCwAttempts(short value) {
        this.minCwAttempts = value;
    }

    public final short getCenelecLegacyMode() {
        return this.cenelecLegacyMode;
    }

    public final void setCenelecLegacyMode(short value) {
        this.cenelecLegacyMode = value;
    }

    public final short getFccLegacyMode() {
        return this.rccLegacyMode;
    }

    public final void setFccLegacyMode(short value) {
        this.rccLegacyMode = value;
    }

    public final short getMaxBe() {
        return this.maxBe;
    }

    public final void setMaxBe(short value) {
        this.maxBe = value;
    }

    public final short getMaxCsmaBackoffs() {
        return this.maxCsmaBackoffs;
    }

    public final void setMaxCsmaBackoffs(short value) {
        this.maxCsmaBackoffs = value;
    }

    public final short getMinBe() {
        return this.minBe;
    }

    public final void setMinBe(short value) {
        this.minBe = value;
    }

    public final boolean getMacBroadcastMaxCwEnabled() {
        return this.macBroadcastMaxCwEnabled;
    }

    public final void setMacBroadcastMaxCwEnabled(boolean value) {
        this.macBroadcastMaxCwEnabled = value;
    }

    public final short getMacTransmitAtten() {
        return this.macTransmitAtten;
    }

    public final void setMacTransmitAtten(short value) {
        this.macTransmitAtten = value;
    }

    public final GXDLMSMacPosTable[] getMacPosTable() {
        return this.macPosTable;
    }

    public final void setMacPosTable(GXDLMSMacPosTable[] value) {
        this.macPosTable = value;
    }

    public final short getMacDuplicateDetectionTtl() {
        return this.macDuplicateDetectionTtl;
    }

    public final void setMacDuplicateDetectionTtl(short value) {
        this.macDuplicateDetectionTtl = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getShortAddress(), this.getRcCoord(), this.getPANId(), this.getKeyTable(), this.getFrameCounter(), this.getToneMask(), this.getTmrTtl(), this.getMaxFrameRetries(), this.getNeighbourTableEntryTtl(), this.getNeighbourTable(), this.getHighPriorityWindowSize(), this.getCscmFairnessLimit(), this.getBeaconRandomizationWindowLength(), this.getA(), this.getK(), this.getMinCwAttempts(), this.getCenelecLegacyMode(), this.getFccLegacyMode(), this.getMaxBe(), this.getMaxCsmaBackoffs(), this.getMinBe(), this.getMacBroadcastMaxCwEnabled(), this.getMacTransmitAtten(), this.getMacPosTable(), this.getMacDuplicateDetectionTtl()};
    }

    private static byte[] getNeighbourTables(GXDLMSNeighbourTable[] tables) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY);
        if (tables == null) {
            bb.setUInt8(0);
        } else {
            GXCommon.setObjectCount(tables.length, bb);
            for (GXDLMSNeighbourTable it : tables) {
                bb.setUInt8(DataType.STRUCTURE);
                bb.setUInt8(11);
                GXCommon.setData(null, bb, DataType.UINT16, it.getShortAddress());
                GXCommon.setData(null, bb, DataType.BOOLEAN, it.getEnabled());
                GXCommon.setData(null, bb, DataType.BITSTRING, it.getToneMap());
                GXCommon.setData(null, bb, DataType.ENUM, (Object)it.getModulation());
                GXCommon.setData(null, bb, DataType.INT8, it.getTxGain());
                GXCommon.setData(null, bb, DataType.ENUM, (Object)it.getTxRes());
                GXCommon.setData(null, bb, DataType.BITSTRING, it.getTxCoeff());
                GXCommon.setData(null, bb, DataType.UINT8, it.getLqi());
                GXCommon.setData(null, bb, DataType.INT8, it.getPhaseDifferential());
                GXCommon.setData(null, bb, DataType.UINT8, it.getTMRValidTime());
                GXCommon.setData(null, bb, DataType.UINT8, it.getNeighbourValidTime());
            }
        }
        return bb.array();
    }

    private static byte[] getPosTables(GXDLMSMacPosTable[] tables) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY);
        if (tables == null) {
            bb.setUInt8(0);
        } else {
            GXCommon.setObjectCount(tables.length, bb);
            for (GXDLMSMacPosTable it : tables) {
                bb.setUInt8(DataType.STRUCTURE);
                bb.setUInt8(3);
                GXCommon.setData(null, bb, DataType.UINT16, it.getShortAddress());
                GXCommon.setData(null, bb, DataType.UINT8, it.getLQI());
                GXCommon.setData(null, bb, DataType.UINT8, it.getValidTime());
            }
        }
        return bb.array();
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            ArrayList<GXDLMSNeighbourTable> list = new ArrayList<GXDLMSNeighbourTable>();
            int index = (Integer)e.getValue();
            for (GXDLMSNeighbourTable it : this.neighbourTable) {
                if (it.getShortAddress() != index) continue;
                list.add(it);
            }
            return GXDLMSG3PlcMacSetup.getNeighbourTables(list.toArray(new GXDLMSNeighbourTable[0]));
        }
        if (e.getIndex() == 2) {
            ArrayList<GXDLMSMacPosTable> list = new ArrayList<GXDLMSMacPosTable>();
            int index = (Integer)e.getValue();
            for (GXDLMSMacPosTable it : this.getMacPosTable()) {
                if (it.getShortAddress() != index) continue;
                list.add(it);
            }
            return GXDLMSG3PlcMacSetup.getPosTables(list.toArray(new GXDLMSMacPosTable[0]));
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        if (all || this.canRead(12)) {
            attributes.add(12);
        }
        if (all || this.canRead(13)) {
            attributes.add(13);
        }
        if (all || this.canRead(14)) {
            attributes.add(14);
        }
        if (all || this.canRead(15)) {
            attributes.add(15);
        }
        if (all || this.canRead(16)) {
            attributes.add(16);
        }
        if (all || this.canRead(17)) {
            attributes.add(17);
        }
        if (all || this.canRead(18)) {
            attributes.add(18);
        }
        if (all || this.canRead(19)) {
            attributes.add(19);
        }
        if (all || this.canRead(20)) {
            attributes.add(20);
        }
        if (all || this.canRead(21)) {
            attributes.add(21);
        }
        if (all || this.canRead(22)) {
            attributes.add(22);
        }
        if (all || this.canRead(23)) {
            attributes.add(23);
        }
        if (all || this.canRead(24)) {
            attributes.add(24);
        }
        if (all || this.canRead(25)) {
            attributes.add(25);
        }
        if (this.getVersion() > 2 && (all || this.canRead(26))) {
            attributes.add(26);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    public final byte[][] getNeighbourTableEntry(GXDLMSClient client, short address) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, address, DataType.UINT16);
    }

    private static GXDLMSNeighbourTable[] parseNeighbourTableEntry(Object value) {
        ArrayList<GXDLMSNeighbourTable> list = new ArrayList<GXDLMSNeighbourTable>();
        if (value != null) {
            for (Object tmp : (Iterable)value) {
                GXStructure arr = (GXStructure)tmp;
                GXDLMSNeighbourTable it = new GXDLMSNeighbourTable();
                it.setShortAddress(((GXUInt16)arr.get(0)).intValue());
                it.setEnabled((Boolean)arr.get(1));
                it.setToneMap(String.valueOf(arr.get(2)));
                it.setModulation(Modulation.forValue(((GXEnum)arr.get(3)).shortValue()));
                it.setTxGain((Byte)arr.get(4));
                it.setTxRes(GainResolution.forValue(((GXEnum)arr.get(5)).shortValue()));
                it.setTxCoeff(String.valueOf(arr.get(6)));
                it.setLqi(((GXUInt8)arr.get(7)).shortValue());
                it.setPhaseDifferential((Byte)arr.get(8));
                it.setTMRValidTime(((GXUInt8)arr.get(9)).shortValue());
                it.setNeighbourValidTime(((GXUInt8)arr.get(10)).shortValue());
                list.add(it);
            }
        }
        return list.toArray(new GXDLMSNeighbourTable[0]);
    }

    public final GXDLMSNeighbourTable[] parseNeighbourTableEntry(GXByteBuffer reply) {
        GXDataInfo info = new GXDataInfo();
        Object value = GXCommon.getData(null, reply, info);
        return GXDLMSG3PlcMacSetup.parseNeighbourTableEntry(value);
    }

    public final byte[][] getPosTableEntry(GXDLMSClient client, int address) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, address, DataType.UINT16);
    }

    private static GXDLMSMacPosTable[] parsePosTableEntry(Object value) {
        ArrayList<GXDLMSMacPosTable> list = new ArrayList<GXDLMSMacPosTable>();
        if (value != null) {
            for (Object tmp : (Iterable)value) {
                GXStructure arr = (GXStructure)tmp;
                GXDLMSMacPosTable it = new GXDLMSMacPosTable();
                it.setShortAddress(((GXUInt16)arr.get(0)).intValue());
                it.setLQI(((GXUInt8)arr.get(1)).shortValue());
                it.setValidTime(((GXUInt8)arr.get(2)).shortValue());
                list.add(it);
            }
        }
        return list.toArray(new GXDLMSMacPosTable[0]);
    }

    public final GXDLMSMacPosTable[] parsePosTableEntry(GXByteBuffer reply) {
        GXDataInfo info = new GXDataInfo();
        Object value = GXCommon.getData(null, reply, info);
        return GXDLMSG3PlcMacSetup.parsePosTableEntry(value);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "MacShortAddress", "MacRcCoord", "MacPANId", "MackeyTable ", "MacFrameCounter", "MacToneMask", "MacTmrTtl", "MacMaxFrameRetries", "MacneighbourTableEntryTtl", "MacNeighbourTable", "MachighPriorityWindowSize", "MacCscmFairnessLimit", "MacBeaconRandomizationWindowLength", "MacA", "MacK", "MacMinCwAttempts", "MacCenelecLegacyMode", "MacFCCLegacyMode", "MacMaxBe", "MacMaxCsmaBackoffs", "MacMinBe", "MacBroadcastMaxCwEnabled", "MacTransmitAtten", "MacPosTable", "MacDuplicateDetectionTtl"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[]{"MAC get neighbour table entry", "MAC get POS tableentry"};
    }

    @Override
    public final int getAttributeCount() {
        if (this.getVersion() == 3) {
            return 26;
        }
        if (this.getVersion() == 2) {
            return 25;
        }
        return 22;
    }

    @Override
    public final int getMethodCount() {
        if (this.getVersion() == 3) {
            return 2;
        }
        return 1;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.UINT16;
            }
            case 3: {
                return DataType.UINT16;
            }
            case 4: {
                return DataType.UINT16;
            }
            case 5: {
                return DataType.ARRAY;
            }
            case 6: {
                return DataType.UINT16;
            }
            case 7: {
                return DataType.BITSTRING;
            }
            case 8: {
                return DataType.UINT8;
            }
            case 9: {
                return DataType.UINT8;
            }
            case 10: {
                return DataType.UINT8;
            }
            case 11: {
                return DataType.ARRAY;
            }
            case 12: {
                return DataType.UINT8;
            }
            case 13: {
                return DataType.UINT8;
            }
            case 14: {
                return DataType.UINT8;
            }
            case 15: {
                return DataType.UINT8;
            }
            case 16: {
                return DataType.UINT8;
            }
            case 17: {
                return DataType.UINT8;
            }
            case 18: {
                return DataType.UINT8;
            }
            case 19: {
                return DataType.UINT8;
            }
            case 20: {
                return DataType.UINT8;
            }
            case 21: {
                return DataType.UINT8;
            }
            case 22: {
                return DataType.UINT8;
            }
            case 23: {
                return DataType.BOOLEAN;
            }
            case 24: {
                return DataType.UINT8;
            }
            case 25: {
                return DataType.ARRAY;
            }
            case 26: {
                return DataType.UINT8;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.shortAddress;
        }
        if (e.getIndex() == 3) {
            return this.rcCoord;
        }
        if (e.getIndex() == 4) {
            return this.panId;
        }
        if (e.getIndex() == 5) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getKeyTable() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getKeyTable().size(), bb);
                for (Map.Entry<Short, byte[]> it : this.getKeyTable()) {
                    bb.setUInt8(DataType.STRUCTURE);
                    bb.setUInt8(2);
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getKey());
                    GXCommon.setData(settings, bb, DataType.OCTET_STRING, it.getValue());
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 6) {
            return this.getFrameCounter();
        }
        if (e.getIndex() == 7) {
            return this.getToneMask();
        }
        if (e.getIndex() == 8) {
            return this.getTmrTtl();
        }
        if (e.getIndex() == 9) {
            return this.getMaxFrameRetries();
        }
        if (e.getIndex() == 10) {
            return this.getNeighbourTableEntryTtl();
        }
        if (e.getIndex() == 11) {
            return GXDLMSG3PlcMacSetup.getNeighbourTables(this.getNeighbourTable());
        }
        if (e.getIndex() == 12) {
            return this.getHighPriorityWindowSize();
        }
        if (e.getIndex() == 13) {
            return this.getCscmFairnessLimit();
        }
        if (e.getIndex() == 14) {
            return this.getBeaconRandomizationWindowLength();
        }
        if (e.getIndex() == 15) {
            return this.getA();
        }
        if (e.getIndex() == 16) {
            return this.getK();
        }
        if (e.getIndex() == 17) {
            return this.getMinCwAttempts();
        }
        if (e.getIndex() == 18) {
            return this.getCenelecLegacyMode();
        }
        if (e.getIndex() == 19) {
            return this.getFccLegacyMode();
        }
        if (e.getIndex() == 20) {
            return this.getMaxBe();
        }
        if (e.getIndex() == 21) {
            return this.getMaxCsmaBackoffs();
        }
        if (e.getIndex() == 22) {
            return this.getMinBe();
        }
        if (e.getIndex() == 23) {
            return this.getMacBroadcastMaxCwEnabled();
        }
        if (e.getIndex() == 24) {
            return this.getMacTransmitAtten();
        }
        if (e.getIndex() == 25) {
            return GXDLMSG3PlcMacSetup.getPosTables(this.getMacPosTable());
        }
        if (e.getIndex() == 26) {
            return this.getMacDuplicateDetectionTtl();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setShortAddress(((GXUInt16)e.getValue()).intValue());
        } else if (e.getIndex() == 3) {
            this.setRcCoord(((GXUInt16)e.getValue()).intValue());
        } else if (e.getIndex() == 4) {
            this.setPANId(((GXUInt16)e.getValue()).intValue());
        } else if (e.getIndex() == 5) {
            this.getKeyTable().clear();
            if (e.getValue() != null) {
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure arr = (GXStructure)tmp;
                    this.keyTable.add(new GXSimpleEntry<Short, byte[]>(((GXUInt8)arr.get(0)).shortValue(), (byte[])arr.get(1)));
                }
            }
        } else if (e.getIndex() == 6) {
            this.setFrameCounter(((GXUInt16)e.getValue()).shortValue());
        } else if (e.getIndex() == 7) {
            this.setToneMask(((GXBitString)e.getValue()).toString());
        } else if (e.getIndex() == 8) {
            this.setTmrTtl(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 9) {
            this.setMaxFrameRetries(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 10) {
            this.setNeighbourTableEntryTtl(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 11) {
            this.setNeighbourTable(GXDLMSG3PlcMacSetup.parseNeighbourTableEntry(e.getValue()));
        } else if (e.getIndex() == 12) {
            this.setHighPriorityWindowSize(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 13) {
            this.setCscmFairnessLimit(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 14) {
            this.setBeaconRandomizationWindowLength(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 15) {
            this.setA(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 16) {
            this.setK(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 17) {
            this.setMinCwAttempts(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 18) {
            this.setCenelecLegacyMode(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 19) {
            this.setFccLegacyMode(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 20) {
            this.setMaxBe(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 21) {
            this.setMaxCsmaBackoffs(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 22) {
            this.setMinBe(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 23) {
            this.setMacBroadcastMaxCwEnabled((Boolean)e.getValue());
        } else if (e.getIndex() == 24) {
            this.setMacTransmitAtten(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 25) {
            this.setMacPosTable(GXDLMSG3PlcMacSetup.parsePosTableEntry(e.getValue()));
        } else if (e.getIndex() == 26) {
            this.setMacDuplicateDetectionTtl(((Byte)e.getValue()).byteValue());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    private void loadKeyTable(GXXmlReader reader) throws XMLStreamException {
        this.getKeyTable().clear();
        if (reader.isStartElement("KeyTable", true)) {
            while (reader.isStartElement("Item", true)) {
                short k = (short)reader.readElementContentAsInt("Key");
                byte[] d = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Data"));
                this.getKeyTable().add(new GXSimpleEntry<Short, byte[]>(k, d));
            }
            reader.readEndElement("KeyTable");
        }
    }

    private void loadNeighbourTable(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXDLMSNeighbourTable> list = new ArrayList<GXDLMSNeighbourTable>();
        if (reader.isStartElement("NeighbourTable", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSNeighbourTable it = new GXDLMSNeighbourTable();
                it.setShortAddress(reader.readElementContentAsInt("ShortAddress"));
                it.setEnabled(reader.readElementContentAsInt("Enabled") != 0);
                it.setToneMap(reader.readElementContentAsString("ToneMap"));
                it.setModulation(Modulation.forValue(reader.readElementContentAsInt("Modulation")));
                it.setTxGain((byte)reader.readElementContentAsInt("TxGain"));
                it.setTxRes(GainResolution.forValue(reader.readElementContentAsInt("TxRes")));
                it.setTxCoeff(reader.readElementContentAsString("TxCoeff"));
                it.setLqi((short)reader.readElementContentAsInt("Lqi"));
                it.setPhaseDifferential((byte)reader.readElementContentAsInt("PhaseDifferential"));
                it.setTMRValidTime((short)reader.readElementContentAsInt("TMRValidTime"));
                it.setNeighbourValidTime((short)reader.readElementContentAsInt("NeighbourValidTime"));
                list.add(it);
            }
            reader.readEndElement("NeighbourTable");
        }
        this.setNeighbourTable(list.toArray(new GXDLMSNeighbourTable[0]));
    }

    private void loadMacPosTable(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXDLMSMacPosTable> list = new ArrayList<GXDLMSMacPosTable>();
        if (reader.isStartElement("MacPosTable", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSMacPosTable it = new GXDLMSMacPosTable();
                it.setShortAddress(reader.readElementContentAsInt("ShortAddress"));
                it.setLQI((byte)reader.readElementContentAsInt("LQI"));
                it.setValidTime(reader.readElementContentAsInt("ValidTime"));
                list.add(it);
            }
            reader.readEndElement("MacPosTable");
        }
        this.setMacPosTable(list.toArray(new GXDLMSMacPosTable[0]));
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.setShortAddress(reader.readElementContentAsInt("ShortAddress"));
        this.setRcCoord(reader.readElementContentAsInt("RcCoord"));
        this.setPANId((short)reader.readElementContentAsInt("PANId"));
        this.loadKeyTable(reader);
        this.setFrameCounter((short)reader.readElementContentAsInt("FrameCounter"));
        this.setToneMask(reader.readElementContentAsString("ToneMask"));
        this.setTmrTtl((byte)reader.readElementContentAsInt("TmrTtl"));
        this.setMaxFrameRetries((byte)reader.readElementContentAsInt("MaxFrameRetries"));
        this.setNeighbourTableEntryTtl((byte)reader.readElementContentAsInt("NeighbourTableEntryTtl"));
        this.loadNeighbourTable(reader);
        this.setHighPriorityWindowSize((byte)reader.readElementContentAsInt("HighPriorityWindowSize"));
        this.setCscmFairnessLimit((byte)reader.readElementContentAsInt("CscmFairnessLimit"));
        this.setBeaconRandomizationWindowLength((byte)reader.readElementContentAsInt("BeaconRandomizationWindowLength"));
        this.setA((byte)reader.readElementContentAsInt("A"));
        this.setK((byte)reader.readElementContentAsInt("K"));
        this.setMinCwAttempts((byte)reader.readElementContentAsInt("MinCwAttempts"));
        this.setCenelecLegacyMode((byte)reader.readElementContentAsInt("CenelecLegacyMode"));
        this.setFccLegacyMode((byte)reader.readElementContentAsInt("FccLegacyMode"));
        this.setMaxBe((byte)reader.readElementContentAsInt("MaxBe"));
        this.setMaxCsmaBackoffs((byte)reader.readElementContentAsInt("MaxCsmaBackoffs"));
        this.setMinBe((byte)reader.readElementContentAsInt("MinBe"));
        this.setMacBroadcastMaxCwEnabled(reader.readElementContentAsInt("MacBroadcastMaxCwEnabled") != 0);
        this.setMacTransmitAtten((byte)reader.readElementContentAsInt("MacTransmitAtten"));
        this.loadMacPosTable(reader);
        this.setMacDuplicateDetectionTtl((byte)reader.readElementContentAsInt("MacDuplicateDetectionTtl"));
    }

    private void saveKeyTable(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("KeyTable");
        if (this.keyTable != null) {
            for (Map.Entry<Short, byte[]> it : this.keyTable) {
                writer.writeStartElement("Item");
                writer.writeElementString("Key", it.getKey().shortValue());
                writer.writeElementString("Data", GXDLMSTranslator.toHex(it.getValue()));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void saveNeighbourTable(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("NeighbourTable");
        if (this.neighbourTable != null) {
            for (GXDLMSNeighbourTable it : this.neighbourTable) {
                writer.writeStartElement("Item");
                writer.writeElementString("ShortAddress", it.getShortAddress());
                writer.writeElementString("Enabled", it.getEnabled());
                writer.writeElementString("ToneMap", it.getToneMap());
                writer.writeElementString("Modulation", it.getModulation().getValue());
                writer.writeElementString("TxGain", it.getTxGain());
                writer.writeElementString("TxRes", it.getTxRes().getValue());
                writer.writeElementString("TxCoeff", it.getTxCoeff());
                writer.writeElementString("Lqi", it.getLqi());
                writer.writeElementString("PhaseDifferential", it.getPhaseDifferential());
                writer.writeElementString("TMRValidTime", it.getTMRValidTime());
                writer.writeElementString("NeighbourValidTime", it.getNeighbourValidTime());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void saveMacPosTable(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("MacPosTable");
        if (this.getMacPosTable() != null) {
            for (GXDLMSMacPosTable it : this.getMacPosTable()) {
                writer.writeStartElement("Item");
                writer.writeElementString("ShortAddress", it.getShortAddress());
                writer.writeElementString("LQI", it.getLQI());
                writer.writeElementString("ValidTime", it.getValidTime());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("ShortAddress", this.getShortAddress());
        writer.writeElementString("RcCoord", this.getRcCoord());
        writer.writeElementString("PANId", this.getPANId());
        this.saveKeyTable(writer);
        writer.writeElementString("FrameCounter", this.getFrameCounter());
        writer.writeElementString("ToneMask", this.getToneMask());
        writer.writeElementString("TmrTtl", this.getTmrTtl());
        writer.writeElementString("MaxFrameRetries", this.getMaxFrameRetries());
        writer.writeElementString("NeighbourTableEntryTtl", this.getNeighbourTableEntryTtl());
        this.saveNeighbourTable(writer);
        writer.writeElementString("HighPriorityWindowSize", this.getHighPriorityWindowSize());
        writer.writeElementString("CscmFairnessLimit", this.getCscmFairnessLimit());
        writer.writeElementString("BeaconRandomizationWindowLength", this.getBeaconRandomizationWindowLength());
        writer.writeElementString("A", this.getA());
        writer.writeElementString("K", this.getK());
        writer.writeElementString("MinCwAttempts", this.getMinCwAttempts());
        writer.writeElementString("CenelecLegacyMode", this.getCenelecLegacyMode());
        writer.writeElementString("FccLegacyMode", this.getFccLegacyMode());
        writer.writeElementString("MaxBe", this.getMaxBe());
        writer.writeElementString("MaxCsmaBackoffs", this.getMaxCsmaBackoffs());
        writer.writeElementString("MinBe", this.getMinBe());
        writer.writeElementString("MacBroadcastMaxCwEnabled", this.getMacBroadcastMaxCwEnabled());
        writer.writeElementString("MacTransmitAtten", this.getMacTransmitAtten());
        this.saveMacPosTable(writer);
        writer.writeElementString("MacDuplicateDetectionTtl", this.getMacDuplicateDetectionTtl());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }
}

