/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.BaudRate;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSHdlcSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private int inactivityTimeout;
    private int deviceAddress;
    private int maximumInfoLengthTransmit;
    private BaudRate communicationSpeed;
    private int windowSizeTransmit;
    private int windowSizeReceive;
    private int interCharachterTimeout;
    private int maximumInfoLengthReceive;

    public GXDLMSHdlcSetup() {
        this("0.0.22.0.0.255");
    }

    public GXDLMSHdlcSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSHdlcSetup(String ln, int sn) {
        super(ObjectType.IEC_HDLC_SETUP, ln, 0);
        this.setCommunicationSpeed(BaudRate.BAUDRATE_9600);
        this.windowSizeTransmit = 1;
        this.windowSizeReceive = 1;
        this.maximumInfoLengthReceive = 128;
        this.maximumInfoLengthTransmit = 128;
        this.inactivityTimeout = 120;
        this.setVersion(1);
    }

    public final BaudRate getCommunicationSpeed() {
        return this.communicationSpeed;
    }

    public final void setCommunicationSpeed(BaudRate value) {
        this.communicationSpeed = value;
    }

    public final int getWindowSizeTransmit() {
        return this.windowSizeTransmit;
    }

    public final void setWindowSizeTransmit(int value) {
        this.windowSizeTransmit = value;
    }

    public final int getWindowSizeReceive() {
        return this.windowSizeReceive;
    }

    public final void setWindowSizeReceive(int value) {
        this.windowSizeReceive = value;
    }

    public final int getMaximumInfoLengthTransmit() {
        return this.maximumInfoLengthTransmit;
    }

    public final void setMaximumInfoLengthTransmit(int value) {
        this.maximumInfoLengthTransmit = value;
    }

    public final int getMaximumInfoLengthReceive() {
        return this.maximumInfoLengthReceive;
    }

    public final void setMaximumInfoLengthReceive(int value) {
        this.maximumInfoLengthReceive = value;
    }

    public final int getInterCharachterTimeout() {
        return this.interCharachterTimeout;
    }

    public final void setInterCharachterTimeout(int value) {
        this.interCharachterTimeout = value;
    }

    public final int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public final void setInactivityTimeout(int value) {
        this.inactivityTimeout = value;
    }

    public final int getDeviceAddress() {
        return this.deviceAddress;
    }

    public final void setDeviceAddress(int value) {
        this.deviceAddress = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getCommunicationSpeed(), this.getWindowSizeTransmit(), this.getWindowSizeReceive(), this.getMaximumInfoLengthTransmit(), this.getMaximumInfoLengthReceive(), this.getInterCharachterTimeout(), this.getInactivityTimeout(), this.getDeviceAddress()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        if (all || !this.isRead(7)) {
            attributes.add(7);
        }
        if (all || !this.isRead(8)) {
            attributes.add(8);
        }
        if (all || !this.isRead(9)) {
            attributes.add(9);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 9;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        if (index == 3) {
            return DataType.UINT8;
        }
        if (index == 4) {
            return DataType.UINT8;
        }
        if (index == 5) {
            if (this.getVersion() == 0) {
                return DataType.UINT8;
            }
            return DataType.UINT16;
        }
        if (index == 6) {
            if (this.getVersion() == 0) {
                return DataType.UINT8;
            }
            return DataType.UINT16;
        }
        if (index == 7) {
            return DataType.UINT16;
        }
        if (index == 8) {
            return DataType.UINT16;
        }
        if (index == 9) {
            return DataType.UINT16;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.communicationSpeed.ordinal();
        }
        if (e.getIndex() == 3) {
            return this.windowSizeTransmit;
        }
        if (e.getIndex() == 4) {
            return this.windowSizeReceive;
        }
        if (e.getIndex() == 5) {
            return this.maximumInfoLengthTransmit;
        }
        if (e.getIndex() == 6) {
            return this.maximumInfoLengthReceive;
        }
        if (e.getIndex() == 7) {
            return this.interCharachterTimeout;
        }
        if (e.getIndex() == 8) {
            return this.inactivityTimeout;
        }
        if (e.getIndex() == 9) {
            return this.deviceAddress;
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.communicationSpeed = BaudRate.values()[((Number)e.getValue()).intValue()];
        } else if (e.getIndex() == 3) {
            this.windowSizeTransmit = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 4) {
            this.windowSizeReceive = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 5) {
            this.maximumInfoLengthTransmit = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 6) {
            this.maximumInfoLengthReceive = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 7) {
            this.interCharachterTimeout = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 8) {
            this.inactivityTimeout = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 9) {
            this.deviceAddress = ((Number)e.getValue()).intValue();
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.communicationSpeed = BaudRate.values()[reader.readElementContentAsInt("Speed")];
        this.windowSizeTransmit = reader.readElementContentAsInt("WindowSizeTx");
        this.windowSizeReceive = reader.readElementContentAsInt("WindowSizeRx");
        this.maximumInfoLengthTransmit = reader.readElementContentAsInt("MaximumInfoLengthTx");
        this.maximumInfoLengthReceive = reader.readElementContentAsInt("MaximumInfoLengthRx");
        this.interCharachterTimeout = reader.readElementContentAsInt("InterCharachterTimeout");
        this.inactivityTimeout = reader.readElementContentAsInt("InactivityTimeout");
        this.deviceAddress = reader.readElementContentAsInt("DeviceAddress");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Speed", this.communicationSpeed.ordinal());
        writer.writeElementString("WindowSizeTx", this.windowSizeTransmit);
        writer.writeElementString("WindowSizeRx", this.windowSizeReceive);
        writer.writeElementString("MaximumInfoLengthTx", this.maximumInfoLengthTransmit);
        writer.writeElementString("MaximumInfoLengthRx", this.maximumInfoLengthReceive);
        writer.writeElementString("InterCharachterTimeout", this.interCharachterTimeout);
        writer.writeElementString("InactivityTimeout", this.inactivityTimeout);
        writer.writeElementString("DeviceAddress", this.deviceAddress);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Communication Speed", "Window Size Transmit", "Window Size Receive", "Maximum Info Length Transmit", "Maximum Info Length Receive", "InterCharachter Timeout", "Inactivity Timeout", "Device Address"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

