/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXEnum;
import gurux.dlms.GXStructure;
import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt32;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXLteNetworkParameters;
import gurux.dlms.objects.GXLteQualityOfService;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.LteCoverageEnhancement;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSLteMonitoring
extends GXDLMSObject
implements IGXDLMSBase {
    private GXLteNetworkParameters networkParameters;
    private GXLteQualityOfService qualityOfService;

    public GXDLMSLteMonitoring() {
        this("0.0.25.11.0.255", 0);
    }

    public GXDLMSLteMonitoring(String ln) {
        this(ln, 0);
    }

    public GXDLMSLteMonitoring(String ln, int sn) {
        super(ObjectType.LTE_MONITORING, ln, sn);
        this.setVersion(1);
        this.networkParameters = new GXLteNetworkParameters();
        this.qualityOfService = new GXLteQualityOfService();
    }

    public final GXLteNetworkParameters getNetworkParameters() {
        return this.networkParameters;
    }

    public final void setNetworkParameters(GXLteNetworkParameters value) {
        this.networkParameters = value;
    }

    public final GXLteQualityOfService getQualityOfService() {
        return this.qualityOfService;
    }

    public final void setQualityOfService(GXLteQualityOfService value) {
        this.qualityOfService = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.networkParameters, this.qualityOfService};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (this.getVersion() > 0 && (all || this.canRead(3))) {
            attributes.add(3);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "Network parameters", "Quality of service"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[0];
    }

    @Override
    public final int getAttributeCount() {
        if (this.getVersion() == 0) {
            return 2;
        }
        return 3;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: {
                return DataType.STRUCTURE;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        byte[] ret = null;
        GXByteBuffer buff = new GXByteBuffer();
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(9, buff);
                GXCommon.setData(settings, buff, DataType.UINT16, this.getNetworkParameters().getT3402());
                GXCommon.setData(settings, buff, DataType.UINT16, this.getNetworkParameters().getT3412());
                GXCommon.setData(settings, buff, DataType.UINT32, this.getNetworkParameters().getT3412ext2());
                GXCommon.setData(settings, buff, DataType.UINT16, this.getNetworkParameters().getT3324());
                GXCommon.setData(settings, buff, DataType.UINT32, this.getNetworkParameters().getTeDRX());
                GXCommon.setData(settings, buff, DataType.UINT16, this.getNetworkParameters().getTPTW());
                GXCommon.setData(settings, buff, DataType.INT8, this.getNetworkParameters().getQRxlevMin());
                GXCommon.setData(settings, buff, DataType.INT8, this.getNetworkParameters().getQRxlevMinCE());
                GXCommon.setData(settings, buff, DataType.INT8, this.getNetworkParameters().getQRxLevMinCE1());
                ret = buff.array();
                break;
            }
            case 3: {
                if (this.getVersion() == 0) {
                    e.setError(ErrorCode.READ_WRITE_DENIED);
                    break;
                }
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(4, buff);
                GXCommon.setData(settings, buff, DataType.INT8, this.getQualityOfService().getSignalQuality());
                GXCommon.setData(settings, buff, DataType.INT8, this.getQualityOfService().getSignalLevel());
                GXCommon.setData(settings, buff, DataType.INT8, this.getQualityOfService().getSignalToNoiseRatio());
                GXCommon.setData(settings, buff, DataType.ENUM, this.getQualityOfService().getCoverageEnhancement().getValue());
                ret = buff.array();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                GXStructure s = (GXStructure)(e.getValue() instanceof GXStructure ? e.getValue() : null);
                if (s == null) break;
                this.getNetworkParameters().setT3402(((GXUInt16)s.get(0)).intValue());
                this.getNetworkParameters().setT3412(((GXUInt16)s.get(1)).intValue());
                this.getNetworkParameters().setT3412ext2(((GXUInt32)s.get(2)).longValue());
                this.getNetworkParameters().setT3324(((GXUInt16)s.get(3)).intValue());
                this.getNetworkParameters().setTeDRX(((GXUInt32)s.get(4)).longValue());
                this.getNetworkParameters().setTPTW(((GXUInt16)s.get(5)).intValue());
                this.getNetworkParameters().setQRxlevMin((Byte)s.get(6));
                this.getNetworkParameters().setQRxlevMinCE((Byte)s.get(7));
                this.getNetworkParameters().setQRxLevMinCE1((Byte)s.get(8));
                break;
            }
            case 3: {
                if (this.getVersion() == 0) {
                    e.setError(ErrorCode.READ_WRITE_DENIED);
                    break;
                }
                GXStructure s = (GXStructure)(e.getValue() instanceof GXStructure ? e.getValue() : null);
                if (s == null) break;
                this.getQualityOfService().setSignalQuality((Byte)s.get(0));
                this.getQualityOfService().setSignalLevel((Byte)s.get(1));
                this.getQualityOfService().setSignalToNoiseRatio((Byte)s.get(2));
                this.getQualityOfService().setCoverageEnhancement(LteCoverageEnhancement.forValue(((GXEnum)s.get(3)).intValue()));
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.networkParameters.setT3402((short)reader.readElementContentAsInt("T3402"));
        this.networkParameters.setT3412((short)reader.readElementContentAsInt("T3412"));
        this.networkParameters.setT3412ext2(reader.readElementContentAsInt("T3412ext2"));
        this.networkParameters.setT3324((short)reader.readElementContentAsInt("T3324"));
        this.networkParameters.setTeDRX(reader.readElementContentAsInt("TeDRX"));
        this.networkParameters.setTPTW((short)reader.readElementContentAsInt("TPTW"));
        this.networkParameters.setQRxlevMin((byte)reader.readElementContentAsInt("QRxlevMin"));
        this.networkParameters.setQRxlevMinCE((byte)reader.readElementContentAsInt("QRxlevMinCE"));
        this.networkParameters.setQRxLevMinCE1((byte)reader.readElementContentAsInt("QRxLevMinCE1"));
        this.qualityOfService.setSignalQuality((byte)reader.readElementContentAsInt("SignalQuality"));
        this.qualityOfService.setSignalLevel((byte)reader.readElementContentAsInt("SignalLevel"));
        this.qualityOfService.setSignalToNoiseRatio((byte)reader.readElementContentAsInt("SignalToNoiseRatio"));
        this.qualityOfService.setCoverageEnhancement(LteCoverageEnhancement.values()[reader.readElementContentAsInt("CoverageEnhancement")]);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("T3402", this.getNetworkParameters().getT3402());
        writer.writeElementString("T3412", this.getNetworkParameters().getT3412());
        writer.writeElementString("T3412ext2", this.getNetworkParameters().getT3412ext2());
        writer.writeElementString("T3324", this.getNetworkParameters().getT3324());
        writer.writeElementString("TeDRX", this.getNetworkParameters().getTeDRX());
        writer.writeElementString("TPTW", this.getNetworkParameters().getTPTW());
        writer.writeElementString("QRxlevMin", this.getNetworkParameters().getQRxlevMin());
        writer.writeElementString("QRxlevMinCE", this.getNetworkParameters().getQRxlevMinCE());
        writer.writeElementString("QRxLevMinCE1", this.getNetworkParameters().getQRxLevMinCE1());
        writer.writeElementString("SignalQuality", this.getQualityOfService().getSignalQuality());
        writer.writeElementString("SignalLevel", this.getQualityOfService().getSignalLevel());
        writer.writeElementString("SignalToNoiseRatio", this.getQualityOfService().getSignalToNoiseRatio());
        writer.writeElementString("CoverageEnhancement", this.getQualityOfService().getCoverageEnhancement().ordinal());
    }

    @Override
    public void postLoad(GXXmlReader reader) {
    }
}

