/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.AddressState;
import gurux.dlms.objects.enums.BaudRate;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSMBusSlavePortSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private BaudRate defaultBaud = BaudRate.BAUDRATE_300;
    private BaudRate availableBaud = BaudRate.BAUDRATE_300;
    private AddressState addressState = AddressState.NONE;
    private int busAddress;

    public GXDLMSMBusSlavePortSetup() {
        this((String)null);
    }

    public GXDLMSMBusSlavePortSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSMBusSlavePortSetup(String ln, int sn) {
        super(ObjectType.MBUS_SLAVE_PORT_SETUP, ln, sn);
    }

    public final BaudRate getDefaultBaud() {
        return this.defaultBaud;
    }

    public final void setDefaultBaud(BaudRate value) {
        this.defaultBaud = value;
    }

    public final BaudRate getAvailableBaud() {
        return this.availableBaud;
    }

    public final void setAvailableBaud(BaudRate value) {
        this.availableBaud = value;
    }

    public final AddressState getAddressState() {
        return this.addressState;
    }

    public final void setAddressState(AddressState value) {
        this.addressState = value;
    }

    public final int getBusAddress() {
        return this.busAddress;
    }

    public final void setBusAddress(int value) {
        this.busAddress = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getDefaultBaud(), this.getAvailableBaud(), this.getAddressState(), this.getBusAddress()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 5;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        if (index == 3) {
            return DataType.ENUM;
        }
        if (index == 4) {
            return DataType.ENUM;
        }
        if (index == 5) {
            return DataType.UINT8;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getDefaultBaud().ordinal();
        }
        if (e.getIndex() == 3) {
            return this.getAvailableBaud().ordinal();
        }
        if (e.getIndex() == 4) {
            return this.getAddressState().ordinal();
        }
        if (e.getIndex() == 5) {
            return this.getBusAddress();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() == null) {
                this.setDefaultBaud(BaudRate.BAUDRATE_300);
            } else {
                this.setDefaultBaud(BaudRate.values()[((Number)e.getValue()).intValue()]);
            }
        } else if (e.getIndex() == 3) {
            if (e.getValue() == null) {
                this.setAvailableBaud(BaudRate.BAUDRATE_300);
            } else {
                this.setAvailableBaud(BaudRate.values()[((Number)e.getValue()).intValue()]);
            }
        } else if (e.getIndex() == 4) {
            if (e.getValue() == null) {
                this.setAddressState(AddressState.NONE);
            } else {
                this.setAddressState(AddressState.values()[((Number)e.getValue()).intValue()]);
            }
        } else if (e.getIndex() == 5) {
            if (e.getValue() == null) {
                this.setBusAddress(0);
            } else {
                this.setBusAddress(((Number)e.getValue()).intValue());
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.defaultBaud = BaudRate.values()[reader.readElementContentAsInt("DefaultBaud")];
        this.availableBaud = BaudRate.values()[reader.readElementContentAsInt("AvailableBaud")];
        this.addressState = AddressState.values()[reader.readElementContentAsInt("AddressState")];
        this.busAddress = reader.readElementContentAsInt("BusAddress");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("DefaultBaud", this.defaultBaud.ordinal());
        writer.writeElementString("AvailableBaud", this.availableBaud.ordinal());
        writer.writeElementString("AddressState", this.addressState.ordinal());
        writer.writeElementString("BusAddress", this.busAddress);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Default Baud Rate", "Available Baud rate", "Address State", "Bus Address"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

