/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSTarget;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSParameterMonitor
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSTarget changedParameter;
    private Date captureTime = new Date(0L);
    private List<GXDLMSTarget> parameters = new ArrayList<GXDLMSTarget>();

    public GXDLMSParameterMonitor() {
        this("0.0.16.2.0.255", 0);
    }

    public GXDLMSParameterMonitor(String ln) {
        this(ln, 0);
    }

    public final GXDLMSTarget getChangedParameter() {
        return this.changedParameter;
    }

    public final void setChangedParameter(GXDLMSTarget value) {
        this.changedParameter = value;
    }

    public final Date getCaptureTime() {
        return this.captureTime;
    }

    public final void setCaptureTime(Date value) {
        this.captureTime = value;
    }

    public final List<GXDLMSTarget> getParameters() {
        return this.parameters;
    }

    public final void setParameters(List<GXDLMSTarget> value) {
        this.parameters = value;
    }

    public GXDLMSParameterMonitor(String ln, int sn) {
        super(ObjectType.PARAMETER_MONITOR, ln, sn);
        this.changedParameter = new GXDLMSTarget();
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.changedParameter, this.captureTime, this.parameters};
    }

    public final byte[][] insert(GXDLMSClient client, GXDLMSTarget entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(3);
        GXCommon.setData(null, bb, DataType.UINT16, entry.getTarget().getObjectType().getValue());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(entry.getTarget().getLogicalName()));
        GXCommon.setData(null, bb, DataType.INT8, entry.getAttributeIndex());
        return client.method(this, 1, bb.array(), DataType.ARRAY);
    }

    public final byte[][] delete(GXDLMSClient client, GXDLMSTarget entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(3);
        GXCommon.setData(null, bb, DataType.UINT16, (Object)entry.getTarget().getObjectType());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(entry.getTarget().getLogicalName()));
        GXCommon.setData(null, bb, DataType.INT8, entry.getAttributeIndex());
        return client.method(this, 2, bb.array(), DataType.ARRAY);
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() != 1 && e.getIndex() != 2) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        } else if (e.getIndex() == 1) {
            List tmp = (List)e.getParameters();
            ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
            String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
            int index = ((Number)tmp.get(2)).intValue();
            for (GXDLMSTarget item : this.parameters) {
                if (item.getTarget().getObjectType() != type || !item.getTarget().getLogicalName().equals(ln) || item.getAttributeIndex() != index) continue;
                this.parameters.remove(item);
                break;
            }
            GXDLMSTarget it = new GXDLMSTarget();
            it.setTarget(settings.getObjects().findByLN(type, ln));
            if (it.getTarget() == null) {
                it.setTarget(GXDLMSClient.createObject(type));
                it.getTarget().setLogicalName(ln);
            }
            it.setAttributeIndex(index);
            this.parameters.add(it);
        } else if (e.getIndex() == 2) {
            List tmp = (List)e.getParameters();
            ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
            String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
            int index = ((Number)tmp.get(2)).intValue();
            for (GXDLMSTarget item : this.parameters) {
                if (item.getTarget().getObjectType() != type || !item.getTarget().getLogicalName().equals(ln) || item.getAttributeIndex() != index) continue;
                this.parameters.remove(item);
                break;
            }
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.STRUCTURE;
            }
            case 3: {
                return DataType.OCTET_STRING;
            }
            case 4: {
                return DataType.ARRAY;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(4);
                if (this.changedParameter == null) {
                    GXCommon.setData(settings, data, DataType.UINT16, 0);
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, new byte[]{0, 0, 0, 0, 0, 0});
                    GXCommon.setData(settings, data, DataType.INT8, 1);
                    GXCommon.setData(settings, data, DataType.NONE, null);
                } else {
                    GXCommon.setData(settings, data, DataType.UINT16, this.changedParameter.getTarget().getObjectType().getValue());
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(this.changedParameter.getTarget().getLogicalName()));
                    GXCommon.setData(settings, data, DataType.INT8, this.changedParameter.getAttributeIndex());
                    GXCommon.setData(settings, data, GXDLMSConverter.getDLMSDataType(this.changedParameter.getValue()), this.changedParameter.getValue());
                }
                return data.array();
            }
            case 3: {
                return this.captureTime;
            }
            case 4: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY.getValue());
                if (this.parameters == null) {
                    data.setUInt8(0);
                } else {
                    data.setUInt8(this.parameters.size());
                    for (GXDLMSTarget it : this.parameters) {
                        data.setUInt8(DataType.STRUCTURE.getValue());
                        data.setUInt8(3);
                        GXCommon.setData(settings, data, DataType.UINT16, it.getTarget().getObjectType().getValue());
                        GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getTarget().getLogicalName()));
                        GXCommon.setData(settings, data, DataType.INT8, it.getAttributeIndex());
                    }
                }
                return data.array();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.changedParameter = new GXDLMSTarget();
                if (!(e.getValue() instanceof List)) break;
                List tmp = (List)e.getValue();
                if (tmp.size() != 4) {
                    throw new GXDLMSException("Invalid structure format.");
                }
                ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
                String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
                this.changedParameter.setTarget(settings.getObjects().findByLN(type, ln));
                if (this.changedParameter.getTarget() == null) {
                    this.changedParameter.setTarget(GXDLMSClient.createObject(type));
                    this.changedParameter.getTarget().setLogicalName(ln);
                }
                this.changedParameter.setAttributeIndex(((Number)tmp.get(2)).intValue());
                this.changedParameter.setValue(tmp.get(3));
                break;
            }
            case 3: {
                if (e.getValue() == null) {
                    this.captureTime = new Date(0L);
                    break;
                }
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.captureTime = tmp.getLocalCalendar().getTime();
                break;
            }
            case 4: {
                this.parameters.clear();
                if (e.getValue() == null) break;
                for (Object i : (List)e.getValue()) {
                    List tmp = (List)i;
                    if (tmp.size() != 3) {
                        throw new GXDLMSException("Invalid structure format.");
                    }
                    GXDLMSTarget obj = new GXDLMSTarget();
                    ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
                    String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
                    obj.setTarget(settings.getObjects().findByLN(type, ln));
                    if (obj.getTarget() == null) {
                        obj.setTarget(GXDLMSClient.createObject(type));
                        obj.getTarget().setLogicalName(GXCommon.toLogicalName((byte[])tmp.get(1)));
                    }
                    obj.setAttributeIndex(((Number)tmp.get(2)).intValue());
                    this.parameters.add(obj);
                }
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.changedParameter = new GXDLMSTarget();
        if (reader.isStartElement("ChangedParameter", true)) {
            ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("Type"));
            String ln = reader.readElementContentAsString("LN");
            this.changedParameter.setTarget(reader.getObjects().findByLN(ot, ln));
            if (this.changedParameter.getTarget() == null) {
                this.changedParameter.setTarget(GXDLMSClient.createObject(ot));
                this.changedParameter.getTarget().setLogicalName(ln);
            }
            this.changedParameter.setAttributeIndex(reader.readElementContentAsInt("Index"));
            this.changedParameter.setValue(reader.readElementContentAsObject("Value", null, null, 0));
            reader.readEndElement("ChangedParameter");
        }
        GXDateTime tmp = reader.readElementContentAsDateTime("Time");
        this.captureTime = null;
        if (tmp != null) {
            this.captureTime = tmp.getMeterCalendar().getTime();
        }
        this.parameters.clear();
        if (reader.isStartElement("Parameters", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSTarget obj = new GXDLMSTarget();
                ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("Type"));
                String ln = reader.readElementContentAsString("LN");
                obj.setTarget(reader.getObjects().findByLN(ot, ln));
                if (obj.getTarget() == null) {
                    obj.setTarget(GXDLMSClient.createObject(ot));
                    obj.getTarget().setLogicalName(ln);
                }
                obj.setAttributeIndex(reader.readElementContentAsInt("Index"));
                this.parameters.add(obj);
            }
            reader.readEndElement("Parameters");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.changedParameter != null && this.changedParameter.getTarget() != null) {
            writer.writeStartElement("ChangedParameter");
            writer.writeElementString("Type", this.changedParameter.getTarget().getObjectType().getValue());
            writer.writeElementString("LN", this.changedParameter.getTarget().getLogicalName());
            writer.writeElementString("Index", this.changedParameter.getAttributeIndex());
            writer.writeElementObject("Value", this.changedParameter.getValue());
            writer.writeEndElement();
        }
        if (this.captureTime != null && this.captureTime.compareTo(new Date(0L)) != 0) {
            writer.writeElementString("Time", this.captureTime);
        }
        if (this.parameters != null && this.parameters.size() != 0) {
            writer.writeStartElement("Parameters");
            for (GXDLMSTarget it : this.parameters) {
                writer.writeStartElement("Item");
                writer.writeElementString("Type", it.getTarget().getObjectType().getValue());
                writer.writeElementString("LN", it.getTarget().getLogicalName());
                writer.writeElementString("Index", it.getAttributeIndex());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "ChangedParameter", "CaptureTime", "Parameters"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Add parameter", "Delete parameter"};
    }
}

