/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXStructure;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXPushConfirmationParameter;
import gurux.dlms.objects.GXPushProtectionParameters;
import gurux.dlms.objects.GXRepetitionDelay;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.DataProtectionIdentifiedKeyType;
import gurux.dlms.objects.enums.DataProtectionKeyType;
import gurux.dlms.objects.enums.DataProtectionWrappedKeyType;
import gurux.dlms.objects.enums.MessageType;
import gurux.dlms.objects.enums.ProtectionType;
import gurux.dlms.objects.enums.PushOperationMethod;
import gurux.dlms.objects.enums.ServiceType;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPushSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private ServiceType service;
    private String destination;
    private MessageType message;
    private List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> pushObjectList = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
    private List<Map.Entry<GXDateTime, GXDateTime>> communicationWindow = new ArrayList<Map.Entry<GXDateTime, GXDateTime>>();
    private int randomisationStartInterval;
    private int numberOfRetries;
    private int repetitionDelay;
    private GXRepetitionDelay repetitionDelay2 = new GXRepetitionDelay();
    private GXDLMSObject portReference;
    private byte pushClientSAP;
    private GXPushProtectionParameters[] pushProtectionParameters;
    private PushOperationMethod pushOperationMethod;
    private GXPushConfirmationParameter confirmationParameters = new GXPushConfirmationParameter();
    private GXDateTime lastConfirmationDateTime;

    public GXDLMSPushSetup() {
        this("0.7.25.9.0.255");
    }

    public GXDLMSPushSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSPushSetup(String ln, int sn) {
        super(ObjectType.PUSH_SETUP, ln, sn);
        this.service = ServiceType.TCP;
        this.message = MessageType.COSEM_APDU;
        this.pushOperationMethod = PushOperationMethod.UNCONFIRMED_FAILURE;
    }

    public final ServiceType getService() {
        return this.service;
    }

    public final void setService(ServiceType value) {
        this.service = value;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final void setDestination(String value) {
        this.destination = value;
    }

    public final MessageType getMessage() {
        return this.message;
    }

    public final void setMessage(MessageType value) {
        this.message = value;
    }

    public final List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> getPushObjectList() {
        return this.pushObjectList;
    }

    public final List<Map.Entry<GXDateTime, GXDateTime>> getCommunicationWindow() {
        return this.communicationWindow;
    }

    public final int getRandomisationStartInterval() {
        return this.randomisationStartInterval;
    }

    public final void setRandomisationStartInterval(int value) {
        this.randomisationStartInterval = value;
    }

    public final int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public final void setNumberOfRetries(byte value) {
        this.numberOfRetries = value;
    }

    public final int getRepetitionDelay() {
        return this.repetitionDelay;
    }

    public final void setRepetitionDelay(int value) {
        this.repetitionDelay = value;
    }

    @Override
    public final Object[] getValues() {
        if (this.version < 2) {
            return new Object[]{this.getLogicalName(), this.pushObjectList, (Object)((Object)this.service) + " " + this.destination + " " + (Object)((Object)this.message), this.communicationWindow, this.randomisationStartInterval, this.numberOfRetries, this.repetitionDelay, this.portReference, this.pushClientSAP, this.pushProtectionParameters, this.pushOperationMethod, this.confirmationParameters, this.lastConfirmationDateTime};
        }
        return new Object[]{this.getLogicalName(), this.pushObjectList, (Object)((Object)this.service) + " " + this.destination + " " + (Object)((Object)this.message), this.communicationWindow, this.randomisationStartInterval, this.numberOfRetries, this.repetitionDelay2, this.portReference, this.pushClientSAP, this.pushProtectionParameters, this.pushOperationMethod, this.confirmationParameters, this.lastConfirmationDateTime};
    }

    public void getPushValues(GXDLMSClient client, List<?> values) {
        if (values.size() != this.pushObjectList.size()) {
            throw new IllegalArgumentException("Size of the push object list is different than values.");
        }
        int pos = 0;
        ArrayList<GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>> objects = new ArrayList<GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>>();
        for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.pushObjectList) {
            GXDLMSObject obj = it.getKey();
            objects.add(new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, new GXDLMSCaptureObject(it.getValue().getAttributeIndex(), it.getValue().getDataIndex())));
            if (it.getValue().getAttributeIndex() == 0) {
                List tmp = (List)values.get(pos);
                for (int index = 1; index <= it.getKey().getAttributeCount(); ++index) {
                    client.updateValue(it.getKey(), index, tmp.get(index - 1));
                }
            } else {
                client.updateValue(obj, it.getValue().getAttributeIndex(), values.get(pos));
            }
            ++pos;
        }
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() != 1) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    public final byte[][] activate(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 1, 0, DataType.INT8);
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 2, 0, DataType.INT8);
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (this.version > 0) {
            if (all || this.canRead(8)) {
                attributes.add(8);
            }
            if (all || this.canRead(9)) {
                attributes.add(9);
            }
            if (all || this.canRead(10)) {
                attributes.add(10);
            }
            if (this.version < 1) {
                if (all || this.canRead(11)) {
                    attributes.add(11);
                }
                if (all || this.canRead(12)) {
                    attributes.add(12);
                }
                if (all || this.canRead(13)) {
                    attributes.add(13);
                }
            }
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        if (this.version == 0) {
            return 7;
        }
        if (this.version == 1) {
            return 10;
        }
        return 13;
    }

    @Override
    public final int getMethodCount() {
        if (this.version < 2) {
            return 1;
        }
        return 2;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        if (index == 3) {
            return DataType.STRUCTURE;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        if (index == 5) {
            return DataType.UINT16;
        }
        if (index == 6) {
            return DataType.UINT8;
        }
        if (index == 7) {
            if (this.version < 2) {
                return DataType.UINT16;
            }
            return DataType.STRUCTURE;
        }
        if (this.version > 0) {
            if (index == 8) {
                return DataType.OCTET_STRING;
            }
            if (index == 9) {
                return DataType.INT8;
            }
            if (index == 10) {
                return DataType.ARRAY;
            }
            if (this.version > 1) {
                if (index == 11) {
                    return DataType.ENUM;
                }
                if (index == 12) {
                    return DataType.STRUCTURE;
                }
                if (index == 13) {
                    return DataType.DATETIME;
                }
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        GXByteBuffer buff = new GXByteBuffer();
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                buff.setUInt8(DataType.ARRAY.getValue());
                GXCommon.setObjectCount(this.pushObjectList.size(), buff);
                for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.pushObjectList) {
                    buff.setUInt8(DataType.STRUCTURE.getValue());
                    buff.setUInt8(4);
                    GXCommon.setData(settings, buff, DataType.UINT16, it.getKey().getObjectType().getValue());
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getKey().getLogicalName()));
                    GXCommon.setData(settings, buff, DataType.INT8, it.getValue().getAttributeIndex());
                    GXCommon.setData(settings, buff, DataType.UINT16, it.getValue().getDataIndex());
                }
                ret = buff.array();
                break;
            }
            case 3: {
                buff.setUInt8(DataType.STRUCTURE.getValue());
                buff.setUInt8(3);
                GXCommon.setData(settings, buff, DataType.ENUM, this.getService().getValue());
                byte[] tmp = null;
                if (GXCommon.isHexString(this.destination)) {
                    tmp = GXCommon.hexToBytes(this.destination);
                } else if (this.destination != null) {
                    tmp = this.getDestination().getBytes();
                }
                GXCommon.setData(settings, buff, DataType.OCTET_STRING, tmp);
                GXCommon.setData(settings, buff, DataType.ENUM, this.getMessage().getValue());
                ret = buff.array();
                break;
            }
            case 4: {
                buff.setUInt8(DataType.ARRAY.getValue());
                GXCommon.setObjectCount(this.communicationWindow.size(), buff);
                for (Map.Entry<GXDateTime, GXDateTime> it : this.communicationWindow) {
                    buff.setUInt8(DataType.STRUCTURE.getValue());
                    buff.setUInt8(2);
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getKey());
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getValue());
                }
                ret = buff.array();
                break;
            }
            case 5: {
                ret = this.randomisationStartInterval;
                break;
            }
            case 6: {
                ret = this.numberOfRetries;
                break;
            }
            case 7: {
                if (this.version < 2) {
                    ret = this.repetitionDelay;
                    break;
                }
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(3, buff);
                GXCommon.setData(settings, buff, DataType.UINT16, this.repetitionDelay2.getMin());
                GXCommon.setData(settings, buff, DataType.UINT16, this.repetitionDelay2.getExponent());
                GXCommon.setData(settings, buff, DataType.UINT16, this.repetitionDelay2.getMax());
                ret = buff.array();
                break;
            }
            case 8: {
                if (this.portReference != null) {
                    ret = GXCommon.logicalNameToBytes(this.portReference.getLogicalName());
                    break;
                }
                ret = null;
                break;
            }
            case 9: {
                ret = this.pushClientSAP;
                break;
            }
            case 10: {
                buff.setUInt8(DataType.ARRAY);
                GXCommon.setObjectCount(this.pushProtectionParameters.length, buff);
                for (GXPushProtectionParameters it : this.pushProtectionParameters) {
                    buff.setUInt8(DataType.STRUCTURE);
                    buff.setUInt8(2);
                    GXCommon.setData(settings, buff, DataType.ENUM, it.getProtectionType().getValue());
                    buff.setUInt8(DataType.STRUCTURE);
                    buff.setUInt8(5);
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getTransactionId());
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getOriginatorSystemTitle());
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getRecipientSystemTitle());
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getOtherInformation());
                    buff.setUInt8(DataType.STRUCTURE);
                    buff.setUInt8(2);
                    GXCommon.setData(settings, buff, DataType.ENUM, it.getKeyInfo().getDataProtectionKeyType().getValue());
                    buff.setUInt8(DataType.STRUCTURE);
                    if (it.getKeyInfo().getDataProtectionKeyType() == DataProtectionKeyType.IDENTIFIED) {
                        buff.setUInt8(1);
                        GXCommon.setData(settings, buff, DataType.ENUM, it.getKeyInfo().getIdentifiedKey().getKeyType().getValue());
                        continue;
                    }
                    if (it.getKeyInfo().getDataProtectionKeyType() == DataProtectionKeyType.WRAPPED) {
                        buff.setUInt8(2);
                        GXCommon.setData(settings, buff, DataType.ENUM, it.getKeyInfo().getWrappedKey().getKeyType().getValue());
                        GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getKeyInfo().getWrappedKey().getKey());
                        continue;
                    }
                    if (it.getKeyInfo().getDataProtectionKeyType() != DataProtectionKeyType.AGREED) continue;
                    buff.setUInt8(2);
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getKeyInfo().getAgreedKey().getParameters());
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getKeyInfo().getAgreedKey().getData());
                }
                ret = buff.array();
                break;
            }
            case 11: {
                ret = this.pushOperationMethod.getValue();
                break;
            }
            case 12: {
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(2, buff);
                GXCommon.setData(settings, buff, DataType.DATETIME, this.confirmationParameters.getStartDate());
                GXCommon.setData(settings, buff, DataType.UINT32, this.confirmationParameters.getInterval());
                ret = buff.array();
                break;
            }
            case 13: {
                ret = this.lastConfirmationDateTime;
                break;
            }
            default: {
                ret = null;
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.pushObjectList.clear();
            if (e.getValue() instanceof List) {
                for (Object it : (List)e.getValue()) {
                    List tmp = (List)it;
                    ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
                    String ln = GXCommon.toLogicalName(tmp.get(1));
                    GXDLMSObject obj = settings.getObjects().findByLN(type, ln);
                    if (obj == null) {
                        obj = GXDLMSClient.createObject(type);
                        obj.setLogicalName(ln);
                    }
                    GXDLMSCaptureObject co = new GXDLMSCaptureObject();
                    co.setAttributeIndex(((Number)tmp.get(2)).intValue());
                    co.setDataIndex(((Number)tmp.get(3)).intValue());
                    GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject> ent = new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, co);
                    this.pushObjectList.add(ent);
                }
            }
        } else if (e.getIndex() == 3) {
            List tmp = (List)e.getValue();
            if (tmp != null) {
                this.setService(ServiceType.forValue(((Number)tmp.get(0)).intValue()));
                byte[] tmp2 = (byte[])tmp.get(1);
                if (GXByteBuffer.isAsciiString(tmp2)) {
                    this.setDestination(new String(tmp2));
                } else {
                    this.setDestination(GXCommon.toHex(tmp2, false));
                }
                this.setMessage(MessageType.forValue(((Number)tmp.get(2)).intValue()));
            }
        } else if (e.getIndex() == 4) {
            this.communicationWindow.clear();
            if (e.getValue() instanceof List) {
                for (Object it : (List)e.getValue()) {
                    List tmp = (List)it;
                    GXDateTime start = (GXDateTime)GXDLMSClient.changeType((byte[])tmp.get(0), DataType.DATETIME, e.getSettings());
                    GXDateTime end = (GXDateTime)GXDLMSClient.changeType((byte[])tmp.get(1), DataType.DATETIME, e.getSettings());
                    this.communicationWindow.add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
                }
            }
        } else if (e.getIndex() == 5) {
            this.randomisationStartInterval = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 6) {
            this.numberOfRetries = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 7) {
            if (this.version < 2) {
                this.repetitionDelay = ((Number)e.getValue()).intValue();
            } else {
                GXStructure tmp = (GXStructure)e.getValue();
                if (tmp != null) {
                    this.repetitionDelay2.setMin(((Number)tmp.get(0)).intValue());
                    this.repetitionDelay2.setExponent(((Number)tmp.get(1)).intValue());
                    this.repetitionDelay2.setMax(((Number)tmp.get(2)).intValue());
                }
            }
        } else if (this.version > 0 && e.getIndex() == 8) {
            this.portReference = null;
            if (e.getValue() instanceof byte[]) {
                byte[] bv = (byte[])e.getValue();
                String ln = GXCommon.toLogicalName(bv);
                this.portReference = settings.getObjects().findByLN(ObjectType.NONE, ln);
            }
        } else if (this.version > 0 && e.getIndex() == 9) {
            this.pushClientSAP = ((Number)e.getValue()).byteValue();
        } else if (this.version > 0 && e.getIndex() == 10) {
            GXArray tmp = (GXArray)e.getValue();
            ArrayList<GXPushProtectionParameters> list = new ArrayList<GXPushProtectionParameters>();
            if (tmp != null) {
                for (Object t : tmp) {
                    GXStructure it = (GXStructure)t;
                    GXPushProtectionParameters p = new GXPushProtectionParameters();
                    p.setProtectionType(ProtectionType.forValue(((Number)it.get(0)).intValue()));
                    GXStructure options = (GXStructure)it.get(1);
                    p.setTransactionId((byte[])options.get(0));
                    p.setOriginatorSystemTitle((byte[])options.get(1));
                    p.setRecipientSystemTitle((byte[])options.get(2));
                    p.setOtherInformation((byte[])options.get(3));
                    GXStructure keyInfo = (GXStructure)options.get(4);
                    DataProtectionKeyType type = DataProtectionKeyType.forValue(((Number)keyInfo.get(0)).intValue());
                    p.getKeyInfo().setDataProtectionKeyType(type);
                    GXStructure data = (GXStructure)keyInfo.get(1);
                    if (type == DataProtectionKeyType.IDENTIFIED) {
                        p.getKeyInfo().getIdentifiedKey().setKeyType(DataProtectionIdentifiedKeyType.forValue(((Number)data.get(0)).intValue()));
                    } else if (type == DataProtectionKeyType.WRAPPED) {
                        p.getKeyInfo().getWrappedKey().setKeyType(DataProtectionWrappedKeyType.forValue(((Number)data.get(0)).intValue()));
                        p.getKeyInfo().getWrappedKey().setKey((byte[])data.get(1));
                    } else if (type == DataProtectionKeyType.AGREED) {
                        p.getKeyInfo().getAgreedKey().setParameters((byte[])data.get(0));
                        p.getKeyInfo().getAgreedKey().setData((byte[])data.get(1));
                    }
                    list.add(p);
                }
            }
            this.pushProtectionParameters = list.toArray(new GXPushProtectionParameters[list.size()]);
        } else if (this.version > 1 && e.getIndex() == 11) {
            this.pushOperationMethod = PushOperationMethod.forValue(((Number)e.getValue()).intValue());
        } else if (this.version > 1 && e.getIndex() == 12) {
            GXStructure tmp = (GXStructure)e.getValue();
            if (tmp != null) {
                this.confirmationParameters.setStartDate((GXDateTime)tmp.get(0));
                this.confirmationParameters.setInterval(((Number)tmp.get(0)).longValue());
            }
        } else if (this.version > 1 && e.getIndex() == 13) {
            this.lastConfirmationDateTime = (GXDateTime)e.getValue();
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.pushObjectList.clear();
        if (reader.isStartElement("ObjectList", true)) {
            while (reader.isStartElement("Item", true)) {
                ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
                String ln = reader.readElementContentAsString("LN");
                int ai = reader.readElementContentAsInt("AI");
                int di = reader.readElementContentAsInt("DI");
                reader.readEndElement("ObjectList");
                GXDLMSCaptureObject co = new GXDLMSCaptureObject(ai, di);
                GXDLMSObject obj = reader.getObjects().findByLN(ot, ln);
                if (obj == null) {
                    obj = GXDLMSClient.createObject(ot);
                    obj.setLogicalName(ln);
                }
                this.pushObjectList.add(new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, co));
            }
            reader.readEndElement("ObjectList");
        }
        this.service = ServiceType.forValue(reader.readElementContentAsInt("Service"));
        this.destination = reader.readElementContentAsString("Destination");
        this.message = MessageType.forValue(reader.readElementContentAsInt("Message"));
        this.communicationWindow.clear();
        if (reader.isStartElement("CommunicationWindow", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDateTime start = reader.readElementContentAsDateTime("Start");
                GXDateTime end = reader.readElementContentAsDateTime("End");
                this.communicationWindow.add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
            }
            reader.readEndElement("CommunicationWindow");
        }
        this.randomisationStartInterval = reader.readElementContentAsInt("RandomisationStartInterval");
        this.numberOfRetries = reader.readElementContentAsInt("NumberOfRetries");
        if (this.version < 2) {
            this.repetitionDelay = reader.readElementContentAsInt("RepetitionDelay");
        } else if (reader.isStartElement("RepetitionDelay", true)) {
            this.repetitionDelay2.setMin(reader.readElementContentAsInt("Min"));
            this.repetitionDelay2.setExponent(reader.readElementContentAsInt("Exponent"));
            this.repetitionDelay2.setMax(reader.readElementContentAsInt("Max"));
        }
        if (this.version > 0) {
            this.portReference = null;
            String ln = reader.readElementContentAsString("LN");
            this.portReference = reader.getObjects().findByLN(ObjectType.NONE, ln);
            if (this.portReference == null) {
                this.portReference = GXDLMSClient.createObject(ObjectType.IEC_HDLC_SETUP);
                this.portReference.setLogicalName(ln);
            }
            this.pushClientSAP = (byte)reader.readElementContentAsInt("PushClientSAP");
            if (reader.isStartElement("PushProtectionParameters", true)) {
                ArrayList<GXPushProtectionParameters> list = new ArrayList<GXPushProtectionParameters>();
                while (reader.isStartElement("Item", true)) {
                    GXPushProtectionParameters it = new GXPushProtectionParameters();
                    it.setProtectionType(ProtectionType.forValue(reader.readElementContentAsInt("ProtectionType")));
                    it.setTransactionId(GXCommon.hexToBytes(reader.readElementContentAsString("TransactionId")));
                    it.setOriginatorSystemTitle(GXCommon.hexToBytes(reader.readElementContentAsString("OriginatorSystemTitle")));
                    it.setRecipientSystemTitle(GXCommon.hexToBytes(reader.readElementContentAsString("RecipientSystemTitle")));
                    it.setOtherInformation(GXCommon.hexToBytes(reader.readElementContentAsString("OtherInformation")));
                    it.getKeyInfo().setDataProtectionKeyType(DataProtectionKeyType.forValue(reader.readElementContentAsInt("DataProtectionKeyType")));
                    it.getKeyInfo().getIdentifiedKey().setKeyType(DataProtectionIdentifiedKeyType.forValue(reader.readElementContentAsInt("IdentifiedKey")));
                    it.getKeyInfo().getWrappedKey().setKeyType(DataProtectionWrappedKeyType.forValue(reader.readElementContentAsInt("WrappedKeyType")));
                    it.getKeyInfo().getWrappedKey().setKey(GXCommon.hexToBytes(reader.readElementContentAsString("WrappedKey")));
                    it.getKeyInfo().getAgreedKey().setParameters(GXCommon.hexToBytes(reader.readElementContentAsString("WrappedKeyParameters")));
                    it.getKeyInfo().getAgreedKey().setData(GXCommon.hexToBytes(reader.readElementContentAsString("AgreedKeyData")));
                    list.add(it);
                }
                reader.readEndElement("PushProtectionParameters");
                this.pushProtectionParameters = list.toArray(new GXPushProtectionParameters[list.size()]);
            }
            if (this.version > 1) {
                this.pushOperationMethod = PushOperationMethod.forValue(reader.readElementContentAsInt("PushOperationMethod"));
                this.confirmationParameters.setStartDate(reader.readElementContentAsDateTime("ConfirmationParametersStartDate"));
                this.confirmationParameters.setInterval(reader.readElementContentAsLong("ConfirmationParametersInterval"));
                this.lastConfirmationDateTime = reader.readElementContentAsDateTime("LastConfirmationDateTime");
            }
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.pushObjectList != null) {
            writer.writeStartElement("ObjectList");
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> entry : this.pushObjectList) {
                writer.writeStartElement("Item");
                writer.writeElementString("ObjectType", entry.getKey().getObjectType().getValue());
                writer.writeElementString("LN", entry.getKey().getLogicalName());
                writer.writeElementString("AI", entry.getValue().getAttributeIndex());
                writer.writeElementString("DI", entry.getValue().getDataIndex());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.service != null) {
            writer.writeElementString("Service", this.service.getValue());
        }
        writer.writeElementString("Destination", this.destination);
        if (this.message != null) {
            writer.writeElementString("Message", this.message.getValue());
        }
        if (this.communicationWindow != null) {
            writer.writeStartElement("CommunicationWindow");
            for (Map.Entry<Object, Object> entry : this.communicationWindow) {
                writer.writeStartElement("Item");
                writer.writeElementString("Start", (GXDateTime)entry.getKey());
                writer.writeElementString("End", (GXDateTime)entry.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("RandomisationStartInterval", this.randomisationStartInterval);
        writer.writeElementString("NumberOfRetries", this.numberOfRetries);
        if (this.version < 2) {
            writer.writeElementString("RepetitionDelay", this.repetitionDelay);
        } else {
            writer.writeStartElement("RepetitionDelay");
            writer.writeElementString("Min", this.repetitionDelay2.getMin(), 0.0);
            writer.writeElementString("Exponent", this.repetitionDelay2.getExponent(), 0.0);
            writer.writeElementString("Max", this.repetitionDelay2.getMax(), 0.0);
            writer.writeEndElement();
        }
        if (this.version > 0) {
            if (this.portReference != null) {
                writer.writeElementString("PortReference", this.portReference.getLogicalName());
            }
            writer.writeElementString("PushClientSAP", this.pushClientSAP);
            if (this.pushProtectionParameters != null) {
                writer.writeStartElement("PushProtectionParameters");
                for (Iterator<Map.Entry<Object, Object>> iterator : this.pushProtectionParameters) {
                    writer.writeStartElement("Item");
                    writer.writeElementString("ProtectionType", ((GXPushProtectionParameters)((Object)iterator)).getProtectionType().getValue());
                    writer.writeElementString("TransactionId", GXCommon.toHex(((GXPushProtectionParameters)((Object)iterator)).getTransactionId(), false));
                    writer.writeElementString("OriginatorSystemTitle", GXCommon.toHex(((GXPushProtectionParameters)((Object)iterator)).getOriginatorSystemTitle(), false));
                    writer.writeElementString("RecipientSystemTitle", GXCommon.toHex(((GXPushProtectionParameters)((Object)iterator)).getRecipientSystemTitle(), false));
                    writer.writeElementString("OtherInformation", GXCommon.toHex(((GXPushProtectionParameters)((Object)iterator)).getOtherInformation(), false));
                    writer.writeElementString("DataProtectionKeyType", ((GXPushProtectionParameters)((Object)iterator)).getKeyInfo().getDataProtectionKeyType().getValue());
                    writer.writeElementString("IdentifiedKey", ((GXPushProtectionParameters)((Object)iterator)).getKeyInfo().getIdentifiedKey().getKeyType().getValue());
                    writer.writeElementString("WrappedKeyType", ((GXPushProtectionParameters)((Object)iterator)).getKeyInfo().getWrappedKey().getKeyType().getValue());
                    writer.writeElementString("WrappedKey", GXCommon.toHex(((GXPushProtectionParameters)((Object)iterator)).getKeyInfo().getWrappedKey().getKey(), false));
                    writer.writeElementString("WrappedKeyParameters", GXCommon.toHex(((GXPushProtectionParameters)((Object)iterator)).getKeyInfo().getAgreedKey().getParameters(), false));
                    writer.writeElementString("AgreedKeyData", GXCommon.toHex(((GXPushProtectionParameters)((Object)iterator)).getKeyInfo().getAgreedKey().getData(), false));
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.version > 1) {
                writer.writeElementString("PushOperationMethod", this.pushOperationMethod.getValue());
                writer.writeElementString("ConfirmationParametersStartDate", this.confirmationParameters.getStartDate());
                writer.writeElementString("ConfirmationParametersInterval", this.confirmationParameters.getInterval());
                writer.writeElementString("LastConfirmationDateTime", this.lastConfirmationDateTime);
            }
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
        GXDLMSObject target;
        if (this.portReference != null && (target = reader.getObjects().findByLN(ObjectType.NONE, this.portReference.getLogicalName())) != null && target != this.portReference) {
            this.portReference = target;
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Object List", "Send Destination And Method", "Communication Window", "Randomisation Start Interval", "Number Of Retries", "Repetition Delay", "Port reference", "Push client SAP", "Push protection parameters", "Push operation method", "Confirmation parameters", "Last confirmation date time"};
    }

    @Override
    public String[] getMethodNames() {
        if (this.version < 2) {
            return new String[]{"Push"};
        }
        return new String[]{"Push", "Reset"};
    }

    public GXRepetitionDelay getRepetitionDelay2() {
        return this.repetitionDelay2;
    }

    public void setRepetitionDelay2(GXRepetitionDelay repetitionDelay2) {
        this.repetitionDelay2 = repetitionDelay2;
    }

    public byte getPushClientSAP() {
        return this.pushClientSAP;
    }

    public void setPushClientSAP(byte pushClientSAP) {
        this.pushClientSAP = pushClientSAP;
    }

    public GXPushProtectionParameters[] getPushProtectionParameters() {
        return this.pushProtectionParameters;
    }

    public void setPushProtectionParameters(GXPushProtectionParameters[] pushProtectionParameters) {
        this.pushProtectionParameters = pushProtectionParameters;
    }

    public PushOperationMethod getPushOperationMethod() {
        return this.pushOperationMethod;
    }

    public void setPushOperationMethod(PushOperationMethod pushOperationMethod) {
        this.pushOperationMethod = pushOperationMethod;
    }

    public GXPushConfirmationParameter getConfirmationParameters() {
        return this.confirmationParameters;
    }

    public void setConfirmationParameters(GXPushConfirmationParameter confirmationParameters) {
        this.confirmationParameters = confirmationParameters;
    }

    public GXDateTime getLastConfirmationDateTime() {
        return this.lastConfirmationDateTime;
    }

    public void setLastConfirmationDateTime(GXDateTime lastConfirmationDateTime) {
        this.lastConfirmationDateTime = lastConfirmationDateTime;
    }
}

