/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSFSKActiveInitiator
extends GXDLMSObject
implements IGXDLMSBase {
    private byte[] systemTitle;
    private int macAddress;
    private byte lSapSelector;

    public GXDLMSSFSKActiveInitiator() {
        this("0.0.26.1.0.255", 0);
    }

    public GXDLMSSFSKActiveInitiator(String ln) {
        this(ln, 0);
    }

    public GXDLMSSFSKActiveInitiator(String ln, int sn) {
        super(ObjectType.SFSK_ACTIVE_INITIATOR, ln, sn);
    }

    public final byte[] getSystemTitle() {
        return this.systemTitle;
    }

    public final void setSystemTitle(byte[] value) {
        this.systemTitle = value;
    }

    public final int getMacAddress() {
        return this.macAddress;
    }

    public final void setMacAddress(int value) {
        this.macAddress = value;
    }

    public final byte getLSapSelector() {
        return this.lSapSelector;
    }

    public final void setLSapSelector(byte value) {
        this.lSapSelector = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), new Object[]{this.systemTitle, this.macAddress, this.lSapSelector}};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 1;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.STRUCTURE;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.STRUCTURE);
            bb.setUInt8(3);
            GXCommon.setData(settings, bb, DataType.OCTET_STRING, this.systemTitle);
            GXCommon.setData(settings, bb, DataType.UINT16, this.macAddress);
            GXCommon.setData(settings, bb, DataType.UINT8, this.lSapSelector);
            return bb.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() != null) {
                List arr = (List)e.getValue();
                this.systemTitle = (byte[])arr.get(0);
                this.macAddress = ((Number)arr.get(1)).intValue();
                this.lSapSelector = ((Number)arr.get(2)).byteValue();
            } else {
                this.systemTitle = null;
                this.macAddress = 0;
                this.lSapSelector = 0;
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.systemTitle = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("SystemTitle"));
        this.macAddress = reader.readElementContentAsInt("MacAddress");
        this.lSapSelector = (byte)reader.readElementContentAsInt("LSapSelector");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("SystemTitle", GXDLMSTranslator.toHex(this.systemTitle));
        writer.writeElementString("MacAddress", this.macAddress);
        writer.writeElementString("LSapSelector", this.lSapSelector);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Active Initiator"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset NEW not synchronized"};
    }
}

