/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDate;
import gurux.dlms.GXTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSScheduleEntry;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.Weekdays;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSchedule
extends GXDLMSObject
implements IGXDLMSBase {
    private List<GXDLMSScheduleEntry> entries = new ArrayList<GXDLMSScheduleEntry>();

    public GXDLMSSchedule() {
        this("0.0.12.0.0.255");
    }

    public GXDLMSSchedule(String ln) {
        this(ln, 0);
    }

    public GXDLMSSchedule(String ln, int sn) {
        super(ObjectType.SCHEDULE, ln, sn);
    }

    public final List<GXDLMSScheduleEntry> getEntries() {
        return this.entries;
    }

    public final void setEntries(List<GXDLMSScheduleEntry> value) {
        this.entries = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.entries};
    }

    public final byte[][] insert(GXDLMSClient client, GXDLMSScheduleEntry entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        this.addEntry(null, entry, data);
        return client.method(this, 2, data.array(), DataType.STRUCTURE);
    }

    public final byte[][] delete(GXDLMSClient client, GXDLMSScheduleEntry entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(2);
        GXCommon.setData(null, data, DataType.UINT16, entry.getIndex());
        GXCommon.setData(null, data, DataType.UINT16, entry.getIndex());
        return client.method(this, 3, data.array(), DataType.STRUCTURE);
    }

    public final byte[][] enable(GXDLMSClient client, GXDLMSScheduleEntry entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(4);
        GXCommon.setData(null, data, DataType.UINT16, entry.getIndex());
        GXCommon.setData(null, data, DataType.UINT16, entry.getIndex());
        GXCommon.setData(null, data, DataType.UINT16, 0);
        GXCommon.setData(null, data, DataType.UINT16, 0);
        return client.method(this, 1, data.array(), DataType.STRUCTURE);
    }

    public final byte[][] disable(GXDLMSClient client, GXDLMSScheduleEntry entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(4);
        GXCommon.setData(null, data, DataType.UINT16, 0);
        GXCommon.setData(null, data, DataType.UINT16, 0);
        GXCommon.setData(null, data, DataType.UINT16, entry.getIndex());
        GXCommon.setData(null, data, DataType.UINT16, entry.getIndex());
        return client.method(this, 1, data.array(), DataType.STRUCTURE);
    }

    private void removeEntry(int index) {
        for (GXDLMSScheduleEntry it : this.entries) {
            if (it.getIndex() != index) continue;
            this.entries.remove(it);
            break;
        }
    }

    private void enableDisable(ArrayList<?> tmp) {
        int index;
        block0: for (index = ((Number)tmp.get(0)).intValue(); index <= ((Number)tmp.get(1)).intValue(); ++index) {
            if (index == 0) continue;
            for (GXDLMSScheduleEntry it : this.entries) {
                if (it.getIndex() != index) continue;
                it.setEnable(true);
                continue block0;
            }
        }
        block2: for (index = ((Number)tmp.get(2)).intValue(); index <= ((Number)tmp.get(3)).intValue(); ++index) {
            if (index == 0) continue;
            for (GXDLMSScheduleEntry it : this.entries) {
                if (it.getIndex() != index) continue;
                it.setEnable(false);
                continue block2;
            }
        }
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.enableDisable((ArrayList)e.getParameters());
                break;
            }
            case 2: {
                GXDLMSScheduleEntry entry = this.createEntry(settings, (ArrayList)e.getParameters());
                this.removeEntry(entry.getIndex());
                this.entries.add(entry);
                break;
            }
            case 3: {
                ArrayList tmp = (ArrayList)e.getParameters();
                for (int index = ((Number)tmp.get(0)).intValue(); index <= ((Number)tmp.get(1)).intValue(); ++index) {
                    this.removeEntry(index);
                }
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 3;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    private void addEntry(GXDLMSSettings settings, GXDLMSScheduleEntry it, GXByteBuffer data) {
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(10);
        data.setUInt8(DataType.UINT16.getValue());
        data.setUInt16(it.getIndex());
        data.setUInt8(DataType.BOOLEAN.getValue());
        data.setUInt8(it.getEnable() ? 1 : 0);
        data.setUInt8(DataType.OCTET_STRING.getValue());
        data.setUInt8(6);
        if (it.getLogicalName() == null) {
            data.set(new byte[]{0, 0, 0, 0, 0, 0});
        } else {
            data.set(GXCommon.logicalNameToBytes(it.getLogicalName()));
        }
        data.setUInt8(DataType.UINT16.getValue());
        data.setUInt16(it.getScriptSelector());
        GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getSwitchTime());
        data.setUInt8(DataType.UINT16.getValue());
        data.setUInt16(it.getValidityWindow());
        GXCommon.setData(settings, data, DataType.BITSTRING, GXBitString.toBitString(Weekdays.toInteger(it.getExecWeekdays()), 7));
        GXCommon.setData(settings, data, DataType.BITSTRING, it.getExecSpecDays());
        GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getBeginDate());
        GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getEndDate());
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(this.entries.size(), data);
            for (GXDLMSScheduleEntry it : this.entries) {
                this.addEntry(settings, it, data);
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    private GXDLMSScheduleEntry createEntry(GXDLMSSettings settings, List<?> tmp) {
        GXDLMSScheduleEntry item = new GXDLMSScheduleEntry();
        item.setIndex(((Number)tmp.get(0)).intValue());
        item.setEnable((Boolean)tmp.get(1));
        item.setLogicalName(GXCommon.toLogicalName(tmp.get(2)));
        item.setScriptSelector(((Number)tmp.get(3)).intValue());
        item.setSwitchTime((GXTime)GXDLMSClient.changeType((byte[])tmp.get(4), DataType.TIME, settings));
        item.setValidityWindow(((Number)tmp.get(5)).intValue());
        item.setExecWeekdays(Weekdays.forValue(((GXBitString)tmp.get(6)).toInteger()));
        item.setExecSpecDays(tmp.get(7).toString());
        item.setBeginDate((GXDate)GXDLMSClient.changeType((byte[])tmp.get(8), DataType.DATE, settings));
        item.setEndDate((GXDate)GXDLMSClient.changeType((byte[])tmp.get(9), DataType.DATE, settings));
        return item;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.entries.clear();
            List arr = (List)e.getValue();
            if (arr != null) {
                for (Object it : arr) {
                    List tmp = (List)it;
                    this.entries.add(this.createEntry(settings, tmp));
                }
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.entries.clear();
        if (reader.isStartElement("Entries", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSScheduleEntry it = new GXDLMSScheduleEntry();
                it.setIndex((byte)reader.readElementContentAsInt("Index"));
                it.setEnable(reader.readElementContentAsInt("Enable") != 0);
                it.setLogicalName(reader.readElementContentAsString("LogicalName"));
                it.setScriptSelector((byte)reader.readElementContentAsInt("ScriptSelector"));
                it.setSwitchTime(reader.readElementContentAsTime("SwitchTime"));
                it.setValidityWindow((byte)reader.readElementContentAsInt("ValidityWindow"));
                it.setExecWeekdays(Weekdays.forValue(reader.readElementContentAsInt("ExecWeekdays")));
                it.setExecSpecDays(reader.readElementContentAsString("ExecSpecDays"));
                it.setBeginDate(reader.readElementContentAsDate("BeginDate"));
                it.setEndDate(reader.readElementContentAsDate("EndDate"));
                this.entries.add(it);
            }
            reader.readEndElement("Entries");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.entries != null) {
            writer.writeStartElement("Entries");
            for (GXDLMSScheduleEntry it : this.entries) {
                writer.writeStartElement("Item");
                writer.writeElementString("Index", it.getIndex());
                writer.writeElementString("Enable", it.getEnable());
                writer.writeElementString("LogicalName", it.getLogicalName());
                writer.writeElementString("ScriptSelector", it.getScriptSelector());
                writer.writeElementString("SwitchTime", it.getSwitchTime());
                writer.writeElementString("ValidityWindow", it.getValidityWindow());
                writer.writeElementString("ExecWeekdays", Weekdays.toInteger(it.getExecWeekdays()));
                writer.writeElementString("ExecSpecDays", it.getExecSpecDays());
                writer.writeElementString("BeginDate", it.getBeginDate());
                writer.writeElementString("EndDate", it.getEndDate());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Entries"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Enable/disable", "Insert", "Delete"};
    }
}

