/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.TokenDelivery;
import gurux.dlms.objects.enums.TokenStatusCode;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSTokenGateway
extends GXDLMSObject
implements IGXDLMSBase {
    private byte[] token;
    private GXDateTime time;
    private List<String> descriptions = new ArrayList<String>();
    private TokenDelivery deliveryMethod = TokenDelivery.LOCAL;
    private TokenStatusCode statusCode = TokenStatusCode.FORMAT_OK;
    private String dataValue;

    public GXDLMSTokenGateway() {
        this("0.0.19.40.0.255", 0);
    }

    public GXDLMSTokenGateway(String ln) {
        this(ln, 0);
    }

    public GXDLMSTokenGateway(String ln, int sn) {
        super(ObjectType.TOKEN_GATEWAY, ln, sn);
    }

    public final byte[] getToken() {
        return this.token;
    }

    public final void setToken(byte[] value) {
        this.token = value;
    }

    public final GXDateTime getTime() {
        return this.time;
    }

    public final void setTime(GXDateTime value) {
        this.time = value;
    }

    public final List<String> getDescriptions() {
        return this.descriptions;
    }

    public final void setDescriptions(List<String> value) {
        this.descriptions = value;
    }

    public final TokenDelivery getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public final void setDeliveryMethod(TokenDelivery value) {
        this.deliveryMethod = value;
    }

    public final TokenStatusCode getStatusCode() {
        return this.statusCode;
    }

    public final void setStatusCode(TokenStatusCode value) {
        this.statusCode = value;
    }

    public final String getDataValue() {
        return this.dataValue;
    }

    public final void setDataValue(String value) {
        this.dataValue = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.token, this.time, this.descriptions, this.deliveryMethod, new Object[]{this.statusCode, this.dataValue}};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.OCTET_STRING;
            }
            case 3: {
                return DataType.OCTET_STRING;
            }
            case 4: {
                return DataType.ARRAY;
            }
            case 5: {
                return DataType.ENUM;
            }
            case 6: {
                return DataType.STRUCTURE;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.token;
            }
            case 3: {
                return this.time;
            }
            case 4: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                if (this.descriptions == null) {
                    bb.setUInt8(0);
                } else {
                    bb.setUInt8((byte)this.descriptions.size());
                    for (String it : this.descriptions) {
                        bb.setUInt8(DataType.OCTET_STRING.getValue());
                        bb.setUInt8((byte)it.length());
                        bb.set(it.getBytes());
                    }
                }
                return bb.array();
            }
            case 5: {
                return this.deliveryMethod.getValue();
            }
            case 6: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(2);
                GXCommon.setData(null, bb, DataType.ENUM, this.statusCode.getValue());
                GXCommon.setData(null, bb, DataType.BITSTRING, this.dataValue);
                return bb.array();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.token = (byte[])e.getValue();
                break;
            }
            case 3: {
                this.time = (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings());
                break;
            }
            case 4: {
                this.descriptions.clear();
                if (e.getValue() == null) break;
                for (Object it : (List)e.getValue()) {
                    this.descriptions.add(new String((byte[])it));
                }
                break;
            }
            case 5: {
                this.deliveryMethod = TokenDelivery.forValue(((Number)e.getValue()).intValue());
                break;
            }
            case 6: {
                this.statusCode = TokenStatusCode.forValue(((Number)((List)e.getValue()).get(0)).intValue());
                this.dataValue = String.valueOf(((List)e.getValue()).get(1));
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.token = GXCommon.hexToBytes(reader.readElementContentAsString("Token"));
        this.time = reader.readElementContentAsDateTime("Time");
        this.descriptions.clear();
        if (reader.isStartElement("Descriptions", true)) {
            while (reader.isStartElement("Item", true)) {
                this.descriptions.add(reader.readElementContentAsString("Name"));
            }
            reader.readEndElement("Descriptions");
        }
        this.deliveryMethod = TokenDelivery.forValue(reader.readElementContentAsInt("DeliveryMethod"));
        this.statusCode = TokenStatusCode.forValue(reader.readElementContentAsInt("Status"));
        this.dataValue = reader.readElementContentAsString("Data");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Token", GXCommon.toHex(this.token, false));
        writer.writeElementString("Time", this.time);
        if (this.descriptions != null) {
            writer.writeStartElement("Descriptions");
            for (String it : this.descriptions) {
                writer.writeStartElement("Item");
                writer.writeElementString("Name", it);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("DeliveryMethod", this.deliveryMethod.getValue());
        writer.writeElementString("Status", this.statusCode.getValue());
        writer.writeElementString("Data", this.dataValue);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Token", "Time", "Description", "DeliveryMethod", "Status"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Enter"};
    }
}

