/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXDate;
import gurux.dlms.GXDateOS;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXDateTimeOS;
import gurux.dlms.GXStructure;
import gurux.dlms.GXTime;
import gurux.dlms.GXTimeOS;
import gurux.dlms.enums.DataType;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class GXXmlReader
implements AutoCloseable {
    private String elementName;
    private XMLStreamReader reader = null;
    private FileInputStream stream;
    private GXDLMSObjectCollection privateObjects;

    public final GXDLMSObjectCollection getObjects() {
        return this.privateObjects;
    }

    private void setObjects(GXDLMSObjectCollection value) {
        this.privateObjects = value;
    }

    @Override
    public final void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    public GXXmlReader(InputStream s) throws XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        this.reader = xif.createXMLStreamReader(s);
        this.setObjects(new GXDLMSObjectCollection());
    }

    public GXXmlReader(String filename) throws XMLStreamException, FileNotFoundException {
        this.stream = new FileInputStream(filename);
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        this.reader = xif.createXMLStreamReader(this.stream);
        this.setObjects(new GXDLMSObjectCollection());
    }

    public String getName() {
        if (this.elementName == null || this.reader.getEventType() == 1) {
            this.elementName = String.valueOf(this.reader.getName());
        }
        return this.elementName;
    }

    private void getNext() throws XMLStreamException {
        int type = this.reader.getEventType();
        while (type == 5 || type == 6 || type == 4) {
            this.read();
            type = this.reader.getEventType();
        }
    }

    public final boolean isEOF() throws XMLStreamException {
        return !this.reader.hasNext();
    }

    public final boolean read() throws XMLStreamException {
        this.reader.next();
        return this.reader.hasNext();
    }

    public final void readEndElement(String name) throws XMLStreamException {
        this.getNext();
        if (this.reader.getEventType() == 2 && name.equalsIgnoreCase(this.getName())) {
            this.read();
            this.getNext();
        }
    }

    public final boolean isStartElement(String name, boolean getNext) throws XMLStreamException {
        boolean ret;
        this.getNext();
        boolean bl = ret = this.reader.getEventType() == 1 && name.equalsIgnoreCase(this.getName());
        if (getNext && (ret || this.reader.getEventType() == 2)) {
            if (this.reader.getEventType() == 2) {
                this.elementName = null;
            }
            if (ret || name.equalsIgnoreCase(this.getName())) {
                this.read();
                if (!ret) {
                    ret = this.isStartElement(name, getNext);
                }
            }
        }
        this.getNext();
        return ret;
    }

    public final boolean isStartElement() {
        return this.reader.isStartElement();
    }

    public final String getAttribute(int index) {
        return this.reader.getAttributeValue(index);
    }

    public final int readElementContentAsInt(String name) throws XMLStreamException {
        return this.readElementContentAsInt(name, 0);
    }

    public final int readElementContentAsInt(String name, int defaultValue) throws XMLStreamException {
        this.getNext();
        if (name.compareToIgnoreCase(this.getName()) == 0) {
            String str = this.getText();
            int ret = Integer.parseInt(str);
            return ret;
        }
        return defaultValue;
    }

    public final long readElementContentAsLong(String name) throws XMLStreamException {
        return this.readElementContentAsLong(name, 0L);
    }

    public final long readElementContentAsLong(String name, long defaultValue) throws XMLStreamException {
        this.getNext();
        if (name.compareToIgnoreCase(this.getName()) == 0) {
            String str = this.getText();
            long ret = Long.parseLong(str);
            return ret;
        }
        return defaultValue;
    }

    public final long readElementContentAsULong(String name) throws XMLStreamException {
        return this.readElementContentAsULong(name, 0L);
    }

    public final long readElementContentAsULong(String name, long defaultValue) throws XMLStreamException {
        this.getNext();
        if (name.compareToIgnoreCase(this.getName()) == 0) {
            String str = this.getText();
            long ret = Long.parseLong(str);
            return ret;
        }
        return defaultValue;
    }

    public final double readElementContentAsDouble(String name, double defaultValue) throws XMLStreamException {
        this.getNext();
        if (name.compareToIgnoreCase(this.getName()) == 0) {
            String str = this.getText();
            double ret = Double.parseDouble(str);
            return ret;
        }
        return defaultValue;
    }

    private List<Object> readArray(DataType dt) throws XMLStreamException {
        ArrayList list = dt == DataType.ARRAY ? new GXArray() : (dt == DataType.STRUCTURE ? new GXStructure() : new ArrayList());
        while (this.isStartElement("Item", false)) {
            list.add(this.readElementContentAsObject("Item", null, null, 0));
        }
        return list;
    }

    public final Object readElementContentAsObject(String name, Object defaultValue, GXDLMSObject obj, int index) throws XMLStreamException {
        this.getNext();
        if (name.compareToIgnoreCase(this.getName()) == 0) {
            DataType uiType;
            DataType dt;
            Object ret = null;
            String str = this.getAttribute(0);
            if (str == null || str.isEmpty()) {
                dt = DataType.NONE;
            } else {
                dt = DataType.forValue(Integer.parseInt(str));
                if (obj != null) {
                    obj.setDataType(index, dt);
                }
            }
            if (this.reader.getAttributeCount() > 1) {
                str = this.getAttribute(1);
                uiType = DataType.forValue(Integer.parseInt(str));
            } else {
                uiType = dt;
            }
            if (obj != null && obj.getUIDataType(index) == DataType.NONE) {
                obj.setUIDataType(index, uiType);
            }
            if (dt == DataType.ARRAY || dt == DataType.STRUCTURE) {
                this.read();
                this.getNext();
                ret = this.readArray(dt);
                this.readEndElement(name);
                return ret;
            }
            str = this.getText();
            switch (uiType) {
                case OCTET_STRING: {
                    if (str.isEmpty()) break;
                    ret = GXDLMSTranslator.hexToBytes(str);
                    break;
                }
                case DATETIME: {
                    if (str.isEmpty()) break;
                    if (dt == DataType.OCTET_STRING) {
                        ret = new GXDateTimeOS(str, Locale.ROOT);
                        break;
                    }
                    ret = new GXDateTime(str, Locale.ROOT);
                    break;
                }
                case DATE: {
                    if (str.isEmpty()) break;
                    if (dt == DataType.OCTET_STRING) {
                        ret = new GXDateOS(str, Locale.ROOT);
                        break;
                    }
                    ret = new GXDate(str, Locale.ROOT);
                    break;
                }
                case TIME: {
                    if (str.isEmpty()) break;
                    if (dt == DataType.OCTET_STRING) {
                        ret = new GXTimeOS(str, Locale.ROOT);
                        break;
                    }
                    ret = new GXTime(str, Locale.ROOT);
                    break;
                }
                case NONE: {
                    ret = defaultValue;
                    break;
                }
                default: {
                    ret = GXDLMSConverter.changeType(str, uiType);
                }
            }
            int type = this.reader.getEventType();
            while (type != 1 && type != 2) {
                this.read();
                type = this.reader.getEventType();
            }
            return ret;
        }
        return defaultValue;
    }

    public final String readElementContentAsString(String name) throws XMLStreamException {
        return this.readElementContentAsString(name, null);
    }

    public final GXDateTime readElementContentAsDateTime(String name) throws XMLStreamException {
        String str = this.readElementContentAsString(name, null);
        GXDateTime it = null;
        if (str != null) {
            it = new GXDateTime(str, Locale.ROOT);
        }
        return it;
    }

    public final GXDate readElementContentAsDate(String name) throws XMLStreamException {
        String str = this.readElementContentAsString(name, null);
        GXDate it = null;
        if (str != null) {
            it = new GXDate(str, Locale.ROOT);
        }
        return it;
    }

    public final GXTime readElementContentAsTime(String name) throws XMLStreamException {
        String str = this.readElementContentAsString(name, null);
        GXTime it = null;
        if (str != null) {
            it = new GXTime(str, Locale.ROOT);
        }
        return it;
    }

    private String getText() throws XMLStreamException {
        String ret = this.reader.getElementText();
        this.read();
        this.getNext();
        this.elementName = null;
        return ret;
    }

    public final String readElementContentAsString(String name, String defaultValue) throws XMLStreamException {
        this.getNext();
        if (name.compareToIgnoreCase(this.getName()) == 0) {
            return this.getText();
        }
        return defaultValue;
    }

    public final String toString() {
        if (this.reader != null) {
            return this.reader.getEventType() + ", Name=\"" + this.elementName + "\"";
        }
        return super.toString();
    }
}

