/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.secure;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.enums.Security;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.enums.SecuritySuite;
import java.math.BigInteger;

public class AesGcmParameter {
    private int tag;
    private GXDLMSSettings settings;
    private Security security;
    private long invocationCounter;
    private byte[] systemTitle;
    private byte[] blockCipherKey;
    private byte[] authenticationKey;
    private int type;
    private byte[] recipientSystemTitle;
    private byte[] dateTime;
    private byte[] otherInformation;
    private int keyParameters;
    private byte[] keyCipheredData;
    private byte[] cipheredContent;
    private byte[] signature;
    private SecuritySuite securitySuite = SecuritySuite.SUITE_0;
    private boolean compressed;
    private boolean ignoreSystemTitle;
    private boolean broadcasted;
    private GXDLMSTranslatorStructure xml;
    BigInteger transactionId;

    public AesGcmParameter(GXDLMSSettings s, int forTag, Security forSecurity, SecuritySuite forSecuritySuite, long forInvocationCounter, byte[] forSystemTitle, byte[] forBlockCipherKey, byte[] forAuthenticationKey) {
        this.settings = s;
        this.tag = forTag;
        this.security = forSecurity;
        this.securitySuite = forSecuritySuite;
        this.invocationCounter = forInvocationCounter;
        this.systemTitle = forSystemTitle;
        this.blockCipherKey = forBlockCipherKey;
        this.authenticationKey = forAuthenticationKey;
        this.type = -1;
    }

    public AesGcmParameter(int forTag, GXDLMSSettings forSettings, Security forSecurity, SecuritySuite forSecuritySuite, long forInvocationCounter, byte[] kdf, byte[] forAuthenticationKey, byte[] forOriginatorSystemTitle, byte[] forRecipientSystemTitle, byte[] forDateTime, byte[] forOtherInformation) {
        this.settings = forSettings;
        this.tag = forTag;
        this.security = forSecurity;
        this.invocationCounter = forInvocationCounter;
        this.securitySuite = forSecuritySuite;
        this.blockCipherKey = kdf;
        this.authenticationKey = forAuthenticationKey;
        this.systemTitle = forOriginatorSystemTitle;
        this.recipientSystemTitle = forRecipientSystemTitle;
        this.type = -1;
        this.dateTime = forDateTime;
        this.otherInformation = forOtherInformation;
    }

    public AesGcmParameter(GXDLMSSettings forSettings, byte[] forsystemTitle, byte[] forblockCipherKey, byte[] forauthenticationKey) {
        this.systemTitle = forsystemTitle;
        this.blockCipherKey = forblockCipherKey;
        this.authenticationKey = forauthenticationKey;
        this.type = -1;
        this.settings = forSettings;
    }

    public final int getTag() {
        return this.tag;
    }

    public final BigInteger getTransactionId() {
        return this.transactionId;
    }

    public final void setTransactionId(BigInteger value) {
        this.transactionId = value;
    }

    public final Security getSecurity() {
        return this.security;
    }

    public final void setSecurity(Security value) {
        this.security = value;
    }

    public final long getInvocationCounter() {
        return this.invocationCounter;
    }

    public final void setInvocationCounter(long value) {
        this.invocationCounter = value;
    }

    public final byte[] getSystemTitle() {
        return this.systemTitle;
    }

    public final void setSystemTitle(byte[] value) {
        this.systemTitle = value;
    }

    public final byte[] getBlockCipherKey() {
        return this.blockCipherKey;
    }

    public final void setBlockCipherKey(byte[] value) {
        this.blockCipherKey = value;
    }

    public final byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public final void setAuthenticationKey(byte[] value) {
        this.authenticationKey = value;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int value) {
        this.type = value;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Security: ");
        sb.append((Object)this.getSecurity());
        sb.append(" InvocationCounter: ");
        sb.append(this.getInvocationCounter());
        sb.append(" SystemTitle: ");
        sb.append(GXCommon.toHex(this.systemTitle, true));
        sb.append(" AuthenticationKey: ");
        sb.append(GXCommon.toHex(this.authenticationKey, true));
        sb.append(" BlockCipherKey: ");
        sb.append(GXCommon.toHex(this.blockCipherKey, true));
        return sb.toString();
    }

    public byte[] getDateTime() {
        return this.dateTime;
    }

    public final void setDateTime(byte[] value) {
        this.dateTime = value;
    }

    public byte[] getOtherInformation() {
        return this.otherInformation;
    }

    public final void setOtherInformation(byte[] value) {
        this.otherInformation = value;
    }

    public byte[] getRecipientSystemTitle() {
        return this.recipientSystemTitle;
    }

    public final void setRecipientSystemTitle(byte[] value) {
        this.recipientSystemTitle = value;
    }

    public SecuritySuite getSecuritySuite() {
        return this.securitySuite;
    }

    public void setSecuritySuite(SecuritySuite value) {
        this.securitySuite = value;
    }

    public boolean getIgnoreSystemTitle() {
        return this.ignoreSystemTitle;
    }

    public void setIgnoreSystemTitle(boolean value) {
        this.ignoreSystemTitle = value;
    }

    public int getKeyParameters() {
        return this.keyParameters;
    }

    public void setKeyParameters(int value) {
        this.keyParameters = value;
    }

    public byte[] getKeyCipheredData() {
        return this.keyCipheredData;
    }

    public void setKeyCipheredData(byte[] value) {
        this.keyCipheredData = value;
    }

    public byte[] getCipheredContent() {
        return this.cipheredContent;
    }

    public void setCipheredContent(byte[] value) {
        this.cipheredContent = value;
    }

    public final void setXml(GXDLMSTranslatorStructure value) {
        this.xml = value;
    }

    public final GXDLMSTranslatorStructure getXml() {
        return this.xml;
    }

    public GXDLMSSettings getSettings() {
        return this.settings;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] value) {
        this.signature = value;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean value) {
        this.compressed = value;
    }

    public boolean isBroadcasted() {
        return this.broadcasted;
    }

    public void setBroadcasted(boolean value) {
        this.broadcasted = value;
    }
}

