/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.ServiceError;
import gurux.dlms.enums.Access;
import gurux.dlms.enums.ApplicationReference;
import gurux.dlms.enums.ConfirmedServiceError;
import gurux.dlms.enums.Definition;
import gurux.dlms.enums.HardwareResource;
import gurux.dlms.enums.Initiate;
import gurux.dlms.enums.LoadDataSet;
import gurux.dlms.enums.Service;
import gurux.dlms.enums.Task;
import gurux.dlms.enums.VdeStateError;

public class GXDLMSConfirmedServiceError
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private ConfirmedServiceError confirmedServiceError;
    private ServiceError serviceError;
    private byte serviceErrorValue;

    GXDLMSConfirmedServiceError(ConfirmedServiceError service, ServiceError type, int value) {
        super("ServiceError " + GXDLMSConfirmedServiceError.getConfirmedServiceError(service) + " exception. " + GXDLMSConfirmedServiceError.getServiceError(type) + " " + GXDLMSConfirmedServiceError.getServiceErrorValue(type, (byte)value));
        this.confirmedServiceError = service;
        this.serviceError = type;
        this.serviceErrorValue = (byte)value;
    }

    public final ConfirmedServiceError getConfirmedServiceError() {
        return this.confirmedServiceError;
    }

    public final byte getServiceErrorValue() {
        return this.serviceErrorValue;
    }

    public final ServiceError getServiceError() {
        return this.serviceError;
    }

    private static String getConfirmedServiceError(ConfirmedServiceError stateError) {
        switch (stateError) {
            case INITIATE_ERROR: {
                return "Initiate Error";
            }
            case READ: {
                return "Read";
            }
            case WRITE: {
                return "Write";
            }
        }
        return "";
    }

    private static String getServiceError(ServiceError error) {
        switch (error) {
            case APPLICATION_REFERENCE: {
                return "Application reference";
            }
            case HARDWARE_RESOURCE: {
                return "Hardware resource";
            }
            case VDE_STATE_ERROR: {
                return "Vde state error";
            }
            case SERVICE: {
                return "Service";
            }
            case DEFINITION: {
                return "Definition";
            }
            case ACCESS: {
                return "Access";
            }
            case INITIATE: {
                return "Initiate";
            }
            case LOAD_DATASET: {
                return "Load dataset";
            }
            case TASK: {
                return "Task";
            }
            case OTHER_ERROR: {
                return "Other Error";
            }
        }
        return "";
    }

    private static String getServiceErrorValue(ServiceError error, byte value) {
        switch (error) {
            case APPLICATION_REFERENCE: {
                return ApplicationReference.forValue(value).toString();
            }
            case HARDWARE_RESOURCE: {
                return HardwareResource.forValue(value).toString();
            }
            case VDE_STATE_ERROR: {
                return VdeStateError.forValue(value).toString();
            }
            case SERVICE: {
                return Service.forValue(value).toString();
            }
            case DEFINITION: {
                return Definition.forValue(value).toString();
            }
            case ACCESS: {
                return Access.forValue(value).toString();
            }
            case INITIATE: {
                return Initiate.forValue(value).toString();
            }
            case LOAD_DATASET: {
                return LoadDataSet.forValue(value).toString();
            }
            case TASK: {
                return Task.forValue(value).toString();
            }
            case OTHER_ERROR: {
                return String.valueOf(value);
            }
        }
        return "";
    }
}

