/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSAccessItem;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConnectionEventArgs;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSLongTransaction;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXReplyData;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ServiceError;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.AccessMode3;
import gurux.dlms.enums.ConfirmedServiceError;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.MethodAccessMode3;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Service;
import gurux.dlms.enums.TranslatorOutputType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSAssociationLogicalName;
import gurux.dlms.objects.GXDLMSAssociationShortName;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSProfileGeneric;
import gurux.dlms.objects.GXDLMSSecuritySetup;
import gurux.dlms.objects.enums.AssociationStatus;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

final class GXDLMSLNCommandHandler {
    private static final Logger LOGGER = Logger.getLogger(GXDLMSServerBase.class.getName());

    private GXDLMSLNCommandHandler() {
    }

    static void handleGetRequest(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (xml == null && (settings.getConnected() & 2) == 0 && cipheredCommand == 0) {
            replyData.set(GXDLMSServerBase.generateConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.UNSUPPORTED.getValue()));
            return;
        }
        byte type = 1;
        short invokeID = 0;
        try {
            if (data.size() != 0) {
                type = (byte)data.getUInt8();
                invokeID = data.getUInt8();
                settings.updateInvokeId(invokeID);
                GXDLMS.addInvokeId(xml, 192, type, invokeID);
            }
            if (type == 1) {
                GXDLMSLNCommandHandler.getRequestNormal(settings, invokeID, server, data, replyData, xml, cipheredCommand);
            } else if (type == 2) {
                GXDLMSLNCommandHandler.getRequestNextDataBlock(settings, invokeID, server, data, replyData, xml, false, cipheredCommand);
            } else if (type == 3) {
                GXDLMSLNCommandHandler.getRequestWithList(settings, invokeID, server, data, replyData, xml, cipheredCommand);
            } else {
                LOGGER.log(Level.INFO, "HandleGetRequest failed. Invalid command type.");
                GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, invokeID, 196, 1, null, null, ErrorCode.READ_WRITE_DENIED.getValue(), cipheredCommand), replyData);
                settings.resetBlockIndex();
            }
            if (xml != null) {
                xml.appendEndTag(192, type);
                xml.appendEndTag(192);
            }
        }
        catch (Exception ex) {
            replyData.clear();
            LOGGER.log(Level.SEVERE, ex.getMessage());
            GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, invokeID, 196, type, null, null, ErrorCode.READ_WRITE_DENIED.getValue(), cipheredCommand), replyData);
            settings.resetBlockIndex();
        }
    }

    public static void handleSetRequest(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        if (xml == null && (settings.getConnected() & 2) == 0 && cipheredCommand == 0) {
            replyData.set(GXDLMSServerBase.generateConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.UNSUPPORTED.getValue()));
            return;
        }
        byte type = (byte)data.getUInt8();
        short invoke = data.getUInt8();
        settings.updateInvokeId(invoke);
        GXDLMSLNParameters p = new GXDLMSLNParameters(settings, invoke, 197, type, null, null, 0, cipheredCommand);
        GXDLMS.addInvokeId(xml, 193, type, invoke);
        try {
            switch (type) {
                case 1: 
                case 2: {
                    GXDLMSLNCommandHandler.handleSetRequestNormal(settings, server, data, type, p, replyData, xml);
                    break;
                }
                case 3: {
                    GXDLMSLNCommandHandler.hanleSetRequestWithDataBlock(settings, server, data, p, replyData, xml);
                    break;
                }
                case 4: {
                    GXDLMSLNCommandHandler.hanleSetRequestWithList(settings, invoke, server, data, p, replyData, xml);
                    break;
                }
                default: {
                    LOGGER.log(Level.INFO, "HandleSetRequest failed. Unknown command.");
                    settings.resetBlockIndex();
                    GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, invoke, 197, 1, null, null, ErrorCode.READ_WRITE_DENIED.getValue(), cipheredCommand), replyData);
                    settings.resetBlockIndex();
                    return;
                }
            }
            if (xml != null) {
                xml.appendEndTag(193, type);
                xml.appendEndTag(193);
                return;
            }
            GXDLMS.getLNPdu(p, replyData);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, invoke, 197, type, null, null, ErrorCode.READ_WRITE_DENIED.getValue(), cipheredCommand), replyData);
            settings.resetBlockIndex();
        }
    }

    private static void appendAttributeDescriptor(GXDLMSTranslatorStructure xml, int ci, byte[] ln, short attributeIndex) {
        ObjectType ot;
        xml.appendStartTag(65290);
        if (xml.isComments() && (ot = ObjectType.forValue(ci)) != null) {
            xml.appendComment(ot.toString());
        }
        xml.appendLine(65291, "Value", xml.integerToHex(ci, 4));
        xml.appendComment(GXCommon.toLogicalName(ln));
        xml.appendLine(65292, "Value", GXCommon.toHex(ln, false));
        xml.appendLine(65293, "Value", xml.integerToHex(attributeIndex, 2));
        xml.appendEndTag(65290);
    }

    private static void appendMethodDescriptor(GXDLMSTranslatorStructure xml, int ci, byte[] ln, short attributeIndex) {
        ObjectType ot;
        xml.appendStartTag(65300);
        if (xml.isComments() && (ot = ObjectType.forValue(ci)) != null) {
            xml.appendComment(ot.toString());
        }
        xml.appendLine(65291, "Value", xml.integerToHex(ci, 4));
        xml.appendComment(GXCommon.toLogicalName(ln));
        xml.appendLine(65292, "Value", GXCommon.toHex(ln, false));
        xml.appendLine(65301, "Value", xml.integerToHex(attributeIndex, 2));
        xml.appendEndTag(65300);
    }

    private static void getRequestNormal(GXDLMSSettings settings, short invokeID, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        GXByteBuffer bb = new GXByteBuffer();
        ValueEventArgs e = null;
        ErrorCode status = ErrorCode.OK;
        settings.setCount(0L);
        settings.setIndex(0L);
        settings.resetBlockIndex();
        int mode = 0;
        try {
            int ci = data.getUInt16();
            byte[] ln = new byte[6];
            data.get(ln);
            short attributeIndex = data.getUInt8();
            short selection = data.getUInt8();
            short selector = 0;
            Object parameters = null;
            GXDataInfo info = new GXDataInfo();
            if (selection != 0) {
                selector = data.getUInt8();
            }
            if (xml != null) {
                GXDLMSLNCommandHandler.appendAttributeDescriptor(xml, ci, ln, attributeIndex);
                if (selection != 0) {
                    info.setXml(xml);
                    xml.appendStartTag(65304);
                    xml.appendLine(65306, "Value", xml.integerToHex(selector, 2));
                    xml.appendStartTag(65307);
                    GXCommon.getData(settings, data, info);
                    xml.appendEndTag(65307);
                    xml.appendEndTag(65304);
                }
                return;
            }
            if (selection != 0) {
                parameters = GXCommon.getData(settings, data, info);
            }
            ObjectType ot = ObjectType.forValue(ci);
            GXDLMSObject obj = settings.getObjects().findByLN(ot, GXCommon.toLogicalName(ln));
            if (obj == null) {
                obj = server.notifyFindObject(ot, 0, GXCommon.toLogicalName(ln));
            }
            e = new ValueEventArgs(server, obj, (int)attributeIndex, (int)selector, parameters);
            if (obj == null) {
                status = ErrorCode.UNDEFINED_OBJECT;
            } else {
                e.setInvokeId(invokeID);
                if (server.notifyGetAttributeAccess(e) == AccessMode.NO_ACCESS.getValue()) {
                    status = ErrorCode.READ_WRITE_DENIED;
                } else {
                    if (settings.getAssignedAssociation() != null) {
                        mode = AccessMode3.toInteger(settings.getAssignedAssociation().getAccess3(obj, attributeIndex));
                    }
                    if ((obj instanceof GXDLMSAssociationLogicalName || obj instanceof GXDLMSAssociationShortName) && attributeIndex == 1) {
                        GXDLMS.appendData(obj, attributeIndex, bb, new byte[]{0, 0, 40, 0, 0, -1});
                    } else {
                        Object value;
                        if (obj instanceof GXDLMSProfileGeneric && attributeIndex == 2) {
                            int rowsize = 0;
                            GXDLMSProfileGeneric pg = (GXDLMSProfileGeneric)e.getTarget();
                            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : pg.getCaptureObjects()) {
                                DataType dt = it.getKey().getDataType(it.getValue().getAttributeIndex());
                                if (dt == DataType.OCTET_STRING) {
                                    dt = it.getKey().getUIDataType(it.getValue().getAttributeIndex());
                                    if (dt == DataType.DATETIME) {
                                        rowsize += GXCommon.getDataTypeSize(DataType.DATETIME);
                                        continue;
                                    }
                                    if (dt == DataType.DATE) {
                                        rowsize += GXCommon.getDataTypeSize(DataType.DATE);
                                        continue;
                                    }
                                    if (dt != DataType.TIME) continue;
                                    rowsize += GXCommon.getDataTypeSize(DataType.TIME);
                                    continue;
                                }
                                if (dt == DataType.NONE) {
                                    rowsize += 2;
                                    continue;
                                }
                                rowsize += GXCommon.getDataTypeSize(dt);
                            }
                            if (rowsize != 0) {
                                e.setRowToPdu(settings.getMaxPduSize() / rowsize);
                            }
                        }
                        server.notifyRead(new ValueEventArgs[]{e});
                        if (e.getHandled()) {
                            value = e.getValue();
                        } else {
                            settings.setCount(e.getRowEndIndex() - e.getRowBeginIndex());
                            value = obj.getValue(settings, e);
                        }
                        server.notifyPostRead(new ValueEventArgs[]{e});
                        if (e.isByteArray()) {
                            bb.set((byte[])value);
                        } else {
                            GXDLMS.appendData(obj, attributeIndex, bb, value);
                        }
                        status = e.getError();
                    }
                }
            }
        }
        catch (Exception ex) {
            status = ErrorCode.READ_WRITE_DENIED;
        }
        GXDLMSLNParameters p = new GXDLMSLNParameters(settings, invokeID, 196, 1, null, bb, status.getValue(), cipheredCommand);
        p.accessMode = mode;
        GXDLMS.getLNPdu(p, replyData);
        if (settings.getCount() != settings.getIndex() || bb.size() != bb.position()) {
            server.setTransaction(new GXDLMSLongTransaction(new ValueEventArgs[]{e}, 192, bb));
        }
    }

    static void getRequestNextDataBlock(GXDLMSSettings settings, int invokeID, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, boolean streaming, int cipheredCommand) throws Exception {
        GXByteBuffer bb = new GXByteBuffer();
        if (!streaming) {
            int index = (int)data.getUInt32();
            if (xml != null) {
                xml.appendLine(65298, null, xml.integerToHex(index, 8));
                return;
            }
            if (index != settings.getBlockIndex()) {
                LOGGER.log(Level.INFO, "getRequestNextDataBlock failed. Invalid block number. " + settings.getBlockIndex() + "/" + index);
                GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, invokeID, 196, 2, null, bb, ErrorCode.DATA_BLOCK_NUMBER_INVALID.getValue(), cipheredCommand), replyData);
                return;
            }
        }
        settings.increaseBlockIndex();
        GXDLMSLNParameters p = new GXDLMSLNParameters(settings, invokeID, streaming ? 224 : 196, 2, null, bb, ErrorCode.OK.getValue(), cipheredCommand);
        p.streaming = streaming;
        p.windowSize = settings.getGbtWindowSize();
        if (server.getTransaction() == null) {
            p.setStatus(ErrorCode.NO_LONG_GET_OR_READ_IN_PROGRESS.getValue());
        } else {
            boolean moreData;
            bb.set(server.getTransaction().getData());
            boolean bl = moreData = settings.getIndex() != settings.getCount();
            if (moreData && bb.size() < settings.getMaxPduSize()) {
                for (ValueEventArgs arg : server.getTransaction().getTargets()) {
                    arg.setInvokeId(p.getInvokeId());
                    server.notifyRead(new ValueEventArgs[]{arg});
                    Object value = arg.getHandled() ? arg.getValue() : arg.getTarget().getValue(settings, arg);
                    p.setInvokeId(arg.getInvokeId());
                    if (arg.isByteArray()) {
                        bb.set((byte[])value);
                        continue;
                    }
                    GXDLMS.appendData(arg.getTarget(), arg.getIndex(), bb, value);
                }
                moreData = settings.getIndex() != settings.getCount();
            }
            p.setMultipleBlocks(true);
            GXDLMS.getLNPdu(p, replyData);
            if (moreData || bb.size() - bb.position() != 0) {
                server.getTransaction().setData(bb);
            } else {
                server.setTransaction(null);
                settings.resetBlockIndex();
            }
        }
    }

    private static void getRequestWithList(GXDLMSSettings settings, short invokeID, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        int pos;
        GXByteBuffer bb = new GXByteBuffer();
        int cnt = GXCommon.getObjectCount(data);
        GXCommon.setObjectCount(cnt, bb);
        ArrayList<ValueEventArgs> list = new ArrayList<ValueEventArgs>();
        if (xml != null) {
            xml.appendStartTag(65308, "Qty", xml.integerToHex(cnt, 2));
        }
        for (pos = 0; pos != cnt; ++pos) {
            ObjectType ci = ObjectType.forValue(data.getUInt16());
            byte[] ln = new byte[6];
            data.get(ln);
            short attributeIndex = data.getUInt8();
            short selection = data.getUInt8();
            short selector = 0;
            Object parameters = null;
            if (selection != 0) {
                selector = data.getUInt8();
                GXDataInfo i = new GXDataInfo();
                parameters = GXCommon.getData(settings, data, i);
            }
            if (xml != null) {
                xml.appendStartTag(65309);
                xml.appendStartTag(65290);
                if (xml.isComments()) {
                    xml.appendComment(ci.toString());
                }
                xml.appendLine(65291, "Value", xml.integerToHex(ci.getValue(), 4));
                xml.appendComment(GXCommon.toLogicalName(ln));
                xml.appendLine(65292, "Value", GXCommon.toHex(ln, false));
                xml.appendLine(65293, "Value", xml.integerToHex(attributeIndex, 2));
                xml.appendEndTag(65290);
                xml.appendEndTag(65309);
                continue;
            }
            GXDLMSObject obj = settings.getObjects().findByLN(ci, GXCommon.toLogicalName(ln));
            if (obj == null) {
                obj = server.notifyFindObject(ci, 0, GXCommon.toLogicalName(ln));
            }
            ValueEventArgs arg = new ValueEventArgs(server, obj, (int)attributeIndex, (int)selector, parameters);
            arg.setInvokeId(invokeID);
            if (obj == null) {
                arg.setError(ErrorCode.UNDEFINED_OBJECT);
                list.add(arg);
                continue;
            }
            if (server.notifyGetAttributeAccess(arg) == AccessMode.NO_ACCESS.getValue()) {
                arg.setError(ErrorCode.READ_WRITE_DENIED);
                list.add(arg);
                continue;
            }
            list.add(arg);
        }
        if (xml != null) {
            xml.appendEndTag(65308);
            return;
        }
        server.notifyRead(list.toArray(new ValueEventArgs[list.size()]));
        pos = 0;
        GXDLMSLNParameters p = new GXDLMSLNParameters(settings, invokeID, 196, 3, null, bb, 255, cipheredCommand);
        for (ValueEventArgs it : list) {
            try {
                Object value = it.getHandled() ? it.getValue() : it.getTarget().getValue(settings, it);
                bb.setUInt8(it.getError().getValue());
                if (it.isByteArray()) {
                    bb.set((byte[])value);
                } else {
                    GXDLMS.appendData(it.getTarget(), it.getIndex(), bb, value);
                }
                p.setInvokeId(it.getInvokeId());
            }
            catch (Exception ex) {
                bb.setUInt8(ErrorCode.HARDWARE_FAULT.getValue());
            }
            if (settings.getIndex() != settings.getCount()) {
                server.setTransaction(new GXDLMSLongTransaction(list.toArray(new ValueEventArgs[list.size()]), 192, null));
            }
            ++pos;
        }
        server.notifyPostRead(list.toArray(new ValueEventArgs[list.size()]));
        GXDLMS.getLNPdu(p, replyData);
    }

    private static void handleSetRequestNormal(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, int type, GXDLMSLNParameters p, GXByteBuffer replyData, GXDLMSTranslatorStructure xml) throws Exception {
        GXDLMSObject obj;
        Object value = null;
        GXDataInfo reply = new GXDataInfo();
        short ci = data.getInt16();
        ObjectType ot = ObjectType.forValue(ci & 0xFFFF);
        byte[] ln = new byte[6];
        data.get(ln);
        short index = data.getUInt8();
        data.getUInt8();
        if (type == 2) {
            short lastBlock = data.getUInt8();
            p.setMultipleBlocks(lastBlock == 0);
            long blockNumber = data.getUInt32();
            if (blockNumber != (long)settings.getBlockIndex()) {
                LOGGER.log(Level.INFO, "handleSetRequest failed. Invalid block number. " + settings.getBlockIndex() + "/" + blockNumber);
                p.setStatus(ErrorCode.DATA_BLOCK_NUMBER_INVALID.getValue());
                return;
            }
            settings.increaseBlockIndex();
            int size = GXCommon.getObjectCount(data);
            int realSize = data.size() - data.position();
            if (size != realSize) {
                LOGGER.log(Level.INFO, "handleSetRequest failed. Invalid block size.");
                p.setStatus(ErrorCode.DATA_BLOCK_UNAVAILABLE.getValue());
                return;
            }
            if (xml != null) {
                GXDLMSLNCommandHandler.appendAttributeDescriptor(xml, ci, ln, index);
                xml.appendStartTag(65349);
                xml.appendLine(65297, "Value", xml.integerToHex(lastBlock, 2));
                xml.appendLine(65298, "Value", xml.integerToHex(blockNumber, 8));
                xml.appendLine(65299, "Value", data.remainingHexString(false));
                xml.appendEndTag(65349);
            }
            return;
        }
        if (xml != null) {
            GXDLMSLNCommandHandler.appendAttributeDescriptor(xml, ci, ln, index);
            xml.appendStartTag(65305);
            GXDataInfo di = new GXDataInfo();
            di.setXml(xml);
            value = GXCommon.getData(settings, data, di);
            if (!di.isComplete()) {
                value = GXCommon.toHex(data.getData(), false, data.position(), data.size() - data.position());
            } else if (value instanceof byte[]) {
                value = GXCommon.toHex((byte[])value, false);
            }
            xml.appendEndTag(65305);
            return;
        }
        if (!p.isMultipleBlocks()) {
            settings.resetBlockIndex();
            value = GXCommon.getData(settings, data, reply);
        }
        if ((obj = settings.getObjects().findByLN(ot, GXCommon.toLogicalName(ln))) == null) {
            obj = server.notifyFindObject(ot, 0, GXCommon.toLogicalName(ln));
        }
        if (obj == null) {
            p.setStatus(ErrorCode.UNDEFINED_OBJECT.getValue());
        } else {
            ValueEventArgs e = new ValueEventArgs(server, obj, (int)index, 0, null);
            e.setInvokeId(p.getInvokeId());
            int am = server.notifyGetAttributeAccess(e);
            if ((am & AccessMode.WRITE.getValue()) == 0) {
                p.setStatus(ErrorCode.READ_WRITE_DENIED.getValue());
            } else {
                try {
                    if (value instanceof byte[]) {
                        DataType dt = obj.getDataType(index);
                        boolean useUtc = false;
                        if (settings != null) {
                            useUtc = settings.getUseUtc2NormalTime();
                        }
                        if (dt != DataType.NONE && dt != DataType.OCTET_STRING) {
                            value = GXDLMSClient.changeType((byte[])value, dt, useUtc);
                        }
                    }
                    e.setValue(value);
                    ValueEventArgs[] list = new ValueEventArgs[]{e};
                    if (p.isMultipleBlocks()) {
                        server.setTransaction(new GXDLMSLongTransaction(list, 192, data));
                    }
                    server.notifyWrite(list);
                    if (e.getError() != ErrorCode.OK) {
                        p.setStatus(e.getError().getValue());
                    } else if (!e.getHandled() && !p.isMultipleBlocks()) {
                        obj.setValue(settings, e);
                    }
                    server.notifyPostWrite(list);
                    p.setInvokeId(e.getInvokeId());
                    p.setStatus(e.getError().getValue());
                }
                catch (Exception ex) {
                    p.setStatus(ErrorCode.HARDWARE_FAULT.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hanleSetRequestWithDataBlock(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXDLMSLNParameters p, GXByteBuffer replyData, GXDLMSTranslatorStructure xml) throws Exception {
        GXDataInfo reply = new GXDataInfo();
        short lastBlock = data.getUInt8();
        p.setMultipleBlocks(lastBlock == 0);
        long blockNumber = data.getUInt32();
        if (xml == null && blockNumber != (long)settings.getBlockIndex()) {
            LOGGER.log(Level.INFO, "handleSetRequest failed. Invalid block number. " + settings.getBlockIndex() + "/" + blockNumber);
            p.setStatus(ErrorCode.DATA_BLOCK_NUMBER_INVALID.getValue());
        } else {
            settings.increaseBlockIndex();
            int size = GXCommon.getObjectCount(data);
            int realSize = data.size() - data.position();
            if (size != realSize) {
                LOGGER.log(Level.INFO, "handleSetRequest failed. Invalid block size.");
                p.setStatus(ErrorCode.DATA_BLOCK_UNAVAILABLE.getValue());
            }
            if (xml != null) {
                xml.appendStartTag(65349);
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendLine(65297, "Value", xml.integerToHex(lastBlock, 2));
                } else {
                    xml.appendLine(65297, "Value", lastBlock != 0 ? "true" : "false");
                }
                xml.appendLine(65298, "Value", xml.integerToHex(blockNumber, 8));
                xml.appendLine(65299, "Value", data.remainingHexString(false));
                xml.appendEndTag(65349);
                return;
            }
            server.getTransaction().getData().set(data);
            if (!p.isMultipleBlocks()) {
                try {
                    DataType dt;
                    Object value = GXCommon.getData(settings, server.getTransaction().getData(), reply);
                    if (value instanceof byte[] && (dt = server.getTransaction().getTargets()[0].getTarget().getDataType(server.getTransaction().getTargets()[0].getIndex())) != DataType.NONE && dt != DataType.OCTET_STRING) {
                        boolean useUtc = settings != null ? settings.getUseUtc2NormalTime() : false;
                        value = GXDLMSClient.changeType((byte[])value, dt, useUtc);
                    }
                    server.getTransaction().getTargets()[0].setValue(value);
                    server.notifyWrite(server.getTransaction().getTargets());
                    if (!server.getTransaction().getTargets()[0].getHandled() && !p.isMultipleBlocks()) {
                        server.getTransaction().getTargets()[0].getTarget().setValue(settings, server.getTransaction().getTargets()[0]);
                    }
                    server.notifyPostWrite(server.getTransaction().getTargets());
                }
                catch (RuntimeException e) {
                    p.setStatus(ErrorCode.HARDWARE_FAULT.getValue());
                }
                finally {
                    server.setTransaction(null);
                }
                settings.resetBlockIndex();
            }
        }
        p.setMultipleBlocks(true);
    }

    private static void hanleSetRequestWithList(GXDLMSSettings settings, int invokeID, GXDLMSServerBase server, GXByteBuffer data, GXDLMSLNParameters p, GXByteBuffer replyData, GXDLMSTranslatorStructure xml) throws Exception {
        block16: {
            int cnt = GXCommon.getObjectCount(data);
            ArrayList<ValueEventArgs> list = new ArrayList<ValueEventArgs>();
            if (xml != null) {
                xml.appendStartTag(65308, "Qty", xml.integerToHex(cnt, 2));
            }
            try {
                int pos;
                for (pos = 0; pos != cnt; ++pos) {
                    ObjectType ci = ObjectType.forValue(data.getUInt16());
                    byte[] ln = new byte[6];
                    data.get(ln);
                    short attributeIndex = data.getUInt8();
                    short selection = data.getUInt8();
                    short selector = 0;
                    Object parameters = null;
                    if (selection != 0) {
                        selector = data.getUInt8();
                        GXDataInfo info = new GXDataInfo();
                        parameters = GXCommon.getData(settings, data, info);
                    }
                    if (xml != null) {
                        xml.appendStartTag(65309);
                        xml.appendStartTag(65290);
                        xml.appendComment(ci.toString());
                        xml.appendLine(65291, "Value", xml.integerToHex(ci.getValue(), 4));
                        xml.appendComment(GXCommon.toLogicalName(ln));
                        xml.appendLine(65292, "Value", GXCommon.toHex(ln, false));
                        xml.appendLine(65293, "Value", xml.integerToHex(attributeIndex, 2));
                        xml.appendEndTag(65290);
                        xml.appendEndTag(65309);
                        continue;
                    }
                    GXDLMSObject obj = settings.getObjects().findByLN(ci, GXCommon.toLogicalName(ln));
                    if (obj == null) {
                        obj = server.notifyFindObject(ci, 0, GXCommon.toLogicalName(ln));
                    }
                    if (obj == null) {
                        ValueEventArgs e = new ValueEventArgs(server, obj, (int)attributeIndex, 0, (Object)0);
                        e.setError(ErrorCode.UNDEFINED_OBJECT);
                        list.add(e);
                        continue;
                    }
                    ValueEventArgs arg = new ValueEventArgs(server, obj, (int)attributeIndex, (int)selector, parameters);
                    arg.setInvokeId(invokeID);
                    if (server.notifyGetAttributeAccess(arg) == 0) {
                        arg.setError(ErrorCode.READ_WRITE_DENIED);
                        list.add(arg);
                        continue;
                    }
                    list.add(arg);
                }
                cnt = GXCommon.getObjectCount(data);
                if (xml != null) {
                    xml.appendEndTag(65308);
                    xml.appendStartTag(65378, "Qty", xml.integerToHex(cnt, 2));
                }
                for (pos = 0; pos != cnt; ++pos) {
                    GXDataInfo di = new GXDataInfo();
                    di.setXml(xml);
                    if (xml != null && xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                        xml.appendStartTag(6, (byte)0);
                    }
                    Object value = GXCommon.getData(settings, data, di);
                    if (!di.isComplete()) {
                        value = GXCommon.toHex(data.getData(), false, data.position(), data.size() - data.position());
                    } else if (value instanceof byte[]) {
                        value = GXCommon.toHex((byte[])value, false);
                    }
                    if (xml == null || xml.getOutputType() != TranslatorOutputType.STANDARD_XML) continue;
                    xml.appendEndTag(6, (byte)0);
                }
                if (xml != null) {
                    xml.appendEndTag(65378);
                }
            }
            catch (Exception ex) {
                if (xml != null) break block16;
                throw ex;
            }
        }
    }

    public static void methodRequest(GXDLMSSettings settings, byte type, short invokeId, GXDLMSServerBase server, GXByteBuffer data, GXDLMSConnectionEventArgs connectionInfo, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        ErrorCode error = ErrorCode.OK;
        ValueEventArgs e = null;
        GXByteBuffer bb = new GXByteBuffer();
        int ci = data.getUInt16();
        ObjectType ot = ObjectType.forValue(ci);
        byte[] ln = new byte[6];
        data.get(ln);
        short id = data.getUInt8();
        Object parameters = null;
        GXDLMSLNParameters p = new GXDLMSLNParameters(settings, invokeId, 199, 1, null, bb, 0, cipheredCommand);
        if (type == 1) {
            byte selection = (byte)data.getUInt8();
            if (xml != null) {
                xml.appendStartTag(195);
                GXDLMSLNCommandHandler.appendMethodDescriptor(xml, ci, ln, id);
                if (selection != 0) {
                    xml.appendStartTag(65294);
                    GXDataInfo di = new GXDataInfo();
                    di.setXml(xml);
                    GXCommon.getData(settings, data, di);
                    xml.appendEndTag(65294);
                }
                return;
            }
            if (selection != 0) {
                GXDataInfo info = new GXDataInfo();
                parameters = GXCommon.getData(settings, data, info);
            }
        } else if (type == 4) {
            p.setRequestType(4);
            p.setStatus(255);
            short lastBlock = data.getUInt8();
            p.setMultipleBlocks(lastBlock == 0);
            long blockNumber = data.getUInt32();
            if (xml == null && blockNumber != (long)settings.getBlockIndex()) {
                System.out.println("MethodRequest failed. Invalid block number. " + settings.getBlockIndex() + "/" + blockNumber);
                p.setStatus(ErrorCode.DATA_BLOCK_NUMBER_INVALID.getValue());
                GXDLMS.getLNPdu(p, replyData);
                return;
            }
            settings.increaseBlockIndex();
            int size = GXCommon.getObjectCount(data);
            int realSize = data.available();
            if (size != realSize) {
                if (xml == null) {
                    System.out.println("MethodRequest failed. Invalid block size.");
                    p.setStatus(ErrorCode.DATA_BLOCK_UNAVAILABLE.getValue());
                    GXDLMS.getLNPdu(p, replyData);
                    return;
                }
                xml.appendComment("Invalid block size.");
            }
            if (xml != null) {
                GXDLMSLNCommandHandler.appendMethodDescriptor(xml, ci, ln, id);
                xml.appendStartTag(65349);
                xml.appendLine(65297, "Value", xml.integerToHex(lastBlock, 2));
                xml.appendLine(65298, "Value", xml.integerToHex(blockNumber, 8));
                xml.appendLine(65299, "Value", data.remainingHexString(false));
                xml.appendEndTag(65349);
                return;
            }
        }
        GXDLMSObject obj = settings.getObjects().findByLN(ot, GXCommon.toLogicalName(ln));
        if ((settings.getConnected() & 2) == 0 && cipheredCommand == 0 && (ci != ObjectType.ASSOCIATION_LOGICAL_NAME.getValue() || id != 1)) {
            replyData.set(GXDLMSServerBase.generateConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.UNSUPPORTED.getValue()));
            return;
        }
        if (obj == null) {
            obj = server.notifyFindObject(ot, 0, GXCommon.toLogicalName(ln));
        }
        if (obj == null) {
            error = ErrorCode.UNDEFINED_OBJECT;
        } else {
            if (settings.getAssignedAssociation() != null) {
                p.accessMode = MethodAccessMode3.toInteger(settings.getAssignedAssociation().getMethodAccess3(obj, id));
            }
            e = new ValueEventArgs(server, obj, (int)id, 0, parameters);
            e.setInvokeId(invokeId);
            if (server.notifyGetMethodAccess(e) == 0) {
                error = ErrorCode.READ_WRITE_DENIED;
            } else {
                try {
                    if (p.isMultipleBlocks()) {
                        server.setTransaction(new GXDLMSLongTransaction(new ValueEventArgs[]{e}, 195, data));
                    } else {
                        server.notifyAction(new ValueEventArgs[]{e});
                        byte[] actionReply = e.getHandled() ? (byte[])e.getValue() : obj.invoke(settings, e);
                        server.notifyPostAction(new ValueEventArgs[]{e});
                        if (actionReply != null && e.getError() == ErrorCode.OK) {
                            bb.setUInt8(1);
                            bb.setUInt8(0);
                            if (e.isByteArray()) {
                                bb.set(actionReply);
                            } else {
                                GXCommon.setData(settings, bb, GXDLMSConverter.getDLMSDataType(actionReply), actionReply);
                            }
                        } else {
                            error = e.getError();
                            bb.setUInt8(0);
                        }
                    }
                }
                catch (Exception ex) {
                    error = ErrorCode.INCONSISTENT_CLASS;
                    bb.setUInt8(0);
                }
                p.setInvokeId(e.getInvokeId());
            }
        }
        if (error != ErrorCode.OK) {
            p.setStatus(error.getValue());
        }
        GXDLMS.getLNPdu(p, replyData);
        if (server.getTransaction() == null && p.getData().available() != 0) {
            server.setTransaction(new GXDLMSLongTransaction(new ValueEventArgs[]{e}, 199, p.getData()));
        }
        if (obj instanceof GXDLMSAssociationLogicalName && id == 1) {
            if (((GXDLMSAssociationLogicalName)obj).getAssociationStatus() == AssociationStatus.ASSOCIATED) {
                server.notifyConnected(connectionInfo);
                settings.setConnected(settings.getConnected() | 2);
            } else {
                server.notifyInvalidConnection(connectionInfo);
                settings.setConnected(settings.getConnected() & 0xFFFFFFFD);
            }
        }
        if (e != null && error == ErrorCode.OK && obj instanceof GXDLMSSecuritySetup && (id == 2 || id == 3)) {
            ((GXDLMSSecuritySetup)obj).applyKeys(settings, e);
        }
    }

    public static void methodRequestNextDataBlock(GXDLMSSettings settings, int invokeID, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, boolean streaming, int cipheredCommand) throws Exception {
        GXByteBuffer bb = new GXByteBuffer();
        short lastBlock = data.getUInt8();
        if (!streaming) {
            long index = data.getUInt32();
            if (xml != null) {
                xml.appendLine(65298, null, xml.integerToHex(index, 8));
                return;
            }
            if (index != (long)settings.getBlockIndex()) {
                LOGGER.log(Level.INFO, "methodRequestNextBlock failed. Invalid block number. " + settings.getBlockIndex() + "/" + index);
                server.setTransaction(null);
                settings.resetBlockIndex();
                GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, 0L, 199, 1, null, bb, ErrorCode.DATA_BLOCK_NUMBER_INVALID.getValue(), cipheredCommand), replyData);
                return;
            }
        }
        settings.increaseBlockIndex();
        GXDLMSLNParameters p = new GXDLMSLNParameters(settings, invokeID, streaming ? 224 : 199, 1, null, bb, ErrorCode.OK.getValue(), cipheredCommand);
        p.setStreaming(streaming);
        p.setWindowSize(settings.getGbtWindowSize());
        if (server.getTransaction() == null) {
            p.setStatus(ErrorCode.NO_LONG_GET_OR_READ_IN_PROGRESS.getValue());
            p.setRequestType(1);
            GXDLMS.getLNPdu(p, replyData);
        } else {
            try {
                server.getTransaction().getData().set(data);
                if (lastBlock == 1) {
                    GXDataInfo info = new GXDataInfo();
                    Object parameters = GXCommon.getData(settings, server.getTransaction().getData(), info);
                    p.getData().clear();
                    for (ValueEventArgs arg : server.getTransaction().getTargets()) {
                        arg.setInvokeId(p.getInvokeId());
                        arg.setParameters(parameters);
                        server.notifyAction(new ValueEventArgs[]{arg});
                        Object value = arg.getHandled() ? arg.getValue() : (Object)arg.getTarget().invoke(settings, arg);
                        server.notifyPostAction(new ValueEventArgs[]{arg});
                        p.setInvokeId(arg.getInvokeId());
                        if (value != null && arg.getError() == ErrorCode.OK) {
                            bb.setUInt8(1);
                            bb.setUInt8(0);
                            if (arg.isByteArray()) {
                                bb.set((byte[])value);
                                continue;
                            }
                            GXCommon.setData(settings, bb, GXDLMSConverter.getDLMSDataType(value), value);
                            continue;
                        }
                        p.setRequestType(1);
                        p.setStatus(arg.getError().getValue());
                        bb.setUInt8(0);
                    }
                    server.setTransaction(null);
                    settings.resetBlockIndex();
                } else {
                    p.setRequestType(4);
                    p.setStatus(255);
                }
            }
            catch (Exception ex) {
                p.setStatus(ErrorCode.INCONSISTENT_CLASS.getValue());
                bb.setUInt8(0);
                server.setTransaction(null);
                settings.resetBlockIndex();
            }
            GXDLMS.getLNPdu(p, replyData);
            if (p.getStatus() == 255 && p.isMultipleBlocks()) {
                settings.increaseBlockIndex();
            }
        }
    }

    static void handleMethodRequest(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXDLMSConnectionEventArgs connectionInfo, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        byte type = (byte)data.getUInt8();
        short invokeId = data.getUInt8();
        settings.updateInvokeId(invokeId);
        GXDLMS.addInvokeId(xml, 195, type, invokeId);
        switch (type) {
            case 1: 
            case 4: {
                GXDLMSLNCommandHandler.methodRequest(settings, type, invokeId, server, data, connectionInfo, replyData, xml, cipheredCommand);
                break;
            }
            case 2: {
                GXDLMSLNCommandHandler.methodRequestNextDataBlock(settings, invokeId, server, data, replyData, xml, false, cipheredCommand);
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Invalid Command.");
            }
            case 6: {
                throw new IllegalArgumentException("Invalid Command.");
            }
            default: {
                if (xml != null) break;
                Logger.getLogger(GXDLMS.class.getName()).log(Level.WARNING, "HandleMethodRequest failed. Invalid command type :{0} ", type);
                settings.resetBlockIndex();
                type = 1;
                data.clear();
                GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, invokeId, 199, type, null, null, ErrorCode.READ_WRITE_DENIED.getValue(), cipheredCommand), replyData);
            }
        }
        if (xml != null) {
            if (type <= 3) {
                xml.appendEndTag(195, type);
            }
            xml.appendEndTag(195);
        }
    }

    public static void handleAccessRequest(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer reply, GXDLMSTranslatorStructure xml, int cipheredCommand) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (xml == null && (settings.getConnected() & 2) == 0 && cipheredCommand == 0) {
            reply.set(GXDLMSServerBase.generateConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.UNSUPPORTED.getValue()));
            return;
        }
        long invokeId = data.getUInt32();
        settings.setLongInvokeID(invokeId);
        int len = GXCommon.getObjectCount(data);
        byte[] tmp = null;
        if (len != 0) {
            tmp = new byte[len];
            data.get(tmp);
            if (xml == null) {
                DataType dt = DataType.DATETIME;
                if (len == 4) {
                    dt = DataType.TIME;
                } else if (len == 5) {
                    dt = DataType.DATE;
                }
                GXDataInfo info = new GXDataInfo();
                info.setType(dt);
                GXCommon.getData(settings, new GXByteBuffer(tmp), info);
            }
        }
        int cnt = GXCommon.getObjectCount(data);
        if (xml != null) {
            xml.appendStartTag(217);
            xml.appendLine(65320, "Value", xml.integerToHex(invokeId, 8));
            xml.appendLine(65314, "Value", GXCommon.toHex(tmp, false));
            xml.appendStartTag(65329);
            xml.appendStartTag(65330, "Qty", xml.integerToHex(cnt, 2));
        }
        ArrayList<GXDLMSAccessItem> list = new ArrayList<GXDLMSAccessItem>();
        for (int pos = 0; pos != cnt; ++pos) {
            byte type = (byte)data.getUInt8();
            if (type != 1 && type != 2 && type != 3) {
                throw new IllegalArgumentException("Invalid access service command type.");
            }
            int ci = data.getUInt16();
            byte[] ln = new byte[6];
            data.get(ln);
            short attributeIndex = data.getUInt8();
            if (xml != null) {
                xml.appendStartTag(65331);
                xml.appendStartTag(217, type);
                GXDLMSLNCommandHandler.appendAttributeDescriptor(xml, ci, ln, attributeIndex);
                xml.appendEndTag(217, type);
                xml.appendEndTag(65331);
                continue;
            }
            ObjectType ot = ObjectType.forValue(ci);
            GXDLMSObject obj = settings.getObjects().findByLN(ot, GXCommon.toLogicalName(ln));
            if (obj == null) {
                try {
                    obj = server.notifyFindObject(ot, 0, GXCommon.toLogicalName(ln));
                }
                catch (Exception e) {
                    obj = null;
                }
            }
            list.add(new GXDLMSAccessItem(type, obj, attributeIndex));
        }
        if (xml != null) {
            xml.appendEndTag(65330);
            xml.appendStartTag(65332, "Qty", xml.integerToHex(cnt, 2));
        }
        cnt = GXCommon.getObjectCount(data);
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(0);
        GXCommon.setObjectCount(cnt, bb);
        GXByteBuffer results = new GXByteBuffer();
        GXCommon.setObjectCount(cnt, results);
        try {
            for (int pos = 0; pos != cnt; ++pos) {
                GXDataInfo di = new GXDataInfo();
                di.setXml(xml);
                if (xml != null && xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                    xml.appendStartTag(6, (byte)0);
                }
                Object value = GXCommon.getData(settings, data, di);
                if (!di.isComplete()) {
                    value = GXCommon.toHex(data.getData(), false, data.position(), data.size() - data.position());
                } else if (value instanceof byte[]) {
                    value = GXCommon.toHex((byte[])value, false);
                }
                if (xml == null) {
                    GXDLMSAccessItem it = (GXDLMSAccessItem)list.get(pos);
                    results.setUInt8(it.getCommand());
                    if (it.getTarget() == null) {
                        bb.setUInt8(0);
                        results.setUInt8(ErrorCode.UNAVAILABLE_OBJECT.getValue());
                    } else {
                        ValueEventArgs e = new ValueEventArgs(settings, it.getTarget(), it.getIndex(), 0, value);
                        settings.setIndex(0L);
                        if (it.getCommand() == 1) {
                            if ((server.notifyGetAttributeAccess(e) & AccessMode.READ.getValue()) == 0) {
                                results.setUInt8(ErrorCode.READ_WRITE_DENIED.getValue());
                            } else {
                                server.notifyRead(new ValueEventArgs[]{e});
                                value = e.getHandled() ? e.getValue() : it.getTarget().getValue(settings, e);
                                if (e.isByteArray()) {
                                    bb.set((byte[])value);
                                } else {
                                    GXDLMS.appendData(it.getTarget(), it.getIndex(), bb, value);
                                }
                                server.notifyPostRead(new ValueEventArgs[]{e});
                                results.setUInt8(ErrorCode.OK.getValue());
                            }
                        } else if (it.getCommand() == 2) {
                            results.setUInt8(ErrorCode.OK.getValue());
                        } else {
                            results.setUInt8(ErrorCode.OK.getValue());
                        }
                    }
                }
                if (xml == null || xml.getOutputType() != TranslatorOutputType.STANDARD_XML) continue;
                xml.appendEndTag(6, (byte)0);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        if (xml != null) {
            xml.appendEndTag(65332);
            xml.appendEndTag(65329);
            xml.appendEndTag(217);
        } else {
            bb.set(results);
            GXDLMS.getLNPdu(new GXDLMSLNParameters(settings, invokeId, 218, 255, null, bb, 255, cipheredCommand), reply);
        }
    }

    static void handleEventNotification(GXDLMSSettings settings, GXReplyData reply, List<Map.Entry<GXDLMSObject, Integer>> list) {
        reply.setTime(null);
        short len = reply.getData().getUInt8();
        byte[] tmp = null;
        if (len != 0) {
            boolean useUtc = settings != null ? settings.getUseUtc2NormalTime() : false;
            len = reply.getData().getUInt8();
            tmp = new byte[len];
            reply.getData().get(tmp);
            reply.setTime((GXDateTime)GXDLMSClient.changeType(tmp, DataType.DATETIME, useUtc));
        }
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(194);
            if (reply.getTime() != null) {
                reply.getXml().appendComment(String.valueOf(reply.getTime()));
                reply.getXml().appendLine(65367, null, GXCommon.toHex(tmp, false));
            }
        }
        int ci = reply.getData().getUInt16();
        byte[] ln = new byte[6];
        reply.getData().get(ln);
        short index = reply.getData().getUInt8();
        if (reply.getXml() != null) {
            GXDLMSLNCommandHandler.appendAttributeDescriptor(reply.getXml(), ci, ln, index);
            reply.getXml().appendStartTag(65365);
        }
        GXDataInfo di = new GXDataInfo();
        di.setXml(reply.getXml());
        Object value = GXCommon.getData(settings, reply.getData(), di);
        if (reply.getXml() != null) {
            reply.getXml().appendEndTag(65365);
            reply.getXml().appendEndTag(194);
        } else {
            GXDLMSObject obj = settings.getObjects().findByLN(ObjectType.forValue(ci), GXCommon.toLogicalName(ln));
            if (obj != null) {
                ValueEventArgs v = new ValueEventArgs(obj, index, 0, null);
                v.setValue(value);
                obj.setValue(settings, v);
                list.add(new GXSimpleEntry<GXDLMSObject, Integer>(obj, Integer.valueOf(index)));
            } else {
                Logger.getLogger(GXDLMS.class.getName()).log(Level.INFO, "InformationReport message. Unknown object :{0} ", String.valueOf((Object)ObjectType.forValue(ci)) + " " + GXCommon.toLogicalName(ln));
            }
        }
    }
}

