/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXDLMSConnectionEventArgs;
import gurux.dlms.GXDLMSLimits;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXHdlcSettings;
import gurux.dlms.GXICipher;
import gurux.dlms.GXServerReply;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.enums.SourceDiagnostic;
import gurux.dlms.objects.GXDLMSIECLocalPortSetup;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public abstract class GXDLMSServer {
    private final GXDLMSServerBase base;

    public GXDLMSServer(boolean logicalNameReferencing, InterfaceType type) {
        this.base = new GXDLMSServerBase(this, logicalNameReferencing, type);
    }

    public final GXDLMSObjectCollection getItems() {
        return this.base.getItems();
    }

    public final GXDLMSLimits getLimits() {
        return this.base.getLimits();
    }

    public final GXHdlcSettings getHdlcSettings() {
        return this.base.getHdlcSettings();
    }

    public final int getMaxReceivePDUSize() {
        return this.base.getMaxReceivePDUSize();
    }

    public final void setMaxReceivePDUSize(int value) {
        this.base.setMaxReceivePDUSize(value);
    }

    public final boolean getUseLogicalNameReferencing() {
        return this.base.getUseLogicalNameReferencing();
    }

    public final void setUseLogicalNameReferencing(boolean value) {
        this.base.setUseLogicalNameReferencing(value);
    }

    public final GXDLMSSettings getSettings() {
        return this.base.getSettings();
    }

    protected final void setCipher(GXICipher value) {
        this.base.setCipher(value);
    }

    public final void initialize() {
        this.base.initialize();
    }

    public final void reset() {
        this.base.reset(false);
    }

    public final byte[] getCtoSChallenge() {
        return this.base.getCtoSChallenge();
    }

    public final byte[] getStoCChallenge() {
        return this.base.getStoCChallenge();
    }

    public final InterfaceType getInterfaceType() {
        return this.base.getInterfaceType();
    }

    public final Set<Conformance> getConformance() {
        return this.base.getSettings().getNegotiatedConformance();
    }

    public final void setConformance(Set<Conformance> value) {
        this.base.getSettings().setNegotiatedConformance(value);
    }

    public final void setStoCChallenge(byte[] value) {
        this.base.setStoCChallenge(value);
    }

    public final void setStartingPacketIndex(int value) {
        this.base.setStartingPacketIndex(value);
    }

    public final int getInvokeID() {
        return this.base.getInvokeID();
    }

    public final void setInvokeID(int value) {
        this.base.setInvokeID(value);
    }

    public final ServiceClass getServiceClass() {
        return this.base.getServiceClass();
    }

    public final void setServiceClass(ServiceClass value) {
        this.base.setServiceClass(value);
    }

    public final Priority getPriority() {
        return this.base.getPriority();
    }

    public final void setPriority(Priority value) {
        this.base.setPriority(value);
    }

    public byte[] getClientSystemTitle() {
        return this.base.getClientSystemTitle();
    }

    public void setClientSystemTitle(byte[] value) {
        this.base.setClientSystemTitle(value);
    }

    public int getPushClientAddress() {
        return this.base.getPushClientAddress();
    }

    public void setPushClientAddress(int value) {
        this.base.setPushClientAddress(value);
    }

    public String getFlaID() {
        return this.base.getFlaID();
    }

    public void setFlaID(String value) {
        if (value == null || value.length() != 3) {
            throw new IllegalArgumentException("Invalid FLAG ID.");
        }
        this.base.setFlaID(value);
    }

    public GXDLMSIECLocalPortSetup getLocalPortSetup() {
        return this.base.getLocalPortSetup();
    }

    public void setLocalPortSetup(GXDLMSIECLocalPortSetup value) {
        this.base.setLocalPortSetup(value);
    }

    public byte getConnectionState() {
        return this.base.getConnectionState();
    }

    public final byte[] handleRequest(byte[] buff) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.handleRequest(buff, new GXDLMSConnectionEventArgs());
    }

    public final byte[] handleRequest(byte[] buff, GXDLMSConnectionEventArgs connectionInfo) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXServerReply sr = new GXServerReply(buff);
        sr.setConnectionInfo(connectionInfo);
        this.base.handleRequest(sr);
        return sr.getReply();
    }

    protected abstract boolean isTarget(int var1, int var2);

    protected abstract SourceDiagnostic validateAuthentication(Authentication var1, byte[] var2);

    protected abstract GXDLMSObject onFindObject(ObjectType var1, int var2, String var3);

    public abstract void read(ValueEventArgs[] var1);

    protected abstract void write(ValueEventArgs[] var1);

    protected abstract void connected(GXDLMSConnectionEventArgs var1);

    protected abstract void invalidConnection(GXDLMSConnectionEventArgs var1);

    protected abstract void disconnected(GXDLMSConnectionEventArgs var1);

    protected abstract void action(ValueEventArgs[] var1);
}

