/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSConnectionEventArgs;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSLimits;
import gurux.dlms.GXDLMSSNParameters;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXHdlcSettings;
import gurux.dlms.GXICipher;
import gurux.dlms.GXServerReply;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.MethodAccessMode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.enums.SourceDiagnostic;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSAssociationLogicalName;
import gurux.dlms.objects.GXDLMSAssociationShortName;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSHdlcSetup;
import gurux.dlms.objects.GXDLMSIECLocalPortSetup;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import gurux.dlms.objects.GXDLMSPushSetup;
import gurux.dlms.objects.GXDLMSTcpUdpSetup;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public abstract class GXDLMSServer2 {
    private final GXDLMSServerBase base;

    public GXDLMSServer2(boolean logicalNameReferencing, InterfaceType type) {
        this.base = new GXDLMSServerBase(this, true, type);
        this.getSettings().setUseLogicalNameReferencing(logicalNameReferencing);
    }

    public GXDLMSServer2(GXDLMSAssociationLogicalName ln, InterfaceType type) {
        this.base = new GXDLMSServerBase(this, true, type);
        this.base.getItems().add(ln);
    }

    public GXDLMSServer2(GXDLMSAssociationShortName sn, InterfaceType type) {
        this.base = new GXDLMSServerBase(this, false, type);
        this.base.getItems().add(sn);
    }

    public GXDLMSServer2(GXDLMSAssociationLogicalName ln, GXDLMSHdlcSetup hdlc) {
        this.base = new GXDLMSServerBase(this, true, InterfaceType.HDLC);
        this.base.setHdlc(hdlc);
        this.base.getItems().add(ln);
        this.base.getItems().add(hdlc);
    }

    public GXDLMSServer2(GXDLMSAssociationShortName sn, GXDLMSHdlcSetup hdlc) {
        this.base = new GXDLMSServerBase(this, false, InterfaceType.HDLC);
        this.getSettings().setHdlc(hdlc);
        this.base.getItems().add(sn);
        this.base.getItems().add(hdlc);
    }

    public GXDLMSServer2(GXDLMSAssociationLogicalName ln, GXDLMSTcpUdpSetup wrapper) {
        this.base = new GXDLMSServerBase(this, true, InterfaceType.WRAPPER);
        this.getSettings().setWrapper(wrapper);
        this.base.getItems().add(ln);
        this.base.getItems().add(wrapper);
    }

    public GXDLMSServer2(GXDLMSAssociationShortName sn, GXDLMSTcpUdpSetup wrapper) {
        this.base = new GXDLMSServerBase(this, false, InterfaceType.WRAPPER);
        this.getSettings().setWrapper(wrapper);
        this.base.getItems().add(sn);
        this.base.getItems().add(wrapper);
    }

    public int getPushClientAddress() {
        return this.getSettings().getPushClientAddress();
    }

    public void setPushClientAddress(int value) {
        this.getSettings().setPushClientAddress(value);
    }

    public byte getConnectionState() {
        return this.getSettings().getConnected();
    }

    public final GXDLMSObjectCollection getItems() {
        return this.base.getItems();
    }

    public final Authentication getAuthentication() {
        return this.getSettings().getAuthentication();
    }

    public void setHdlc(GXDLMSHdlcSetup value) {
        this.getSettings().setHdlc(value);
    }

    public final GXDLMSHdlcSetup getHdlc() {
        return this.getSettings().getHdlc();
    }

    public void setWrapper(GXDLMSTcpUdpSetup value) {
        this.getSettings().setWrapper(value);
    }

    public final GXDLMSTcpUdpSetup getWrapper() {
        return this.getSettings().getWrapper();
    }

    public final int getWindowSize() {
        return this.getSettings().getGbtWindowSize();
    }

    public final void setWindowSize(int value) {
        this.getSettings().setGbtWindowSize((byte)value);
    }

    @Deprecated
    public final GXDLMSLimits getLimits() {
        return this.base.getLimits();
    }

    public final GXHdlcSettings getHdlcSettings() {
        return this.base.getHdlcSettings();
    }

    public boolean getUseUtc2NormalTime() {
        return this.base.getUseUtc2NormalTime();
    }

    public void setUseUtc2NormalTime(boolean value) {
        this.base.setUseUtc2NormalTime(value);
    }

    public Set<DateTimeSkips> getDateTimeSkips() {
        return this.base.getDateTimeSkips();
    }

    public void setDateTimeSkips(Set<DateTimeSkips> value) {
        this.base.setDateTimeSkips(value);
    }

    public final int getMaxReceivePDUSize() {
        return this.base.getMaxReceivePDUSize();
    }

    public final void setMaxReceivePDUSize(int value) {
        this.base.setMaxReceivePDUSize(value);
    }

    public final boolean getUseLogicalNameReferencing() {
        return this.base.getUseLogicalNameReferencing();
    }

    public final void setUseLogicalNameReferencing(boolean value) {
        this.base.setUseLogicalNameReferencing(value);
    }

    public final GXDLMSSettings getSettings() {
        return this.base.getSettings();
    }

    protected final void setCipher(GXICipher value) {
        this.base.setCipher(value);
    }

    public String getFlaID() {
        return this.base.getFlaID();
    }

    public void setFlaID(String value) {
        if (value == null || value.length() != 3) {
            throw new IllegalArgumentException("Invalid FLAG ID.");
        }
        this.base.setFlaID(value);
    }

    public GXDLMSIECLocalPortSetup getLocalPortSetup() {
        return this.base.getLocalPortSetup();
    }

    public void setLocalPortSetup(GXDLMSIECLocalPortSetup value) {
        this.base.setLocalPortSetup(value);
    }

    public final void initialize() {
        this.base.initialize();
    }

    public void updateShortNames() {
        this.base.updateShortNames(true);
    }

    public void close() throws Exception {
        this.base.close();
    }

    public final void reset() {
        this.base.reset(false);
    }

    public final byte[] getCtoSChallenge() {
        return this.base.getCtoSChallenge();
    }

    public final byte[] getStoCChallenge() {
        return this.base.getStoCChallenge();
    }

    public final InterfaceType getInterfaceType() {
        return this.base.getInterfaceType();
    }

    public final Set<Conformance> getConformance() {
        return this.base.getSettings().getProposedConformance();
    }

    public final void setConformance(Set<Conformance> value) {
        this.base.getSettings().setProposedConformance(value);
    }

    public final void setStoCChallenge(byte[] value) {
        this.base.setStoCChallenge(value);
    }

    public final void setStartingPacketIndex(int value) {
        this.base.setStartingPacketIndex(value);
    }

    public final int getInvokeID() {
        return this.base.getInvokeID();
    }

    public final void setInvokeID(int value) {
        this.base.setInvokeID(value);
    }

    public final ServiceClass getServiceClass() {
        return this.base.getServiceClass();
    }

    public final void setServiceClass(ServiceClass value) {
        this.base.setServiceClass(value);
    }

    public final Priority getPriority() {
        return this.base.getPriority();
    }

    public final void setPriority(Priority value) {
        this.base.setPriority(value);
    }

    public final void setAssignedAssociation(GXDLMSAssociationLogicalName value) {
        this.base.setAssignedAssociation(value);
    }

    public final GXDLMSAssociationLogicalName getAssignedAssociation() {
        return this.base.getAssignedAssociation();
    }

    public final byte[] handleRequest(byte[] buff) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.handleRequest(buff, new GXDLMSConnectionEventArgs());
    }

    public final byte[] handleRequest(byte[] buff, GXDLMSConnectionEventArgs connectionInfo) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXServerReply sr = new GXServerReply(buff);
        sr.setConnectionInfo(connectionInfo);
        this.base.handleRequest(sr);
        return sr.getReply();
    }

    public final void handleRequest(GXServerReply sr) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        this.base.handleRequest(sr);
    }

    protected abstract boolean isTarget(int var1, int var2) throws Exception;

    protected abstract SourceDiagnostic onValidateAuthentication(Authentication var1, byte[] var2) throws Exception;

    public abstract void onPreGet(ValueEventArgs[] var1) throws Exception;

    public abstract void onPostGet(ValueEventArgs[] var1) throws Exception;

    protected abstract GXDLMSObject onFindObject(ObjectType var1, int var2, String var3) throws Exception;

    public abstract void onPreRead(ValueEventArgs[] var1) throws Exception;

    public abstract void onPostRead(ValueEventArgs[] var1) throws Exception;

    protected abstract void onPreWrite(ValueEventArgs[] var1) throws Exception;

    protected abstract void onPostWrite(ValueEventArgs[] var1) throws Exception;

    protected abstract void onConnected(GXDLMSConnectionEventArgs var1) throws Exception;

    protected abstract void onInvalidConnection(GXDLMSConnectionEventArgs var1) throws Exception;

    protected abstract void onDisconnected(GXDLMSConnectionEventArgs var1) throws Exception;

    protected abstract AccessMode onGetAttributeAccess(ValueEventArgs var1) throws Exception;

    protected abstract MethodAccessMode onGetMethodAccess(ValueEventArgs var1) throws Exception;

    protected abstract void onPreAction(ValueEventArgs[] var1) throws Exception;

    protected abstract void onPostAction(ValueEventArgs[] var1) throws Exception;

    public final void addData(GXDLMSObject obj, int index, GXByteBuffer buff) {
        ValueEventArgs e = new ValueEventArgs(obj, index, 0, null);
        Object value = obj.getValue(this.getSettings(), e);
        DataType dt = obj.getDataType(index);
        if (dt == DataType.NONE && value != null) {
            dt = GXDLMSConverter.getDLMSDataType(value);
        }
        GXCommon.setData(this.base.getSettings(), buff, dt, value);
    }

    public final byte[][] generateDataNotificationMessages(Date time, GXByteBuffer data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (this.getUseLogicalNameReferencing()) {
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.getSettings(), 0L, 15, 0, null, data, 255, 0);
            if (time == null) {
                p.setTime(null);
            } else {
                p.setTime(new GXDateTime(time));
            }
            reply = GXDLMS.getLnMessages(p);
        } else {
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.getSettings(), 15, 1, 0, data, null);
            reply = GXDLMS.getSnMessages(p);
        }
        if (!this.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER) && reply.size() != 1) {
            throw new IllegalArgumentException("Data is not fit to one PDU. Use general block transfer.");
        }
        return (byte[][])reply.toArray((T[])new byte[0][0]);
    }

    public final byte[][] generatePushSetupMessages(Date date, GXDLMSPushSetup push) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (push == null) {
            throw new IllegalArgumentException("push");
        }
        GXByteBuffer buff = new GXByteBuffer();
        buff.setUInt8((byte)DataType.STRUCTURE.getValue());
        GXCommon.setObjectCount(push.getPushObjectList().size(), buff);
        for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : push.getPushObjectList()) {
            this.addData(it.getKey(), it.getValue().getAttributeIndex(), buff);
        }
        return this.generateDataNotificationMessages(date, buff);
    }

    public byte[] getClientSystemTitle() {
        return this.getSettings().getPreEstablishedSystemTitle();
    }

    public void setClientSystemTitle(byte[] value) {
        this.getSettings().setPreEstablishedSystemTitle(value);
    }

    public boolean isChangedWithAction(ObjectType objectType, int methodIndex) {
        if (objectType == ObjectType.ASSOCIATION_LOGICAL_NAME && methodIndex != 1 || objectType == ObjectType.SECURITY_SETUP && (methodIndex == 1 || methodIndex == 4 || methodIndex == 6 || methodIndex == 7 || methodIndex == 8)) {
            return true;
        }
        return objectType == ObjectType.SAP_ASSIGNMENT || objectType == ObjectType.DISCONNECT_CONTROL || objectType == ObjectType.SPECIAL_DAYS_TABLE || objectType == ObjectType.REGISTER_ACTIVATION;
    }
}

