/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.enums.DataType;
import gurux.dlms.enums.TranslatorOutputType;
import gurux.dlms.internal.GXCommon;
import java.util.HashMap;

public class GXDLMSTranslatorStructure {
    int commentsIndex = 0;
    private StringBuilder sb = new StringBuilder();
    private HashMap<Integer, String> tags;
    private final TranslatorOutputType outputType;
    private boolean showNumericsAsHex;
    private boolean omitNameSpace;
    private boolean showStringAsHex;
    private int offset;
    private boolean comments;

    public final TranslatorOutputType getOutputType() {
        return this.outputType;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("offset");
        }
        this.offset = value;
    }

    public final boolean getShowStringAsHex() {
        return this.showStringAsHex;
    }

    final void setShowStringAsHex(boolean value) {
        this.showStringAsHex = value;
    }

    GXDLMSTranslatorStructure(TranslatorOutputType type, boolean omitNS, boolean numericAshex, boolean hex, boolean addComments, HashMap<Integer, String> list) {
        this.outputType = type;
        this.omitNameSpace = omitNS;
        this.showNumericsAsHex = numericAshex;
        this.setShowStringAsHex(hex);
        this.tags = list;
        this.comments = addComments;
    }

    public final String toString() {
        return this.sb.toString();
    }

    public final String getDataType(DataType type) {
        return this.getTag(0xFF0000 + type.getValue());
    }

    private static void appendSpaces(StringBuilder sb, int count) {
        for (int pos = 0; pos != count; ++pos) {
            sb.append(' ');
        }
    }

    private String getTag(int tag) {
        String tmp = this.tags.get(tag);
        if (this.getOutputType() == TranslatorOutputType.SIMPLE_XML || this.omitNameSpace) {
            return tmp;
        }
        return "x:" + tmp;
    }

    public final void appendLine(String str) {
        GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
        this.sb.append(str);
        this.sb.append('\r');
        this.sb.append('\n');
    }

    public final void appendLine(int tag, String name, String value) {
        String tmp = this.getTag(tag);
        if (tmp == null) {
            throw new IllegalArgumentException("Tag");
        }
        this.appendLine(tmp, name, value);
    }

    public final void appendLine(String tag, String name, String value) {
        GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
        this.sb.append('<');
        this.sb.append(tag);
        if (this.outputType == TranslatorOutputType.SIMPLE_XML) {
            this.sb.append(' ');
            if (name == null) {
                this.sb.append("Value");
            } else {
                this.sb.append(name);
            }
            this.sb.append("=\"");
        } else {
            this.sb.append('>');
        }
        this.sb.append(value);
        if (this.outputType == TranslatorOutputType.SIMPLE_XML) {
            this.sb.append("\" />");
        } else {
            this.sb.append("</");
            this.sb.append(tag);
            this.sb.append('>');
        }
        this.sb.append('\r');
        this.sb.append('\n');
    }

    public final void appendComment(String comment) {
        if (this.comments) {
            GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
            if (this.commentsIndex == 0) {
                this.sb.append("<!-- ");
                this.sb.append(comment);
                this.sb.append(" -->");
            } else {
                this.sb.append("# ");
                this.sb.append(comment);
            }
            this.sb.append('\r');
            this.sb.append('\n');
        }
    }

    public void startComment(String comment) {
        if (this.comments) {
            GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
            if (this.commentsIndex == 0) {
                this.sb.append("<!-- ");
            } else {
                this.sb.append("# ");
            }
            ++this.commentsIndex;
            this.sb.append(comment);
            this.sb.append('\r');
            this.sb.append('\n');
            ++this.offset;
        }
    }

    public final void endComment() {
        if (this.comments) {
            --this.offset;
            --this.commentsIndex;
            if (this.commentsIndex == 0) {
                GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
                this.sb.append("-->");
            }
            this.sb.append('\r');
            this.sb.append('\n');
        }
    }

    public final void append(String value) {
        this.sb.append(value);
    }

    public final void append(int tag, boolean start) {
        if (start) {
            GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
            this.sb.append('<');
        } else {
            this.sb.append("</");
        }
        this.sb.append(this.getTag(tag));
        this.sb.append('>');
    }

    public final void appendStartTag(int tag, String name, String value) {
        this.appendStartTag(this.getTag(tag), name, value);
    }

    public final void appendStartTag(String tag, String name, String value) {
        GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
        this.sb.append('<');
        this.sb.append(tag);
        if (this.outputType == TranslatorOutputType.SIMPLE_XML && name != null) {
            this.sb.append(' ');
            this.sb.append(name);
            this.sb.append("=\"");
            this.sb.append(value);
            this.sb.append("\" >");
        } else {
            this.sb.append('>');
        }
        this.sb.append('\r');
        this.sb.append('\n');
        ++this.offset;
    }

    public final void appendStartTag(int tag) {
        this.appendStartTag(tag, false);
    }

    public final void appendStartTag(int tag, boolean plain) {
        String tmp = this.getTag(tag);
        if (tmp == null) {
            throw new IllegalArgumentException("appendStartTag");
        }
        GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
        this.sb.append("<");
        this.sb.append(tmp);
        this.sb.append('>');
        if (!plain) {
            this.sb.append('\r');
            this.sb.append('\n');
        }
        ++this.offset;
    }

    public final void appendStartTag(int cmd, byte type) {
        this.appendStartTag(cmd << 8 | type);
    }

    public final void appendEndTag(int cmd, byte type) {
        this.appendEndTag(cmd << 8 | type);
    }

    public final void appendEndTag(int tag, boolean plain) {
        this.appendEndTag(this.getTag(tag), plain);
    }

    public final void appendEndTag(int tag) {
        this.appendEndTag(this.getTag(tag));
    }

    public final void appendEndTag(String tag) {
        this.appendEndTag(tag, false);
    }

    public final void appendEndTag(String tag, boolean plain) {
        this.setOffset(this.getOffset() - 1);
        if (!plain) {
            GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
        }
        this.sb.append("</");
        this.sb.append(tag);
        this.sb.append('>');
        this.sb.append('\r');
        this.sb.append('\n');
    }

    public final void appendEmptyTag(int tag) {
        this.appendEmptyTag(this.getTag(tag));
    }

    public final void appendEmptyTag(String tag) {
        GXDLMSTranslatorStructure.appendSpaces(this.sb, 2 * this.offset);
        this.sb.append("<");
        this.sb.append(tag);
        this.sb.append('/');
        this.sb.append('>');
        this.sb.append('\r');
        this.sb.append('\n');
    }

    public final void trim() {
        this.sb.setLength(this.sb.length() - 2);
    }

    public final int getXmlLength() {
        return this.sb.length();
    }

    public final void setXmlLength(int value) {
        this.sb.setLength(value);
    }

    public final String integerToHex(long value, int desimals) {
        return this.integerToHex(value, desimals, false);
    }

    public final String integerToHex(long value, int desimals, boolean forceHex) {
        if (forceHex || this.showNumericsAsHex && this.outputType == TranslatorOutputType.SIMPLE_XML) {
            return GXCommon.integerToHex(value, desimals);
        }
        return String.valueOf(value);
    }

    public final String integerToHex(Object value, int desimals) {
        if (this.showNumericsAsHex && this.outputType == TranslatorOutputType.SIMPLE_XML) {
            return GXCommon.integerToHex(value, desimals);
        }
        return String.valueOf(value);
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean value) {
        this.comments = value;
    }
}

