/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.internal.GXCommon;

public class GXAsn1BitString {
    private int padBits;
    private byte[] value;

    public final int getPadBits() {
        return this.padBits;
    }

    public final byte[] getValue() {
        return this.value;
    }

    public final int length() {
        if (this.value == null) {
            return 0;
        }
        return 8 * this.value.length - this.padBits;
    }

    public GXAsn1BitString() {
    }

    public GXAsn1BitString(String bitString) {
        this.padBits = 8 - bitString.length() % 8;
        if (this.padBits == 8) {
            this.padBits = 0;
        }
        StringBuilder sb = new StringBuilder(bitString);
        GXAsn1BitString.appendZeros(sb, this.padBits);
        this.value = new byte[sb.length() / 8];
        for (int pos = 0; pos != this.value.length; ++pos) {
            this.value[pos] = (byte)Integer.parseInt(sb.substring(8 * pos, 8 * (pos + 1)), 2);
        }
    }

    public GXAsn1BitString(byte[] str, int padCount) {
        if (str == null) {
            throw new IllegalArgumentException("data");
        }
        if (this.padBits < 0 || this.padBits > 7) {
            throw new IllegalArgumentException("PadCount must be in the range 0 to 7");
        }
        this.value = str;
        this.padBits = padCount;
    }

    public GXAsn1BitString(byte[] str) {
        if (str == null) {
            throw new IllegalArgumentException("data");
        }
        this.padBits = str[0];
        if (this.padBits < 0 || this.padBits > 7) {
            throw new IllegalArgumentException("PadCount must be in the range 0 to 7");
        }
        this.value = new byte[str.length - 1];
        System.arraycopy(str, 1, this.value, 0, str.length - 1);
    }

    private static void appendZeros(StringBuilder sb, int count) {
        for (int pos = 0; pos != count; ++pos) {
            sb.append('0');
        }
    }

    public final String toString() {
        if (this.value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(8 * this.value.length);
        for (byte it : this.value) {
            GXCommon.toBitString(sb, it, 8);
        }
        sb.setLength(sb.length() - this.padBits);
        return String.valueOf(8 * this.value.length - this.padBits) + " bit " + sb.toString();
    }

    public final String asString() {
        if (this.value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(8 * this.value.length);
        for (byte it : this.value) {
            GXCommon.toBitString(sb, it, 8);
        }
        sb.setLength(sb.length() - this.padBits);
        return sb.toString();
    }

    public int toInteger() {
        int ret = 0;
        if (this.value != null) {
            int bytePos = 0;
            for (byte it : this.value) {
                ret |= GXCommon.swapBits(it) << bytePos;
                bytePos += 8;
            }
        }
        return ret;
    }
}

