/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.asn.GXAsn1BitString;
import gurux.dlms.asn.GXAsn1Context;
import gurux.dlms.asn.GXAsn1Ia5String;
import gurux.dlms.asn.GXAsn1Integer;
import gurux.dlms.asn.GXAsn1ObjectIdentifier;
import gurux.dlms.asn.GXAsn1PublicKey;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.asn.GXAsn1Settings;
import gurux.dlms.asn.GXAsn1Utf8String;
import gurux.dlms.asn.GXPkcs10;
import gurux.dlms.asn.GXPkcs8;
import gurux.dlms.asn.GXx509Certificate;
import gurux.dlms.asn.enums.Ecc;
import gurux.dlms.asn.enums.KeyUsage;
import gurux.dlms.asn.enums.PkcsType;
import gurux.dlms.asn.enums.X509Name;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.enums.CertificateType;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class GXAsn1Converter {
    private static byte[] p256Head = GXCommon.fromBase64("MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE");
    private static byte[] p384Head = GXCommon.hexToBytes("30 76 30 10 06 07 2A 86 48 CE 3D 02 0106 05 2B 81 04 00 22 03 62 00 04");

    private GXAsn1Converter() {
    }

    public static Path getFilePath(Ecc scheme, CertificateType certificateType, byte[] systemTitle) {
        Path path;
        switch (certificateType) {
            case DIGITAL_SIGNATURE: {
                path = Paths.get("D", new String[0]);
                break;
            }
            case KEY_AGREEMENT: {
                path = Paths.get("A", new String[0]);
                break;
            }
            case TLS: {
                path = Paths.get("T", new String[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown certificate type.");
            }
        }
        path = Paths.get(path.toString() + GXDLMSTranslator.toHex(systemTitle, false) + ".pem", new String[0]);
        path = scheme == Ecc.P256 ? Paths.get("Keys", path.toString()) : Paths.get("Keys384", path.toString());
        return path;
    }

    public static PrivateKey getPrivateKey(byte[] value) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (value != null && (value.length == 32 || value.length == 48)) {
            byte[] privKeyBytes = value.length == 32 ? GXCommon.hexToBytes("3041020100301306072A8648CE3D020106082A8648CE3D030107 042730250201010420") : GXCommon.hexToBytes("304E020100301006072A8648CE3D020106052B81040022 043730350201010430");
            byte[] key = new byte[privKeyBytes.length + value.length];
            System.arraycopy(privKeyBytes, 0, key, 0, privKeyBytes.length);
            System.arraycopy(value, 0, key, privKeyBytes.length, value.length);
            PKCS8EncodedKeySpec priv = new PKCS8EncodedKeySpec(key);
            KeyFactory kf = KeyFactory.getInstance("EC");
            return kf.generatePrivate(priv);
        }
        throw new IllegalArgumentException("Invalid private key.");
    }

    public static PublicKey getPublicKey(byte[] value) {
        if (value != null && (value.length == 64 || value.length == 96)) {
            KeyFactory eckf;
            byte[] head = value.length == 64 ? p256Head : p384Head;
            byte[] encodedKey = new byte[head.length + value.length];
            System.arraycopy(head, 0, encodedKey, 0, head.length);
            System.arraycopy(value, 0, encodedKey, head.length, value.length);
            try {
                eckf = KeyFactory.getInstance("EC");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("EC key factory not present in runtime");
            }
            try {
                X509EncodedKeySpec ecpks = new X509EncodedKeySpec(encodedKey);
                return eckf.generatePublic(ecpks);
            }
            catch (InvalidKeySpecException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        throw new IllegalArgumentException("Invalid public key.");
    }

    public static byte[] rawValue(PublicKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid public key.");
        }
        GXAsn1BitString tmp = (GXAsn1BitString)((GXAsn1Sequence)GXAsn1Converter.fromByteArray(key.getEncoded())).get(1);
        GXByteBuffer bb = new GXByteBuffer();
        if (key.getEncoded().length == 91) {
            bb.set(tmp.getValue(), 1, 64);
        } else if (key.getEncoded().length == 120) {
            bb.set(tmp.getValue(), 1, 96);
        } else {
            throw new IllegalArgumentException("Invalid public key.");
        }
        return bb.array();
    }

    public static byte[] rawValue(PrivateKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid private key.");
        }
        byte[] tmp = (byte[])((GXAsn1Sequence)((GXAsn1Sequence)GXAsn1Converter.fromByteArray(key.getEncoded())).get(2)).get(1);
        GXByteBuffer bb = new GXByteBuffer();
        bb.set(tmp);
        return bb.array();
    }

    static List<GXSimpleEntry<Object, Object>> encodeSubject(String value) {
        ArrayList<GXSimpleEntry<Object, Object>> list = new ArrayList<GXSimpleEntry<Object, Object>>();
        for (String tmp : value.split("[,]")) {
            Object val;
            String[] it = tmp.split("[=]");
            if (it.length != 2) {
                throw new IllegalArgumentException("Invalid subject.");
            }
            X509Name name = X509Name.valueOf(it[0].trim());
            switch (name) {
                case C: {
                    val = it[1].trim();
                    break;
                }
                case E: {
                    val = new GXAsn1Ia5String(it[1].trim());
                    break;
                }
                default: {
                    val = new GXAsn1Utf8String(it[1].trim());
                }
            }
            String oid = name.getValue();
            list.add(new GXSimpleEntry<GXAsn1ObjectIdentifier, Object>(new GXAsn1ObjectIdentifier(oid), val));
        }
        return list;
    }

    public static String getSubject(GXAsn1Sequence values) {
        StringBuilder sb = new StringBuilder();
        for (Object tmp : values) {
            Map.Entry it = (Map.Entry)tmp;
            sb.append((Object)X509Name.forValue(it.getKey().toString()));
            sb.append('=');
            Object value = it.getValue();
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() != 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private static void getValue(GXByteBuffer bb, List<Object> objects, GXAsn1Settings s, boolean getNext) {
        ArrayList tmp = null;
        short type = bb.getUInt8();
        int len = GXCommon.getObjectCount(bb);
        if (len > bb.size() - bb.position()) {
            throw new IllegalArgumentException("Not enought memory.");
        }
        int connectPos = 0;
        if (s != null) {
            connectPos = s.getXmlLength();
        }
        int start = bb.position();
        String tagString = null;
        if (s != null) {
            s.appendSpaces();
            tagString = type == 2 ? (len == 1 || len == 2 || len == 4 || len == 8 ? s.getTag((short)(-len)) : s.getTag((short)2)) : s.getTag(type);
            s.append("<" + tagString + ">");
        }
        block0 : switch (type) {
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                if (s != null) {
                    s.increase();
                }
                tmp = new GXAsn1Context();
                ((GXAsn1Context)tmp).setIndex(type & 0xF);
                objects.add(tmp);
                while (bb.position() < start + len) {
                    GXAsn1Converter.getValue(bb, tmp, s, false);
                }
                if (s == null) break;
                s.decrease();
                break;
            }
            case 48: {
                if (s != null) {
                    s.increase();
                }
                tmp = new GXAsn1Sequence();
                objects.add(tmp);
                int cnt = 0;
                while (bb.position() < start + len) {
                    ++cnt;
                    GXAsn1Converter.getValue(bb, tmp, s, false);
                    if (!getNext) continue;
                }
                if (s == null) break;
                s.appendComment(connectPos, String.valueOf(cnt) + " elements.");
                s.decrease();
                break;
            }
            case 49: {
                if (s != null) {
                    s.increase();
                }
                tmp = new ArrayList();
                GXAsn1Converter.getValue(bb, tmp, s, false);
                if (tmp.get(0) instanceof GXAsn1Sequence) {
                    tmp = (GXAsn1Sequence)tmp.get(0);
                    objects.add(new GXSimpleEntry(tmp.get(0), tmp.get(1)));
                } else {
                    GXSimpleEntry<ArrayList, Object> e = new GXSimpleEntry<ArrayList, Object>(tmp, null);
                    objects.add(e);
                }
                if (s == null) break;
                s.decrease();
                break;
            }
            case 6: 
            case 134: {
                GXAsn1ObjectIdentifier oi = new GXAsn1ObjectIdentifier(bb, len);
                objects.add(oi);
                if (s == null) break;
                String str = oi.getDescription();
                if (str != null) {
                    s.appendComment(connectPos, str);
                }
                s.append(oi.toString());
                break;
            }
            case 19: {
                objects.add(bb.getString(len));
                if (s == null) break;
                s.append(String.valueOf(objects.get(objects.size() - 1)));
                break;
            }
            case 12: {
                objects.add(new GXAsn1Utf8String(bb.getString(bb.position(), len, "UTF-8")));
                bb.position(bb.position() + len);
                if (s == null) break;
                s.append(String.valueOf(objects.get(objects.size() - 1)));
                break;
            }
            case 22: {
                objects.add(new GXAsn1Ia5String(bb.getString(len)));
                if (s == null) break;
                s.append(String.valueOf(objects.get(objects.size() - 1)));
                break;
            }
            case 2: {
                if (len == 1) {
                    objects.add(bb.getInt8());
                } else if (len == 2) {
                    objects.add(bb.getInt16());
                } else if (len == 4) {
                    objects.add(bb.getInt32());
                } else {
                    byte[] tmp2 = new byte[len];
                    bb.get(tmp2);
                    objects.add(new GXAsn1Integer(tmp2));
                }
                if (s == null) break;
                s.append(String.valueOf(objects.get(objects.size() - 1)));
                break;
            }
            case 5: {
                objects.add(null);
                break;
            }
            case 3: {
                GXAsn1BitString tmp3 = new GXAsn1BitString(bb.subArray(bb.position(), len));
                objects.add(tmp3);
                bb.position(bb.position() + len);
                if (s == null) break;
                s.appendComment(connectPos, String.valueOf(tmp3.length()) + " bit.");
                s.append(tmp3.asString());
                break;
            }
            case 23: {
                byte[] tmp2 = new byte[len];
                bb.get(tmp2);
                objects.add(GXAsn1Converter.getUtcTime(new String(tmp2)));
                if (s == null) break;
                SimpleDateFormat f = new SimpleDateFormat();
                s.append(f.format(objects.get(objects.size() - 1)));
                break;
            }
            case 24: {
                byte[] tmp2 = new byte[len];
                bb.get(tmp2);
                objects.add(GXCommon.getGeneralizedTime(new String(tmp2)));
                if (s == null) break;
                s.append(String.valueOf(objects.get(objects.size() - 1)));
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                tmp = new GXAsn1Context();
                ((GXAsn1Context)tmp).setConstructed(false);
                ((GXAsn1Context)tmp).setIndex(type & 0xF);
                byte[] tmp2 = new byte[len];
                bb.get(tmp2);
                tmp.add(tmp2);
                objects.add(tmp);
                if (s == null) break;
                s.append(GXCommon.toHex(tmp2));
                break;
            }
            case 4: {
                short t = bb.getUInt8(bb.position());
                switch (t) {
                    case 3: 
                    case 48: {
                        if (s != null) {
                            s.increase();
                        }
                        GXAsn1Converter.getValue(bb, objects, s, false);
                        if (s == null) break block0;
                        s.decrease();
                        break;
                    }
                    default: {
                        byte[] tmp2 = new byte[len];
                        bb.get(tmp2);
                        objects.add(tmp2);
                        if (s == null) break block0;
                        s.append(GXCommon.toHex(tmp2));
                        break;
                    }
                }
                break;
            }
            case 1: {
                boolean b = bb.getUInt8() != 0;
                objects.add(b);
                if (s == null) break;
                s.append(String.valueOf(b));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
        }
        if (s != null) {
            s.append("</" + tagString + ">\r\n");
        }
    }

    private static Date getUtcTime(String dateString) {
        Calendar calendar;
        int second = 0;
        int year = 2000 + Integer.parseInt(dateString.substring(0, 2));
        int month = Integer.parseInt(dateString.substring(2, 4)) - 1;
        int day = Integer.parseInt(dateString.substring(4, 6));
        int hour = Integer.parseInt(dateString.substring(6, 8));
        int minute = Integer.parseInt(dateString.substring(8, 10));
        if (dateString.endsWith("Z")) {
            if (dateString.length() > 11) {
                second = Integer.parseInt(dateString.substring(10, 12));
            }
            calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        } else {
            if (dateString.length() > 15) {
                second = Integer.parseInt(dateString.substring(10, 12));
            }
            calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT" + dateString.substring(dateString.length() - 6, dateString.length() - 1)));
        }
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTime();
    }

    private static String dateToString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        long v = calendar.getTimeInMillis();
        calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(v);
        StringBuilder sb = new StringBuilder();
        sb.append(GXCommon.integerString(calendar.get(1) - 2000, 2));
        sb.append(GXCommon.integerString(1 + calendar.get(2), 2));
        sb.append(GXCommon.integerString(calendar.get(5), 2));
        sb.append(GXCommon.integerString(calendar.get(11), 2));
        sb.append(GXCommon.integerString(calendar.get(12), 2));
        sb.append(GXCommon.integerString(calendar.get(13), 2));
        sb.append("Z");
        return sb.toString();
    }

    public static Object fromByteArray(byte[] data) {
        GXByteBuffer bb = new GXByteBuffer(data);
        ArrayList<Object> objects = new ArrayList<Object>();
        while (bb.position() != bb.size()) {
            GXAsn1Converter.getValue(bb, objects, null, false);
        }
        return objects.get(0);
    }

    public static Object getNext(GXByteBuffer data) {
        ArrayList<Object> objects = new ArrayList<Object>();
        GXAsn1Converter.getValue(data, objects, null, true);
        return objects.get(0);
    }

    private static int getBytes(GXByteBuffer bb, Object target) {
        int start = bb.size();
        int cnt = 0;
        if (target instanceof GXAsn1Context) {
            GXAsn1Context a = (GXAsn1Context)target;
            GXByteBuffer tmp = new GXByteBuffer();
            for (Object it : a) {
                cnt += GXAsn1Converter.getBytes(tmp, it);
            }
            start = bb.size();
            if (a.isConstructed()) {
                bb.setUInt8(0xA0 | a.getIndex());
                GXCommon.setObjectCount(cnt, bb);
            } else {
                tmp.setUInt8(0, 0x80 | a.getIndex());
            }
            bb.set(tmp);
            return cnt += bb.size() - start;
        }
        if (target instanceof Object[]) {
            GXByteBuffer tmp = new GXByteBuffer();
            for (Object it : (Object[])target) {
                cnt += GXAsn1Converter.getBytes(tmp, it);
            }
            start = bb.size();
            bb.setUInt8(48);
            GXCommon.setObjectCount(cnt, bb);
            bb.set(tmp);
            return cnt += bb.size() - start;
        }
        if (target instanceof GXAsn1Sequence || target instanceof List) {
            GXByteBuffer tmp = new GXByteBuffer();
            for (Object it : (List)target) {
                cnt += GXAsn1Converter.getBytes(tmp, it);
            }
            start = bb.size();
            if (target instanceof GXAsn1Context) {
                GXAsn1Context c = (GXAsn1Context)target;
                if (c.isConstructed()) {
                    bb.setUInt8(0x30 | c.getIndex());
                } else {
                    bb.setUInt8(0x10 | c.getIndex());
                }
            } else {
                bb.setUInt8(48);
            }
            GXCommon.setObjectCount(cnt, bb);
            bb.set(tmp);
            return cnt += bb.size() - start;
        }
        if (target instanceof String) {
            bb.setUInt8(19);
            GXCommon.setObjectCount(((String)target).length(), bb);
            bb.add(target);
        } else if (target instanceof Byte) {
            bb.setUInt8(2);
            GXCommon.setObjectCount(1, bb);
            bb.add(target);
        } else if (target instanceof Short) {
            bb.setUInt8(2);
            GXCommon.setObjectCount(2, bb);
            bb.add(target);
        } else if (target instanceof Integer) {
            bb.setUInt8(2);
            GXCommon.setObjectCount(4, bb);
            bb.add(target);
        } else if (target instanceof GXAsn1Integer) {
            bb.setUInt8(2);
            byte[] b = ((GXAsn1Integer)target).getByteArray();
            GXCommon.setObjectCount(b.length, bb);
            bb.set(b);
        } else if (target instanceof Long) {
            bb.setUInt8(2);
            GXCommon.setObjectCount(8, bb);
            bb.add(target);
        } else if (target instanceof byte[]) {
            bb.setUInt8(4);
            GXCommon.setObjectCount(((byte[])target).length, bb);
            bb.add(target);
        } else if (target == null) {
            bb.setUInt8(5);
            GXCommon.setObjectCount(0, bb);
        } else if (target instanceof Boolean) {
            bb.setUInt8(1);
            bb.setUInt8(1);
            if (((Boolean)target).booleanValue()) {
                bb.setUInt8(255);
            } else {
                bb.setUInt8(0);
            }
        } else if (target instanceof GXAsn1ObjectIdentifier) {
            bb.setUInt8(6);
            byte[] t = ((GXAsn1ObjectIdentifier)target).getEncoded();
            GXCommon.setObjectCount(t.length, bb);
            bb.add(t);
        } else {
            if (target instanceof Map.Entry) {
                GXByteBuffer tmp;
                Map.Entry e = (Map.Entry)target;
                GXByteBuffer tmp2 = new GXByteBuffer();
                if (e.getValue() != null) {
                    tmp = new GXByteBuffer();
                    cnt += GXAsn1Converter.getBytes(tmp2, e.getKey());
                    tmp.setUInt8(48);
                    GXCommon.setObjectCount(cnt += GXAsn1Converter.getBytes(tmp2, e.getValue()), tmp);
                    tmp.set(tmp2);
                } else {
                    GXAsn1Converter.getBytes(tmp2, ((List)e.getKey()).get(0));
                    tmp = tmp2;
                }
                cnt = bb.size();
                bb.setUInt8(49);
                GXCommon.setObjectCount(tmp.size(), bb);
                bb.set(tmp);
                return bb.size() - cnt;
            }
            if (target instanceof GXAsn1Utf8String) {
                bb.setUInt8(12);
                String str = target.toString();
                GXCommon.setObjectCount(str.length(), bb);
                bb.add(str);
            } else if (target instanceof GXAsn1Ia5String) {
                bb.setUInt8(22);
                String str = target.toString();
                GXCommon.setObjectCount(str.length(), bb);
                bb.add(str);
            } else if (target instanceof GXAsn1BitString) {
                GXAsn1BitString bs = (GXAsn1BitString)target;
                bb.setUInt8(3);
                GXCommon.setObjectCount(1 + bs.getValue().length, bb);
                bb.setUInt8(bs.getPadBits());
                bb.add(bs.getValue());
            } else {
                if (target instanceof GXAsn1PublicKey) {
                    GXAsn1PublicKey bs = (GXAsn1PublicKey)target;
                    bb.setUInt8(3);
                    GXCommon.setObjectCount(66, bb);
                    bb.setUInt8(0);
                    bb.setUInt8(4);
                    bb.add(bs.getValue());
                    return 68;
                }
                if (target instanceof Date) {
                    bb.setUInt8(23);
                    String str = GXAsn1Converter.dateToString((Date)target);
                    bb.setUInt8(str.length());
                    bb.add(str);
                } else {
                    throw new IllegalArgumentException("Invalid type: " + target.getClass().toString());
                }
            }
        }
        return bb.size() - start;
    }

    public static byte[] toByteArray(Object objects) {
        GXByteBuffer bb = new GXByteBuffer();
        GXAsn1Converter.getBytes(bb, objects);
        return bb.array();
    }

    public static String pduToXml(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        if (!GXCommon.isHexString(value)) {
            return GXAsn1Converter.pduToXml(GXCommon.fromBase64(value));
        }
        return GXAsn1Converter.pduToXml(new GXByteBuffer(GXCommon.hexToBytes(value)));
    }

    public static String pduToXml(byte[] value) {
        return GXAsn1Converter.pduToXml(new GXByteBuffer(value), false);
    }

    public static String pduToXml(byte[] value, boolean comments) {
        return GXAsn1Converter.pduToXml(new GXByteBuffer(value), comments);
    }

    public static String pduToXml(GXByteBuffer value) {
        return GXAsn1Converter.pduToXml(value, false);
    }

    public static String pduToXml(GXByteBuffer value, boolean comments) {
        GXAsn1Settings s = new GXAsn1Settings();
        s.setComments(comments);
        ArrayList<Object> objects = new ArrayList<Object>();
        while (value.position() != value.size()) {
            GXAsn1Converter.getValue(value, objects, s, false);
        }
        return s.toString();
    }

    private static int readNode(Node node, GXAsn1Settings s, List<Object> list) {
        String str = node.getNodeName().toLowerCase();
        short tag = s.getTag(str);
        switch (tag) {
            case 64: {
                ArrayList<Object> tmp = new ArrayList<Object>();
                for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
                    Node node2 = node.getChildNodes().item(pos);
                    if (node2.getNodeType() != 1) continue;
                    GXAsn1Converter.readNode(node2, s, tmp);
                }
                list.add(tmp);
                break;
            }
            case 160: {
                GXAsn1Context tmp = new GXAsn1Context();
                for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
                    Node node3 = node.getChildNodes().item(pos);
                    if (node3.getNodeType() != 1) continue;
                    GXAsn1Converter.readNode(node3, s, tmp);
                }
                list.add(tmp);
                break;
            }
            case 48: {
                GXAsn1Sequence tmp = new GXAsn1Sequence();
                for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
                    Node node4 = node.getChildNodes().item(pos);
                    if (node4.getNodeType() != 1) continue;
                    GXAsn1Converter.readNode(node4, s, tmp);
                }
                list.add(tmp);
                break;
            }
            case 49: {
                ArrayList<Object> tmp = new ArrayList<Object>();
                for (int pos = 0; pos != node.getChildNodes().getLength(); ++pos) {
                    Node node5 = node.getChildNodes().item(pos);
                    if (node5.getNodeType() != 1) continue;
                    GXAsn1Converter.readNode(node5, s, tmp);
                }
                for (Object e : tmp) {
                    GXSimpleEntry<ArrayList<Object>, Object> e2;
                    if (e instanceof List) {
                        List t = (List)e;
                        e2 = new GXSimpleEntry(t.get(0), t.get(1));
                    } else {
                        e2 = new GXSimpleEntry<ArrayList<Object>, Object>(tmp, null);
                    }
                    list.add(e2);
                }
                break;
            }
            case 6: {
                list.add(new GXAsn1ObjectIdentifier(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case 19: {
                list.add(node.getChildNodes().item(0).getNodeValue());
                break;
            }
            case 12: {
                list.add(new GXAsn1Utf8String(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case 22: {
                list.add(new GXAsn1Ia5String(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case 2: {
                list.add(new GXAsn1Integer(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case 5: {
                list.add(null);
                break;
            }
            case 3: {
                list.add(new GXAsn1BitString(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case 23: {
                try {
                    SimpleDateFormat f = new SimpleDateFormat();
                    Date date = f.parse(node.getChildNodes().item(0).getNodeValue());
                    list.add(date);
                    break;
                }
                catch (ParseException | DOMException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            case 24: {
                break;
            }
            case 4: {
                list.add(GXCommon.hexToBytes(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case -1: {
                list.add(Byte.parseByte(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case -2: {
                list.add(Short.parseShort(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case -4: {
                list.add(Integer.parseInt(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            case -8: {
                list.add(Long.parseLong(node.getChildNodes().item(0).getNodeValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node: " + node.getNodeName());
            }
        }
        return 0;
    }

    public static byte[] xmlToPdu(String xml) {
        Document doc;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        ArrayList<Object> list = new ArrayList<Object>();
        GXAsn1Settings s = new GXAsn1Settings();
        GXAsn1Converter.readNode(doc.getDocumentElement(), s, list);
        return GXAsn1Converter.toByteArray(list.get(0));
    }

    public static String systemTitleToSubject(byte[] systemTitle) {
        GXByteBuffer bb = new GXByteBuffer(systemTitle);
        return "CN=" + bb.toHex(false, 0);
    }

    public static byte[] systemTitleFromSubject(String subject) {
        return GXDLMSTranslator.hexToBytes(GXAsn1Converter.hexSystemTitleFromSubject(subject));
    }

    public static String hexSystemTitleFromSubject(String subject) {
        String cn = subject;
        int index = cn.indexOf("CN=");
        if (index == -1) {
            throw new IllegalArgumentException("Common Name is missing.");
        }
        cn = cn.substring(index + 3, index + 3 + 16);
        return cn;
    }

    public static Set<KeyUsage> certificateTypeToKeyUsage(CertificateType type) {
        HashSet<KeyUsage> k = new HashSet<KeyUsage>();
        switch (type) {
            case DIGITAL_SIGNATURE: {
                k.add(KeyUsage.DIGITAL_SIGNATURE);
                break;
            }
            case KEY_AGREEMENT: {
                k.add(KeyUsage.KEY_AGREEMENT);
                break;
            }
            case TLS: {
                k.add(KeyUsage.DIGITAL_SIGNATURE);
                k.add(KeyUsage.KEY_AGREEMENT);
                break;
            }
            case OTHER: {
                break;
            }
            default: {
                return null;
            }
        }
        return k;
    }

    public static PkcsType getCertificateType(byte[] data) {
        return GXAsn1Converter.getCertificateType(data, null);
    }

    static PkcsType getCertificateType(byte[] data, GXAsn1Sequence seq) {
        GXAsn1Sequence val = seq;
        if (val == null) {
            val = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(data);
        }
        if (val.get(0) instanceof GXAsn1Sequence) {
            try {
                new GXx509Certificate(data);
                return PkcsType.x509_CERTIFICATE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (val.get(0) instanceof GXAsn1Sequence) {
            try {
                new GXPkcs10(data);
                return PkcsType.PKCS_10;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (val.get(0) instanceof Byte) {
            try {
                new GXPkcs8(data);
                return PkcsType.PKCS_8;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PkcsType.NONE;
    }

    public static PkcsType GetCertificateType(String der) {
        return GXAsn1Converter.getCertificateType(GXCommon.fromBase64(der));
    }
}

