/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.asn.enums.HashAlgorithm;
import gurux.dlms.asn.enums.PkcsObjectIdentifier;
import gurux.dlms.asn.enums.X509Certificate;
import gurux.dlms.asn.enums.X509Name;
import gurux.dlms.asn.enums.X9ObjectIdentifier;

public class GXAsn1ObjectIdentifier {
    private String objectIdentifier;

    public GXAsn1ObjectIdentifier() {
    }

    public GXAsn1ObjectIdentifier(String oid) {
        this.objectIdentifier = oid;
    }

    public GXAsn1ObjectIdentifier(GXByteBuffer bb, int count) {
        this.objectIdentifier = GXAsn1ObjectIdentifier.oidStringFromBytes(bb, count);
    }

    private static String oidStringFromBytes(GXByteBuffer bb, int len) {
        long value = 0L;
        StringBuilder sb = new StringBuilder();
        if (len != 0) {
            short tmp = bb.getUInt8();
            sb.append(tmp / 40);
            sb.append('.');
            sb.append(tmp % 40);
            for (int pos = 1; pos != len; ++pos) {
                tmp = bb.getUInt8();
                if ((tmp & 0x80) != 0) {
                    value += (long)(tmp & 0x7F);
                    value <<= 7;
                    continue;
                }
                sb.append('.');
                sb.append(value += (long)tmp);
                value = 0L;
            }
        }
        return sb.toString();
    }

    static byte[] oidStringtoBytes(String oid) {
        String[] arr = oid.trim().split("[.]");
        GXByteBuffer tmp = new GXByteBuffer();
        int value = Integer.parseInt(arr[0]) * 40;
        tmp.setUInt8(value += Integer.parseInt(arr[1]));
        for (int pos = 2; pos != arr.length; ++pos) {
            value = Integer.parseInt(arr[pos]);
            if (value < 128) {
                tmp.setUInt8(value);
                continue;
            }
            if (value < 16384) {
                tmp.setUInt8(0x80 | value >> 7);
                tmp.setUInt8(value & 0x7F);
                continue;
            }
            if (value < 0x200000) {
                tmp.setUInt8(0x80 | value >> 14);
                tmp.setUInt8(0x80 | value >> 7);
                tmp.setUInt8(value & 0x7F);
                continue;
            }
            if (value < 0x10000000) {
                tmp.setUInt8(0x80 | value >> 21);
                tmp.setUInt8(0x80 | value >> 14);
                tmp.setUInt8(0x80 | value >> 7);
                tmp.setUInt8(value & 0x7F);
                continue;
            }
            if ((long)value < 0x800000000L) {
                tmp.setUInt8(0x80 | value >> 49);
                tmp.setUInt8(0x80 | value >> 42);
                tmp.setUInt8(0x80 | value >> 35);
                tmp.setUInt8(0x80 | value >> 28);
                tmp.setUInt8(0x80 | value >> 21);
                tmp.setUInt8(0x80 | value >> 14);
                tmp.setUInt8(0x80 | value >> 7);
                tmp.setUInt8(value & 0x7F);
                continue;
            }
            throw new IllegalArgumentException("Invalid OID.");
        }
        return tmp.array();
    }

    public final String getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public final void setObjectIdentifier(String value) {
        this.objectIdentifier = value;
    }

    public final String toString() {
        return this.objectIdentifier;
    }

    public final byte[] getEncoded() {
        return GXAsn1ObjectIdentifier.oidStringtoBytes(this.objectIdentifier);
    }

    public final String getDescription() {
        Enum tmp = X509Name.forValue(this.objectIdentifier);
        if (tmp != null) {
            return tmp.toString();
        }
        tmp = HashAlgorithm.forValue(this.objectIdentifier);
        if (tmp != null) {
            return tmp.toString();
        }
        tmp = X9ObjectIdentifier.forValue(this.objectIdentifier);
        if (tmp != null) {
            return tmp.toString();
        }
        tmp = PkcsObjectIdentifier.forValue(this.objectIdentifier);
        if (tmp != null) {
            return tmp.toString();
        }
        tmp = X509Certificate.forValue(this.objectIdentifier);
        if (tmp != null) {
            return tmp.toString();
        }
        return null;
    }
}

