/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import java.util.HashMap;

final class GXAsn1Settings {
    private int count;
    private boolean comments;
    private final StringBuilder sb = new StringBuilder();
    private HashMap<Short, String> tags = new HashMap();
    private HashMap<String, Short> tagbyName = new HashMap();

    private void addTag(int key, String value) {
        this.tags.put((short)key, value);
        this.tagbyName.put(value.toLowerCase(), (short)key);
    }

    GXAsn1Settings() {
        this.addTag(64, "Application");
        this.addTag(160, "Context");
        this.addTag(48, "Sequence");
        this.addTag(49, "Set");
        this.addTag(6, "ObjectIdentifier");
        this.addTag(19, "String");
        this.addTag(12, "UTF8");
        this.addTag(22, "IA5");
        this.addTag(2, "Integer");
        this.addTag(5, "Null");
        this.addTag(3, "BitString");
        this.addTag(23, "UtcTime");
        this.addTag(24, "GeneralizedTime");
        this.addTag(4, "OctetString");
        this.addTag(1, "Bool");
        this.addTag(-1, "Byte");
        this.addTag(-2, "Short");
        this.addTag(-4, "Int");
        this.addTag(-8, "Long");
    }

    public String getTag(short value) {
        return this.tags.get(value);
    }

    public short getTag(String value) {
        return this.tagbyName.get(value);
    }

    public int getXmlLength() {
        return this.sb.length();
    }

    public void appendComment(int offset, String value) {
        if (this.comments) {
            boolean empty = this.sb.length() == 0;
            StringBuilder tmp = empty ? this.sb : new StringBuilder();
            for (int pos = 0; pos < this.count - 1; ++pos) {
                tmp.append(' ');
            }
            tmp.append("<!--");
            tmp.append(value);
            tmp.append("-->\r\n");
            if (!empty) {
                this.sb.insert(offset, tmp);
            }
        }
    }

    public void appendSpaces() {
        for (int pos = 0; pos != this.count; ++pos) {
            this.sb.append(' ');
        }
    }

    public void append(String value) {
        this.sb.append(value);
    }

    public void increase() {
        ++this.count;
        this.append("\r\n");
    }

    public void decrease() {
        --this.count;
        this.appendSpaces();
    }

    public String toString() {
        return this.sb.toString();
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean value) {
        this.comments = value;
    }
}

